/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eline;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eline.LogicInf;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eline.TEElineServiceData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eline_u2kv1r2c01.TEElineUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEQueryElineServiceSupperBean
extends TENEExplorerBean {
    protected Map servicemap = new HashMap();
    protected static final String NSERR_CFG_GET_NULL = "38662";
    protected static final String CARRIER_TYPE_1 = "1";
    protected static final String CARRIER_TYPE_3 = "3";
    protected static final String CARRIER_TYPE_4 = "4";
    protected boolean isLogFlag = true;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = new ArrayList();
            Operation operation = null;
            String QxName = subFunc.getQxMapping(0).getContent();
            operation = TECreateObjectFactory.getOperation((int)neid, (String)QxName);
            Input input = operation.getInput();
            input.setPartValue("serviceIndex", "0");
            this.operationList.add(operation);
            int resCode = 0;
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)this.operationList, this.TIME_OUT);
            if (null != result) {
                resCode = result.retCode;
            }
            if (resCode == 0) {
                Operation oper = (Operation)this.operationList.get(0);
                int count = oper.getOutputCount();
                for (int i = 0; i < count; ++i) {
                    String errorCode = oper.getOutput(i).getFault(0).getCode();
                    if (!String.valueOf(0).equals(errorCode)) continue;
                    Output output = oper.getOutput(i);
                    String serviceIndex = output.getPartValue("serviceIndex");
                    String serviceID = output.getPartValue("serviceID").trim();
                    String serviceName = output.getPartValue("serviceName").trim();
                    int maxPackageLen = -1;
                    if (null != output.getPartValue("maxPackageLen")) {
                        maxPackageLen = Integer.parseInt(output.getPartValue("maxPackageLen").trim());
                    }
                    String bpdu = output.getPartValue("bpdu");
                    int logicInfNum = Integer.parseInt(output.getPartValue("logicInfNum"));
                    if (logicInfNum == 0) continue;
                    ArrayList<LogicInf> logicInfList = new ArrayList<LogicInf>();
                    String[] logicInfStr = new String[logicInfNum];
                    String logicInf = output.getPartValue("logicInfData");
                    int lens = logicInf.length() / 8;
                    int index = 0;
                    for (int j = 0; j < lens; ++j) {
                        int logicInflength = 8;
                        logicInfStr[j] = logicInf.substring(index, index + logicInflength);
                        index += logicInflength;
                    }
                    for (int k = 0; k < logicInfStr.length; ++k) {
                        logicInfList.add(this.parseLogicInfData(logicInfStr[k]));
                    }
                    TEElineServiceData serviceData = new TEElineServiceData(serviceIndex, serviceName, serviceID, maxPackageLen, logicInfNum, logicInfList);
                    serviceData.setBpdu(bpdu);
                    this.servicemap.put(serviceData.serviceIndex, serviceData);
                }
                this.refreshServiceID(neid, oper);
                ArrayList secOperList = this.getVuniVnniInfoOperationList(subFunc);
                if (!secOperList.isEmpty()) {
                    resCode = 0;
                    result = TENECommMgr.getInstance().sendCommand(neid, (List)secOperList, this.TIME_OUT);
                    if (null != result) {
                        resCode = result.retCode;
                    }
                    this.operationList.addAll(secOperList);
                    if (resCode == 0) {
                        this.handleSecOperList(secOperList);
                    }
                }
                this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resCode));
            }
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
        filterErrorCodeList.add(Integer.valueOf(NSERR_CFG_GET_NULL));
        return filterErrorCodeList;
    }

    public void handleSecOperList(List secOperList) {
        int size = secOperList.size();
        for (int i = 0; i < size; ++i) {
            TEElineServiceData svcData;
            String index;
            int j;
            int outputs;
            Operation oper = (Operation)secOperList.get(i);
            if ("NSCMD_SERVICE_GET_ETHVUNI_EX".equals(oper.getName())) {
                outputs = oper.getOutputCount();
                for (j = 0; j < outputs; ++j) {
                    if (!oper.getOutput(j).getFault(0).getCode().equals(String.valueOf(0))) continue;
                    index = oper.getOutput(j).getPartValue("serviceIndex");
                    String vuniid = oper.getOutput(j).getPartValue("vuniID");
                    int slotid = Integer.parseInt(oper.getOutput(j).getPartValue("slotid"));
                    int subslotid = Integer.parseInt(oper.getOutput(j).getPartValue("subslotid"));
                    int portid = Integer.parseInt(oper.getOutput(j).getPartValue("portid"));
                    TEElineServiceData svcData2 = (TEElineServiceData)this.servicemap.get(index);
                    LogicInf logicInf = svcData2.getLogicInfFromList(1, vuniid);
                    logicInf.logicInfName = this.getPortNameForPTN(slotid, subslotid, portid);
                    logicInf.portid = portid;
                }
                continue;
            }
            if ("NSCMD_SERVICE_GET_EVNNI_EX".equals(oper.getName())) {
                outputs = oper.getOutputCount();
                for (j = 0; j < outputs; ++j) {
                    if (!oper.getOutput(j).getFault(0).getCode().equals(String.valueOf(0))) continue;
                    index = oper.getOutput(j).getPartValue("serviceIndex");
                    String vnniid = oper.getOutput(j).getPartValue("vnniID");
                    String carrierType = oper.getOutput(j).getPartValue("carrierType");
                    String carrier1 = oper.getOutput(j).getPartValue("carrierID1");
                    String carrier2 = oper.getOutput(j).getPartValue("carrierID2");
                    String carrier3 = oper.getOutput(j).getPartValue("carrierID3");
                    TEElineServiceData svcData3 = (TEElineServiceData)this.servicemap.get(index);
                    LogicInf logicInf = svcData3.getLogicInfFromList(2, vnniid);
                    if (CARRIER_TYPE_1.equals(carrierType)) {
                        logicInf.logicInfName = this.getPWName(carrier3, secOperList);
                        svcData3.setBearerIndex(carrier3);
                        continue;
                    }
                    if (CARRIER_TYPE_3.equals(carrierType)) {
                        logicInf.logicInfName = this.getPortNameForPTN(Integer.parseInt(carrier1), Integer.parseInt(carrier2), Integer.parseInt(carrier3));
                        logicInf.portid = Integer.parseInt(carrier3);
                        continue;
                    }
                    if (!CARRIER_TYPE_4.equals(carrierType)) continue;
                    logicInf.logicInfName = this.getVnniQinqLinkName(carrier3);
                }
                continue;
            }
            if ("NSCMD_SERVICE_GET_SERVTAGROLE".equals(oper.getName())) {
                outputs = oper.getOutputCount();
                for (j = 0; j < outputs; ++j) {
                    if (!oper.getOutput(j).getFault(0).getCode().equals(String.valueOf(0))) continue;
                    index = oper.getOutput(j).getPartValue("serviceIndex");
                    svcData = (TEElineServiceData)this.servicemap.get(index);
                    String servicetagrole = oper.getOutput(j).getPartValue("servicetagrole");
                    svcData.setService(servicetagrole);
                }
                continue;
            }
            if (!"NSCMD_SERVICE_GET_SWITCH_PWANDARP".equals(oper.getName())) continue;
            outputs = oper.getOutputCount();
            for (j = 0; j < outputs; ++j) {
                if (!oper.getOutput(j).getFault(0).getCode().equals(String.valueOf(0))) continue;
                index = oper.getOutput(j).getPartValue("serviceIndex");
                svcData = (TEElineServiceData)this.servicemap.get(index);
                String pwenable = oper.getOutput(j).getPartValue("pwenable");
                String arpenable = oper.getOutput(j).getPartValue("arpenable");
                svcData.setPwEnable(pwenable);
                svcData.setArpEnable(arpenable);
            }
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        boolean isSuccess = true;
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        BussinessParams bParams = new BussinessParams();
        for (Map.Entry element : this.servicemap.entrySet()) {
            TEElineServiceData serviceData = (TEElineServiceData)element.getValue();
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("serviceIndex", serviceData.serviceIndex);
            rParams.addParam(param);
            param = new Param("serviceID", serviceData.serviceID);
            rParams.addParam(param);
            param = new Param("serviceName", serviceData.serviceName);
            rParams.addParam(param);
            LogicInf logicInf0 = serviceData.getLogicInfByIndex(0);
            LogicInf logicInf1 = serviceData.getLogicInfByIndex(1);
            if (logicInf0.logicInfType == 2 && logicInf1.logicInfType == 1) {
                param = new Param("sourceNode", logicInf1.logicInfName);
                rParams.addParam(param);
                param = new Param("sinkNode", logicInf0.logicInfName);
                rParams.addParam(param);
            } else {
                param = new Param("sourceNode", logicInf0.logicInfName);
                rParams.addParam(param);
                param = new Param("sinkNode", logicInf1.logicInfName);
                rParams.addParam(param);
            }
            param = new Param("bpdu", serviceData.bpdu);
            rParams.addParam(param);
            bParams.addRowParams(rParams);
        }
        int errCode = 0;
        int size = operationList.size();
        block1: for (int i = 0; i < size; ++i) {
            Operation operation = (Operation)operationList.get(0);
            int rowLen = operation.getOutputCount();
            for (int j = 0; j < rowLen; ++j) {
                Output output = operation.getOutput(i);
                errCode = Integer.parseInt(output.getFault(0).getCode());
                if (errCode == 0 || errCode == 38662) continue;
                isSuccess = false;
                continue block1;
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)(isSuccess ? 0 : errCode)));
        this.outputData.setBussinessParams(bParams);
    }

    public LogicInf parseLogicInfData(String logicInfStr) {
        String[] logic = new String[2];
        int lens = logicInfStr.length() / 4;
        int index = 0;
        for (int j = 0; j < lens; ++j) {
            int logicInflength = 4;
            logic[j] = logicInfStr.substring(index, index + logicInflength);
            index += logicInflength;
        }
        int logicType = Integer.parseInt(logic[0], 16);
        int logicID = Integer.parseInt(logic[1], 16);
        LogicInf logicInf = new LogicInf(logicType, String.valueOf(logicID));
        return logicInf;
    }

    public ArrayList getVuniVnniInfoOperationList(SubFunc subFunc) {
        ArrayList<Object> operList = new ArrayList<Object>();
        Operation operation = null;
        Input input = null;
        String QxName1 = subFunc.getQxMapping(1).getContent();
        String QxName2 = subFunc.getQxMapping(2).getContent();
        for (Map.Entry element : this.servicemap.entrySet()) {
            TEElineServiceData serviceData = (TEElineServiceData)element.getValue();
            List logicInfList = serviceData.logicInfList;
            String serviceIndex = serviceData.serviceIndex;
            int size = logicInfList.size();
            for (int j = 0; j < size; ++j) {
                LogicInf logic = (LogicInf)logicInfList.get(j);
                if (logic.logicInfType == 1) {
                    operation = TECreateObjectFactory.getOperation((int)this.neid, (String)QxName1);
                    input = operation.getInput();
                    input.setPartValue("ethType", CARRIER_TYPE_1);
                    input.setPartValue("serviceIndex", serviceIndex);
                    input.setPartValue("vuniID", logic.logicInfID);
                    operList.add(operation.clone());
                    continue;
                }
                if (logic.logicInfType != 2) continue;
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)QxName2);
                input = operation.getInput();
                input.setPartValue("ethType", CARRIER_TYPE_1);
                input.setPartValue("serviceIndex", serviceIndex);
                input.setPartValue("vnniID", logic.logicInfID);
                operList.add(operation.clone());
            }
            this.addOtherOperation(operList, serviceIndex);
        }
        return operList;
    }

    public void addOtherOperation(ArrayList operList, String serviceIndex) {
    }

    public String getPortNameForPTN(int slotid, int subslotid, int portid) {
        String portName;
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        Vector logBoardList = neObj.getClonedBoardList();
        int boardType = 0;
        int subBoardType = 0;
        int len = logBoardList.size();
        block0: for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)logBoardList.get(i);
            int boardSlot = board.getSlotID();
            if (boardSlot != slotid) continue;
            if (subslotid == 255) {
                boardType = board.getBoardType();
                continue;
            }
            List subBoardList = board.getSubBoardList();
            int size = subBoardList.size();
            for (int k = 0; k < size; ++k) {
                TESubBoard subBoard = (TESubBoard)subBoardList.get(k);
                int subBoardId = subBoard.getSubSlotID();
                if (subBoardId != subslotid) continue;
                subBoardType = subBoard.getSubBoardType();
                continue block0;
            }
        }
        if (subBoardType == 0) {
            portName = cfgDataMgr.getPortNameForPTN(this.neid, slotid, boardType, portid);
            portName = slotid + "-" + cfgDataMgr.getBoardTypeName(this.neid, boardType) + "-" + portName;
        } else {
            portName = cfgDataMgr.getPortNameForPTN(this.neid, slotid, subBoardType, portid);
        }
        return portName;
    }

    public String getVnniQinqLinkName(String qinqLinkID) {
        return "QinQ Link ID-" + qinqLinkID;
    }

    public String getPWName(String pwindex, List secOperList) {
        Operation oper = null;
        String pwID = "/";
        String temppwindex = "";
        int size = secOperList.size();
        for (int i = 0; i < size; ++i) {
            oper = (Operation)secOperList.get(i);
            if (!"NSCMD_PTN_MPLS_PW_GET_PW".equals(oper.getName())) continue;
            int outputs = oper.getOutputCount();
            for (int j = 0; j < outputs; ++j) {
                if (!String.valueOf(0).equals(oper.getOutput(j).getFault(0).getCode()) || !pwindex.equals(temppwindex = oper.getOutput(j).getPartValue("pwIndex"))) continue;
                pwID = oper.getOutput(j).getPartValue("pwID");
                return "PW-" + pwID;
            }
        }
        return "PW-" + pwID;
    }

    public void refreshServiceID(int neid, Operation oper) {
        new RefreshServiceIDThread(neid, oper).start();
    }

    public class RefreshServiceIDThread
    extends Thread {
        int neid;
        Operation oper;

        public RefreshServiceIDThread(int neid, Operation oper) {
            this.neid = neid;
            this.oper = oper;
        }

        @Override
        public void run() {
            TEElineUtil.refreshElineServiceIDCache(this.neid, "serviceID", this.oper);
            TEElineUtil.refreshElanServiceID(this.neid);
            TEElineUtil.refreshEaggrServiceID(this.neid);
        }
    }
}

