/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eline;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEGetQinQLinkBean
extends TENEExplorerBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData.setBussinessParams(new BussinessParams());
        Operation operation = (Operation)operationList.get(0);
        boolean isSucc = true;
        int count = operation.getOutputCount();
        for (int i = 0; i < count; ++i) {
            Output output = operation.getOutput(i);
            RowParams rParams = new RowParams();
            this.outputData.getBussinessParams().addRowParams(rParams);
            int errCode = Integer.parseInt(output.getFault(0).getCode());
            if (errCode != 0) {
                if (errCode == 38662) continue;
                isSucc = false;
                rParams.addRowErrors(this.constructRowErrors(errCode));
                continue;
            }
            int slotid = Integer.parseInt(output.getPartValue("slotid"));
            int portid = Integer.parseInt(output.getPartValue("portid"));
            rParams.addParam(this.constructParam("linkid", output.getPartValue("linkid")));
            rParams.addParam(this.constructParam("slotid", output.getPartValue("slotid")));
            rParams.addParam(this.constructParam("boardname", this.getBoardName(neid, slotid)));
            rParams.addParam(this.constructParam("portid", output.getPartValue("portid")));
            rParams.addParam(this.constructParam("portname", this.getPortName(neid, slotid, portid)));
            rParams.addParam(this.constructParam("svlanid", output.getPartValue("svlanid")));
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)(isSucc ? 0 : 2)));
    }

    private String getBoardName(int neid, int slotid) {
        String boardName = "";
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        if (board != null) {
            boardName = board.getBoardName();
        }
        return boardName;
    }

    private String getPortName(int neid, int slotid, int portid) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        String portName = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardType, portid);
        return portName;
    }

    private Param constructParam(String key, String value) {
        Param paramTemp = new Param();
        paramTemp.setName(key);
        paramTemp.setValue(value);
        return paramTemp;
    }

    private RowErrors constructRowErrors(int errCode) {
        RowErrors rowErrorTemp = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(String.valueOf(errCode));
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errCode));
        rowErrorTemp.setErrorMessage(errorMessage);
        rowErrorTemp.addParam(this.constructParam("neid", String.valueOf(this.neid)));
        rowErrorTemp.addParam(this.constructParam("nename", TENEListMgr.getInstance().getNE(this.neid).getNEName()));
        return rowErrorTemp;
    }

    public ArrayList getFilterErrorCodeList() {
        if (null == this.subfunc) {
            return new ArrayList();
        }
        return this.subfunc.getFilterErrCodeList();
    }
}

