/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.elan_u2kv1r8c00;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.elan_u2kv1r8c00.LoopCycDetect;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class TEGetElanLoopcycDetectBean
extends TECommonWriteLogBean {
    protected ArrayList operationList2 = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.decryptParamForInputData(inputData);
            this.modifyInputParams();
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            this.encryptParamForOutputData();
            this.modifyOutputParams();
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        int iLength = operationList.size();
        for (int i = 0; i < iLength; ++i) {
            Operation oper = (Operation)operationList.get(i);
            Output[] outputs = oper.getOutput();
            int jLength = outputs.length;
            for (int j = 0; j < jLength; ++j) {
                int result;
                if (outputs[j].getPartValue("cvlannum") == null) continue;
                int cvlannum = Integer.parseInt(outputs[j].getPartValue("cvlannum"));
                String vlanList = outputs[j].getPartValue("cvlanlist");
                String vlan = TEGetElanLoopcycDetectBean.parseVlanList(vlanList, cvlannum, 4);
                outputs[j].setPartValue("cvlanlist", vlan);
                List resList = this.getGetElanLoopcycDetectMap(neid, outputs[j]);
                if (resList == null || (result = this.getGetElanLoopcycDetectResult(neid, resList)) != 0) continue;
                Part resultpart = new Part();
                resultpart.setName("periodloopresult");
                resultpart.setValue(this.getNearestResult());
                outputs[j].addPart(resultpart);
            }
        }
        super.handleMessage(neid, operationList, subfunc);
    }

    private String getNearestResult() {
        StringBuffer result = new StringBuffer();
        int iLength = this.operationList2.size();
        for (int i = 0; i < iLength; ++i) {
            Operation oper = (Operation)this.operationList2.get(i);
            Output[] outputs = oper.getOutput();
            ArrayList<Integer> vlanList = new ArrayList<Integer>();
            int jLength = outputs.length;
            for (int j = 0; j < jLength; ++j) {
                Calendar currenttime;
                String time = outputs[j].getPartValue("time");
                if (time == null || (currenttime = TEDateUtils.byteStrToCalendar((String)time)) == null || currenttime.getTime() == null) continue;
                long jtmpCurrenttime = currenttime.getTime().getTime();
                int jvlanid = Integer.parseInt(outputs[j].getPartValue("vlanid"));
                int latesttime = j;
                if (vlanList.contains(jvlanid)) continue;
                vlanList.add(jvlanid);
                for (int k = 0; k < outputs.length; ++k) {
                    long ktmpCurrenttime;
                    int kvlanid = Integer.parseInt(outputs[k].getPartValue("vlanid"));
                    if (k == j || kvlanid != jvlanid || (time = outputs[k].getPartValue("time")) == null || (currenttime = TEDateUtils.byteStrToCalendar((String)time)) == null || currenttime.getTime() == null || jtmpCurrenttime >= (ktmpCurrenttime = currenttime.getTime().getTime())) continue;
                    latesttime = k;
                }
                result.append(outputs[latesttime].getPartValue("vlanid"));
                result.append("-");
                result.append(outputs[latesttime].getPartValue("loopResult"));
                result.append("-");
                result.append(outputs[latesttime].getPartValue("status"));
                result.append(";");
            }
        }
        return result.toString();
    }

    private int getGetElanLoopcycDetectResult(int neid, List resList) {
        this.operationList2 = new ArrayList();
        for (int i = 0; i < resList.size(); ++i) {
            LoopCycDetect loopCycDetect = (LoopCycDetect)resList.get(i);
            Operation aoperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETH_GET_ELAN_LOOP_CYCDETECT_RESULT");
            Input input1 = aoperation.getInput();
            input1.setPartValue("serviceindex", loopCycDetect.getServiceindex());
            input1.setPartValue("logicalinterfacetype", loopCycDetect.getLogicalinterfacetype());
            input1.setPartValue("logicalinterfaceid", loopCycDetect.getLogicalinterfaceid());
            this.operationList2.add(aoperation);
        }
        return this.sendMessage(neid, this.operationList2);
    }

    private List getGetElanLoopcycDetectMap(int neid, Output output) {
        ArrayList<LoopCycDetect> resList = new ArrayList<LoopCycDetect>();
        String serviceindex = output.getPartValue("serviceindex");
        String logicalinterfacetype = output.getPartValue("logicalinterfacetype");
        String logicalinterfaceid = output.getPartValue("logicalinterfaceid");
        if (serviceindex == null || logicalinterfacetype == null || logicalinterfaceid == null) {
            return resList;
        }
        resList.add(new LoopCycDetect(serviceindex, logicalinterfacetype, logicalinterfaceid));
        return resList;
    }

    public static String parseVlanList(String valueStr, int tagnum, int interval) {
        if (valueStr == null || valueStr.length() == 0 || tagnum == 0) {
            return "";
        }
        ArrayList<Integer> strList = new ArrayList<Integer>();
        int index = 0;
        for (int i = 0; i < tagnum; ++i) {
            int tmp = Integer.parseInt(valueStr.substring(index, index + interval), 16);
            if (tmp != 0) {
                strList.add(tmp);
            }
            index += interval;
        }
        ArrayList allList = new ArrayList();
        ArrayList<Integer> dstlist = new ArrayList<Integer>();
        int size = strList.size();
        for (int i = 0; i < size; ++i) {
            int pathNum = (Integer)strList.get(i);
            if (dstlist.isEmpty() || (Integer)dstlist.get(dstlist.size() - 1) + 1 == pathNum) {
                dstlist.add(pathNum);
            } else {
                allList.add(dstlist);
                dstlist = new ArrayList<Integer>();
                dstlist.add(pathNum);
            }
            if (i != size - 1) continue;
            allList.add(dstlist);
        }
        StringBuilder strBuilder = new StringBuilder();
        int size2 = allList.size();
        for (int i = 0; i < size2; ++i) {
            dstlist = (ArrayList<Integer>)allList.get(i);
            if (dstlist.size() == 1) {
                strBuilder.append(",");
                strBuilder.append(dstlist.get(0));
                continue;
            }
            strBuilder.append(",");
            strBuilder.append(dstlist.get(0));
            strBuilder.append("-");
            strBuilder.append(dstlist.get(dstlist.size() - 1));
        }
        return strBuilder.toString().substring(1, strBuilder.toString().length());
    }
}

