/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.elan_fo;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.mdp.TEFInterfaceUtils;
import com.huawei.nglct.explorer.integrateexplorer.TEInterNEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.ptn.service.comm.AsnEthPtnVUNI;
import com.huawei.nglct.nemgr.f_interface.ptn.service.vlan.AsnEthPtnGetElanCommonReq;
import com.huawei.nglct.nemgr.f_interface.ptn.service.vlan.AsnEthPtnGetElanVUniRsp;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.elan_fo.TEElanCommonUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.math.BigInteger;
import java.util.List;
import net.commustru.fstru.FStruct;

public class TEPtnGetElanYUNIServiceBean
extends TEInterNEExplorerBean {
    public Datainterface sendAsnMsg() {
        AsnEthPtnGetElanVUniRsp rsp;
        Datainterface output = new Datainterface();
        BussinessParams bsParams = this.inputData.getBussinessParams();
        AsnEthPtnGetElanCommonReq req = TEElanCommonUtil.convertRowData2AsnEthPtnGetElanCommonReq(bsParams, this.neid, this.user);
        int result = super.sendCommand(this.neid, (FStruct)req, (FStruct)(rsp = new AsnEthPtnGetElanVUniRsp()), this.subfunc.getCode());
        if (result == 0) {
            if (rsp.result.isSuccess) {
                BussinessParams bussiness = new BussinessParams();
                int len = rsp.vUniList.size();
                for (int i = 0; i < len; ++i) {
                    AsnEthPtnVUNI vuni = (AsnEthPtnVUNI)rsp.vUniList.get(i);
                    RowParams row = this.convertAsnEthPtnVUNIToRowParams(vuni);
                    bussiness.addRowParams(row);
                }
                output.setBussinessParams(bussiness);
            } else if (rsp.result.retCode != null) {
                result = rsp.result.retCode.intValue();
            }
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        return output;
    }

    private RowParams convertAsnEthPtnVUNIToRowParams(AsnEthPtnVUNI vuni) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        RowParams row = new RowParams();
        row.addParam("block", "NSCMD_SERVICE_GET_ETHVUNI_EX");
        row.addParam("serviceIndex", "NSCMD_SERVICE_GET_ETHVUNI_EX");
        row.addParam("vuniID", TEFInterfaceUtils.convertBigInt2Str((BigInteger)vuni.vuniID));
        row.addParam("slotid", TEFInterfaceUtils.convertBigInt2Str((BigInteger)vuni.slotID));
        String boardName = mgr.getBoardName(this.neid, vuni.slotID.intValue());
        row.addParam("boardName", boardName);
        row.addParam("porttype", TEFInterfaceUtils.convertBigInt2Str((BigInteger)vuni.role));
        row.addParam("subslotid", "255");
        int tmpPortID = TEConfigurationDataMgr.getPortRelativeID((int)vuni.portID.intValue());
        row.addParam("portid", String.valueOf(tmpPortID));
        String portName = mgr.getPortName(this.neid, vuni.slotID.intValue(), tmpPortID);
        row.addParam("portname", portName);
        row.addParam("tagID", TEFInterfaceUtils.convertVLAN2Str((List)vuni.vlanList));
        return row;
    }
}

