/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.elan_fo;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.mdp.TEFInterfaceUtils;
import com.huawei.nglct.explorer.integrateexplorer.TEInterNEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.ptn.service.vlan.AsnEthPthElanIndex;
import com.huawei.nglct.nemgr.f_interface.ptn.service.vlan.AsnEthPtnElanStaticMacCFDB;
import com.huawei.nglct.nemgr.f_interface.ptn.service.vlan.AsnEthPtnGetElanMacCFDBReq;
import com.huawei.nglct.nemgr.f_interface.ptn.service.vlan.AsnEthPtnGetElanMacCFDBRsp;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.elan_fo.TEElanCommonUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;

public class TEPtnGetElanMacCFDBServiceBean
extends TEInterNEExplorerBean {
    public AsnEthPthElanIndex elanIndex;
    public int slotid;

    public Datainterface sendAsnMsg() {
        AsnEthPtnGetElanMacCFDBRsp rsp;
        Datainterface output = new Datainterface();
        AsnEthPtnGetElanMacCFDBReq req = this.buildGetReq();
        int result = super.sendCommand(this.neid, (FStruct)req, (FStruct)(rsp = new AsnEthPtnGetElanMacCFDBRsp()), this.subfunc.getCode());
        if (result == 0) {
            if (rsp.result.isSuccess) {
                BussinessParams bussiness = new BussinessParams();
                int len = rsp.staticMacCFDBList.size();
                for (int i = 0; i < len; ++i) {
                    AsnEthPtnElanStaticMacCFDB elanSrv = (AsnEthPtnElanStaticMacCFDB)rsp.staticMacCFDBList.get(i);
                    RowParams row = this.buildGetRspXML(elanSrv);
                    bussiness.addRowParams(row);
                }
                output.setBussinessParams(bussiness);
            } else if (rsp.result.retCode != null && rsp.result.retCode.intValue() != 38662 && rsp.result.retCode.intValue() != 38737) {
                result = rsp.result.retCode.intValue();
            }
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        return output;
    }

    private RowParams buildGetRspXML(AsnEthPtnElanStaticMacCFDB staticMac) {
        RowParams row = new RowParams();
        row.addParam("serviceIndex", TEFInterfaceUtils.convertBigInt2Str((BigInteger)this.elanIndex.serviceIndex));
        row.addParam("slotid", String.valueOf(this.slotid));
        row.addParam("macAddr", TEElanCommonUtil.convertAsnMac2MacStr(staticMac.macAddr));
        row.addParam("vlanID", String.valueOf(staticMac.vlanID));
        row.addParam("mactype", String.valueOf(staticMac.macAddrType.intValue()));
        row.addParam("eInterfaceType", String.valueOf(staticMac.logicalInterfaceType.intValue()));
        row.addParam("logicalInterfaceID", String.valueOf(staticMac.logicalInterfaceID.intValue()));
        row.addParam("eSlotId", String.valueOf(staticMac.logicalInterfaceIDPara1.intValue()));
        row.addParam("eSubslotId", "255");
        int portID = TEConfigurationDataMgr.getPortRelativeID((int)staticMac.logicalInterfaceIDPara2.intValue());
        row.addParam("eportId", String.valueOf(portID));
        row.addParam("queryflag", String.valueOf("0"));
        String boardname = this.getBoardName(this.neid, staticMac.logicalInterfaceIDPara1.intValue());
        String portname = this.getPortNameForPTN(this.neid, staticMac.logicalInterfaceIDPara1.intValue(), portID);
        row.addParam("eInterface", staticMac.logicalInterfaceIDPara1.intValue() + "-" + boardname + "-" + portname);
        return row;
    }

    private String getPortNameForPTN(int neid, int slotid, int portid) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, boardType, portid);
        return portName;
    }

    private String getBoardName(int neid, int slotid) {
        String boardName = "";
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        if (board != null) {
            boardName = board.getBoardName();
        }
        return boardName;
    }

    private AsnEthPtnGetElanMacCFDBReq buildGetReq() {
        AsnEthPtnGetElanMacCFDBReq req = new AsnEthPtnGetElanMacCFDBReq();
        req.userID = BigInteger.valueOf(Long.parseLong(this.user));
        req.neID = BigInteger.valueOf(this.neid);
        req.missionID = BigInteger.valueOf(0L);
        BussinessParams bsParams = this.inputData.getBussinessParams();
        RowParams rParams = bsParams.getRowParams(0);
        this.elanIndex = req.elanIndex = TEElanCommonUtil.convertRowData2AsnEthPthElanIndex(bsParams);
        req.slotID = TEFInterfaceUtils.convertParam2BigInt((Param)rParams.getParam("slotid"));
        this.slotid = req.slotID.intValue();
        req.vlanID = TEFInterfaceUtils.convertParam2BigInt((Param)rParams.getParam("vlanID"));
        req.macFDBNum = TEFInterfaceUtils.convertParam2BigInt((Param)rParams.getParam("macnum"));
        req.macAddrType = TEFInterfaceUtils.convertParam2BigInt((Param)rParams.getParam("mactype"));
        req.getFlag = TEFInterfaceUtils.convertParam2BigInt((Param)rParams.getParam("queryflag"));
        return req;
    }
}

