/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.elan_fo;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.mdp.TEFInterfaceUtils;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnEtherMACAddr;
import com.huawei.nglct.nemgr.f_interface.ptn.service.comm.AsnEthPtnVLANList;
import com.huawei.nglct.nemgr.f_interface.ptn.service.vlan.AsnEthPthElanIndex;
import com.huawei.nglct.nemgr.f_interface.ptn.service.vlan.AsnEthPtnGetElanCommonReq;
import com.huawei.nglct.util.string.TEStringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class TEElanCommonUtil {
    public static int UNI_TYPE = 1;
    public static int NNI_TYPE = 2;
    public static int DEPLOYED_TYPE = 1;
    public static int UNDEPLOYED_TYPE = 0;
    public static int PHYPORT = 1;
    public static int PW_TYPE = 2;
    public static int STATIC_TYPE = 1;
    public static int DYNAMIC_TYPE = 2;
    public static int SELFLEARN_TYPE = 0;

    public static AsnEthPtnVLANList convertVlanIDStr2List(String vlanIDStr) {
        AsnEthPtnVLANList vlanList = new AsnEthPtnVLANList();
        if (vlanIDStr.equals("")) {
            return vlanList;
        }
        ArrayList vlans = new ArrayList();
        TEStringUtils.strToNumList((String)vlanIDStr, vlans);
        int length = vlans.size();
        for (int i = 0; i < length; ++i) {
            vlanList.add((Object)TEFInterfaceUtils.convertParam2BigInt((String)String.valueOf(vlans.get(i))));
        }
        return vlanList;
    }

    public static AsnEthPthElanIndex convertRowData2AsnEthPthElanIndex(BussinessParams bsParams) {
        AsnEthPthElanIndex elanIndex = new AsnEthPthElanIndex();
        for (int i = 0; i < bsParams.getRowParamsCount(); ++i) {
            RowParams elanRowParams = bsParams.getRowParams(i);
            Param serIndexParam = elanRowParams.getParam("serviceIndex");
            Param serviceIDParam = elanRowParams.getParam("serviceID");
            Param activateStateParam = elanRowParams.getParam("activateState");
            if (serIndexParam == null || serviceIDParam == null || activateStateParam == null) continue;
            elanIndex.serviceIndex = TEFInterfaceUtils.convertParam2BigInt((Param)serIndexParam);
            elanIndex.serviceID = TEFInterfaceUtils.convertParam2BigInt((Param)serviceIDParam);
            elanIndex.activateState = TEFInterfaceUtils.convertParam2BigInt((Param)activateStateParam);
            return elanIndex;
        }
        TELogFactory.getNormalLogger().error("Create ElanIndex failed!");
        return elanIndex;
    }

    public static List<AsnEthPthElanIndex> convertRowData2AsnEthPthElanIndexList(BussinessParams bsParams) {
        ArrayList<AsnEthPthElanIndex> elanIndexList = new ArrayList<AsnEthPthElanIndex>();
        for (int i = 0; i < bsParams.getRowParamsCount(); ++i) {
            AsnEthPthElanIndex elanIndex = new AsnEthPthElanIndex();
            RowParams elanRowParams = bsParams.getRowParams(i);
            Param sParam = elanRowParams.getParam("serviceIndex");
            if (sParam == null) continue;
            elanIndex.serviceIndex = TEFInterfaceUtils.convertParam2BigInt((Param)sParam);
            sParam = elanRowParams.getParam("serviceID");
            if (sParam == null) continue;
            elanIndex.serviceID = TEFInterfaceUtils.convertParam2BigInt((Param)sParam);
            sParam = elanRowParams.getParam("activateState");
            if (sParam == null) continue;
            elanIndex.activateState = TEFInterfaceUtils.convertParam2BigInt((Param)sParam);
            elanIndexList.add(elanIndex);
        }
        return elanIndexList;
    }

    public static AsnEthPtnGetElanCommonReq convertRowData2AsnEthPtnGetElanCommonReq(BussinessParams bsParams, int neid, String user) {
        AsnEthPtnGetElanCommonReq req = new AsnEthPtnGetElanCommonReq();
        req.userID = BigInteger.valueOf(Long.parseLong(user));
        req.neID = BigInteger.valueOf(neid);
        req.elanIndex = TEElanCommonUtil.convertRowData2AsnEthPthElanIndex(bsParams);
        return req;
    }

    public static AsnEtherMACAddr convertMacStr2AsnMac(String macStr) {
        AsnEtherMACAddr asnMac = new AsnEtherMACAddr();
        String[] macAddrs = macStr.split("-");
        int k = macAddrs.length;
        for (int j = 0; j < k; ++j) {
            if (!"".equals(macAddrs[j])) {
                asnMac.add((Object)BigInteger.valueOf(Long.parseLong(macAddrs[j], 16)));
                continue;
            }
            asnMac.add((Object)BigInteger.valueOf(0L));
        }
        return asnMac;
    }

    public static String convertAsnMac2MacStr(AsnEtherMACAddr macAddr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < macAddr.size(); ++i) {
            String macNum = ((BigInteger)macAddr.get(i)).toString(16);
            if (macNum.length() < 2) {
                macNum = '0' + macNum;
            }
            sb.append(macNum);
            if (i == macAddr.size() - 1) continue;
            sb.append('-');
        }
        return sb.toString();
    }
}

