/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.elan;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.elan.TEGetLoopbackCache;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.elan.TELoopbackRspBean;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.elan.TELoopbackRspKeyBean;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class TEStartElanLoopbackBean
extends TECommonWriteLogBean {
    private static final int SELECTALLVALUE = 65534;
    private static final int DEFAULT_VALUE = 1;

    private List getVlanList(String strVlanList) {
        ArrayList vlanList = new ArrayList();
        TEStringUtils.str2Vec((String)strVlanList, vlanList);
        return vlanList;
    }

    protected void modifyInputParams() {
        RowParams inputParams = this.inputData.getBussinessParams().getRowParams(0);
        List vlanList = this.getVlanList(inputParams.getParam("initVlanList").getValue());
        if (vlanList == null || vlanList.isEmpty()) {
            inputParams.getParam("vlanNum").setValue("0");
            inputParams.getParam("vlanList").setValue("0000");
        } else {
            inputParams.getParam("vlanNum").setValue(String.valueOf(vlanList.size()));
            inputParams.getParam("vlanList").setValue(TEStringUtils.intToFormatString((List)vlanList, (int)4));
        }
        TEGetLoopbackCache.getInstance().clear();
        TEGetLoopbackCache.getInstance().registerListener();
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        if (Integer.parseInt(this.outputData.getErrorMessage().getErrorcode()) > 1) {
            return;
        }
        RowParams inputParams = this.inputData.getBussinessParams().getRowParams(0);
        String initVlanList = inputParams.getParam("initVlanList").getValue();
        List vlanList = this.getVlanList("".equals(initVlanList) ? "0" : initVlanList);
        String inftype = inputParams.getParam("inftype").getValue();
        String infID = inputParams.getParam("infID").getValue();
        String serviceIndex = inputParams.getParam("serviceIndex").getValue();
        String slotid = inputParams.getParam("slotid").getValue();
        String boardName = inputParams.getParam("boardName").getValue();
        String portname = inputParams.getParam("portname").getValue();
        String sequence = this.outputData.getBussinessParams().getRowParams(0).getParam("sequence").getValue();
        Map<TELoopbackRspKeyBean, Boolean> statusMap = TEGetLoopbackCache.getInstance().getDetectStatusMap();
        TELoopbackRspKeyBean key = new TELoopbackRspKeyBean(serviceIndex, Integer.parseInt(inftype), Integer.parseInt(infID), sequence);
        for (int times = 0; null == statusMap.get(key) && times < 100; ++times) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                TELogFactory.getNormalLogger().error("InterruptedException!", (Throwable)e);
            }
        }
        this.outputData.getBussinessParams().clearRowParams();
        ArrayList<TELoopbackRspBean> rspBeanList = new ArrayList<TELoopbackRspBean>();
        if (TEGetLoopbackCache.getInstance().getCache().isEmpty()) {
            for (Integer vlan : vlanList) {
                if (vlan == 65534) {
                    TEGetLoopbackCache.getInstance().getCache().add(new TELoopbackRspBean(key, 1));
                    continue;
                }
                TEGetLoopbackCache.getInstance().getCache().add(new TELoopbackRspBean(key, vlan));
            }
        }
        if (vlanList.size() == 1 && (Integer)vlanList.get(0) == 65534) {
            rspBeanList.addAll(TEGetLoopbackCache.getInstance().getCache());
        } else {
            for (TELoopbackRspBean RspBean : TEGetLoopbackCache.getInstance().getCache()) {
                for (Integer vlan : vlanList) {
                    if (!RspBean.getKey().equals(key) || vlan.intValue() != RspBean.getVlanID()) continue;
                    rspBeanList.add(RspBean);
                }
            }
            Collections.sort(rspBeanList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    TELoopbackRspBean rspBean1 = (TELoopbackRspBean)o1;
                    TELoopbackRspBean rspBean2 = (TELoopbackRspBean)o2;
                    return rspBean1.getVlanID() - rspBean2.getVlanID();
                }
            });
        }
        for (TELoopbackRspBean rspBean : rspBeanList) {
            RowParams row = new RowParams();
            row.addParam(new Param("slotid", slotid));
            row.addParam(new Param("boardName", boardName));
            row.addParam(new Param("portname", portname));
            row.addParam(new Param("vlan", rspBean.getVlanID() == 0 ? "" : String.valueOf(rspBean.getVlanID())));
            row.addParam(new Param("detectResult", String.valueOf(rspBean.getResult())));
            row.addParam(new Param("status", String.valueOf(rspBean.getCloseStatus())));
            if (rspBean.getReceivedInfType() == 1) {
                row.addParam(new Param("packetUNI", rspBean.getReceivedInfID() == -1 ? "/" : String.valueOf(rspBean.getReceivedInfID())));
                row.addParam(new Param("packetNNI", "/"));
            } else {
                row.addParam(new Param("packetNNI", rspBean.getReceivedInfID() == -1 ? "/" : String.valueOf(rspBean.getReceivedInfID())));
                row.addParam(new Param("packetUNI", "/"));
            }
            this.outputData.getBussinessParams().addRowParams(row);
        }
    }
}

