/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.elan;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEBatchOperations;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEEthUtil;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEOutbackRowProducer;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEOutputProducer;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.List;

public class TEQuernElanOutputProducer
implements TEOutputProducer,
TEOutbackRowProducer {
    private static final String BUSINESS_TYPE = "businessType";
    private static final String BOARD_SLOT = "portID";
    private static final String BOARD_NAME = "portName";
    private static final String PORT_NUM = "portNum";
    private static final String PORT_NAME = "portName";
    private static final String PORT_TYPE = "portType";
    private static final String ID = "id";
    private static final String ROLE = "role";
    private static final String VLANS = "vlans";
    private static final String PORT_ENABLED = "portEnabled";
    private static final String PORT_MODE = "portMode";
    private static final String ENCAP_TYPE = "encapType";
    private static final String TAG_TYPE = "tagType";

    @Override
    public Object produceOutput(int neID, List<TEBatchOperations> batches) {
        Datainterface df = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        df.setBussinessParams(bParams);
        List<Operation> ceOpers = batches.get((int)0).operations;
        bParams.getRowParamList().addAll(TEEthUtil.createBlock(neID, this, true, ceOpers.get(0), new Operation[0]));
        bParams.getRowParamList().addAll(TEEthUtil.createBlock(neID, this, true, ceOpers.get(1), ceOpers.get(3), ceOpers.get(4), ceOpers.get(5), ceOpers.get(6)));
        bParams.getRowParamList().addAll(TEEthUtil.createBlock(neID, this, false, ceOpers.get(2), ceOpers.get(3), ceOpers.get(4), ceOpers.get(5), ceOpers.get(6)));
        return df;
    }

    @Override
    public RowParams createRow(int neID, Output output, Operation ... opers) {
        Operation operation = opers[0];
        RowParams rowParams = new RowParams();
        String operationName = operation.getName();
        if ("NSCMD_SERVICE_GET_EAGGRINFO".equals(operationName)) {
            return TEQuernElanOutputProducer.createMainRow(output);
        }
        if ("NSCMD_SERVICE_GET_ETHVUNI_EX".equals(operationName)) {
            return TEQuernElanOutputProducer.createPortRow(true, output, neID, opers[1], opers[2], opers[3], opers[4]);
        }
        if ("NSCMD_SERVICE_GET_EVNNI_EX".equals(operationName)) {
            return TEQuernElanOutputProducer.createPortRow(false, output, neID, opers[1], opers[2], opers[3], opers[4]);
        }
        return rowParams;
    }

    private static RowParams createMainRow(Output output) {
        RowParams rowParams = new RowParams();
        Part part = output.getPart(1);
        Param param = new Param(part.getName(), part.getValue());
        rowParams.addParam(param);
        part = output.getPart(2);
        param = new Param(part.getName(), part.getValue());
        rowParams.addParam(param);
        param = new Param(BUSINESS_TYPE, Integer.toString(4));
        rowParams.addParam(param);
        return rowParams;
    }

    private static RowParams createPortRow(boolean isUni, Output vni, int neID, Operation portEnabled, Operation portMode, Operation encapType, Operation tagAware) {
        Param param;
        RowParams rowParams = new RowParams();
        String slot = null;
        String subCard = null;
        String portNum = null;
        if (isUni) {
            slot = vni.getPart(4).getValue();
            subCard = vni.getPart(5).getValue();
            portNum = vni.getPart(6).getValue();
            TEQuernElanOutputProducer.addPortParams(rowParams, neID, slot, subCard, portNum);
            param = new Param(PORT_TYPE, Integer.toString(1));
            rowParams.addParam(param);
        } else {
            Part part = vni.getPart(4);
            if (Integer.parseInt(part.getValue()) != 3) {
                return null;
            }
            slot = vni.getPart(5).getValue();
            subCard = vni.getPart(6).getValue();
            portNum = vni.getPart(7).getValue();
            TEQuernElanOutputProducer.addPortParams(rowParams, neID, slot, subCard, portNum);
            param = new Param(PORT_TYPE, Integer.toString(2));
            rowParams.addParam(param);
        }
        param = new Param(ID, vni.getPart(2).getValue());
        rowParams.addParam(param);
        param = new Param(ROLE, vni.getPart(3).getValue());
        rowParams.addParam(param);
        if (isUni) {
            StringBuffer sb = new StringBuffer();
            byte[] bValue = vni.getPartValue("branchPort").getBytes();
            int nCount = 4;
            int nPos = 0;
            int nParaSize = bValue.length;
            while (nPos + nCount <= nParaSize && nParaSize > 0) {
                byte[] bTmp = new byte[4];
                System.arraycopy(bValue, nPos + 0, bTmp, 0, 4);
                int portId = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                sb.append(portId).append(',');
                nPos += nCount;
            }
            param = new Param(VLANS, sb.toString());
            rowParams.addParam(param);
        } else {
            param = new Param(VLANS, "");
            rowParams.addParam(param);
        }
        param = new Param(PORT_ENABLED, TEEthUtil.findPortAttr(portEnabled.getOutput(), slot, subCard, portNum));
        rowParams.addParam(param);
        param = new Param(PORT_MODE, TEEthUtil.findPortAttr(portMode.getOutput(), slot, subCard, portNum));
        rowParams.addParam(param);
        param = new Param(ENCAP_TYPE, TEEthUtil.findPortAttr(encapType.getOutput(), slot, subCard, portNum));
        rowParams.addParam(param);
        param = new Param(TAG_TYPE, TEEthUtil.findPortAttr(tagAware.getOutput(), slot, subCard, portNum));
        rowParams.addParam(param);
        return rowParams;
    }

    private static void addPortParams(RowParams row, int neID, String slot, String subCard, String portNum) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEBoard board = ne.getBoard(Integer.parseInt(slot));
        Param para = new Param(BOARD_SLOT, slot);
        row.addParam(para);
        para = new Param("portName", board.getBoardName());
        row.addParam(para);
        para = new Param(PORT_NUM, portNum);
        row.addParam(para);
        TEPort port = board.getPort(Integer.parseInt(portNum));
        para = new Param("portName", port.getPortName());
        row.addParam(para);
    }
}

