/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.elan;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEGetElanSHGBean
extends TENEExplorerBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int retCode = this.handleboardlist(operationList);
        if (retCode != 0) {
            this.setErrorDate(retCode);
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }

    private int handleboardlist(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        String[][] portdatastr = new String[len][4];
        int portnum = 0;
        int retCode = 0;
        for (int j = 0; j < len; ++j) {
            Output output = outputArr[j];
            retCode = Integer.valueOf(output.getFault()[0].getCode());
            if (retCode != 0) {
                if (retCode == 38662) {
                    retCode = 0;
                }
                return retCode;
            }
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("serviceIndex") && value != null) {
                    portdatastr[j][0] = value;
                    continue;
                }
                if (name.equalsIgnoreCase("splitid") && value != null) {
                    portdatastr[j][1] = value;
                    continue;
                }
                if (name.equalsIgnoreCase("portNumber") && value != null) {
                    portnum = Integer.valueOf(value);
                    portdatastr[j][2] = Integer.toString(portnum);
                    continue;
                }
                if (!name.equalsIgnoreCase("portdata") || value == null) continue;
                String portstr = null;
                int index = 0;
                for (int i = 0; i < portnum; ++i) {
                    int portdatalength = 4;
                    int porttypelength = 2;
                    int idbegindex = index + porttypelength;
                    portstr = i == 0 ? Integer.toString(Integer.valueOf(value.substring(index, idbegindex), 16)) + "," + Integer.toString(Integer.valueOf(value.substring(idbegindex, idbegindex + portdatalength), 16)) : portstr + "|" + Integer.toString(Integer.valueOf(value.substring(index, idbegindex), 16)) + "," + Integer.toString(Integer.valueOf(value.substring(idbegindex, idbegindex + portdatalength), 16));
                    index = index + porttypelength + portdatalength;
                }
                portdatastr[j][3] = portstr;
            }
        }
        this.handlePortdata(portdatastr);
        return retCode;
    }

    private void handlePortdata(String[][] portstr) {
        BussinessParams businessParam = new BussinessParams();
        for (int i = 0; i < portstr.length; ++i) {
            RowParams rtnRowParams = new RowParams();
            rtnRowParams.addParam("serviceIndex", portstr[i][0]);
            rtnRowParams.addParam("splitid", portstr[i][1]);
            rtnRowParams.addParam("portNumber", portstr[i][2]);
            if (null != portstr[i][3]) {
                rtnRowParams.addParam("portdata", portstr[i][3]);
            } else {
                rtnRowParams.addParam("portdata", "");
            }
            businessParam.addRowParams(rtnRowParams);
        }
        this.outputData.setBussinessParams(businessParam);
    }

    private void setErrorDate(int retCode) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        TEOperationLogUtility.setOperaStr((String)"");
        TEOperationLogUtility.writeLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }
}

