/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.elan;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEGetElanLoopbackBean
extends TENEExplorerBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        int iLength = operationList.size();
        for (int i = 0; i < iLength; ++i) {
            Operation oper = (Operation)operationList.get(i);
            Output[] outputs = oper.getOutput();
            RowParams inputRow = this.inputData.getBussinessParams().getRowParams(i);
            int jLength = outputs.length;
            for (int j = 0; j < jLength; ++j) {
                String vlanList = outputs[j].getPartValue("vlanList");
                if (vlanList == null) {
                    ErrorMessage errMsg = new ErrorMessage();
                    String errCode = outputs[j].getFault(0).getCode();
                    errMsg.setErrorcode(errCode);
                    errMsg.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errCode)));
                    this.outputData.setErrorMessage(errMsg);
                    return;
                }
                int lenList = vlanList.length();
                for (int startIndex = 0; startIndex < lenList; startIndex += 2) {
                    int vlanID = Integer.parseInt(vlanList.substring(startIndex, startIndex + 4), 16);
                    int isoff = Integer.parseInt(vlanList.substring(startIndex += 4, startIndex + 2), 16);
                    RowParams rowparam = new RowParams();
                    rowparam.addParam(new Param("serviceIndex", outputs[j].getPartValue("serviceIndex")));
                    rowparam.addParam(new Param("inftype", outputs[j].getPartValue("inftype")));
                    rowparam.addParam(new Param("vuniID", outputs[j].getPartValue("infID")));
                    rowparam.addParam(new Param("vlanID", vlanID == 0 ? "" : String.valueOf(vlanID)));
                    rowparam.addParam(new Param("portEnable", String.valueOf(isoff)));
                    rowparam.addParam(new Param("slotid", inputRow.getParam("slotid").getValue()));
                    rowparam.addParam(new Param("boardName", inputRow.getParam("boardName").getValue()));
                    rowparam.addParam(new Param("portname", inputRow.getParam("portname").getValue()));
                    this.outputData.getBussinessParams().addRowParams(rowparam);
                }
            }
        }
    }
}

