/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.elan;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEBatchOperations;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEOutbackRowProducer;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEOutputProducer;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEElanOutputProducer
implements TEOutputProducer,
TEOutbackRowProducer {
    private static final List filterErrList = new ArrayList();
    private static final int NSCMD_SERVICE_CRT_ETHSERV = 32396;
    private static final int NSCMD_SERVICE_ADD_ETHVUNI_EX = 33928;
    private static final int NSCMD_CFG_SERVICE_ADD_ETHPBVUNI_EX = 36117;
    private static final int TAG_NUM_LIMIT = 127;
    private Datainterface inputData;

    public TEElanOutputProducer(Datainterface inputData) {
        this.inputData = inputData;
    }

    public TEElanOutputProducer() {
    }

    private Map getAllInputDataTagID() {
        HashMap<String, String[]> id = new HashMap<String, String[]>();
        String key = "";
        String slotid = "";
        String portid = "";
        String vuniID = "";
        RowParams[] rows = this.inputData.getBussinessParams().getRowParams();
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i].getParam("tagID") == null || rows[i].getParam("slotid") == null || rows[i].getParam("portid") == null) continue;
            slotid = rows[i].getParam("slotid").getValue().trim();
            portid = rows[i].getParam("portid").getValue().trim();
            vuniID = rows[i].getParam("vuniID").getValue().trim();
            String[] tagid = rows[i].getParam("tagID").getValue().trim().split(",");
            key = "".concat(slotid).concat(portid).concat(vuniID);
            id.put(key, tagid);
        }
        return id;
    }

    @Override
    public Object produceOutput(int neID, List<TEBatchOperations> batches) {
        Datainterface df = new Datainterface();
        BussinessParams bp = new BussinessParams();
        df.setBussinessParams(bp);
        boolean isFail = true;
        boolean isSucc = true;
        int size = batches.size();
        if (size < 1) {
            df.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return df;
        }
        int len = batches.size();
        for (int i = 0; i < len; ++i) {
            TEBatchOperations batch = batches.get(i);
            List<Operation> ceOpers = batch.operations;
            int operlen = ceOpers.size();
            for (int k = 0; k < operlen; ++k) {
                RowParams row = new RowParams();
                int errCode = Integer.parseInt(ceOpers.get(k).getOutput(0).getFault(0).getCode());
                if (errCode != 0) {
                    isSucc = false;
                    row.addRowErrors(this.constructRowErrors(neID, errCode));
                    bp.getRowParamList().add(row);
                    continue;
                }
                isFail = false;
            }
        }
        int ErrorCode2 = isSucc && !isFail ? 0 : (!isSucc && isFail ? 2 : 1);
        df.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)ErrorCode2));
        return df;
    }

    private Datainterface produceOutputParam(int neID, List operationList) {
        Datainterface df = new Datainterface();
        BussinessParams bp = new BussinessParams();
        df.setBussinessParams(bp);
        boolean isFail = true;
        boolean isSucc = true;
        int size = operationList.size();
        if (size < 1) {
            df.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return df;
        }
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation oper = (Operation)operationList.get(i);
            RowParams row = new RowParams();
            int errCode = Integer.parseInt(oper.getOutput(0).getFault(0).getCode());
            if (errCode != 0 && !filterErrList.contains(errCode)) {
                isSucc = false;
                row.addRowErrors(this.constructRowErrors(neID, errCode));
                bp.getRowParamList().add(row);
                continue;
            }
            isFail = false;
        }
        int ErrorCode2 = isSucc && !isFail ? 0 : (!isSucc && isFail ? 2 : 1);
        df.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)ErrorCode2));
        return df;
    }

    private Object dispatchTagID(Map<String, String[]> tags, int neID, List<TEBatchOperations> batches, int preErrorCode) {
        ArrayList operationList = new ArrayList(0);
        Iterator<String> it = tags.keySet().iterator();
        TEDataConverter.addSingleTRANSBeginOper((int)neID, null, (Datainterface)this.inputData, operationList);
        while (it.hasNext()) {
            String slotportid = it.next();
            String[] tagIDs = tags.get(slotportid);
            if (null == tagIDs || tagIDs.length <= 127) continue;
            String serviceIndex = this.getParValueFromOpears(32396, "serviceIndex", batches);
            if (serviceIndex == null) {
                serviceIndex = this.getParValueFromInput(33928, "serviceIndex", batches);
            }
            String unnID = this.getParValueFromOpears(slotportid, "vuniID", batches);
            operationList.addAll(this.buildDispatchOper(neID, serviceIndex, unnID, tagIDs));
        }
        TEDataConverter.addSingleTRANSCommitOper((int)neID, null, (Datainterface)this.inputData, operationList);
        if (operationList.size() > 2) {
            int timeout = 50;
            if (operationList.size() > 20 && operationList.size() < 30) {
                timeout = 90;
            } else if (operationList.size() > 30) {
                timeout = 120;
            }
            OperationResult result = TENECommMgr.getInstance().sendCommand(neID, operationList, timeout);
            Datainterface df = new Datainterface();
            BussinessParams bp = new BussinessParams();
            df.setBussinessParams(bp);
            if (0 != preErrorCode) {
                return null;
            }
            if (null != result && result.retCode != 0) {
                df.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
                return df;
            }
            return this.produceOutputParam(neID, operationList);
        }
        return null;
    }

    private ArrayList buildDispatchOper(int neID, String serviceIndex, String unnID, String[] tagIDs) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = null;
        int count = 1;
        while (tagIDs.length > 127 * count) {
            oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_SERVICE_ADD_ETHVUNITAG");
            oper.getInput().setPartValue("serviceIndex", serviceIndex);
            oper.getInput().setPartValue("vuniID", unnID);
            if (tagIDs.length > 127 * (count + 1)) {
                oper.getInput().setPartValue("tagNum", String.valueOf(127));
                oper.getInput().setPartValue("tagID", TEElanOutputProducer.getTagIDPartValue(tagIDs, 127 * count, 127));
            } else {
                oper.getInput().setPartValue("tagNum", String.valueOf(tagIDs.length - 127 * count));
                oper.getInput().setPartValue("tagID", TEElanOutputProducer.getTagIDPartValue(tagIDs, 127 * count, 127));
            }
            ++count;
            operationList.add(oper);
        }
        return operationList;
    }

    private String getParValueFromOpears(int cmdID, String partName, List<TEBatchOperations> batches) {
        int len = batches.size();
        for (int i = 0; i < len; ++i) {
            TEBatchOperations batch = batches.get(i);
            List<Operation> ceOpers = batch.operations;
            int operlen = ceOpers.size();
            for (int k = 0; k < operlen; ++k) {
                if (ceOpers.get(k).getCmdid() != cmdID) continue;
                return ceOpers.get(k).getOutput()[0].getPart(partName).getValue();
            }
        }
        return null;
    }

    private String getParValueFromInput(int cmdID, String partName, List<TEBatchOperations> batches) {
        int len = batches.size();
        for (int i = 0; i < len; ++i) {
            TEBatchOperations batch = batches.get(i);
            List<Operation> ceOpers = batch.operations;
            int operlen = ceOpers.size();
            for (int k = 0; k < operlen; ++k) {
                Part tmp;
                if (ceOpers.get(k).getCmdid() != cmdID || (tmp = ceOpers.get(k).getInput().getPart(partName)) == null) continue;
                return tmp.getValue();
            }
        }
        return null;
    }

    private String getParValueFromOpears(String slotportid, String partName, List<TEBatchOperations> batches) {
        int len = batches.size();
        for (int i = 0; i < len; ++i) {
            TEBatchOperations batch = batches.get(i);
            List<Operation> ceOpers = batch.operations;
            Operation op = null;
            String slotid = "";
            String portid = "";
            String vuniID = "";
            int operlen = ceOpers.size();
            for (int k = 0; k < operlen; ++k) {
                op = ceOpers.get(k);
                if (ceOpers.get(k).getCmdid() != 33928 && ceOpers.get(k).getCmdid() != 36117) continue;
                slotid = op.getInput().getPartValue("slotid");
                portid = op.getInput().getPartValue("portid");
                vuniID = op.getInput().getPartValue("vuniID");
                if (!"".concat(slotid).concat(portid).concat(vuniID).equals(slotportid)) continue;
                return ceOpers.get(k).getOutput()[0].getPart(partName).getValue();
            }
        }
        return null;
    }

    @Override
    public RowParams createRow(int neID, Output output, Operation ... opers) {
        return null;
    }

    private RowErrors constructRowErrors(int neid, int errCode) {
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(String.valueOf(errCode));
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errCode));
        rowError.setErrorMessage(errorMessage);
        rowError.addParam(this.constructParam("neid", String.valueOf(neid)));
        rowError.addParam(this.constructParam("nename", TENEListMgr.getInstance().getNE(neid).getNEName()));
        return rowError;
    }

    private Param constructParam(String key, String value) {
        Param param = new Param();
        param.setName(key);
        param.setValue(value);
        return param;
    }

    public static String getTagIDPartValue(String[] tagIDs, int startPos, int tagNum) {
        StringBuffer tagID = new StringBuffer();
        if (tagIDs.length == 1 && tagIDs[0].isEmpty()) {
            tagIDs[0] = "0";
        }
        if (startPos + tagNum <= tagIDs.length) {
            for (int i = startPos; i < startPos + tagNum; ++i) {
                TEElanOutputProducer.apendCharWithProtocol(tagIDs, tagID, i);
            }
        } else {
            for (int i = startPos; i < tagIDs.length; ++i) {
                TEElanOutputProducer.apendCharWithProtocol(tagIDs, tagID, i);
            }
        }
        return tagID.toString();
    }

    private static void apendCharWithProtocol(String[] tagIDs, StringBuffer tagID, int i) {
        StringBuffer addstr = new StringBuffer("0");
        int tmpIntId = Integer.parseInt(tagIDs[i]);
        String tmpID = Integer.toHexString(tmpIntId);
        int len = 8 - tmpID.length();
        for (int j = 1; j < len; ++j) {
            addstr.append('0');
        }
        tagID.append(addstr).append(tmpID);
    }

    static {
        filterErrList.add(38737);
        filterErrList.add(57658);
    }
}

