/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eaggr;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eaggr.TEEAggrUtil;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TEClassifierData;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TEClassifierMgr;
import com.huawei.nglct.nemgr.ip.ptn.policy.classifier.TERuleData;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEQueryPolicyDetailBean
extends TECommonWriteLogBean {
    private Map<String, Output> carInfoMap = new HashMap<String, Output>();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation oper = (Operation)operationList.get(0);
        this.handleClassifier(oper);
        oper = (Operation)operationList.get(1);
        int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
        if (0 == errCode) {
            Output output = null;
            int m = oper.getOutputCount();
            for (int i = 0; i < m; ++i) {
                output = oper.getOutput(i);
                this.queryCarInfo(output);
            }
        }
        super.handleMessage(neid, operationList, subfunc);
    }

    private void handleClassifier(Operation oper) {
        int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
        if (0 != errCode) {
            return;
        }
        TEClassifierMgr classifierMgr = TEClassifierMgr.getInstance();
        classifierMgr.clearClassifierList();
        Output output = null;
        int policyType = -1;
        int policyId = -1;
        int classifierId = -1;
        int m = oper.getOutputCount();
        for (int i = 0; i < m; ++i) {
            output = oper.getOutput(i);
            policyType = Integer.valueOf(output.getPartValue("policyType"));
            TEClassifierData data = classifierMgr.getClassifierData(policyType, policyId = Integer.valueOf(output.getPartValue("policyId")).intValue(), classifierId = Integer.parseInt(output.getPartValue("classifierId")));
            if (null == data) {
                data = new TEClassifierData(policyType, policyId, classifierId);
            }
            int order = Integer.parseInt(output.getPartValue("classifierOrder"));
            int relation = Integer.parseInt(output.getPartValue("relation"));
            int ruleId = Integer.parseInt(output.getPartValue("ruleId"));
            String rule = output.getPartValue("classifierRule");
            int n = rule.length();
            for (int j = 0; j < n; ++j) {
                if (rule.charAt(j) != '\u0000') continue;
                rule = rule.substring(0, j);
                break;
            }
            data.setClassifierOrder(order);
            data.setRelation(relation);
            TERuleData ruleData = new TERuleData(this.neid, ruleId, rule);
            ruleData.setRuleStr(rule);
            data.addRule(ruleData);
            classifierMgr.addClassifier(data);
        }
        Collections.sort(classifierMgr.getClassifierList());
        output = (Output)oper.getOutput(0).clone();
        oper.clearOutput();
        List classifierList = classifierMgr.getClassifierList();
        int mn = classifierList.size();
        for (int k = 0; k < mn; ++k) {
            TEClassifierData data = (TEClassifierData)classifierList.get(k);
            output.setPartValue("policyType", String.valueOf(data.getPolicyType()));
            output.setPartValue("policyId", String.valueOf(data.getPolicyId()));
            output.setPartValue("classifierId", String.valueOf(data.getClassifierId()));
            List ruleList = data.getRuleList();
            String classifierRule = classifierMgr.convertRule2nm(ruleList, data.getRelation(), false);
            int rulelen = classifierRule.length();
            if (classifierRule.endsWith("&") || classifierRule.endsWith("|")) {
                classifierRule = classifierRule.substring(0, rulelen - 1);
            }
            output.setPartValue("classifierRule", classifierRule);
            oper.addOutput((Output)output.clone());
        }
    }

    private void queryCarInfo(Output output) {
        Output tmpOutput = null;
        String policyId = output.getPartValue("car");
        if (this.carInfoMap.containsKey(policyId)) {
            tmpOutput = this.carInfoMap.get(policyId);
            this.addPart(output, tmpOutput);
        } else {
            ArrayList<Operation> operList = new ArrayList<Operation>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_QOS_GET_CARINFO");
            oper.getInput().setPartValue("policyId", policyId);
            operList.add(oper);
            int errCode = this.sendMessage(this.neid, operList);
            if (0 == errCode && 0 == (errCode = Integer.valueOf((tmpOutput = (oper = (Operation)operList.get(0)).getOutput(0)).getFault(0).getCode()).intValue())) {
                TEEAggrUtil.setBandwidthLimit(tmpOutput);
                this.carInfoMap.put(tmpOutput.getPartValue("policyId"), tmpOutput);
                this.addPart(output, tmpOutput);
            }
        }
    }

    private void addPart(Output addOutput, Output tmpOutput) {
        int m = tmpOutput.getPartCount();
        for (int i = 1; i < m; ++i) {
            addOutput.addPart(tmpOutput.getPart(i));
        }
    }
}

