/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eaggr;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEBatchOperations;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEEthUtil;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEOutbackRowProducer;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEOutputProducer;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.List;

public class TEQuernAggreOutputProducer
implements TEOutputProducer,
TEOutbackRowProducer {
    private static final String BUSINESS_TYPE = "businessType";
    private static final String BOARD_SLOT = "portID";
    private static final String BOARD_NAME = "portName";
    private static final String PORT_NUM = "portNum";
    private static final String PORT_NAME = "portName";
    private static final String PORT_TYPE = "portType";
    private static final String ID = "id";
    private static final String ROLE = "role";
    private static final String VLANS = "vlans";
    private static final String PORT_ENABLED = "portEnabled";
    private static final String PORT_MODE = "portMode";
    private static final String ENCAP_TYPE = "encapType";
    private static final String TAG_TYPE = "tagType";
    private List<TEBatchOperations> batches;

    @Override
    public Object produceOutput(int neID, List<TEBatchOperations> batches) {
        Datainterface df = new Datainterface();
        BussinessParams bp = new BussinessParams();
        df.setBussinessParams(bp);
        TEBatchOperations batch = batches.get(0);
        List<Operation> ceOpers = batch.operations;
        bp.getRowParamList().addAll(TEEthUtil.createBlock(neID, this, true, ceOpers.get(0), new Operation[0]));
        this.batches = batches;
        int size = batches.size();
        if (size <= 1) {
            return df;
        }
        bp.getRowParamList().addAll(TEEthUtil.createBlock(neID, this, true, ceOpers.get(1), new Operation[0]));
        bp.getRowParamList().addAll(TEEthUtil.createBlock(neID, this, true, ceOpers.get(2), new Operation[0]));
        return df;
    }

    @Override
    public RowParams createRow(int neID, Output output, Operation ... opers) {
        Operation oper = opers[0];
        RowParams row = new RowParams();
        switch (oper.getCmdid()) {
            case 32400: {
                return TEQuernAggreOutputProducer.createMainRow(output);
            }
            case 33929: {
                return this.createPortRow(true, output, neID);
            }
            case 32412: {
                return this.createPortRow(false, output, neID);
            }
        }
        return row;
    }

    private static RowParams createMainRow(Output output) {
        RowParams row = new RowParams();
        Part part = output.getPart(1);
        Param param = new Param(part.getName(), part.getValue());
        row.addParam(param);
        part = output.getPart(2);
        param = new Param(part.getName(), part.getValue());
        row.addParam(param);
        param = new Param(BUSINESS_TYPE, Integer.toString(4));
        row.addParam(param);
        return row;
    }

    private RowParams createPortRow(boolean isUni, Output vni, int neID) {
        Param param;
        RowParams row = new RowParams();
        String slot = null;
        String subCard = null;
        String portNum = null;
        if (isUni) {
            slot = vni.getPart(4).getValue();
            subCard = vni.getPart(5).getValue();
            portNum = vni.getPart(6).getValue();
            TEQuernAggreOutputProducer.addPortParams(row, neID, slot, subCard, portNum);
            param = new Param(PORT_TYPE, Integer.toString(1));
            row.addParam(param);
        } else {
            Part part = vni.getPart(4);
            if (Integer.parseInt(part.getValue()) != 3) {
                return null;
            }
            slot = vni.getPart(5).getValue();
            subCard = vni.getPart(6).getValue();
            portNum = vni.getPart(7).getValue();
            TEQuernAggreOutputProducer.addPortParams(row, neID, slot, subCard, portNum);
            param = new Param(PORT_TYPE, Integer.toString(2));
            row.addParam(param);
        }
        param = new Param(ID, vni.getPart(2).getValue());
        row.addParam(param);
        param = new Param(ROLE, vni.getPart(3).getValue());
        row.addParam(param);
        if (isUni) {
            StringBuffer sb = new StringBuffer();
            byte[] bValue = vni.getPartValue("branchPort").getBytes();
            int nCount = 4;
            int nParaSize = bValue.length;
            for (int nPos = 0; nPos < nParaSize; nPos += nCount) {
                byte[] bTmp = new byte[4];
                System.arraycopy(bValue, nPos + 0, bTmp, 0, 4);
                int portId = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                sb.append(portId).append(',');
            }
            param = new Param(VLANS, sb.toString());
            row.addParam(param);
        } else {
            param = new Param(VLANS, "");
            row.addParam(param);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(vni.getPart("slotid").getValue());
        builder.append(":");
        builder.append(vni.getPart("subslotid").getValue());
        builder.append(":");
        builder.append(vni.getPart("port").getValue());
        TEBatchOperations batch = TEEthUtil.findBatch(this.batches, builder.toString());
        Operation portEnabled = batch.operations.get(0);
        Operation portMode = batch.operations.get(1);
        Operation encapType = batch.operations.get(2);
        Operation tagAware = batch.operations.get(3);
        param = new Param(PORT_ENABLED, TEEthUtil.findPortAttr(portEnabled.getOutput(), slot, subCard, portNum));
        row.addParam(param);
        param = new Param(PORT_MODE, TEEthUtil.findPortAttr(portMode.getOutput(), slot, subCard, portNum));
        row.addParam(param);
        param = new Param(ENCAP_TYPE, TEEthUtil.findPortAttr(encapType.getOutput(), slot, subCard, portNum));
        row.addParam(param);
        param = new Param(TAG_TYPE, TEEthUtil.findPortAttr(tagAware.getOutput(), slot, subCard, portNum));
        row.addParam(param);
        return row;
    }

    private static void addPortParams(RowParams row, int neID, String slot, String subCard, String portNum) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEBoard board = ne.getBoard(Integer.parseInt(slot));
        Param param = new Param(BOARD_SLOT, slot);
        row.addParam(param);
        param = new Param("portName", board.getBoardName());
        row.addParam(param);
        param = new Param(PORT_NUM, portNum);
        row.addParam(param);
        TEPort port = board.getPort(Integer.parseInt(portNum));
        param = new Param("portName", port.getPortName());
        row.addParam(param);
    }
}

