/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eaggr;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEEthUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEModifyEAggrVuniBean
extends TECommonWriteLogBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, inputData, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        Operation delOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_DEL_ETHVUNI");
        Input delInput = delOper.getInput();
        Operation addOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_ADD_ETHVUNI_EX");
        Input addInput = addOper.getInput();
        this.operationList = new ArrayList();
        String serviceIndex = null;
        Param delParam = null;
        Param modParam = null;
        RowParams rowParams2 = null;
        for (RowParams rowParams2 : inputData.getBussinessParams().getRowParams()) {
            serviceIndex = rowParams2.getParam("serviceIndex").getValue();
            delParam = rowParams2.getParam("delvuni");
            modParam = rowParams2.getParam("modvuni");
            if (null != delParam) {
                delInput.setPartValue("serviceIndex", serviceIndex);
                delInput.setPartValue("vuniID", delParam.getValue());
                this.operationList.add(delOper.clone());
                continue;
            }
            if (null != modParam) {
                rowParams2.addParam("vuniID", modParam.getValue());
                ArrayList oneRowOperList = TEEthUtil.buildVlanFilterTagOper(neid, rowParams2, "NSCMD_SERVICE_SET_ETHVUNITAG");
                this.operationList.addAll(oneRowOperList);
                continue;
            }
            String vlanID = rowParams2.getParam("tagID").getValue();
            ArrayList<Integer> tagIDs = new ArrayList<Integer>();
            TEStringUtils.strToNumList((String)vlanID, tagIDs);
            addInput.setPartValue("autoServiceIndex", "0");
            addInput.setPartValue("serviceIndex", serviceIndex);
            addInput.setPartValue("autoVuniID", "1");
            addInput.setPartValue("vuniID", "0");
            addInput.setPartValue("role", rowParams2.getParam("role").getValue());
            addInput.setPartValue("slotid", rowParams2.getParam("slotid").getValue());
            addInput.setPartValue("subslotid", "255");
            addInput.setPartValue("portid", rowParams2.getParam("port").getValue());
            if (tagIDs.size() <= 127) {
                addInput.setPartValue("tagNum", String.valueOf(tagIDs.size()));
                addInput.setPartValue("tagID", TEEthUtil.getLimitNumTagStr(tagIDs, tagIDs.size()));
            } else {
                addInput.setPartValue("tagNum", String.valueOf(127));
                addInput.setPartValue("tagID", TEEthUtil.getLimitNumTagStr(tagIDs, 127));
            }
            this.operationList.add(addOper.clone());
        }
        return this.operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, Datainterface inputData, SubFunc subfunc) {
        RowParams rowParams2 = null;
        RowParams[] rowParamses = inputData.getBussinessParams().getRowParams();
        Param addParam = null;
        Param delParam = null;
        Param modParam = null;
        Operation opration = null;
        ArrayList addOperationList = new ArrayList();
        for (RowParams rowParams2 : rowParamses) {
            addParam = rowParams2.getParam("role");
            delParam = rowParams2.getParam("delvuni");
            modParam = rowParams2.getParam("modvuni");
            if (addParam == null || delParam != null || modParam != null) continue;
            String vlanID = rowParams2.getParam("tagID").getValue();
            ArrayList tagIDs = new ArrayList();
            TEStringUtils.strToNumList((String)vlanID, tagIDs);
            if (tagIDs.size() <= 127) continue;
            int len = operationList.size();
            for (int j = 0; j < len; ++j) {
                opration = (Operation)operationList.get(j);
                if (null == opration || !"NSCMD_SERVICE_ADD_ETHVUNI_EX".equals(opration.getName()) || !opration.getInput().getPart("slotid").getValue().equals(rowParams2.getParam("slotid").getValue()) || !opration.getInput().getPart("portid").getValue().equals(rowParams2.getParam("port").getValue()) || this.getOperationFaultCode(opration) != 0) continue;
                if (rowParams2.getParam("vuniID") == null) {
                    rowParams2.addParam("vuniID", opration.getOutput(0).getPartValue("vuniID"));
                } else {
                    rowParams2.getParam("vuniID").setValue(opration.getOutput(0).getPartValue("vuniID"));
                }
                ArrayList oneRowOperList = TEEthUtil.buildVlanFilterTagOper(neid, rowParams2, "NSCMD_SERVICE_SET_ETHVUNITAG");
                addOperationList.addAll(oneRowOperList);
            }
        }
        if (!addOperationList.isEmpty()) {
            TENECommMgr.getInstance().sendCommand(neid, addOperationList, null, this.TIME_OUT, false);
            operationList.addAll(addOperationList);
        }
        super.handleMessage(neid, operationList, subfunc);
    }

    private int getOperationFaultCode(Operation oper) {
        int faultCode = 0;
        int size = oper.getOutputCount();
        for (int row = 0; row < size; ++row) {
            int result = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
            if (0 == result) continue;
            return result;
        }
        return faultCode;
    }
}

