/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.eaggr;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TEEAggrUtil {
    private static final String NMS_SLOT = "65535";

    private TEEAggrUtil() {
    }

    public static String parseIntegerList(List<Long> parseList) {
        Collections.sort(parseList);
        String pathName = "";
        if (parseList.size() >= 2) {
            Iterator<Long> it = parseList.iterator();
            long curNumber = it.next();
            long offset = 0L;
            StringBuilder temp = new StringBuilder(String.valueOf(curNumber));
            while (it.hasNext()) {
                long nextNum = it.next();
                if (nextNum != curNumber + offset + 1L) {
                    if (offset != 0L) {
                        temp.append("-").append(curNumber + offset);
                        temp.append(",").append(nextNum);
                    } else {
                        temp.append(",").append(nextNum);
                    }
                    offset = 0L;
                    curNumber = nextNum;
                    continue;
                }
                ++offset;
            }
            if (offset > 0L) {
                temp.append("-").append(curNumber + offset);
            }
            pathName = pathName + temp.toString();
        } else if (parseList.size() == 1) {
            pathName = pathName + parseList.get(0);
        }
        return pathName;
    }

    public static void setPortName(int neid, Datainterface outputData) {
        int slotId = -1;
        int portId = -1;
        String slotStr = null;
        String portName = null;
        RowParams rowPara = null;
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        BussinessParams bussinessParams = outputData.getBussinessParams();
        for (int j = bussinessParams.getRowParamsCount() - 1; j >= 0; --j) {
            rowPara = bussinessParams.getRowParams(j);
            if (rowPara.getRowErrorsCount() > 0) continue;
            Param bandwidth = rowPara.getParam("bandwidthlimit");
            slotStr = rowPara.getParam("slotid").getValue();
            Param portParam = rowPara.getParam("port");
            if (bandwidth != null && bandwidth.getValue().equals("") || NMS_SLOT.equalsIgnoreCase(slotStr)) {
                bussinessParams.removeRowParams(j);
                continue;
            }
            if ("".equals(slotStr) || "0".equals(slotStr) || 0xFFFFFFFFL == (long)Integer.valueOf(slotStr).intValue() || portParam == null || portParam.getValue().isEmpty()) continue;
            slotId = Integer.valueOf(slotStr);
            portId = Integer.valueOf(portParam.getValue());
            portName = cfgMgr.getPortNameForPTN(neid, slotId, cfgMgr.getBoardType(neid, slotId), portId);
            rowPara.getParam("portname").setValue(portName);
        }
    }

    public static void setBandwidthLimit(Output outputs) {
        long cir = Long.valueOf(outputs.getPartValue("cir"));
        long cbs = Long.valueOf(outputs.getPartValue("cbs"));
        long pir = Long.valueOf(outputs.getPartValue("pir"));
        long pbs = Long.valueOf(outputs.getPartValue("pbs"));
        int bwLimit = 1;
        if (0xFFFFFFFFL == cir && 0xFFFFFFFFL == cbs && 0xFFFFFFFFL == pir && 0xFFFFFFFFL == pbs) {
            bwLimit = 0;
        }
        Part newPart = new Part();
        newPart.setName("bandwidthlimit");
        newPart.setValue(String.valueOf(bwLimit));
        outputs.addPart(newPart);
    }

    public static void addTransaction(int neid, List operRes) {
        if (null != operRes && !operRes.isEmpty()) {
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_TRANSACTION_BEGIN");
            operRes.add(0, oper.clone());
            oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_TRANSACTION_END");
            operRes.add(oper.clone());
        }
    }

    public static int createPW(int neid, List<RowParams> rowList) {
        return TEEAggrUtil.createPW(neid, rowList, new ArrayList<String>());
    }

    public static int createPW(int neid, List<RowParams> rowList, List<String> pwIndexList) {
        Operation addSPWOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_ADD_STCUCPW");
        Input addSPWInput = addSPWOper.getInput();
        Operation addDPWOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_ADD_DYNLDPPW");
        Input addDPWInput = addDPWOper.getInput();
        Operation setEncapTypeOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_ENCAPTYPE");
        Input setEncapTypeInput = setEncapTypeOperation.getInput();
        Operation setEnableOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_ENABLE");
        Input setEnableInput = setEnableOper.getInput();
        Operation setCWVCCVOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_CW_VCCV");
        Operation setCWOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_CW");
        Input setCWInput = setCWOper.getInput();
        Operation setVccvOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_VCCV");
        Input setVccvInput = setVccvOperation.getInput();
        Operation setReqVlanOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_ETH_REQVLAN");
        Input setReqVlanInput = setReqVlanOper.getInput();
        Operation setTpIdOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_ETH_TPID");
        Input setTpIdInput = setTpIdOper.getInput();
        Operation setExpOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_QOS_SET_PW_EXP");
        Input setExpInput = setExpOperation.getInput();
        Operation setLspOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_QOS_SET_PW_LSPMODE");
        Input setLspInput = setLspOper.getInput();
        int pwSignalType = 0;
        Param param = null;
        RowParams rowParas = null;
        ArrayList<Object> operList = null;
        int retCode = 0;
        int m = rowList.size();
        for (int i = 0; i < m; ++i) {
            operList = new ArrayList<Object>();
            rowParas = rowList.get(i);
            pwSignalType = Integer.valueOf(rowParas.getParam("pwSignalType").getValue());
            if (1 == pwSignalType) {
                addSPWInput.setPartValue("pwType", rowParas.getParam("pwType").getValue());
                addSPWInput.setPartValue("pwID", rowParas.getParam("pwID").getValue());
                addSPWInput.setPartValue("direction", rowParas.getParam("direction").getValue());
                addSPWInput.setPartValue("pwIngressLabel", rowParas.getParam("pwIngressLabel").getValue());
                addSPWInput.setPartValue("pwEgressLabel", rowParas.getParam("pwEgressLabel").getValue());
                addSPWInput.setPartValue("oppositeLsrID", rowParas.getParam("oppositeLsrID").getValue());
                addSPWInput.setPartValue("tunnelIndexes", rowParas.getParam("tunnelIndexes").getValue());
                operList.add(addSPWOper.clone());
            } else {
                addDPWInput.setPartValue("pwType", rowParas.getParam("pwType").getValue());
                addDPWInput.setPartValue("pwID", rowParas.getParam("pwID").getValue());
                addDPWInput.setPartValue("direction", rowParas.getParam("direction").getValue());
                addDPWInput.setPartValue("oppositeLsrID", rowParas.getParam("oppositeLsrID").getValue());
                addDPWInput.setPartValue("tunnelIndexes", rowParas.getParam("tunnelIndexes").getValue());
                operList.add(addDPWOper.clone());
            }
            setEncapTypeInput.setPartValue("pwEncapsType", rowParas.getParam("pwEncapsType").getValue());
            operList.add(setEncapTypeOperation.clone());
            setEnableInput.setPartValue("isUsedDefaultId", "2");
            setEnableInput.setPartValue("pwIndex", "0");
            setEnableInput.setPartValue("enableState", rowParas.getParam("enableState").getValue());
            if (null != setCWVCCVOper) {
                Input setCWVCCVInput = setCWVCCVOper.getInput();
                setCWVCCVInput.setPartValue("controlWord", rowParas.getParam("controlWord").getValue());
                setCWVCCVInput.setPartValue("ctrlChanType", rowParas.getParam("ctrlChanType").getValue());
                setCWVCCVInput.setPartValue("vccv", rowParas.getParam("vccv").getValue());
                operList.add(setCWVCCVOper.clone());
            } else {
                setCWInput.setPartValue("controlWord", rowParas.getParam("controlWord").getValue());
                operList.add(setCWOper.clone());
                setVccvInput.setPartValue("ctrlChanType", rowParas.getParam("ctrlChanType").getValue());
                setVccvInput.setPartValue("vccv", rowParas.getParam("vccv").getValue());
                operList.add(setVccvOperation.clone());
            }
            param = rowParas.getParam("requestVLAN");
            if (null != param) {
                setReqVlanInput.setPartValue("requestVLAN", param.getValue());
                operList.add(setReqVlanOper.clone());
            }
            if (null != (param = rowParas.getParam("tpID"))) {
                setTpIdInput.setPartValue("isUsedDefaultId", "2");
                setTpIdInput.setPartValue("pwIndex", "0");
                setTpIdInput.setPartValue("tpID", param.getValue());
                operList.add(setTpIdOper.clone());
            }
            if (null != (param = rowParas.getParam("exp"))) {
                setExpInput.setPartValue("auto", "2");
                setExpInput.setPartValue("pwIndex", "0");
                setExpInput.setPartValue("direction", rowParas.getParam("idirection").getValue());
                setExpInput.setPartValue("exp", param.getValue());
                operList.add(setExpOperation.clone());
            }
            if (null != (param = rowParas.getParam("lspmode"))) {
                setLspInput.setPartValue("auto", "2");
                setLspInput.setPartValue("pwIndex", "0");
                setLspInput.setPartValue("direction", rowParas.getParam("edirection").getValue());
                setLspInput.setPartValue("lspmode", param.getValue());
                operList.add(setLspOper.clone());
            }
            TEEAggrUtil.addTransaction(neid, operList);
            retCode = TEEAggrUtil.handleCreatePW(neid, rowList, operList, pwIndexList);
            if (0 != retCode) break;
        }
        TEEAggrUtil.backFillPwIndex(retCode, rowList, pwIndexList);
        return retCode;
    }

    public static int createPWForEggress(int neid, List<RowParams> rowList) {
        return TEEAggrUtil.createPWForEggress(neid, rowList, new ArrayList<String>());
    }

    public static int createPWForEggress(int neid, List<RowParams> rowList, List<String> pwIndexList) {
        Operation addSPWOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_ADD_STCUCPW");
        Input addSPWInput1 = addSPWOper.getInput();
        Operation addDPWOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_ADD_DYNLDPPW");
        Input addDPWInput1 = addDPWOper.getInput();
        Operation setEncapTypeOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_ENCAPTYPE");
        Input setEncapTypeInput = setEncapTypeOperation.getInput();
        Operation setEnableOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_ENABLE");
        Input setEnableInput = setEnableOper.getInput();
        Operation setCWVCCVOper1 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_CW_VCCV");
        Operation setCWOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_CW");
        Input setCWInput = setCWOper.getInput();
        Operation setVccvOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_VCCV");
        Input setVccvInput = setVccvOperation.getInput();
        Operation setReqVlanOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_ETH_REQVLAN");
        Input setReqVlanInput = setReqVlanOper.getInput();
        Operation setTpIdOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_SET_ETH_TPID");
        Input setTpIdInput = setTpIdOper.getInput();
        Operation addBPWOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_BOUND_EGRESS_TNL");
        Input addBPWInput = addBPWOperation.getInput();
        Operation setExpOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_QOS_SET_PW_EXP");
        Input setExpInput = setExpOper.getInput();
        Operation setLspOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_QOS_SET_PW_LSPMODE");
        Input setLspInput = setLspOper.getInput();
        int pwSignalType = 0;
        Param paramTmp = null;
        RowParams rowParas = null;
        ArrayList<Object> operList = null;
        int retCode = 0;
        int m = rowList.size();
        for (int i = 0; i < m; ++i) {
            operList = new ArrayList<Object>();
            rowParas = rowList.get(i);
            pwSignalType = Integer.valueOf(rowParas.getParam("pwSignalType").getValue());
            if (1 == pwSignalType) {
                addSPWInput1.setPartValue("pwType", rowParas.getParam("pwType").getValue());
                addSPWInput1.setPartValue("pwID", rowParas.getParam("pwID").getValue());
                addSPWInput1.setPartValue("direction", rowParas.getParam("direction").getValue());
                addSPWInput1.setPartValue("pwIngressLabel", rowParas.getParam("pwIngressLabel").getValue());
                addSPWInput1.setPartValue("pwEgressLabel", rowParas.getParam("pwEgressLabel").getValue());
                addSPWInput1.setPartValue("oppositeLsrID", rowParas.getParam("oppositeLsrID").getValue());
                addSPWInput1.setPartValue("tunnelIndexes", rowParas.getParam("tunnelIndexes").getValue());
                operList.add(addSPWOper.clone());
            } else {
                addDPWInput1.setPartValue("pwType", rowParas.getParam("pwType").getValue());
                addDPWInput1.setPartValue("pwID", rowParas.getParam("pwID").getValue());
                addDPWInput1.setPartValue("direction", rowParas.getParam("direction").getValue());
                addDPWInput1.setPartValue("oppositeLsrID", rowParas.getParam("oppositeLsrID").getValue());
                addDPWInput1.setPartValue("tunnelIndexes", rowParas.getParam("tunnelIndexes").getValue());
                operList.add(addDPWOper.clone());
            }
            addBPWInput.setPartValue("tunnelid", rowParas.getParam("tunnelid").getValue());
            addBPWInput.setPartValue("ingressid", rowParas.getParam("ingressid").getValue());
            addBPWInput.setPartValue("egressid", rowParas.getParam("egressid").getValue());
            operList.add(addBPWOperation.clone());
            setEncapTypeInput.setPartValue("pwEncapsType", rowParas.getParam("pwEncapsType").getValue());
            operList.add(setEncapTypeOperation.clone());
            setEnableInput.setPartValue("isUsedDefaultId", "2");
            setEnableInput.setPartValue("pwIndex", "0");
            setEnableInput.setPartValue("enableState", rowParas.getParam("enableState").getValue());
            if (null != setCWVCCVOper1) {
                Input setCWVCCVInput = setCWVCCVOper1.getInput();
                setCWVCCVInput.setPartValue("controlWord", rowParas.getParam("controlWord").getValue());
                setCWVCCVInput.setPartValue("ctrlChanType", rowParas.getParam("ctrlChanType").getValue());
                setCWVCCVInput.setPartValue("vccv", rowParas.getParam("vccv").getValue());
                operList.add(setCWVCCVOper1.clone());
            } else {
                setCWInput.setPartValue("controlWord", rowParas.getParam("controlWord").getValue());
                operList.add(setCWOper.clone());
                setVccvInput.setPartValue("ctrlChanType", rowParas.getParam("ctrlChanType").getValue());
                setVccvInput.setPartValue("vccv", rowParas.getParam("vccv").getValue());
                operList.add(setVccvOperation.clone());
            }
            paramTmp = rowParas.getParam("requestVLAN");
            if (null != paramTmp) {
                setReqVlanInput.setPartValue("requestVLAN", paramTmp.getValue());
                operList.add(setReqVlanOper.clone());
            }
            if (null != (paramTmp = rowParas.getParam("tpID"))) {
                setTpIdInput.setPartValue("isUsedDefaultId", "2");
                setTpIdInput.setPartValue("pwIndex", "0");
                setTpIdInput.setPartValue("tpID", paramTmp.getValue());
                operList.add(setTpIdOper.clone());
            }
            if (null != (paramTmp = rowParas.getParam("exp"))) {
                setExpInput.setPartValue("auto", "2");
                setExpInput.setPartValue("pwIndex", "0");
                setExpInput.setPartValue("direction", rowParas.getParam("idirection").getValue());
                setExpInput.setPartValue("exp", paramTmp.getValue());
                operList.add(setExpOper.clone());
            }
            if (null != (paramTmp = rowParas.getParam("lspmode"))) {
                setLspInput.setPartValue("auto", "2");
                setLspInput.setPartValue("pwIndex", "0");
                setLspInput.setPartValue("direction", rowParas.getParam("edirection").getValue());
                setLspInput.setPartValue("lspmode", paramTmp.getValue());
                operList.add(setLspOper.clone());
            }
            TEEAggrUtil.addTransaction(neid, operList);
            retCode = TEEAggrUtil.handleCreatePW(neid, rowList, operList, pwIndexList);
            if (0 != retCode) break;
        }
        TEEAggrUtil.backFillPwIndex(retCode, rowList, pwIndexList);
        return retCode;
    }

    public static int handleCreatePW(int neid, List<RowParams> rowList, List operList, List<String> pwIndexList) {
        int retCode = TENECommMgr.getInstance().sendCommand((int)neid, (List)((ArrayList)operList), null, (int)30, (boolean)false).retCode;
        if (0 == retCode) {
            String opName = null;
            Output output = null;
            Operation oper = null;
            String pwIndex = null;
            int m = operList.size();
            for (int i = 0; i < m; ++i) {
                int errCode;
                oper = (Operation)operList.get(i);
                opName = oper.getName();
                if ("NSCMD_PTN_MPLS_PW_ADD_STCUCPW".equals(opName) || "NSCMD_PTN_MPLS_PW_ADD_DYNLDPPW".equals(opName)) {
                    output = oper.getOutput(0);
                    errCode = Integer.valueOf(output.getFault(0).getCode());
                    if (0 != errCode) {
                        pwIndex = null;
                        retCode = errCode;
                        continue;
                    }
                    pwIndex = output.getPartValue("pwIndex");
                    pwIndexList.add(pwIndex);
                    continue;
                }
                if (!"NSCMD_CFG_TRANSACTION_END".equals(opName) || 0 == (errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode()).intValue()) || null == pwIndex) continue;
                pwIndexList.remove(pwIndex);
                retCode = errCode;
            }
            if (0 != retCode) {
                TEEAggrUtil.batchDelPW(neid, pwIndexList);
                return retCode;
            }
        }
        return retCode;
    }

    public static void backFillPwIndex(int errCode, List<RowParams> rowList, List<String> pwIndexList) {
        if (0 == errCode) {
            RowParams rowParas = null;
            int n = rowList.size();
            for (int j = 0; j < n; ++j) {
                rowParas = rowList.get(j);
                rowParas.getParam("carrierID3").setValue(pwIndexList.get(j));
                if (rowParas.getParam("qosPwIndex") == null) continue;
                rowParas.getParam("qosPwIndex").setValue(pwIndexList.get(j));
            }
        }
    }

    public static void batchDelPW(int neid, List<String> pwIndexList) {
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_MPLS_PW_DEL_PW");
        Input input = operation.getInput();
        ArrayList<Object> operList = new ArrayList<Object>();
        int m = pwIndexList.size();
        for (int i = 0; i < m; ++i) {
            input.setPartValue("pwIndex", pwIndexList.get(i));
            operList.add(operation.clone());
        }
        if (!operList.isEmpty()) {
            TENECommMgr.getInstance().sendCommand(neid, operList, null, 30, false);
        }
    }

    public static int addVNNI(int neid, List<RowParams> rowList, List operList) {
        Operation addVnniOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_ADD_ETHVNNI");
        Input addVnniInput = addVnniOper.getInput();
        RowParams rowParas = null;
        operList.clear();
        int m = rowList.size();
        for (int i = 0; i < m; ++i) {
            rowParas = rowList.get(i);
            addVnniInput.setPartValue("autoServiceIndex", "0");
            addVnniInput.setPartValue("serviceIndex", rowParas.getParam("serviceIndex").getValue());
            addVnniInput.setPartValue("autoVnniID", "1");
            addVnniInput.setPartValue("vnniID", rowParas.getParam("vnniID").getValue());
            addVnniInput.setPartValue("role", rowParas.getParam("role").getValue());
            addVnniInput.setPartValue("carrierType", rowParas.getParam("carrierType").getValue());
            addVnniInput.setPartValue("carrierID1", rowParas.getParam("carrierID1").getValue());
            addVnniInput.setPartValue("carrierID2", rowParas.getParam("carrierID2").getValue());
            addVnniInput.setPartValue("carrierID3", rowParas.getParam("carrierID3").getValue());
            operList.add(addVnniOper.clone());
        }
        return TENECommMgr.getInstance().sendCommand((int)neid, (List)((ArrayList)operList), null, (int)30, (boolean)false).retCode;
    }
}

