/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.cesmgr_u2kv1r7c00;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.cesmgr.TECesUtil;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.TEEthUtil;
import com.huawei.nglct.util.convertor.TETimeSlotConvertUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import gnu.trove.TLongArrayList;
import java.util.ArrayList;

public class TEQueryCesBean
extends TECommonWriteLogBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation oper = (Operation)operationList.get(0);
        int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
        if (0 == errCode) {
            Part part = null;
            Output output = null;
            int m = oper.getOutputCount();
            for (int i = 0; i < m; ++i) {
                output = oper.getOutput(i);
                part = output.getPart("servicename");
                part.setValue(IOStreamConvertor.replaceSpecialStr((String)part.getValue()).trim());
            }
            TECesUtil.refreshCESIDCache(neid, "serviceid", oper);
        }
        oper = (Operation)operationList.get(1);
        if (0 == errCode) {
            Part overheadPart = null;
            StringBuilder overheadString = new StringBuilder("");
            Output output = null;
            int m = oper.getOutputCount();
            for (int i = 0; i < m; ++i) {
                output = oper.getOutput(i);
                if (output.getPartValue("overheadcount") == null) continue;
                int countPart = Integer.parseInt(output.getPartValue("overheadcount"));
                overheadPart = output.getPart("overhead");
                if (countPart > 0) {
                    for (int j = 0; j < countPart; ++j) {
                        String oneOverheadObj = overheadPart.getValue().substring(2 * j, 2 * (j + 1));
                        if (oneOverheadObj.isEmpty()) continue;
                        overheadString.append(oneOverheadObj).append(';');
                    }
                }
                overheadPart.setValue(overheadString.toString());
            }
        }
        this.handleVUNI((Operation)operationList.get(2));
        this.handleVNNI((Operation)operationList.get(3));
        super.handleMessage(neid, operationList, subfunc);
    }

    private void handleVUNI(Operation oper) {
        int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
        if (0 == errCode) {
            Output output = null;
            TLongArrayList cesIndexList = new TLongArrayList();
            int m = oper.getOutputCount();
            for (int i = 0; i < m; ++i) {
                output = oper.getOutput(i);
                long cesIndex = Long.valueOf(output.getPartValue("cesindex"));
                if (!cesIndexList.contains(cesIndex)) {
                    this.convertOutput("src", output);
                    cesIndexList.add(cesIndex);
                    continue;
                }
                this.convertOutput("snk", output);
            }
        }
    }

    private void convertOutput(String srcSnk, Output output) {
        int slotId = Integer.valueOf(output.getPartValue("slotid"));
        int portId = Integer.valueOf(output.getPartValue("port"));
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        int boardType = cfgDataMgr.getBoardType(this.neid, slotId);
        String boardName = cfgDataMgr.getBoardTypeName(this.neid, boardType);
        String portName = cfgDataMgr.getPortNameForPTN(this.neid, slotId, boardType, portId);
        this.addPart(output, srcSnk + "boardname", boardName);
        this.addPart(output, srcSnk + "portname", portName);
        Part part = output.getPart("slotid");
        part.setName(srcSnk + part.getName());
        part = output.getPart("port");
        part.setName(srcSnk + part.getName());
        part = output.getPart("highchannel");
        part.setName(srcSnk + part.getName());
        part = output.getPart("lowchannel");
        part.setName(srcSnk + part.getName());
        String level = output.getPartValue("lowlevel");
        part.setValue(level + "-" + part.getValue());
        this.addPart(output, "level", level);
        String timeSlotStr = "-";
        int timeSlotNum = Integer.valueOf(output.getPartValue("vunitimenum"));
        part = output.getPart("vunitimes");
        if (0 < timeSlotNum) {
            ArrayList<Integer> timeSlotList = new ArrayList<Integer>();
            byte[] bValue = part.getValue().getBytes();
            int timeSlot = -1;
            int nCount = 4;
            int nPos = 0;
            int nParaSize = bValue.length;
            while (nPos + nCount <= nParaSize && nParaSize > 0) {
                timeSlot = IOStreamConvertor.readPositiveInt((byte[])bValue, (int)nPos);
                timeSlotList.add(TETimeSlotConvertUtil.convertSlotMode((int)timeSlot));
                nPos += nCount;
            }
            timeSlotStr = TEStringUtils.parseIntegerList(timeSlotList);
        }
        part.setName(srcSnk + "timeslot");
        part.setValue(timeSlotStr);
    }

    private void addPart(Output output, String partName, String partValue) {
        Part newPart = new Part();
        newPart.setName(partName);
        newPart.setValue(partValue);
        output.addPart(newPart);
    }

    private void handleVNNI(Operation oper) {
        int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
        if (0 == errCode) {
            int loadType = -1;
            Output output = null;
            int m = oper.getOutputCount();
            for (int i = 0; i < m; ++i) {
                output = oper.getOutput(i);
                loadType = Integer.valueOf(output.getPartValue("loadtype"));
                if (1 != loadType) continue;
                long index = Long.valueOf(output.getPartValue("index"));
                this.queryPWInfo(output, index);
            }
        }
    }

    private void queryPWInfo(Output output, long index) {
        Output tmpOutput;
        long pwId = index;
        String tunnelTypeStr = "";
        String tunnelIdStr = "";
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW");
        oper.getInput().setPartValue("pwIndex", String.valueOf(index));
        operList.add(oper);
        int errCode = this.sendMessage(this.neid, operList);
        if (0 == errCode && 0 == (errCode = Integer.valueOf((tmpOutput = (oper = (Operation)operList.get(0)).getOutput(0)).getFault(0).getCode()).intValue())) {
            pwId = Long.valueOf(tmpOutput.getPartValue("pwID"));
            TLongArrayList tunnelList = new TLongArrayList();
            int tunnelCount = Integer.valueOf(tmpOutput.getPartValue("tunnelCount"));
            String tunnelIndexList = tmpOutput.getPartValue("tunnelIndexList");
            for (int i = 0; i < tunnelCount; ++i) {
                String tunnelIndex = tunnelIndexList.substring(8 * i, 8 * i + 8);
                if (tunnelIndex == null || tunnelIndex.equals("")) continue;
                tunnelList.add(Long.valueOf(tunnelIndex, 16).longValue());
            }
            String[] strArr = this.queryTunnelInfo(tunnelList);
            tunnelTypeStr = strArr[0];
            tunnelIdStr = strArr[1];
        }
        Part part = output.getPart("index");
        part.setName("pwIndex");
        part.setValue(String.valueOf(index));
        this.addPart(output, "pwID", String.valueOf(pwId));
        this.addPart(output, "tunneltype", tunnelTypeStr);
        this.addPart(output, "tunnelid", tunnelIdStr);
        String protectPwIndex = TEEthUtil.getProtectPwIndexByWorkPwIndex(this.neid, String.valueOf(index));
        if (protectPwIndex == null) {
            protectPwIndex = "";
        }
        this.addPart(output, "protectPwIndex", protectPwIndex);
    }

    private String[] queryTunnelInfo(TLongArrayList tunnelList) {
        String str;
        ArrayList<Object> operList = new ArrayList<Object>();
        Operation oper1 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_MPLS_GET_TUNNEL");
        Input input1 = oper1.getInput();
        Operation oper2 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_IP_TNL_GET_TUNNEL");
        Input input2 = oper2.getInput();
        Operation oper3 = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GRE_TNL_GET_TUNNEL");
        Input input3 = oper3.getInput();
        String tunnelIndex = null;
        int m = tunnelList.size();
        for (int i = 0; i < m; ++i) {
            tunnelIndex = String.valueOf(tunnelList.get(i));
            input1.setPartValue("tunnelindex", tunnelIndex);
            operList.add(oper1.clone());
            input2.setPartValue("tunnelindex", tunnelIndex);
            operList.add(oper2.clone());
            input3.setPartValue("tunnelindex", tunnelIndex);
            operList.add(oper3.clone());
        }
        int tunnelType = -1;
        StringBuilder sb = new StringBuilder();
        if (operList.size() > 0) {
            Operation oper = null;
            int errCode = this.sendMessage(this.neid, operList);
            if (0 == errCode) {
                int n = operList.size();
                for (int j = 0; j < n; ++j) {
                    oper = (Operation)operList.get(j);
                    errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
                    if (0 != errCode) continue;
                    tunnelType = this.getTunnelType(oper);
                    sb.append(oper.getOutput(0).getPartValue("tunnelid"));
                    sb.append(",");
                }
            }
        }
        str = (str = sb.toString()).endsWith(",") ? str.substring(0, str.length() - 1) : str;
        String[] strArr = new String[]{String.valueOf(tunnelType), str};
        return strArr;
    }

    private int getTunnelType(Operation oper) {
        int tunnelType = 1;
        String operName = oper.getName();
        if ("NSCMD_CFG_IP_TNL_GET_TUNNEL".equals(operName)) {
            tunnelType = 3;
        } else if ("NSCMD_CFG_GRE_TNL_GET_TUNNEL".equals(operName)) {
            tunnelType = 4;
        }
        return tunnelType;
    }
}

