/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.cesmgr_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TECreateProtectGroup
extends TECommonWriteLogBean {
    protected static final String NSCMD_PTN_MPLS_PW_ADD_STCUCPW = "NSCMD_PTN_MPLS_PW_ADD_STCUCPW";
    protected static final String NSCMD_PTN_MPLS_PW_ADD_DYNLDPPW = "NSCMD_PTN_MPLS_PW_ADD_DYNLDPPW";
    protected static final String NSCMD_PTN_MPLS_PW_SET_CES_RTPEN = "NSCMD_PTN_MPLS_PW_SET_CES_RTPEN";
    protected static final String NSCMD_PTN_MPLS_PW_SET_CES_JITTER = "NSCMD_PTN_MPLS_PW_SET_CES_JITTER";
    protected static final String NSCMD_PTN_MPLS_PW_SET_CES_LOADTIME = "NSCMD_PTN_MPLS_PW_SET_CES_LOADTIME";
    protected static final String NSCMD_PTN_MPLS_PW_SET_ENCAPCES_CLKMODE = "NSCMD_PTN_MPLS_PW_SET_ENCAPCES_CLKMODE";
    protected static final String NSCMD_PTN_MPLS_PW_SET_CES_EMULPARA = "NSCMD_PTN_MPLS_PW_SET_CES_EMULPARA";
    protected static final String NSCMD_PTN_QOS_SET_PW_EXP = "NSCMD_PTN_QOS_SET_PW_EXP";
    protected static final String NSCMD_PTN_MPLS_PW_BOUND_EGRESS_TNL = "NSCMD_PTN_MPLS_PW_BOUND_EGRESS_TNL";
    protected static final String NSCMD_SERVICE_CES_SET_SRVPRI = "NSCMD_SERVICE_CES_SET_SRVPRI";
    protected static final String NSCMD_ETHN_PWOAM_SET_ENABLE = "NSCMD_ETHN_PWOAM_SET_ENABLE";
    protected static final String NSCMD_ETHN_PWOAM_SET_TTSI = "NSCMD_ETHN_PWOAM_SET_TTSI";
    protected static final String NSCMD_ETHN_PWOAM_SET_CHECKWAY = "NSCMD_ETHN_PWOAM_SET_CHECKWAY";
    protected static final String NSCMD_ETHN_PWOAM_SET_CHECKPARA = "NSCMD_ETHN_PWOAM_SET_CHECKPARA";
    protected static final String NSCMD_ETHN_PWAPS_ADD_APSPG = "NSCMD_ETHN_PWAPS_ADD_APSPG";
    protected static final String NSCMD_ETHN_PWAPS_SET_APSEN = "NSCMD_ETHN_PWAPS_SET_APSEN";
    protected static final String NSCMD_ETHN_PWAPS_SET_SWMOODE = "NSCMD_ETHN_PWAPS_SET_SWMOODE";
    protected static final String NSCMD_ETHN_PWAPS_SET_RVTMOODE = "NSCMD_ETHN_PWAPS_SET_RVTMOODE";
    protected static final String NSCMD_ETHN_PWAPS_SET_WTRTIME = "NSCMD_ETHN_PWAPS_SET_WTRTIME";
    protected static final String NSCMD_ETHN_PWAPS_SET_HOLDOFFTIME = "NSCMD_ETHN_PWAPS_SET_HOLDOFFTIME";
    protected static final String NSCMD_ETHN_PWAPS_ADD_APSPAIR = "NSCMD_ETHN_PWAPS_ADD_APSPAIR";
    protected static final String NSCMD_PTN_MPLS_PW_SET_VCCV = "NSCMD_PTN_MPLS_PW_SET_VCCV";
    protected static final String NSCMD_PTN_MPLS_PW_SET_CW_VCCV = "NSCMD_PTN_MPLS_PW_SET_CW_VCCV";
    private static final int GETOPERAFAILED = -2;
    private static final int OPERFROMNEFAILED = -3;
    private static final int SENDCMDFAILED = -4;
    public static final String PW_SIGNAL_TYPE_STATIC = "0";
    public static final String PW_SIGNAL_TYPE_DYNAMIC = "1";
    private static final String PW_APS = "1";
    private static final String PW_SLAVE_PAIRE = "2";
    private String protectType;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.protectType = inputData.getBussinessParams().getRowParams(inputData.getBussinessParams().getRowParamsCount() - 1).getParam("protecttype").getValue();
            String workPwIndex = inputData.getBussinessParams().getRowParams(inputData.getBussinessParams().getRowParamsCount() - 1).getParam("workPwIndex").getValue();
            int totalResult = 0;
            totalResult = this.setPWAttr(workPwIndex, subFunc, inputData.getBussinessParams().getRowParams(1));
            if (totalResult != 0) {
                if (totalResult == -3) {
                    this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                } else if (totalResult == -2) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)totalResult));
                }
                return this.outputData;
            }
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            String protectPwIndex = null;
            Object resultObj = this.createProtectPw(subFunc);
            if (resultObj instanceof Datainterface) {
                return (Datainterface)resultObj;
            }
            protectPwIndex = resultObj.toString();
            totalResult = this.createProtectGroup(workPwIndex, protectPwIndex, subFunc);
            if (totalResult != 0) {
                if (totalResult == -3) {
                    this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                } else if (totalResult == -2) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
                }
                this.deletePW(protectPwIndex);
                return this.outputData;
            }
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            this.outputData.getBussinessParams().getRowParams(0).getParam("protectpw").setValue(protectPwIndex);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private int createProtectGroup(String workPwIndex, String protectPwIndex, SubFunc subFunc) {
        RowParams row = this.inputData.getBussinessParams().getRowParams()[this.inputData.getBussinessParams().getRowParamsCount() - 1];
        Datainterface tmpIput = new Datainterface();
        BussinessParams bus = new BussinessParams();
        bus.addRowParams(row);
        tmpIput.setBussinessParams(bus);
        this.operationList = new ArrayList();
        TEDataConverter.addTRANSBeginOper((int)this.neid, (SubFunc)subFunc, (Datainterface)tmpIput, (ArrayList)this.operationList);
        ArrayList<String> ParamList = new ArrayList<String>();
        int result = 0;
        Param param = new Param();
        param.setName("workpw");
        param.setValue(workPwIndex);
        row.addParam(param);
        param = new Param();
        param.setName("protectpw");
        param.setValue(protectPwIndex);
        row.addParam(param);
        if ("1".equals(this.protectType)) {
            ParamList.add("autoassign");
            ParamList.add("apsid");
            ParamList.add("protype");
            ParamList.add("workpw");
            ParamList.add("protectpw");
            result = this.addOperationList(this.neid, NSCMD_ETHN_PWAPS_ADD_APSPG, ParamList, row, this.operationList);
            if (result != 0) {
                return result;
            }
            ParamList.clear();
            ParamList.add("autoassign");
            ParamList.add("apsid");
            ParamList.add("switchmode");
            result = this.addOperationList(this.neid, NSCMD_ETHN_PWAPS_SET_SWMOODE, ParamList, row, this.operationList);
            if (result != 0) {
                return result;
            }
            ParamList.clear();
            ParamList.add("autoassign");
            ParamList.add("apsid");
            ParamList.add("rvtmode");
            result = this.addOperationList(this.neid, NSCMD_ETHN_PWAPS_SET_RVTMOODE, ParamList, row, this.operationList);
            if (result != 0) {
                return result;
            }
            ParamList.clear();
            ParamList.add("autoassign");
            ParamList.add("apsid");
            ParamList.add("isenable");
            result = this.addOperationList(this.neid, NSCMD_ETHN_PWAPS_SET_APSEN, ParamList, row, this.operationList);
            if (result != 0) {
                return result;
            }
            ParamList.clear();
            ParamList.add("autoassign");
            ParamList.add("apsid");
            ParamList.add("wtrtime");
            result = this.addOperationList(this.neid, NSCMD_ETHN_PWAPS_SET_WTRTIME, ParamList, row, this.operationList);
            if (result != 0) {
                return result;
            }
            ParamList.clear();
            ParamList.add("autoassign");
            ParamList.add("apsid");
            ParamList.add("delaytime");
            result = this.addOperationList(this.neid, NSCMD_ETHN_PWAPS_SET_HOLDOFFTIME, ParamList, row, this.operationList);
            if (result != 0) {
                return result;
            }
        } else if (PW_SLAVE_PAIRE.equals(this.protectType)) {
            ParamList.add("autoassign");
            ParamList.add("apsid");
            ParamList.add("workpw");
            ParamList.add("protectpw");
            ParamList.add("extendargs");
            result = this.addOperationList(this.neid, NSCMD_ETHN_PWAPS_ADD_APSPAIR, ParamList, row, this.operationList);
            if (result != 0) {
                return result;
            }
        }
        TEDataConverter.addTRANSCommitOper((int)this.neid, (SubFunc)subFunc, (Datainterface)tmpIput, (ArrayList)this.operationList);
        return this.sendMessageAndProcessResult(subFunc);
    }

    protected void getSetPRIOperation(RowParams row, List operList, String cesIndex) {
        Param srvPriParam;
        Operation oper;
        String unnid = null;
        for (int i = 0; i < operList.size(); ++i) {
            Part unnidPart;
            oper = (Operation)operList.get(i);
            if (!oper.getName().equals("NSCMD_SERVICE_CES_CRT_VUNI") || (unnidPart = oper.getInput().getPart("vuniid")) == null) continue;
            unnid = unnidPart.getValue();
            break;
        }
        if ((srvPriParam = row.getParam("srvPri")) != null) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_SERVICE_CES_SET_SRVPRI);
            oper.getInput().setPartValue("isAuto", PW_SLAVE_PAIRE);
            oper.getInput().setPartValue("cesindex", cesIndex);
            oper.getInput().setPartValue("isUniAuto", PW_SLAVE_PAIRE);
            oper.getInput().setPartValue("vuniid", unnid);
            oper.getInput().setPartValue("srvPri", srvPriParam.getValue());
            operList.add(oper);
        }
    }

    private void addSpecialInputParam(RowParams row) {
        row.addParam("auto", PW_SLAVE_PAIRE);
    }

    protected void addTunnelInputParam(RowParams row) {
        Param param = row.getParam("egresstunnelIndexes");
        int tunnelIndexes = 0;
        try {
            tunnelIndexes = Integer.parseInt(param.getValue());
        }
        catch (NumberFormatException ex) {
            tunnelIndexes = 0;
        }
        ArrayList<Operation> queryList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_MPLS_GET_TUNNEL");
        oper.getInput().setPartValue("tunnelindex", String.valueOf(tunnelIndexes));
        queryList.add(oper);
        int totalResult = TECommuNEMgr.getInstance().sendCommand((int)this.neid, queryList, (int)20, (SubFunc)this.subfunc).retCode;
        if (totalResult != 0) {
            return;
        }
        this.inputData.getBussinessParams().getRowParams(0).addParam("ingressid", oper.getOutput(0).getPartValue("ingressNodeId"));
        this.inputData.getBussinessParams().getRowParams(0).addParam("egressid", oper.getOutput(0).getPartValue("egressNodeId"));
        this.inputData.getBussinessParams().getRowParams(0).addParam("tunnelid", oper.getOutput(0).getPartValue("tunnelid"));
    }

    private int setPWAttr(String pwIndex, SubFunc subFunc, RowParams row) {
        Datainterface tmpIput = new Datainterface();
        BussinessParams bus = new BussinessParams();
        bus.addRowParams(row);
        tmpIput.setBussinessParams(bus);
        this.operationList = new ArrayList();
        row.addParam("pwIndex", pwIndex);
        row.addParam("pwindex", pwIndex);
        TEDataConverter.addTRANSBeginOper((int)this.neid, (SubFunc)subFunc, (Datainterface)tmpIput, (ArrayList)this.operationList);
        ArrayList<String> ParamList = new ArrayList<String>();
        ParamList.add("pwIndex");
        ParamList.add("direction");
        ParamList.add("exp");
        int result = 0;
        boolean addCommandFlag = true;
        TENE currentNE = TENEListMgr.getInstance().getNE(this.neid);
        int neType = currentNE.getNEType();
        String[] neVersions = currentNE.getShowNEVersion().split("\\.");
        if (neType == 76 || neType == 77 || neType == 114 || neType == 83) {
            if (neVersions.length > 3 && (neVersions[2].compareTo("03") > 0 || "03".equals(neVersions[2]) && neVersions[3].compareTo("30") >= 0)) {
                addCommandFlag = false;
            }
        } else if (neType == 95 && neVersions.length > 3 && (neVersions[2].compareTo("06") > 0 || "06".equals(neVersions[2]) && neVersions[3].compareTo("20") >= 0)) {
            addCommandFlag = false;
        }
        if (addCommandFlag) {
            result = this.addOperationList(this.neid, NSCMD_PTN_QOS_SET_PW_EXP, ParamList, row, this.operationList);
        }
        if (result != 0) {
            return -2;
        }
        if ("1".equals(this.protectType)) {
            ParamList.clear();
            ParamList.add("unknown");
            ParamList.add("pwindex");
            ParamList.add("checkMode");
            result = this.addOperationList(this.neid, NSCMD_ETHN_PWOAM_SET_CHECKWAY, ParamList, row, this.operationList);
            if (result != 0) {
                return -2;
            }
            ParamList.clear();
            ParamList.add("unknown");
            ParamList.add("pwindex");
            ParamList.add("pagcketType");
            ParamList.add("checkPeriod");
            result = this.addOperationList(this.neid, NSCMD_ETHN_PWOAM_SET_CHECKPARA, ParamList, row, this.operationList);
            if (result != 0) {
                return -2;
            }
            ParamList.clear();
            ParamList.add("unknown");
            ParamList.add("pwindex");
            ParamList.add("lsrId");
            ParamList.add("sendpwId");
            result = this.addOperationList(this.neid, NSCMD_ETHN_PWOAM_SET_TTSI, ParamList, row, this.operationList);
            if (result != 0) {
                return -2;
            }
            ParamList.clear();
            ParamList.add("unknown");
            ParamList.add("pwindex");
            ParamList.add("enablestate");
            result = this.addOperationList(this.neid, NSCMD_ETHN_PWOAM_SET_ENABLE, ParamList, row, this.operationList);
            if (result != 0) {
                return -2;
            }
        }
        if (this.operationList.size() == 1 && ((Operation)this.operationList.get(0)).getName().equals("QX5_TRANS_BEGIN")) {
            return 0;
        }
        TEDataConverter.addTRANSCommitOper((int)this.neid, (SubFunc)subFunc, (Datainterface)tmpIput, (ArrayList)this.operationList);
        return this.sendMessageAndProcessResult(subFunc);
    }

    private int sendMessageAndProcessResult(SubFunc subFunc) {
        int result = this.sendMessage(this.neid);
        if (result == 0) {
            this.handleMessage(this.neid, this.operationList, subFunc);
            RowParams[] outputParams = this.outputData.getBussinessParams().getRowParams();
            int endPos = outputParams.length - 1;
            if (outputParams[endPos].getRowErrorsCount() != 0 && !outputParams[endPos].getRowErrors(0).getErrorMessage().getErrorcode().equals(PW_SIGNAL_TYPE_STATIC)) {
                return -3;
            }
        }
        return result;
    }

    private Map createPw(SubFunc subFunc, RowParams row) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.addSpecialInputParam(row);
        this.operationList = (ArrayList)this.getCreatePwOperation(this.neid, this.inputData, subFunc, row);
        if (null == this.operationList || this.operationList.size() == 0) {
            resultMap.put("totalresult", -2);
            return resultMap;
        }
        int result = this.sendMessage(this.neid);
        if (result == 0) {
            this.handleMessage(this.neid, this.operationList, subFunc);
            RowParams[] outputParams = this.outputData.getBussinessParams().getRowParams();
            int endPos = outputParams.length - 1;
            if (outputParams[endPos].getRowErrorsCount() == 0 || outputParams[endPos].getRowErrors(0).getErrorMessage().getErrorcode().equals(PW_SIGNAL_TYPE_STATIC)) {
                Param pwIndexParam = outputParams[0].getParam("pwIndex");
                if (pwIndexParam != null) {
                    resultMap.put("pwIndex", pwIndexParam.getValue());
                    resultMap.put("totalresult", result);
                } else {
                    resultMap.put("totalresult", -3);
                }
                return resultMap;
            }
            resultMap.put("totalresult", -3);
            return resultMap;
        }
        resultMap.put("totalresult", -4);
        resultMap.put("totalresult", result);
        return resultMap;
    }

    public List getCreatePwOperation(int neid, Datainterface input, SubFunc subFunc, RowParams row) {
        ArrayList operList = new ArrayList();
        Datainterface tmpIput = new Datainterface();
        BussinessParams bus = new BussinessParams();
        bus.addRowParams(row);
        tmpIput.setBussinessParams(bus);
        TEDataConverter.addTRANSBeginOper((int)neid, (SubFunc)subFunc, (Datainterface)tmpIput, operList);
        ArrayList<String> paramList = new ArrayList<String>();
        Param pwSignTypeParam = row.getParam("pwSignalType");
        if (pwSignTypeParam == null) {
            return null;
        }
        int result = 0;
        Param param = row.getParam("tunnelIndexes");
        int tunnelIndexes = 0;
        try {
            tunnelIndexes = Integer.parseInt(param.getValue());
        }
        catch (NumberFormatException ex) {
            tunnelIndexes = 0;
        }
        param.setValue(TEStringUtils.convertStringToProtolType((String)Integer.toHexString(tunnelIndexes), (int)8));
        if (pwSignTypeParam.getValue().equalsIgnoreCase(PW_SIGNAL_TYPE_STATIC)) {
            paramList.add("pwType");
            paramList.add("pwID");
            paramList.add("direction");
            paramList.add("pwIngressLabel");
            paramList.add("pwEgressLabel");
            paramList.add("oppositeLsrID");
            paramList.add("tunnelNum");
            paramList.add("tunnelIndexes");
            result = this.addOperationList(neid, NSCMD_PTN_MPLS_PW_ADD_STCUCPW, paramList, row, operList);
            if (result != 0) {
                return null;
            }
        } else {
            paramList.add("pwType");
            paramList.add("pwID");
            paramList.add("direction");
            paramList.add("oppositeLsrID");
            paramList.add("tunnelNum");
            paramList.add("tunnelIndexes");
            result = this.addOperationList(neid, NSCMD_PTN_MPLS_PW_ADD_DYNLDPPW, paramList, row, operList);
            if (result != 0) {
                return null;
            }
        }
        paramList.clear();
        paramList.add("rtpEnableState");
        paramList.add("auto");
        result = this.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_CES_RTPEN, paramList, row, operList);
        if (result != 0) {
            return null;
        }
        paramList.clear();
        paramList.add("cachtime");
        paramList.add("auto");
        result = this.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_CES_JITTER, paramList, row, operList);
        if (result != 0) {
            return null;
        }
        paramList.clear();
        paramList.add("loadtime");
        paramList.add("auto");
        result = this.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_CES_LOADTIME, paramList, row, operList);
        if (result != 0) {
            return null;
        }
        paramList.clear();
        paramList.add("timeMode");
        result = this.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_ENCAPCES_CLKMODE, paramList, row, operList);
        if (result != 0) {
            return null;
        }
        paramList.clear();
        paramList.add("emuLevel");
        paramList.add("validTimeslotNum");
        result = this.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_CES_EMULPARA, paramList, row, operList);
        if (result != 0) {
            return null;
        }
        paramList.clear();
        paramList.add("ctrlChanType");
        paramList.add("vccv");
        result = this.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_VCCV, paramList, row, operList);
        if (result != 0) {
            return null;
        }
        paramList.clear();
        paramList.add("ingressid");
        paramList.add("egressid");
        paramList.add("tunnelid");
        result = this.addOperationList(neid, NSCMD_PTN_MPLS_PW_BOUND_EGRESS_TNL, paramList, row, operList);
        if (result != 0) {
            return null;
        }
        TEDataConverter.addTRANSCommitOper((int)neid, (SubFunc)subFunc, (Datainterface)tmpIput, operList);
        return operList;
    }

    protected int addOperationList(int neid, String cmdName, List<String> paramList, RowParams row, List operList) {
        int result = 0;
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)cmdName);
        if (null == oper) {
            return 2;
        }
        for (int i = 0; i < paramList.size(); ++i) {
            result = TECreateProtectGroup.getAndFillParm(paramList.get(i), oper.getInput(), row);
            if (result == 0) continue;
            return result;
        }
        operList.add(oper);
        return result;
    }

    private static int getAndFillParm(String paramName, Input input, RowParams row) {
        int result = 0;
        Param param = row.getParam(paramName);
        if (param == null) {
            TELogFactory.getNormalLogger().info("Create PW failed for intput param is null(" + paramName + ")!");
            return 1090646019;
        }
        input.setPartValue(paramName, param.getValue());
        return result;
    }

    private void deletePW(String pwIndex) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_DEL_PW");
        oper.getInput().setPartValue("pwIndex", pwIndex);
        this.operationList.clear();
        this.operationList.add(oper);
        int result = this.sendMessage(this.neid);
        if (result != 0) {
            TELogFactory.getNormalLogger().info("Delete pw(pwIndex=" + pwIndex + ") failed!");
        }
    }

    private Object createProtectPw(SubFunc subFunc) {
        return this.processCreatePW(subFunc, this.inputData.getBussinessParams().getRowParams(0));
    }

    private Object processCreatePW(SubFunc subFunc, RowParams row) {
        Map resultMap = this.createPw(subFunc, row);
        int totalResult = (Integer)resultMap.get("totalresult");
        String pwIndex = null;
        if (totalResult != 0) {
            if (totalResult == -3) {
                this.writeLog(this.neid, this.subfunc, this.inputData, this.user, this.ipAddress, this.outputData);
            } else if (totalResult == -2) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)((Integer)resultMap.get("totalresult"))));
            }
            return this.outputData;
        }
        pwIndex = resultMap.get("pwIndex").toString();
        this.writeLog(this.neid, this.subfunc, this.inputData, this.user, this.ipAddress, this.outputData);
        if (pwIndex != null) {
            totalResult = this.setPWAttr(pwIndex, subFunc, row);
            if (totalResult != 0) {
                if (totalResult == -3) {
                    this.writeLog(this.neid, this.subfunc, this.inputData, this.user, this.ipAddress, this.outputData);
                } else if (totalResult == -2) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)totalResult));
                }
                this.deletePW(pwIndex);
                return this.outputData;
            }
            this.writeLog(this.neid, this.subfunc, this.inputData, this.user, this.ipAddress, this.outputData);
        }
        return pwIndex;
    }
}

