/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.cesmgr;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.cesmgr.PortInterface;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.cesmgr.TECesUtil;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.cesmgr.UNIOperParam;
import com.huawei.nglct.util.convertor.TETimeSlotConvertUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TECreateCesUNIBean
extends TECommonWriteLogBean {
    private static int unniIndex = 100;
    private static final String NSCMD_SERVICE_CES_CRT = "NSCMD_SERVICE_CES_CRT";
    private static final String NSCMD_SERVICE_CES_CRT_VUNI = "NSCMD_SERVICE_CES_CRT_VUNI";
    private static final String VC12LEVEL = "1";
    private static final String AUTO_FLG_1 = "1";
    private static final String AUTO_FLG_2 = "2";
    private static final String INVALID_0XFF = "255";
    private static final String INVALID_0XFFFF = "65535";
    private static String servicetype = null;
    private static String TRANSITP2P = "3";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowParams[] rows = inputData.getBussinessParams().getRowParams();
            for (int i = 0; i < rows.length; ++i) {
                this.operationList = this.getOneRowOperation(neid, subFunc, rows[i], memeryData);
                if (null == this.operationList || this.operationList.size() == 0) continue;
                int result_Info = this.sendMessage(neid);
                if (result_Info == 0) {
                    this.handleMessage(neid, this.operationList, subFunc);
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result_Info));
                }
                Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
                if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                    this.isLogFlag = false;
                }
                if (!this.isLogFlag || !this.isNeedOperationlog()) continue;
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (IndexOutOfBoundsException e1) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e1);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    public ArrayList getOneRowOperation(int neid, SubFunc subFunc, RowParams row, Datainterface memeryData) {
        this.operationList = new ArrayList();
        Datainterface tmpInput = new Datainterface();
        BussinessParams bus = new BussinessParams();
        bus.addRowParams(row);
        tmpInput.setBussinessParams(bus);
        String cesID = TECesUtil.getCesServiceID(neid, row);
        if (cesID != null) {
            TEDataConverter.addTRANSBeginOper((int)neid, (SubFunc)subFunc, (Datainterface)tmpInput, (ArrayList)this.operationList);
            TECreateCesUNIBean.createCesOper(neid, row, cesID, this.operationList);
            TECreateCesUNIBean.processUNIInterfaceParam(row, "src", cesID, neid, this.operationList);
            TECreateCesUNIBean.processUNIInterfaceParam(row, "snk", cesID, neid, this.operationList);
            TEDataConverter.addTRANSCommitOper((int)neid, (SubFunc)subFunc, (Datainterface)tmpInput, (ArrayList)this.operationList);
        }
        return this.operationList;
    }

    public static void createCesOper(int neid, RowParams row, String cesID, ArrayList operList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_SERVICE_CES_CRT);
        TECreateCesUNIBean.buildCreateCESCmd(oper.getInput(), row, cesID);
        operList.add(oper);
    }

    public static void processUNIInterfaceParam(RowParams param, String prefix, String cesindex, int neid, ArrayList operList) {
        Param slotid = param.getParam(prefix + "Slotid");
        Param portid = param.getParam(prefix + "Port");
        if (slotid != null && portid != null) {
            Param srcHighchannelParam = param.getParam(prefix + "Highchannel");
            Param srclowchannelParam = param.getParam(prefix + "lowchannel");
            String highChannelStr = null;
            String lowChannelStr = null;
            if (srcHighchannelParam != null) {
                highChannelStr = srcHighchannelParam.getValue();
            }
            if (srclowchannelParam != null) {
                lowChannelStr = srclowchannelParam.getValue();
            }
            UNIOperParam uniParam = new UNIOperParam();
            uniParam.srcSlotid = slotid.getValue();
            uniParam.srcPort = portid.getValue();
            uniParam.cesindex = cesindex;
            uniParam.highChannel = highChannelStr;
            uniParam.lowChannel = lowChannelStr;
            Param vunitimesParam = param.getParam(prefix + "Vunitimes");
            if (vunitimesParam != null) {
                uniParam.vunitimes = vunitimesParam.getValue();
            }
            TECreateCesUNIBean.createUNIOper(neid, uniParam, operList);
        }
    }

    private static void createUNIOper(int neid, UNIOperParam uniParam, ArrayList operList) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_SERVICE_CES_CRT_VUNI);
        PortInterface port = new PortInterface();
        port.slotid = uniParam.srcSlotid;
        port.portid = uniParam.srcPort;
        port.highChannel = INVALID_0XFFFF;
        port.lowChannel = INVALID_0XFFFF;
        port.vunitimes = uniParam.vunitimes;
        if (uniParam.highChannel != null && !uniParam.highChannel.equalsIgnoreCase("null")) {
            port.highChannel = String.valueOf(TETimeSlotConvertUtil.convertSlotMode((int)Integer.parseInt(uniParam.highChannel)));
        }
        if (uniParam.lowChannel != null && !uniParam.lowChannel.equalsIgnoreCase("null")) {
            port.lowChannel = String.valueOf(TETimeSlotConvertUtil.convertSlotMode((int)Integer.parseInt(uniParam.lowChannel)));
        }
        TECreateCesUNIBean.buildUNIInput(oper.getInput(), port, uniParam.cesindex);
        operList.add(oper);
    }

    private static void buildCreateCESCmd(Input input, RowParams param, String cesID) {
        input.setPartValue("autoassign", "1");
        if (cesID != null) {
            input.setPartValue("cesindex", cesID);
            input.setPartValue("serviceid", cesID);
        } else if (param.getParam("cesindex") != null) {
            input.setPartValue("cesindex", param.getParam("cesindex").getValue());
            input.setPartValue("serviceid", param.getParam("cesindex").getValue());
        }
        if (param.getParam("servicename") != null) {
            input.setPartValue("servicename", param.getParam("serviceName").getValue());
        }
        if (param.getParam("servicetype") != null) {
            servicetype = param.getParam("servicetype").getValue();
            input.setPartValue("servicetype", param.getParam("servicetype").getValue());
        }
    }

    private static void buildUNIInput(Input input, PortInterface port, String cesindex) {
        input.setPartValue("auto", AUTO_FLG_2);
        input.setPartValue("cesindex", cesindex);
        input.setPartValue("autoflag", "1");
        input.setPartValue("vuniid", String.valueOf(TECreateCesUNIBean.getNextUniIndex()));
        input.setPartValue("vunirole", INVALID_0XFF);
        input.setPartValue("slotid", port.slotid);
        input.setPartValue("subslotid", INVALID_0XFF);
        input.setPartValue("port", port.portid);
        boolean isTransitP2p = null != servicetype && TRANSITP2P.equals(servicetype);
        servicetype = null;
        if (isTransitP2p) {
            input.setPartValue("highchannel", "1");
            input.setPartValue("lowchannel", INVALID_0XFFFF);
        } else {
            input.setPartValue("highchannel", port.highChannel);
            input.setPartValue("lowchannel", port.lowChannel);
        }
        input.setPartValue("lowlevel", "1");
        ArrayList intValues = new ArrayList();
        if (port.vunitimes == null || isTransitP2p) {
            input.setPartValue("vunitimenum", "0");
            input.setPartValue("vunitimes", "0000");
        } else {
            TEStringUtils.strToNumList((String)port.vunitimes, intValues);
            if (intValues.size() == 0) {
                input.setPartValue("vunitimenum", "0");
                input.setPartValue("vunitimes", "0000");
            } else {
                input.setPartValue("vunitimenum", String.valueOf(intValues.size()));
                input.setPartValue("vunitimes", TEStringUtils.intToFormatString(intValues, (int)4));
            }
        }
    }

    public static synchronized int getNextUniIndex() {
        if (unniIndex >= 65535) {
            unniIndex = 1;
        }
        return unniIndex++;
    }
}

