/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.cesmgr;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.cesmgr.TECesUtil;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.cesmgr.TECreateCesUNIBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TECreateCesNNIBean
extends TECommonWriteLogBean {
    private static final String NSCMD_PTN_MPLS_PW_ADD_STCUCPW = "NSCMD_PTN_MPLS_PW_ADD_STCUCPW";
    private static final String NSCMD_PTN_MPLS_PW_ADD_DYNLDPPW = "NSCMD_PTN_MPLS_PW_ADD_DYNLDPPW";
    private static final String NSCMD_PTN_MPLS_PW_SET_CES_RTPEN = "NSCMD_PTN_MPLS_PW_SET_CES_RTPEN";
    private static final String NSCMD_PTN_MPLS_PW_SET_CES_JITTER = "NSCMD_PTN_MPLS_PW_SET_CES_JITTER";
    private static final String NSCMD_PTN_MPLS_PW_SET_CES_LOADTIME = "NSCMD_PTN_MPLS_PW_SET_CES_LOADTIME";
    private static final String NSCMD_PTN_MPLS_PW_SET_ENCAPCES_CLKMODE = "NSCMD_PTN_MPLS_PW_SET_ENCAPCES_CLKMODE";
    private static final String NSCMD_PTN_MPLS_PW_SET_CES_EMULPARA = "NSCMD_PTN_MPLS_PW_SET_CES_EMULPARA";
    private static final String NSCMD_PTN_QOS_SET_PW_EXP = "NSCMD_PTN_QOS_SET_PW_EXP";
    private static final String NSCMD_SERVICE_CES_CRT_VNNI = "NSCMD_SERVICE_CES_CRT_VNNI";
    private static final String NSCMD_PTN_MPLS_PW_BOUND_EGRESS_TNL = "NSCMD_PTN_MPLS_PW_BOUND_EGRESS_TNL";
    private static final String NSCMD_SERVICE_CES_SET_SRVPRI = "NSCMD_SERVICE_CES_SET_SRVPRI";
    private static final String NSCMD_PTN_MPLS_PW_SET_VCCV = "NSCMD_PTN_MPLS_PW_SET_VCCV";
    private static final int GETOPERAFAILED = -2;
    private static final int OPERFROMNEFAILED = -3;
    private static final int SENDCMDFAILED = -4;
    public static final String PW_SIGNAL_TYPE_STATIC = "0";
    public static final String PW_SIGNAL_TYPE_DYNAMIC = "1";
    private static final String AUTO_FLG_2 = "2";
    private static final String AUTO_FLG_65535 = "65535";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            Map resMap = this.createPw(subFunc, inputData);
            int totalResults = (Integer)resMap.get("totalresult");
            String pwIndex = null;
            if (totalResults != 0) {
                if (totalResults == -3) {
                    this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                } else if (totalResults == -2) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)((Integer)resMap.get("totalresult"))));
                }
                return this.outputData;
            }
            pwIndex = resMap.get("pwIndex").toString();
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            if (pwIndex != null) {
                totalResults = this.setPWExp(pwIndex, subFunc, inputData);
                if (totalResults != 0) {
                    if (totalResults == -3) {
                        this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                    } else if (totalResults == -2) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                    } else {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)totalResults));
                    }
                    this.deletePW(pwIndex);
                    return this.outputData;
                }
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                totalResults = this.createCESNNI(pwIndex, subFunc, inputData);
                if (totalResults != 0) {
                    if (totalResults == -3) {
                        this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                    } else if (totalResults == -2) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                    } else {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)totalResults));
                    }
                    this.deletePW(pwIndex);
                    return this.outputData;
                }
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private int createCESNNI(String pwIndex, SubFunc subFunc, Datainterface inputData) {
        Param cesindex;
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        this.operationList = new ArrayList();
        String serviceID = TECesUtil.getCesServiceID(this.neid, rowParams[0]);
        if (serviceID == null && (cesindex = rowParams[0].getParam("cesindex")) != null) {
            serviceID = cesindex.getValue();
        }
        if (serviceID == null) {
            return 38748;
        }
        TEDataConverter.addTRANSBeginOper((int)this.neid, (SubFunc)subFunc, (Datainterface)inputData, (ArrayList)this.operationList);
        TECreateCesUNIBean.createCesOper(this.neid, rowParams[0], serviceID, this.operationList);
        TECreateCesUNIBean.processUNIInterfaceParam(rowParams[0], "src", serviceID, this.neid, this.operationList);
        this.getNNIOper(pwIndex, this.operationList, serviceID);
        this.getSetPRIOperation(rowParams[0], this.operationList, serviceID);
        TEDataConverter.addTRANSCommitOper((int)this.neid, (SubFunc)subFunc, (Datainterface)inputData, (ArrayList)this.operationList);
        return this.sendMessageAndProcessResult(subFunc);
    }

    protected void getSetPRIOperation(RowParams row, List operList, String cesIndex) {
        Param srvPriParam;
        Operation operation;
        String unnid = null;
        for (int i = 0; i < operList.size(); ++i) {
            Part unnidPart;
            operation = (Operation)operList.get(i);
            if (!operation.getName().equals("NSCMD_SERVICE_CES_CRT_VUNI") || (unnidPart = operation.getInput().getPart("vuniid")) == null) continue;
            unnid = unnidPart.getValue();
            break;
        }
        if ((srvPriParam = row.getParam("srvPri")) != null) {
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_SERVICE_CES_SET_SRVPRI);
            operation.getInput().setPartValue("isAuto", AUTO_FLG_2);
            operation.getInput().setPartValue("cesindex", cesIndex);
            operation.getInput().setPartValue("isUniAuto", AUTO_FLG_2);
            operation.getInput().setPartValue("vuniid", unnid);
            operation.getInput().setPartValue("srvPri", srvPriParam.getValue());
            operList.add(operation);
        }
    }

    private void addSpecialInputParam(RowParams row) {
        row.addParam("auto", AUTO_FLG_2);
    }

    protected void addTunnelInputParam(RowParams row) {
        Param para = row.getParam("tunnelIndexes");
        int tunnelIndexes = 0;
        try {
            tunnelIndexes = Integer.parseInt(para.getValue());
        }
        catch (NumberFormatException ex) {
            tunnelIndexes = 0;
        }
        ArrayList<Operation> queryList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_MPLS_GET_TUNNEL");
        operation.getInput().setPartValue("tunnelindex", String.valueOf(tunnelIndexes));
        queryList.add(operation);
        int totalResult = TECommuNEMgr.getInstance().sendCommand((int)this.neid, queryList, (int)20, (SubFunc)this.subfunc).retCode;
        if (totalResult != 0) {
            return;
        }
        this.inputData.getBussinessParams().getRowParams(0).addParam("ingressid", operation.getOutput(0).getPartValue("ingressNodeId"));
        this.inputData.getBussinessParams().getRowParams(0).addParam("egressid", operation.getOutput(0).getPartValue("egressNodeId"));
        this.inputData.getBussinessParams().getRowParams(0).addParam("tunnelid", operation.getOutput(0).getPartValue("tunnelid"));
    }

    private void getNNIOper(String pwIndex, List operList, String cesIndex) {
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_SERVICE_CES_CRT_VNNI);
        operation.getInput().setPartValue("auto", AUTO_FLG_2);
        operation.getInput().setPartValue("cesindex", cesIndex);
        operation.getInput().setPartValue("autoflag", PW_SIGNAL_TYPE_DYNAMIC);
        operation.getInput().setPartValue("vnniid", String.valueOf(TECreateCesUNIBean.getNextUniIndex()));
        operation.getInput().setPartValue("index", pwIndex);
        operList.add(operation);
    }

    private int setPWExp(String pwIndex, SubFunc subFunc, Datainterface inputData) {
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        this.operationList = new ArrayList();
        TEDataConverter.addTRANSBeginOper((int)this.neid, (SubFunc)subFunc, (Datainterface)inputData, (ArrayList)this.operationList);
        ArrayList<String> ParamList = new ArrayList<String>();
        rowParams[0].addParam("pwIndex", pwIndex);
        ParamList.add("pwIndex");
        ParamList.add("direction");
        ParamList.add("exp");
        int result = TECreateCesNNIBean.addOperationList(this.neid, NSCMD_PTN_QOS_SET_PW_EXP, ParamList, rowParams[0], this.operationList);
        if (result != 0) {
            return -2;
        }
        TEDataConverter.addTRANSCommitOper((int)this.neid, (SubFunc)subFunc, (Datainterface)inputData, (ArrayList)this.operationList);
        return this.sendMessageAndProcessResult(subFunc);
    }

    private int sendMessageAndProcessResult(SubFunc subFunc) {
        int resultCode = this.sendMessage(this.neid);
        if (resultCode == 0) {
            this.handleMessage(this.neid, this.operationList, subFunc);
            RowParams[] outputParams = this.outputData.getBussinessParams().getRowParams();
            int endPos = outputParams.length - 1;
            if (outputParams[endPos].getRowErrorsCount() != 0 && !outputParams[endPos].getRowErrors(0).getErrorMessage().getErrorcode().equals(PW_SIGNAL_TYPE_STATIC)) {
                return -3;
            }
        }
        return resultCode;
    }

    private Map createPw(SubFunc subFunc, Datainterface inputData) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        RowParams[] rows = inputData.getBussinessParams().getRowParams();
        this.addSpecialInputParam(rows[0]);
        this.addTunnelInputParam(rows[0]);
        this.operationList = (ArrayList)TECreateCesNNIBean.getCreatePwOperation(this.neid, inputData, subFunc, rows[0]);
        if (null == this.operationList || this.operationList.size() == 0) {
            resMap.put("totalresult", -2);
            return resMap;
        }
        int result = this.sendMessage(this.neid);
        if (result == 0) {
            this.handleMessage(this.neid, this.operationList, subFunc);
            RowParams[] optParams = this.outputData.getBussinessParams().getRowParams();
            int endPos = optParams.length - 1;
            if (optParams[endPos].getRowErrorsCount() == 0 || optParams[endPos].getRowErrors(0).getErrorMessage().getErrorcode().equals(PW_SIGNAL_TYPE_STATIC)) {
                Param pwIndexParam = optParams[0].getParam("pwIndex");
                if (pwIndexParam != null) {
                    resMap.put("pwIndex", pwIndexParam.getValue());
                    resMap.put("totalresult", result);
                } else {
                    resMap.put("totalresult", -3);
                }
                return resMap;
            }
            resMap.put("totalresult", -3);
            return resMap;
        }
        resMap.put("totalresult", -4);
        resMap.put("totalresult", result);
        return resMap;
    }

    public static List getCreatePwOperation(int neid, Datainterface input, SubFunc subFunc, RowParams row) {
        ArrayList operationList = new ArrayList();
        TEDataConverter.addTRANSBeginOper((int)neid, (SubFunc)subFunc, (Datainterface)input, operationList);
        ArrayList<String> paramList = new ArrayList<String>();
        Param pwSignTypeParam = row.getParam("pwSignalType");
        if (pwSignTypeParam == null) {
            return null;
        }
        int result = 0;
        Param param = row.getParam("tunnelIndexes");
        int tunnelIndexes = 0;
        try {
            tunnelIndexes = Integer.parseInt(param.getValue());
        }
        catch (NumberFormatException ex) {
            tunnelIndexes = 0;
        }
        param.setValue(TEStringUtils.convertStringToProtolType((String)Integer.toHexString(tunnelIndexes), (int)8));
        if (pwSignTypeParam.getValue().equalsIgnoreCase(PW_SIGNAL_TYPE_STATIC)) {
            paramList.add("pwType");
            paramList.add("pwID");
            paramList.add("direction");
            paramList.add("pwIngressLabel");
            paramList.add("pwEgressLabel");
            paramList.add("oppositeLsrID");
            paramList.add("tunnelNum");
            paramList.add("tunnelIndexes");
            result = TECreateCesNNIBean.addOperationList(neid, NSCMD_PTN_MPLS_PW_ADD_STCUCPW, paramList, row, operationList);
            if (result != 0) {
                return null;
            }
        } else {
            paramList.add("pwType");
            paramList.add("pwID");
            paramList.add("direction");
            paramList.add("oppositeLsrID");
            paramList.add("tunnelNum");
            paramList.add("tunnelIndexes");
            result = TECreateCesNNIBean.addOperationList(neid, NSCMD_PTN_MPLS_PW_ADD_DYNLDPPW, paramList, row, operationList);
            if (result != 0) {
                return null;
            }
        }
        paramList.clear();
        paramList.add("rtpEnableState");
        paramList.add("auto");
        result = TECreateCesNNIBean.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_CES_RTPEN, paramList, row, operationList);
        if (result != 0) {
            return null;
        }
        paramList.clear();
        paramList.add("cachtime");
        paramList.add("auto");
        result = TECreateCesNNIBean.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_CES_JITTER, paramList, row, operationList);
        if (result != 0) {
            return null;
        }
        paramList.clear();
        paramList.add("loadtime");
        paramList.add("auto");
        result = TECreateCesNNIBean.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_CES_LOADTIME, paramList, row, operationList);
        if (result != 0) {
            return null;
        }
        paramList.clear();
        paramList.add("timeMode");
        result = TECreateCesNNIBean.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_ENCAPCES_CLKMODE, paramList, row, operationList);
        if (result != 0) {
            return null;
        }
        paramList.clear();
        paramList.add("emuLevel");
        paramList.add("validTimeslotNum");
        result = TECreateCesNNIBean.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_CES_EMULPARA, paramList, row, operationList);
        if (result != 0) {
            return null;
        }
        paramList.clear();
        paramList.add("ingressid");
        paramList.add("egressid");
        paramList.add("tunnelid");
        result = TECreateCesNNIBean.addOperationList(neid, NSCMD_PTN_MPLS_PW_BOUND_EGRESS_TNL, paramList, row, operationList);
        if (result != 0) {
            return null;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String neVersion = ne.getHostVersion();
        if (neVersion.compareTo("5.76.01.40") >= 0 && neVersion.compareTo("5.76.01.99") < 0) {
            paramList.clear();
            paramList.add("ctrlChanType");
            paramList.add("vccv");
            result = TECreateCesNNIBean.addOperationList(neid, NSCMD_PTN_MPLS_PW_SET_VCCV, paramList, row, operationList);
            if (result != 0) {
                return null;
            }
        }
        TEDataConverter.addTRANSCommitOper((int)neid, (SubFunc)subFunc, (Datainterface)input, operationList);
        return operationList;
    }

    private static int addOperationList(int neid, String cmdName, List<String> paramList, RowParams row, List operList) {
        int result = 0;
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)cmdName);
        if (operation == null) {
            return 0;
        }
        for (int i = 0; i < paramList.size(); ++i) {
            result = TECreateCesNNIBean.getAndFillParm(paramList.get(i), operation.getInput(), row);
            if (result == 0) continue;
            return result;
        }
        operList.add(operation);
        return result;
    }

    private static int getAndFillParm(String paramName, Input input, RowParams rows) {
        int result = 0;
        Param param = rows.getParam(paramName);
        if (param == null) {
            TELogFactory.getNormalLogger().info("Create PW failed for intput param is null(" + paramName + ")!");
            return 1090646019;
        }
        input.setPartValue(paramName, param.getValue());
        return result;
    }

    private void deletePW(String pwIndex) {
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_DEL_PW");
        operation.getInput().setPartValue("pwIndex", pwIndex);
        this.operationList.clear();
        this.operationList.add(operation);
        int result = this.sendMessage(this.neid);
        if (result != 0) {
            TELogFactory.getNormalLogger().info("Delete pw(pwIndex=" + pwIndex + ") failed!");
        }
    }
}

