/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.cesmgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class TECesUtil {
    public static final long START_ID = 1L;
    public static Hashtable<Integer, List<Long>> CESIDLIST_CACHE = new Hashtable();

    public static synchronized void refreshCESIDCache(int neid, String paramName, Operation oper) {
        Vector<Long> cesIDList = new Vector<Long>();
        int m = oper.getOutputCount();
        for (int i = 0; i < m; ++i) {
            Output output = oper.getOutput(i);
            Part serviceIDPart = output.getPart(paramName);
            if (serviceIDPart == null) continue;
            try {
                cesIDList.add(Long.parseLong(serviceIDPart.getValue()));
                continue;
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Refresh ces id cache failed beacause input error serviceid=" + serviceIDPart.getValue(), (Throwable)e);
                return;
            }
        }
        long cesID = 1L;
        while (cesIDList.contains(cesID)) {
            ++cesID;
        }
        CESIDLIST_CACHE.put(neid, cesIDList);
    }

    public static synchronized long getMaxCesID(int neid) {
        List<Object> idList;
        if (CESIDLIST_CACHE.containsKey(neid) && (idList = CESIDLIST_CACHE.get(neid)) != null && idList.size() > 0) {
            long cesID = 1L;
            while (idList.contains(cesID)) {
                ++cesID;
            }
            idList.add(cesID);
            return cesID;
        }
        idList = new Vector<Long>();
        idList.add(2L);
        CESIDLIST_CACHE.put(neid, idList);
        return 1L;
    }

    public static String getCesServiceID(int neid, RowParams row) {
        boolean isAuto = false;
        Param isAutoParam = row.getParam("isAuto");
        if (isAutoParam != null && isAutoParam.getValue().equalsIgnoreCase("1")) {
            isAuto = true;
        }
        if (isAuto) {
            return String.valueOf(TECesUtil.getMaxCesID(neid));
        }
        Param cesindex = row.getParam("cesindex");
        if (cesindex != null) {
            return cesindex.getValue();
        }
        return null;
    }

    public static boolean removeCESIDCache(int neID) {
        boolean isRemoved = false;
        if (CESIDLIST_CACHE.contains(neID)) {
            CESIDLIST_CACHE.remove(neID);
            isRemoved = true;
        } else {
            TELogFactory.getNormalLogger().info("The ces id list is not exist. neID->" + neID);
        }
        return isRemoved;
    }
}

