/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEAutoTestCache;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEAutoTestData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEAutoTestUtils;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TELatencyData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TELongPacketLossData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEPacketLossData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEThroughPutData;
import com.huawei.nglct.util.string.TEErrorResourceUtil;

public class TEQueryAutoTestResultBean
extends TENEExplorerBean {
    private static final String TYPE_PARAM_NAME = "type";
    private static final String THROUGHPUT_PARAM_NAME = "throughput";
    private static final String FRAMESIZE_PARAM_NAME = "framesize";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        BussinessParams bussiness = inputData.getBussinessParams();
        String serviceIndex = bussiness.getRowParams(0).getParam("serviceIndex").getValue();
        String framesize = bussiness.getRowParams(0).getParam(FRAMESIZE_PARAM_NAME).getValue();
        String thruputper = bussiness.getRowParams(0).getParam("thruputper").getValue();
        TEAutoTestData testdata = TEAutoTestCache.getInstance().getServcieCache(neid, serviceIndex);
        boolean isClear = false;
        if (testdata == null || this.getFromNEFlag(bussiness.getRowParams(0))) {
            TEAutoTestCache.getInstance().delServiceCahce(neid, serviceIndex);
            testdata = TEAutoTestUtils.queryTestDataFromNE(neid, serviceIndex);
        } else if (testdata.getProcess() >= 100 && !testdata.getLongPacketLossData().isEmpty()) {
            isClear = true;
        }
        if (testdata != null) {
            this.outputData.setBussinessParams(this.convertOutputData(testdata, framesize, thruputper));
            if (isClear) {
                TEAutoTestCache.getInstance().delServiceCahce(neid, serviceIndex);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return this.outputData;
    }

    private boolean getFromNEFlag(RowParams row) {
        boolean bFromNE = false;
        if (row.getParam("bFromNE") != null && "true".equals(row.getParam("bFromNE").getValue())) {
            bFromNE = true;
        }
        return bFromNE;
    }

    public BussinessParams convertOutputData(TEAutoTestData testdata, String framesize, String thruputper) {
        int i;
        BussinessParams bussiness = new BussinessParams();
        RowParams row = new RowParams();
        row.addParam(TYPE_PARAM_NAME, "autotest");
        row.addParam("process", String.valueOf(testdata.getProcess()));
        row.addParam("testtype", String.valueOf(testdata.getTestType()));
        row.addParam("serviceIndex", String.valueOf(testdata.getServiceIndex()));
        bussiness.addRowParams(row);
        int len = testdata.getThroughPutData().size();
        for (i = 0; i < len; ++i) {
            bussiness.addRowParams(this.convertThroughputParam(testdata.getThroughPutData().get(i)));
        }
        len = testdata.getLatencyData().size();
        for (i = 0; i < len; ++i) {
            bussiness.addRowParams(this.convertLatencyParam(testdata.getLatencyData().get(i)));
        }
        len = testdata.getPacketLossData().size();
        for (i = 0; i < len; ++i) {
            bussiness.addRowParams(this.convertPacketLossParam(testdata.getPacketLossData().get(i)));
        }
        len = testdata.getLongPacketLossData().size();
        for (i = 0; i < len; ++i) {
            TELongPacketLossData longpacketloss = testdata.getLongPacketLossData().get(i);
            if (!framesize.equals(String.valueOf(longpacketloss.getFrameSize())) || !thruputper.equals(String.valueOf(longpacketloss.getThroughPut()))) continue;
            bussiness.addRowParams(this.convertLongPacketLossParam(longpacketloss));
        }
        return bussiness;
    }

    public RowParams convertThroughputParam(TEThroughPutData throughput) {
        RowParams row = new RowParams();
        row.addParam(TYPE_PARAM_NAME, THROUGHPUT_PARAM_NAME);
        row.addParam(FRAMESIZE_PARAM_NAME, String.valueOf(throughput.getFrameSize()));
        row.addParam(THROUGHPUT_PARAM_NAME, String.valueOf(throughput.getThroughPut()));
        return row;
    }

    public RowParams convertLatencyParam(TELatencyData latency) {
        RowParams row = new RowParams();
        row.addParam(TYPE_PARAM_NAME, "latency");
        row.addParam(FRAMESIZE_PARAM_NAME, String.valueOf(latency.getFrameSize()));
        row.addParam(THROUGHPUT_PARAM_NAME, String.valueOf(latency.getThroughPut()));
        row.addParam("latency", String.valueOf(latency.getLatency()));
        return row;
    }

    public RowParams convertPacketLossParam(TEPacketLossData packetLoss) {
        RowParams row = new RowParams();
        row.addParam(TYPE_PARAM_NAME, "packetLoss");
        row.addParam(FRAMESIZE_PARAM_NAME, String.valueOf(packetLoss.getFrameSize()));
        row.addParam(THROUGHPUT_PARAM_NAME, String.valueOf(packetLoss.getThroughPut()));
        row.addParam("packetloss", String.valueOf(packetLoss.getPacketloss()));
        return row;
    }

    public RowParams convertLongPacketLossParam(TELongPacketLossData longpacketLoss) {
        RowParams row = new RowParams();
        row.addParam(TYPE_PARAM_NAME, "longpacketLoss");
        row.addParam(FRAMESIZE_PARAM_NAME, String.valueOf(longpacketLoss.getFrameSize()));
        row.addParam(THROUGHPUT_PARAM_NAME, String.valueOf(longpacketLoss.getThroughPut()));
        row.addParam("sendpkt", longpacketLoss.getSendPkt());
        row.addParam("recpkt", longpacketLoss.getRecPkt());
        row.addParam("longpacketloss", String.valueOf(longpacketLoss.getLoss()));
        return row;
    }
}

