/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEAutoTestCache;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEAutoTestData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEAutoTestUtils;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eline.LogicInf;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEQueryAutoTestParamBean
extends TENEExplorerBean {
    private static final String NSCMD_SERVICE_GET_ETHVUNI = "NSCMD_SERVICE_GET_ETHVUNI_EX";
    private static final String NSCMD_SERVICE_GET_ETHVUNIPLUS = "NSCMD_SERVICE_GET_ETHVUNIPLUS";
    private static final String NSCMD_SERVICE_GET_EVNNI_EX = "NSCMD_SERVICE_GET_EVNNI_EX";
    private static final String NSCMD_PTN_MPLS_PW_GET_PW = "NSCMD_PTN_MPLS_PW_GET_PW";
    private static final String NSCMD_ETH_SRV_GET_AUTOTEST_REPORT = "NSCMD_ETH_SRV_GET_AUTOTEST_REPORT";
    private static final String NSCMD_ETH_SRV_GET_ETHTEST_FRAMELEN = "NSCMD_ETH_SRV_GET_ETHTEST_FRAMELEN";
    private static final int LOGICINF_LENGTH = 8;
    private static final int TEST_STATUS_DISABLE = 0;
    private static final int UNINNI_NUMBER = 2;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        Map<String, ServiceResult> service2UniMap = this.queryServiceUNIAndTestInfo(neid, this.outputData);
        this.appendUNIAndTest2Output(this.outputData, service2UniMap);
    }

    public Map<String, ServiceResult> queryServiceUNIAndTestInfo(int neid, Datainterface outputData) {
        OperationResult result;
        BussinessParams bussiness;
        List<Operation> operList;
        Map<String, ServiceResult> service2UniMap = null;
        if (outputData != null && !(operList = this.getVuniAndTestInfoOperationList(bussiness = outputData.getBussinessParams())).isEmpty() && (result = TENECommMgr.getInstance().sendCommand(neid, operList, this.TIME_OUT)) != null && result.retCode == 0) {
            service2UniMap = this.handleUNIAndTestOperList(operList);
        }
        return service2UniMap;
    }

    private void handleUNIOperation(Operation oper, Map<String, ServiceResult> serviceMap) {
        if (oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) {
            String index = oper.getOutput(0).getPartValue("serviceIndex");
            String vuniid = oper.getOutput(0).getPartValue("vuniID");
            int slotid = Integer.parseInt(oper.getOutput(0).getPartValue("slotid"));
            int subslotid = Integer.parseInt(oper.getOutput(0).getPartValue("subslotid"));
            int portid = Integer.parseInt(oper.getOutput(0).getPartValue("portid"));
            LogicInf logicInf = new LogicInf(1, vuniid);
            logicInf.logicInfName = this.getBoardPortName(slotid, subslotid, portid);
            if (serviceMap.containsKey(index)) {
                serviceMap.get(index).getList().add(logicInf);
            } else {
                ArrayList<LogicInf> logic = new ArrayList<LogicInf>();
                logic.add(logicInf);
                ServiceResult result = new ServiceResult();
                result.setList(logic);
                serviceMap.put(index, result);
            }
        }
    }

    private void handleNNIOperation(Operation oper, Map<String, ServiceResult> serviceMap, Map<String, String> pwidMap) {
        if (oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) {
            String index = oper.getOutput(0).getPartValue("serviceIndex");
            String vnniid = oper.getOutput(0).getPartValue("vnniID");
            String carrierType = oper.getOutput(0).getPartValue("carrierType");
            String carrier1 = oper.getOutput(0).getPartValue("carrierID1");
            String carrier2 = oper.getOutput(0).getPartValue("carrierID2");
            String carrier3 = oper.getOutput(0).getPartValue("carrierID3");
            if ("1".equals(carrierType) || "3".equals(carrierType)) {
                LogicInf logicInf = new LogicInf(2, vnniid);
                if ("1".equals(carrierType)) {
                    String pwName = pwidMap.get(carrier3);
                    logicInf.logicInfName = pwName == null ? "PW-" + carrier3 : pwName;
                } else if ("3".equals(carrierType)) {
                    logicInf.logicInfName = this.getBoardPortName(Integer.parseInt(carrier1), Integer.parseInt(carrier2), Integer.parseInt(carrier3));
                }
                if (serviceMap.containsKey(index)) {
                    serviceMap.get(index).getList().add(logicInf);
                } else {
                    ArrayList<LogicInf> logic = new ArrayList<LogicInf>();
                    logic.add(logicInf);
                    ServiceResult result = new ServiceResult();
                    result.setList(logic);
                    serviceMap.put(index, result);
                }
            }
        }
    }

    private void handlePWOperation(List<Operation> secOperList, Map<String, String> pwidMap) {
        int size = secOperList.size();
        for (int i = 0; i < size; ++i) {
            Operation oper = secOperList.get(i);
            if (!NSCMD_PTN_MPLS_PW_GET_PW.equals(oper.getName())) continue;
            int outputs = oper.getOutputCount();
            for (int j = 0; j < outputs; ++j) {
                if (!String.valueOf(0).equals(oper.getOutput(j).getFault(0).getCode())) continue;
                String temppwindex = oper.getInput().getPartValue("pwIndex");
                String pwID = oper.getOutput(j).getPartValue("pwID");
                if (pwID == null) {
                    pwID = oper.getOutput(j).getPartValue("pwId");
                }
                pwID = "PW-" + pwID;
                pwidMap.put(temppwindex, pwID);
            }
        }
    }

    private Map<String, String> queryPWInfo(List<Operation> secOperList) {
        OperationResult result;
        HashMap<String, String> pwidMap = new HashMap<String, String>();
        ArrayList<Operation> queryPWList = new ArrayList<Operation>();
        int size = secOperList.size();
        for (int i = 0; i < size; ++i) {
            Operation oper = secOperList.get(i);
            if (!NSCMD_SERVICE_GET_EVNNI_EX.equals(oper.getName()) || !oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
            String carrierType = oper.getOutput(0).getPartValue("carrierType");
            String carrier3 = oper.getOutput(0).getPartValue("carrierID3");
            if (!"1".equals(carrierType)) continue;
            Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_PTN_MPLS_PW_GET_PW);
            Input input = operation.getInput();
            input.setPartValue("pwIndex", carrier3);
            queryPWList.add((Operation)operation.clone());
        }
        if (!queryPWList.isEmpty() && (result = TENECommMgr.getInstance().sendCommand(this.neid, queryPWList, this.TIME_OUT)) != null && result.retCode == 0) {
            this.handlePWOperation(queryPWList, pwidMap);
        }
        return pwidMap;
    }

    private Map<String, ServiceResult> handleUNIAndTestOperList(List<Operation> secOperList) {
        HashMap<String, ServiceResult> service2uni = new HashMap<String, ServiceResult>();
        Map<String, String> pwidMap = this.queryPWInfo(secOperList);
        int size = secOperList.size();
        for (int i = 0; i < size; ++i) {
            String serviceIndex;
            ServiceResult result;
            Operation oper = secOperList.get(i);
            if (NSCMD_SERVICE_GET_ETHVUNI.equals(oper.getName()) || NSCMD_SERVICE_GET_ETHVUNIPLUS.equals(oper.getName())) {
                this.handleUNIOperation(oper, service2uni);
                continue;
            }
            if (NSCMD_SERVICE_GET_EVNNI_EX.equals(oper.getName())) {
                this.handleNNIOperation(oper, service2uni, pwidMap);
                continue;
            }
            if (NSCMD_ETH_SRV_GET_AUTOTEST_REPORT.equals(oper.getName())) {
                TEAutoTestData testdata = TEAutoTestUtils.parseAutoTestOperation(oper);
                if (testdata.getProcess() >= 0 && testdata.getProcess() < 100) {
                    TEAutoTestCache.getInstance().addServiceCahce(this.neid, testdata.getServiceIndex(), testdata);
                } else if (testdata.getProcess() == 100) {
                    TEAutoTestCache.getInstance().delServiceCahce(this.neid, testdata.getServiceIndex());
                }
                result = (ServiceResult)service2uni.get(testdata.getServiceIndex());
                if (result == null) continue;
                result.setProcess(testdata.getProcess());
                continue;
            }
            if (!NSCMD_ETH_SRV_GET_ETHTEST_FRAMELEN.equals(oper.getName()) || !oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0)) || (result = (ServiceResult)service2uni.get(serviceIndex = oper.getOutput(0).getPartValue("serviceIndex"))) == null) continue;
            result.setFrameSize(oper.getOutput(0).getPartValue("framesize"));
        }
        return service2uni;
    }

    public List<Operation> getVuniAndTestInfoOperationList(BussinessParams bussiness) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        for (int i = bussiness.getRowParamsCount() - 1; i >= 0; --i) {
            Operation operation;
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            String serviceIndex = row.getParam("serviceIndex").getValue();
            List<LogicInf> logicInfList = this.parseLogicInfoData(row.getParam("logicInfData").getValue());
            int size = logicInfList.size();
            for (int j = 0; j < size; ++j) {
                Input input;
                LogicInf logic = logicInfList.get(j);
                if (logic.logicInfType == 1) {
                    operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_SERVICE_GET_ETHVUNI);
                    if (operation != null) {
                        input = operation.getInput();
                        input.setPartValue("ethType", "1");
                        input.setPartValue("serviceIndex", serviceIndex);
                        input.setPartValue("vuniID", logic.logicInfID);
                        operList.add((Operation)operation.clone());
                    }
                    if ((operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_SERVICE_GET_ETHVUNIPLUS)) == null) continue;
                    input = operation.getInput();
                    input.setPartValue("ethType", "1");
                    input.setPartValue("serviceIndex", serviceIndex);
                    input.setPartValue("vuniID", logic.logicInfID);
                    operList.add((Operation)operation.clone());
                    continue;
                }
                if (logic.logicInfType != 2 || null == (operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_SERVICE_GET_EVNNI_EX))) continue;
                input = operation.getInput();
                input.setPartValue("ethType", "1");
                input.setPartValue("serviceIndex", serviceIndex);
                input.setPartValue("vnniID", logic.logicInfID);
                operList.add((Operation)operation.clone());
            }
            if (logicInfList.isEmpty()) continue;
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETH_SRV_GET_AUTOTEST_REPORT);
            operation.getInput().setPartValue("serviceIndex", serviceIndex);
            operList.add((Operation)operation.clone());
            if (!TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_CFG_ETH_AUTOTEST", "AUTOTEST_ATTR_SPECIAL_FRAMESIZE")) continue;
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETH_SRV_GET_ETHTEST_FRAMELEN);
            operation.getInput().setPartValue("serviceIndex", serviceIndex);
            operList.add((Operation)operation.clone());
        }
        return operList;
    }

    public List<LogicInf> parseLogicInfoData(String logicInfData) {
        ArrayList<LogicInf> logicList = new ArrayList<LogicInf>();
        if (logicInfData != null) {
            int lens = logicInfData.length() / 8;
            int index = 0;
            for (int j = 0; j < lens; ++j) {
                String logicinf = logicInfData.substring(index, index + 8);
                int logicType = Integer.parseInt(logicinf.substring(0, 4), 16);
                int logicID = Integer.parseInt(logicinf.substring(4, 8), 16);
                logicList.add(new LogicInf(logicType, String.valueOf(logicID)));
                index += 8;
            }
        }
        return logicList;
    }

    public String getBoardPortName(int slotid, int subslotid, int portid) {
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        int boardType = cfgDataMgr.getBoardType(this.neid, slotid);
        String portName = cfgDataMgr.getPortNameForPTN(this.neid, slotid, boardType, portid);
        portName = slotid + "-" + cfgDataMgr.getBoardTypeName(this.neid, boardType) + "-" + portName;
        return portName;
    }

    public void appendUNIAndTest2Output(Datainterface outputData, Map<String, ServiceResult> service2UniMap) {
        BussinessParams bussiness = outputData.getBussinessParams();
        for (int i = bussiness.getRowParamsCount() - 1; i >= 0; --i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            String serviceIndex = row.getParam("serviceIndex").getValue();
            List<LogicInf> logicList = null;
            ServiceResult serviceResult = null;
            if (service2UniMap != null && service2UniMap.containsKey(serviceIndex)) {
                serviceResult = service2UniMap.get(serviceIndex);
                logicList = serviceResult.getList();
            }
            if (serviceResult == null || logicList == null || logicList.size() < 2) {
                bussiness.removeRowParams(i);
                continue;
            }
            LogicInf sourceLogic = (LogicInf)logicList.get(0);
            LogicInf sinkLogic = logicList.get(1);
            if (sourceLogic.logicInfType == 2 && sinkLogic.logicInfType == 1) {
                sourceLogic = logicList.get(1);
                sinkLogic = logicList.get(0);
            }
            if (!this.isSupportAutoTest(sourceLogic, sinkLogic)) {
                bussiness.removeRowParams(i);
                continue;
            }
            String uniid = row.getParam("vuniid").getValue();
            row.addParam("sourceuniid", sourceLogic.logicInfID);
            row.addParam("sourceunitype", String.valueOf(sourceLogic.logicInfType));
            row.addParam("sourceNode", sourceLogic.logicInfName);
            row.addParam("sinkuniid", sinkLogic.logicInfID);
            row.addParam("sinkunitype", String.valueOf(sinkLogic.logicInfType));
            row.addParam("sinkNode", sinkLogic.logicInfName);
            Param testNameParam = row.getParam("testname");
            testNameParam.setValue(IOStreamConvertor.removeSpecialStr((String)testNameParam.getValue()));
            String status = row.getParam("enablestatus").getValue();
            row.addParam(this.convertStatusParam(uniid, sourceLogic, "sourcestatus", status));
            row.addParam(this.convertStatusParam(uniid, sinkLogic, "sinkstatus", status));
            int testtype = -1;
            TEAutoTestData testdata = TEAutoTestCache.getInstance().getServcieCache(this.neid, serviceIndex);
            if (testdata != null) {
                testtype = testdata.getTestType();
            }
            row.addParam("testtype", String.valueOf(testtype));
            row.addParam("process", String.valueOf(serviceResult.getProcess()));
            row.addParam("specialfsize", String.valueOf(serviceResult.getFrameSize()));
        }
    }

    private Param convertStatusParam(String uniid, LogicInf logic, String paramName, String value) {
        String status = "-";
        if (logic.logicInfType == 1) {
            status = uniid.equals(logic.logicInfID) ? value : String.valueOf(0);
        }
        return new Param(paramName, status);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(57500);
        errorList.add(38662);
        return errorList;
    }

    private boolean isSupportAutoTest(LogicInf sourceLogic, LogicInf sinkLogic) {
        boolean isSupportMPLS = TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_CFG_ETH_AUTOTEST", "AUTOTEST_ATTR_SUPPORT_MPLS");
        boolean isSupport = false;
        isSupport = isSupportMPLS && (sourceLogic.logicInfType == 1 && sinkLogic.logicInfType == 2 || sourceLogic.logicInfType == 2 && sinkLogic.logicInfType == 1) ? true : sourceLogic.logicInfType == 1 && sinkLogic.logicInfType == 1;
        return isSupport;
    }

    class ServiceResult {
        private int process = -1;
        private String frameSize = "";
        private List<LogicInf> list;

        ServiceResult() {
        }

        public int getProcess() {
            return this.process;
        }

        public void setProcess(int process) {
            this.process = process;
        }

        public List<LogicInf> getList() {
            return this.list;
        }

        public void setList(List<LogicInf> list) {
            this.list = list;
        }

        public String getFrameSize() {
            return this.frameSize;
        }

        public void setFrameSize(String frameSize) {
            this.frameSize = frameSize;
        }
    }
}

