/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEAutoTestData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TELatencyData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TELongPacketLossData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEPacketLossData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEThroughPutData;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;

public class TEAutoTestUtils {
    public static final int BYTE_INVALID = 255;
    public static final int INT_INVALID = 65535;
    public static final long LONG_INVALID = 0xFFFFFFFFL;
    public static final int TEST_TYPE_NORMAL = 0;
    public static final int TEST_TYPE_LONG = 1;
    public static final int PROCESS_FINISH = 100;
    private static final double FLAG = 4.294967296E9;
    public static final int INIT_VALUE = -1;
    public static final int TEST_STOP = 0;
    public static final int TEST_START = 1;
    public static final int TIME_OUT = 20;
    private static final String NSCMD_ETH_SRV_GET_AUTOTEST_REPORT = "NSCMD_ETH_SRV_GET_AUTOTEST_REPORT";

    private TEAutoTestUtils() {
    }

    public static TEAutoTestData queryTestDataFromNE(int neid, String serviceIndex) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_ETH_SRV_GET_AUTOTEST_REPORT);
        oper.getInput().setPartValue("serviceIndex", String.valueOf(serviceIndex));
        ArrayList<Operation> operList = new ArrayList<Operation>();
        operList.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operList, 20);
        TEAutoTestData testdata = null;
        if (result != null && result.retCode == 0) {
            testdata = TEAutoTestUtils.parseAutoTestOperation((Operation)operList.get(0));
        }
        return testdata;
    }

    public static TEAutoTestData parseAutoTestOperation(Operation oper) {
        TEAutoTestData testdata = new TEAutoTestData();
        if (oper == null) {
            return testdata;
        }
        int len = oper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            Output output = oper.getOutput(i);
            if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
            int testtype = Integer.parseInt(output.getPartValue("testtype"));
            int process = Integer.parseInt(output.getPartValue("process"));
            if (process == 255) continue;
            String serviceIndex = output.getPartValue("serviceIndex");
            testdata.setServiceIndex(serviceIndex);
            int framesize = Integer.parseInt(output.getPartValue("framesize"));
            String starttime = TEAutoTestUtils.convertTime(output.getPartValue("starttime"));
            String endtime = TEAutoTestUtils.convertTime(output.getPartValue("endtime"));
            if (testtype == 0) {
                long[] delayvalue;
                int[] thtypevalue;
                if (testdata.getProcess() < process) {
                    testdata.setProcess(process);
                }
                if (testdata.getProcess() < 100) {
                    testdata.setTestType(0);
                } else {
                    testdata.setTestType(-1);
                }
                long thruput = Long.parseLong(output.getPartValue("thruput"));
                if (thruput != 0xFFFFFFFFL) {
                    testdata.getThroughPutData().add(new TEThroughPutData(framesize, thruput, starttime, endtime));
                }
                if ((thtypevalue = TEAutoTestUtils.getThruputTypeValue(output))[0] != 65535) {
                    testdata.getPacketLossData().add(new TEPacketLossData(framesize, thtypevalue[0], TEAutoTestUtils.convertLoss(thtypevalue[1]), starttime, endtime));
                }
                if ((delayvalue = TEAutoTestUtils.getDelayTypeValue(output))[0] == 0xFFFFFFFFL) continue;
                testdata.getLatencyData().add(new TELatencyData(framesize, (int)delayvalue[0], delayvalue[1], starttime, endtime));
                continue;
            }
            if (testtype != 1) continue;
            if (process < 100) {
                testdata.setProcess(process);
                testdata.setTestType(1);
            }
            double sendpkt = TEAutoTestUtils.getPktValue(output.getPartValue("sendpkt").getBytes());
            double recpkt = TEAutoTestUtils.getPktValue(output.getPartValue("recpkt").getBytes());
            int[] thtypevalue = TEAutoTestUtils.getThruputTypeValue(output);
            if (thtypevalue[0] == 65535) continue;
            testdata.getLongPacketLossData().add(new TELongPacketLossData(framesize, thtypevalue[0], TEAutoTestUtils.convertLoss(thtypevalue[1]), sendpkt, recpkt, starttime, endtime));
        }
        return testdata;
    }

    public static String convertLoss(int loss) {
        if (loss == 65534) {
            return "-";
        }
        float floss = (float)loss / 100.0f;
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(floss);
    }

    private static String convertTime(String time) {
        if (time.length() >= 14) {
            int year = Integer.parseInt(time.substring(0, 4), 16);
            int month = Integer.parseInt(time.substring(4, 6), 16);
            int day = Integer.parseInt(time.substring(6, 8), 16);
            int hour = Integer.parseInt(time.substring(8, 10), 16);
            int minute = Integer.parseInt(time.substring(10, 12), 16);
            int second = Integer.parseInt(time.substring(12, 14), 16);
            Calendar cal = Calendar.getInstance();
            cal.set(year, month - 1, day, hour, minute, second);
            return TEDateUtils.calendarToStr((Calendar)cal);
        }
        return "";
    }

    public static double getPktValue(byte[] bValue) {
        byte[] bTmp = new byte[8];
        System.arraycopy(bValue, 0, bTmp, 0, 8);
        long lHighValue = IOStreamConvertor.readUnSignedPositiveLong((byte[])bTmp, (int)0);
        double highValue = (double)lHighValue * 4.294967296E9;
        bTmp = new byte[8];
        System.arraycopy(bValue, 8, bTmp, 0, 8);
        long lLowValue = IOStreamConvertor.readUnSignedPositiveLong((byte[])bTmp, (int)0);
        return highValue + (double)lLowValue;
    }

    private static int[] getThruputTypeValue(Output output) {
        int lr100;
        int lr90;
        int[] result = new int[]{65535, 65535};
        int lr80 = Integer.parseInt(output.getPartValue("lr80"));
        if (lr80 != 65535) {
            result[0] = 80;
            result[1] = lr80;
        }
        if ((lr90 = Integer.parseInt(output.getPartValue("lr90"))) != 65535) {
            result[0] = 90;
            result[1] = lr90;
        }
        if ((lr100 = Integer.parseInt(output.getPartValue("lr100"))) != 65535) {
            result[0] = 100;
            result[1] = lr100;
        }
        return result;
    }

    private static long[] getDelayTypeValue(Output output) {
        long delay100;
        long delay90;
        long[] result = new long[]{0xFFFFFFFFL, 0xFFFFFFFFL};
        long delay80 = Long.parseLong(output.getPartValue("delay80"));
        if (delay80 != 0xFFFFFFFFL) {
            result[0] = 80L;
            result[1] = delay80;
        }
        if ((delay90 = Long.parseLong(output.getPartValue("delay90"))) != 0xFFFFFFFFL) {
            result[0] = 90L;
            result[1] = delay90;
        }
        if ((delay100 = Long.parseLong(output.getPartValue("delay100"))) != 0xFFFFFFFFL) {
            result[0] = 100L;
            result[1] = delay100;
        }
        return result;
    }
}

