/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.model.eventinterpret.TEEventDataConstants;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEAutoTestData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEAutoTestUtils;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TELatencyData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TELongPacketLossData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEPacketLossData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEThroughPutData;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.Hashtable;
import java.util.Map;

public class TEAutoTestCache {
    private Map<Integer, Hashtable<String, TEAutoTestData>> autotestcache = new Hashtable<Integer, Hashtable<String, TEAutoTestData>>();
    private static TEAutoTestCache instance = null;
    private TEPacketLossNoticeHandler packetlossNotice = new TEPacketLossNoticeHandler();
    private TEThroughPutNoticeHandler throughputNotice = new TEThroughPutNoticeHandler();
    private TELatencyNoticeHandler latencyNotice = new TELatencyNoticeHandler();
    private TELongPacketLossNoticeHandler longpacketlossNotice = new TELongPacketLossNoticeHandler();
    private TEAutotestEndNoticeHandler autotestNotice = new TEAutotestEndNoticeHandler();

    private TEAutoTestCache() {
        Operation oper = TECreateObjectFactory.getOperation((String)TEEventDataConstants.QX_DES_PATH_MAIN, (String)"NSEVT_ETH_SRV_PACKETLOSS_RSP");
        TENECommMgr.getInstance().registerListener(oper, (NoticeHandler)this.packetlossNotice);
        oper = TECreateObjectFactory.getOperation((String)TEEventDataConstants.QX_DES_PATH_MAIN, (String)"NSEVT_ETH_SRV_THROUGHPUT_RSP");
        TENECommMgr.getInstance().registerListener(oper, (NoticeHandler)this.throughputNotice);
        oper = TECreateObjectFactory.getOperation((String)TEEventDataConstants.QX_DES_PATH_MAIN, (String)"NSEVT_ETH_SRV_LATENCY_RSP");
        TENECommMgr.getInstance().registerListener(oper, (NoticeHandler)this.latencyNotice);
        oper = TECreateObjectFactory.getOperation((String)TEEventDataConstants.QX_DES_PATH_MAIN, (String)"NSEVT_ETH_SRV_LONGTERM_PACKETLOSS_RSP");
        TENECommMgr.getInstance().registerListener(oper, (NoticeHandler)this.longpacketlossNotice);
        oper = TECreateObjectFactory.getOperation((String)TEEventDataConstants.QX_DES_PATH_MAIN, (String)"NSEVT_ETH_SRV_AUTOTEST_ENDRSP");
        TENECommMgr.getInstance().registerListener(oper, (NoticeHandler)this.autotestNotice);
    }

    public static synchronized TEAutoTestCache getInstance() {
        if (instance == null) {
            instance = new TEAutoTestCache();
        }
        return instance;
    }

    public Map<Integer, Hashtable<String, TEAutoTestData>> getAutotestCache() {
        return this.autotestcache;
    }

    public void setAutotestCache(Map<Integer, Hashtable<String, TEAutoTestData>> autotestcache) {
        this.autotestcache = autotestcache;
    }

    public Hashtable<String, TEAutoTestData> getNECache(int neid) {
        return this.autotestcache.get(neid);
    }

    public TEAutoTestData getServcieCache(int neid, String serviceIndex) {
        TEAutoTestData autotest = null;
        Hashtable<String, TEAutoTestData> nedata = this.autotestcache.get(neid);
        if (nedata != null) {
            autotest = nedata.get(serviceIndex);
        }
        return autotest;
    }

    public synchronized void addServiceCahce(int neid, String serviceIndex, TEAutoTestData testdata) {
        Hashtable<String, TEAutoTestData> nedata = this.autotestcache.get(neid);
        if (nedata == null) {
            nedata = new Hashtable();
            this.autotestcache.put(neid, nedata);
        }
        nedata.put(serviceIndex, testdata);
    }

    public synchronized void delNECahce(int neid) {
        this.autotestcache.remove(neid);
    }

    public synchronized void delServiceCahce(int neid, String serviceIndex) {
        Hashtable<String, TEAutoTestData> nedata = this.autotestcache.get(neid);
        if (nedata != null) {
            nedata.remove(serviceIndex);
        }
    }

    class TEAutotestEndNoticeHandler
    implements NoticeHandler {
        TEAutotestEndNoticeHandler() {
        }

        public void handleNotice(int cmd, int neid, Operation oper) {
            for (Output output : oper.getOutput()) {
                String serviceIndex = output.getPartValue("serviceIndex");
                TEAutoTestCache.getInstance().delServiceCahce(neid, serviceIndex);
            }
        }
    }

    class TELongPacketLossNoticeHandler
    implements NoticeHandler {
        TELongPacketLossNoticeHandler() {
        }

        public void handleNotice(int cmd, int neid, Operation oper) {
            for (Output output : oper.getOutput()) {
                String serviceIndex = output.getPartValue("serviceIndex");
                TEAutoTestData autotest = TEAutoTestCache.getInstance().getServcieCache(neid, serviceIndex);
                if (autotest == null) continue;
                double sendnum = TEAutoTestUtils.getPktValue(output.getPartValue("sendpkt").getBytes());
                double inceptnum = TEAutoTestUtils.getPktValue(output.getPartValue("recpkt").getBytes());
                int loss = Integer.parseInt(output.getPartValue("loss"));
                TELongPacketLossData longdata = new TELongPacketLossData(Integer.parseInt(output.getPartValue("framesize")), Integer.parseInt(output.getPartValue("throughput")), TEAutoTestUtils.convertLoss(loss), sendnum, inceptnum);
                autotest.getLongPacketLossData().add(longdata);
                autotest.setProcess(100);
            }
        }
    }

    class TELatencyNoticeHandler
    implements NoticeHandler {
        TELatencyNoticeHandler() {
        }

        public void handleNotice(int cmd, int neid, Operation oper) {
            for (Output output : oper.getOutput()) {
                String serviceIndex = output.getPartValue("serviceIndex");
                TEAutoTestData autotest = TEAutoTestCache.getInstance().getServcieCache(neid, serviceIndex);
                long latencyval = Long.parseLong(output.getPartValue("latency"));
                if (autotest == null || latencyval == 0xFFFFFFFFL) continue;
                TELatencyData latency = new TELatencyData(Integer.parseInt(output.getPartValue("framesize")), Integer.parseInt(output.getPartValue("throughput")), latencyval);
                autotest.getLatencyData().add(latency);
                int process = Integer.parseInt(output.getPartValue("process"));
                if (process > autotest.getProcess()) {
                    autotest.setProcess(process);
                }
                if (autotest.getTestType() != -1) continue;
                autotest.setTestType(0);
            }
        }
    }

    class TEThroughPutNoticeHandler
    implements NoticeHandler {
        TEThroughPutNoticeHandler() {
        }

        public void handleNotice(int cmd, int neid, Operation oper) {
            for (Output output : oper.getOutput()) {
                String serviceIndex = output.getPartValue("serviceIndex");
                TEAutoTestData autotest = TEAutoTestCache.getInstance().getServcieCache(neid, serviceIndex);
                long throughputval = Long.parseLong(output.getPartValue("throughput"));
                if (autotest == null || throughputval == 0xFFFFFFFFL) continue;
                TEThroughPutData throughput = new TEThroughPutData(Integer.parseInt(output.getPartValue("framesize")), throughputval);
                autotest.getThroughPutData().add(throughput);
                int process = Integer.parseInt(output.getPartValue("process"));
                if (process > autotest.getProcess()) {
                    autotest.setProcess(process);
                }
                if (autotest.getTestType() != -1) continue;
                autotest.setTestType(0);
            }
        }
    }

    class TEPacketLossNoticeHandler
    implements NoticeHandler {
        TEPacketLossNoticeHandler() {
        }

        public void handleNotice(int cmd, int neid, Operation oper) {
            for (Output output : oper.getOutput()) {
                String serviceIndex = output.getPartValue("serviceIndex");
                TEAutoTestData autotest = TEAutoTestCache.getInstance().getServcieCache(neid, serviceIndex);
                int packetlossval = Integer.parseInt(output.getPartValue("packetloss"));
                if (autotest == null || packetlossval == 65535) continue;
                TEPacketLossData packetloss = new TEPacketLossData(Integer.parseInt(output.getPartValue("framesize")), Integer.parseInt(output.getPartValue("throughput")), TEAutoTestUtils.convertLoss(packetlossval));
                autotest.getPacketLossData().add(packetloss);
                int process = Integer.parseInt(output.getPartValue("process"));
                if (process > autotest.getProcess()) {
                    autotest.setProcess(process);
                }
                if (autotest.getTestType() != -1) continue;
                autotest.setTestType(0);
            }
        }
    }
}

