/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEAutoTestData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEAutoTestUtils;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TELatencyData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TELongPacketLossData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEPacketLossData;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.autotest.TEThroughPutData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.nglct.util.system.TESystemUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TEATReportServlet
extends HttpServlet {
    private static final long serialVersionUID = 132776166793818478L;
    private static final String INPUTDATA_PARAM = "inputdata";
    private static final String NEID_PARAM = "neid";
    private static final String LINESEP = "\r\n";
    private static final String TAB_CODE = "\t";
    private static final int SPILT_COUNT = 200;
    private static final int NEID_MAX = 65536;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String inputDataStr = request.getParameter(INPUTDATA_PARAM);
        inputDataStr = URLDecoder.decode(inputDataStr, "UTF-8");
        Datainterface inputData = null;
        int neid = -1;
        String serviceIndex = null;
        try {
            inputData = TECreateObjectFactory.parseInputData((String)inputDataStr);
            neid = this.getNEID(inputData);
            serviceIndex = inputData.getBussinessParams().getRowParams(0).getParam("serviceIndex").getValue();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEATReportServlet exception", (Throwable)e);
        }
        if (inputData == null || neid == -1 || serviceIndex == null) {
            TESystemUtil.sendRedirect((String)"page/printerror.html?message=0", (HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        TEAutoTestData testdata = TEAutoTestUtils.queryTestDataFromNE(neid, serviceIndex);
        if (testdata == null) {
            String erroMsg = TESysManagerBean.getInstance().getlanguage().equals("zh") ? URLEncoder.encode(TEErrorResourceUtil.getErrorMessage((int)1090617361).getErrorinfo(), "UTF-8") : TEErrorResourceUtil.getErrorMessage((int)1090617361).getErrorinfo();
            TESystemUtil.sendRedirect((String)("page/printerror.html?msg=" + erroMsg), (HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        String result = this.getATData2Text(neid, inputData, testdata);
        ServletOutputStream out = response.getOutputStream();
        String Language = request.getHeader("Accept-Language");
        String encode = "UTF-8";
        if (Language.indexOf("zh") >= 0) {
            encode = "GBK";
        }
        response.setCharacterEncoding(encode);
        response.setHeader("Content-Type", "application/force-download");
        String filename = "AutoTest_" + this.getShowNEName(neid) + "_" + serviceIndex + ".txt";
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        response.setHeader("Expires", "0");
        response.setHeader("Pragma", "public");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Cache-Control", "public");
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream((OutputStream)out);
            bos.write(result.getBytes(encode));
            this.wirteLog(neid, inputData, request);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEATReportServlet fail!", (Throwable)e);
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
    }

    private void wirteLog(int neid, Datainterface inputData, HttpServletRequest request) {
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        TEResourceUtil res = this.getReportRes(neid);
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        TELogInfo loginfo = new TELogInfo();
        loginfo.setCmdID(2179936);
        loginfo.setOperateName(res.getString("TECMDCODE_ETHSRV_QUERY_AUTOTEST_RESULT"));
        String desc = res.getString("exporttitle") + " " + res.getString("serviceID") + ":" + row.getParam("serviceID").getValue() + " ";
        desc = desc + res.getString("serviceName") + ":" + row.getParam("serviceName").getValue() + " ";
        desc = desc + res.getString("testname") + ":" + row.getParam("testname").getValue() + " ";
        loginfo.setOperateDesc(desc);
        String nmUser = request.getParameter("nmUser");
        if (null == nmUser || "".equals(nmUser)) {
            nmUser = TESysManagerBean.getInstance().getSysUser();
        }
        try {
            loginfo.setUserID(Integer.parseInt(nmUser));
        }
        catch (Exception e) {
            loginfo.setUserID(0);
        }
        loginfo.setLocation(request.getLocalAddr());
        loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
        loginfo.setOperateObject(neObj.getNEName());
        loginfo.setErrCode(0);
        loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)0));
        TELogMgr.writeLog((TELogInfo)loginfo);
    }

    private String getATData2Text(int neid, Datainterface inputData, TEAutoTestData testdata) throws UnsupportedEncodingException, IOException {
        StringBuilder sbTemp = new StringBuilder();
        sbTemp.append(this.getATServiceTxt(neid, inputData));
        sbTemp.append(this.getATThroughputTxt(neid, testdata.getThroughPutData()));
        sbTemp.append(this.getATLatencyTxt(neid, testdata.getLatencyData()));
        sbTemp.append(this.getATPacketLossTxt(neid, testdata.getPacketLossData()));
        sbTemp.append(this.getATLongPktLossTxt(neid, testdata.getLongPacketLossData()));
        return sbTemp.toString();
    }

    public String getATServiceTxt(int neid, Datainterface inputData) {
        TEResourceUtil res = this.getReportRes(neid);
        StringBuilder sbTemp = new StringBuilder();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int maxLength = 12;
        maxLength = TESysManagerBean.getInstance().getlanguage().indexOf("zh") >= 0 ? TEStringUtils.getChineseLength((String)res.getString("endflag")) : TEStringUtils.getChineseLength((String)res.getString("serviceName"));
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        sbTemp.append(res.getString("autotesttitle")).append(LINESEP);
        sbTemp.append(LINESEP);
        sbTemp.append(res.getString("nename")).append(TEStringUtils.getSpace((int)(maxLength - TEStringUtils.getChineseLength((String)res.getString("nename"))))).append(TAB_CODE).append(ne.getNEName()).append(LINESEP);
        sbTemp.append(res.getString("testname")).append(TEStringUtils.getSpace((int)(maxLength - TEStringUtils.getChineseLength((String)res.getString("testname"))))).append(TAB_CODE).append(row.getParam("testname").getValue()).append(LINESEP);
        sbTemp.append(res.getString("serviceID")).append(TEStringUtils.getSpace((int)(maxLength - TEStringUtils.getChineseLength((String)res.getString("serviceID"))))).append(TAB_CODE).append(row.getParam("serviceID").getValue()).append(LINESEP);
        sbTemp.append(res.getString("serviceName")).append(TEStringUtils.getSpace((int)(maxLength - TEStringUtils.getChineseLength((String)res.getString("serviceName"))))).append(TAB_CODE).append(row.getParam("serviceName").getValue()).append(LINESEP);
        sbTemp.append(res.getString("endflag")).append(TEStringUtils.getSpace((int)(maxLength - TEStringUtils.getChineseLength((String)res.getString("endflag"))))).append(TAB_CODE).append(row.getParam("endflag").getValue()).append(LINESEP);
        sbTemp.append(res.getString("testnode")).append(TEStringUtils.getSpace((int)(maxLength - TEStringUtils.getChineseLength((String)res.getString("testnode"))))).append(TAB_CODE).append(row.getParam("testnode").getValue()).append(LINESEP);
        sbTemp.append(res.getString("testtime")).append(TEStringUtils.getSpace((int)(maxLength - TEStringUtils.getChineseLength((String)res.getString("testtime"))))).append(TAB_CODE).append(TEDateUtils.calendarToStr((Calendar)Calendar.getInstance())).append(LINESEP);
        sbTemp.append(LINESEP);
        return sbTemp.toString();
    }

    public String getATThroughputTxt(int neid, List<TEThroughPutData> throughs) {
        TEResourceUtil res = this.getReportRes(neid);
        String title = this.appendSpace(res.getString("framesize")) + this.appendSpace(res.getString("throughput")) + this.appendSpace(res.getString("starttime")) + this.appendSpace(res.getString("endtime"));
        StringBuilder sbTemp = new StringBuilder();
        sbTemp.append(this.appendSplit(200));
        sbTemp.append(LINESEP);
        if (throughs != null) {
            sbTemp.append(res.getString("throughputtitle")).append(LINESEP);
            sbTemp.append(res.getString("total")).append(throughs.size()).append(res.getString("item")).append(LINESEP);
            sbTemp.append(title);
            sbTemp.append(LINESEP);
            int len = throughs.size();
            for (int i = 0; i < len; ++i) {
                TEThroughPutData through = throughs.get(i);
                sbTemp.append(this.appendSpace(String.valueOf(through.getFrameSize())));
                sbTemp.append(this.appendSpace(String.valueOf(through.getThroughPut())));
                sbTemp.append(this.appendSpace(String.valueOf(through.getStartTime())));
                sbTemp.append(this.appendSpace(String.valueOf(through.getEndTime())));
                sbTemp.append(LINESEP);
            }
        }
        sbTemp.append(LINESEP);
        return sbTemp.toString();
    }

    public String getATLatencyTxt(int neid, List<TELatencyData> latencys) {
        TEResourceUtil res = this.getReportRes(neid);
        String title = this.appendSpace(res.getString("framesize")) + this.appendSpace(res.getString("throughputper")) + this.appendSpace(res.getString("latency")) + this.appendSpace(res.getString("starttime")) + this.appendSpace(res.getString("endtime"));
        StringBuilder sbTemp = new StringBuilder();
        sbTemp.append(this.appendSplit(200));
        sbTemp.append(LINESEP);
        if (latencys != null) {
            sbTemp.append(res.getString("latencytitle")).append(LINESEP);
            sbTemp.append(res.getString("total")).append(latencys.size()).append(res.getString("item")).append(LINESEP);
            sbTemp.append(title);
            sbTemp.append(LINESEP);
            int len = latencys.size();
            for (int i = 0; i < len; ++i) {
                TELatencyData latency = latencys.get(i);
                sbTemp.append(this.appendSpace(String.valueOf(latency.getFrameSize())));
                sbTemp.append(this.appendSpace(String.valueOf(latency.getThroughPut())));
                sbTemp.append(this.appendSpace(String.valueOf(latency.getLatency())));
                sbTemp.append(this.appendSpace(String.valueOf(latency.getStartTime())));
                sbTemp.append(this.appendSpace(String.valueOf(latency.getEndTime())));
                sbTemp.append(LINESEP);
            }
        }
        sbTemp.append(LINESEP);
        return sbTemp.toString();
    }

    public String getATPacketLossTxt(int neid, List<TEPacketLossData> packets) {
        TEResourceUtil res = this.getReportRes(neid);
        String title = this.appendSpace(res.getString("framesize")) + this.appendSpace(res.getString("throughputper")) + this.appendSpace(res.getString("packetloss")) + this.appendSpace(res.getString("starttime")) + this.appendSpace(res.getString("endtime"));
        StringBuilder sbTemp = new StringBuilder();
        sbTemp.append(this.appendSplit(200));
        sbTemp.append(LINESEP);
        if (packets != null) {
            sbTemp.append(res.getString("packettitle")).append(LINESEP);
            sbTemp.append(res.getString("total")).append(packets.size()).append(res.getString("item")).append(LINESEP);
            sbTemp.append(title);
            sbTemp.append(LINESEP);
            int len = packets.size();
            for (int i = 0; i < len; ++i) {
                TEPacketLossData packet = packets.get(i);
                sbTemp.append(this.appendSpace(String.valueOf(packet.getFrameSize())));
                sbTemp.append(this.appendSpace(String.valueOf(packet.getThroughPut())));
                sbTemp.append(this.appendSpace(String.valueOf(packet.getPacketloss())));
                sbTemp.append(this.appendSpace(String.valueOf(packet.getStartTime())));
                sbTemp.append(this.appendSpace(String.valueOf(packet.getEndTime())));
                sbTemp.append(LINESEP);
            }
        }
        sbTemp.append(LINESEP);
        return sbTemp.toString();
    }

    public String getATLongPktLossTxt(int neid, List<TELongPacketLossData> longpktlosss) {
        TEResourceUtil res = this.getReportRes(neid);
        String title = this.appendSpace(res.getString("framesize")) + this.appendSpace(res.getString("throughputper")) + this.appendSpace(res.getString("recpkt")) + this.appendSpace(res.getString("sendpkt")) + this.appendSpace(res.getString("packetloss")) + this.appendSpace(res.getString("starttime")) + this.appendSpace(res.getString("endtime"));
        StringBuilder sbTemp = new StringBuilder();
        sbTemp.append(this.appendSplit(200));
        sbTemp.append(LINESEP);
        if (longpktlosss != null) {
            sbTemp.append(res.getString("longpackettitle")).append(LINESEP);
            sbTemp.append(res.getString("total")).append(longpktlosss.size()).append(res.getString("item")).append(LINESEP);
            sbTemp.append(title);
            sbTemp.append(LINESEP);
            int len = longpktlosss.size();
            for (int i = 0; i < len; ++i) {
                TELongPacketLossData longpktloss = longpktlosss.get(i);
                sbTemp.append(this.appendSpace(String.valueOf(longpktloss.getFrameSize())));
                sbTemp.append(this.appendSpace(String.valueOf(longpktloss.getThroughPut())));
                sbTemp.append(this.appendSpace(String.valueOf(longpktloss.getRecPkt())));
                sbTemp.append(this.appendSpace(longpktloss.getSendPkt()));
                sbTemp.append(this.appendSpace(longpktloss.getLoss()));
                sbTemp.append(this.appendSpace(String.valueOf(longpktloss.getStartTime())));
                sbTemp.append(this.appendSpace(String.valueOf(longpktloss.getEndTime())));
                sbTemp.append(LINESEP);
            }
        }
        sbTemp.append(LINESEP);
        return sbTemp.toString();
    }

    private String appendSplit(int length) {
        StringBuilder sbTemp = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sbTemp.append('-');
        }
        return sbTemp.toString();
    }

    private String appendSpace(String value) {
        String result = value + TEStringUtils.getSpace((int)(25 - TEStringUtils.getChineseLength((String)value))) + TAB_CODE;
        return result;
    }

    private int getNEID(Datainterface inputData) {
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        Param param = row.getParam(NEID_PARAM);
        int neid = -1;
        if (param != null && !param.getValue().equals("")) {
            neid = Integer.parseInt(param.getValue());
        }
        return neid;
    }

    private String getShowNEName(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String temp = String.valueOf(neid);
        if (ne != null) {
            temp = "NE(" + ne.getRealNEID() / 65536 + "-" + ne.getRealNEID() % 65536 + ")";
        }
        return temp;
    }

    private TEResourceUtil getReportRes(int neid) {
        StringBuffer filePath = new StringBuffer(50);
        filePath.append("ip").append(File.separator).append("ptn").append(File.separator).append("res").append(File.separator).append("ethservice").append(File.separator).append("autotest").append(File.separator).append("autotestmgrres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        return TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

