/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethprotocolconfig.mstp;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TESetMappingListBean
extends TECommonWriteLogBean {
    private static final int TIME_OUT = 60;
    private static final int COM_NUM_EACH_BATCH = 400;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        BussinessParams businessparams = inputData.getBussinessParams();
        if (null == businessparams.getRowParams(1).getParam("vlanID")) {
            return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        }
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        this.getSetMappingListOper(businessparams);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int lenArry = this.operationList.size();
        ArrayList<Object> operationListPart = new ArrayList<Object>();
        int endIndex = 0;
        int i = 0;
        while (i * 400 < lenArry) {
            Operation cmd_start;
            int n = endIndex = (i + 1) * 400 > lenArry ? lenArry : (i + 1) * 400;
            if (!operationListPart.isEmpty()) {
                operationListPart.clear();
            }
            if ((cmd_start = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_TRANSACTION_BEGIN")) != null) {
                operationListPart.add(cmd_start);
            }
            operationListPart.addAll(this.operationList.subList(i * 400, endIndex));
            Operation cmd_end = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_TRANSACTION_END");
            if (cmd_end != null) {
                operationListPart.add(cmd_end);
            }
            int result = this.sendMessage(neid, operationListPart);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                TELogFactory.getNormalLogger().error("Thread Sleep Fail!", (Throwable)e);
            }
            if (result == 0) {
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                if (null == filterErrorCodeList) {
                    this.handleMessage(neid, operationListPart, subFunc);
                } else {
                    this.handleMessage(neid, operationListPart, subFunc, filterErrorCodeList);
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                break;
            }
            ++i;
        }
        if (null != operationListPart) {
            operationListPart.clear();
            this.operationList.clear();
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public int sendMessage(int neid, ArrayList operationListPart) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)operationListPart, 60);
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    private void getSetMappingListOper(BussinessParams bussinessparams) {
        RowParams rowparams = null;
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_SET_MSTPMSTIMAP");
        Input input = oper.getInput();
        String vlanid = "";
        HashMap<String, String> vlanmap = new HashMap<String, String>();
        int len = bussinessparams.getRowParamsCount();
        for (int i = 1; i < len; ++i) {
            int j;
            int lenArry;
            rowparams = bussinessparams.getRowParams(i);
            ArrayList oldVlanid = this.paresVlan(rowparams.getParam("oldVlanID").getValue());
            ArrayList vlanidArray = this.paresVlan(rowparams.getParam("vlanID").getValue());
            String mstiID = rowparams.getParam("mstiID").getValue();
            if (!vlanidArray.isEmpty()) {
                lenArry = vlanidArray.size();
                for (j = 0; j < lenArry; ++j) {
                    vlanid = vlanidArray.get(j).toString();
                    input.setPartValue("idFlag", "0");
                    input.setPartValue("portGroupID", rowparams.getParam("portGroupID").getValue());
                    if ("0".equals(vlanid) || "4095".equals(vlanid)) continue;
                    if (oldVlanid.contains(vlanid)) {
                        oldVlanid.remove(vlanid);
                        continue;
                    }
                    input.setPartValue("vlanID", vlanid);
                    input.setPartValue("mstiID", mstiID);
                    vlanmap.put(vlanid, rowparams.getParam("mstiID").getValue());
                    this.operationList.add(oper.clone());
                }
            }
            lenArry = oldVlanid.size();
            for (j = 0; j < lenArry; ++j) {
                vlanid = oldVlanid.get(j).toString();
                input.setPartValue("idFlag", "0");
                input.setPartValue("portGroupID", rowparams.getParam("portGroupID").getValue());
                if (vlanmap.containsKey(vlanid) || "0".equals(mstiID)) continue;
                input.setPartValue("vlanID", vlanid);
                input.setPartValue("mstiID", "0");
                this.operationList.add(oper.clone());
            }
        }
    }

    private ArrayList paresVlan(String vlan) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (vlan.isEmpty() || "-".equals(vlan)) {
            return resultList;
        }
        String[] strArr = vlan.split(",");
        int len = strArr.length;
        for (int i = 0; i < len; ++i) {
            int b = strArr[i].indexOf("-");
            if (0 < b) {
                String[] range = strArr[i].split("-");
                int rangeStart = Integer.parseInt(range[0]);
                int rangeEnd = Integer.parseInt(range[1]);
                for (int j = rangeStart; j <= rangeEnd; ++j) {
                    resultList.add(resultList.size(), "" + j);
                }
                continue;
            }
            resultList.add(resultList.size(), strArr[i]);
        }
        return resultList;
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getSinleDetailInfo(RowParams[] rParamsArr) {
        int i;
        StringBuffer filePath = new StringBuffer(50);
        filePath.append("ip").append(File.separator).append("ptn").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ethprotocolconfig").append(File.separator).append("MSTP_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer operDesc = new StringBuffer();
        RowParams rowparams = null;
        Param param = null;
        HashMap<String, String> mappinglistMap = new HashMap<String, String>(16);
        ArrayList<String> mstiIDList = new ArrayList<String>(16);
        String portGroupID = null;
        String mstiID = null;
        String vlanID = null;
        String mappingModel = null;
        int len = rParamsArr.length;
        for (i = 1; i < len; ++i) {
            rowparams = rParamsArr[i];
            param = rowparams.getParam("portGroupID");
            if (param != null && portGroupID == null) {
                portGroupID = param.getValue();
            }
            if ((param = rowparams.getParam("mappingModel")) != null) {
                mappingModel = param.getValue();
                break;
            }
            param = rowparams.getParam("mstiID");
            if (param != null) {
                mstiID = param.getValue();
            }
            if ((param = rowparams.getParam("vlanID")) != null) {
                vlanID = param.getValue();
            }
            mstiIDList.add(mstiID);
            mappinglistMap.put(mstiID, vlanID);
        }
        operDesc.append(res.getString("portGroupID")).append(':');
        operDesc.append(portGroupID).append(',');
        if (mappingModel != null) {
            operDesc.append(res.getString("useMappingTemplet")).append(':');
            operDesc.append(mappingModel);
            return operDesc.toString();
        }
        operDesc.append(res.getString("customMappingList")).append(',');
        operDesc.append(res.getString("mappingList")).append(":\n");
        for (i = 0; i < mstiIDList.size(); ++i) {
            mstiID = (String)mstiIDList.get(i);
            vlanID = (String)mappinglistMap.get(mstiID);
            operDesc.append(res.getString("mstiID")).append(':');
            operDesc.append(mstiID).append(',');
            operDesc.append(res.getString("vlanID")).append(':');
            operDesc.append(vlanID);
            operDesc.append('\n');
        }
        String result = operDesc.toString();
        if (result.endsWith("\n")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

