/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethprotocolconfig.mstp;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEQueryPGPortBean
extends TENEExplorerBean {
    private ArrayList rowErrorList = new ArrayList();
    private static final int INVALIDVALUE = 255;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = businessparams.getRowParams(0);
        String portGroupID = rowparams.getParam("portGroupID").getValue();
        int resultCode = -1;
        resultCode = this.queryPort(portGroupID);
        if (resultCode == 0) {
            resultCode = this.queryPortProtocol(portGroupID);
        }
        if (resultCode != 0) {
            resultCode = 1;
            int size = this.rowErrorList.size();
            for (int i = 0; i < size; ++i) {
                RowParams rParam = new RowParams();
                RowErrors rError = (RowErrors)this.rowErrorList.get(i);
                rParam.addRowErrors(rError);
                this.outputData.getBussinessParams().addRowParams(rParam);
            }
        }
        ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
        this.outputData.setErrorMessage(bigErr);
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int queryPort(String portGroupID) {
        RowParams pgPortRowparam = null;
        Param param = null;
        Part part = null;
        TEConfigurationDataMgr pgportMgr = TEConfigurationDataMgr.getInstance();
        Operation pgportoper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_GET_MSTPPORTGROUP");
        Input input = pgportoper.getInput();
        input.setPartValue("portGroupID", portGroupID);
        this.operationList.add(pgportoper);
        int result = this.sendMessage(this.neid);
        if (result != 0) {
            return result;
        }
        Operation tmpPgPortOper = (Operation)this.operationList.get(0);
        this.operationList.clear();
        for (Output output : tmpPgPortOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code == 0) continue;
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("portGroupID", portGroupID);
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                this.rowErrorList.add(rowError);
                return code;
            }
            part = output.getPart("portInfo");
            if (part == null || part.getValue() == null) {
                return 0;
            }
            byte[] bPgPortValue = part.getValue().getBytes();
            int stepLength = 10;
            int startIndex = 0;
            while (startIndex + stepLength <= bPgPortValue.length) {
                pgPortRowparam = new RowParams();
                param = new Param("portGroupID", portGroupID);
                pgPortRowparam.addParam(param);
                byte[] bTmp = new byte[4];
                System.arraycopy(bPgPortValue, startIndex + 0, bTmp, 0, 4);
                int slotid = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                param = new Param("slotid", slotid + "");
                pgPortRowparam.addParam(param);
                int boardType = pgportMgr.getBoard(this.neid, slotid).getBoardType();
                String boardName = pgportMgr.getBoardTypeName(this.neid, boardType);
                param = new Param("boardName", boardName);
                pgPortRowparam.addParam(param);
                pgPortRowparam.addParam(new Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)this.neid, (int)slotid))));
                if (!TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid).equals("")) {
                    pgPortRowparam.addParam(new Param("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid)));
                }
                bTmp = new byte[2];
                System.arraycopy(bPgPortValue, startIndex + 4, bTmp, 0, 2);
                int subslotid = IOStreamConvertor.readPositiveShort((byte[])bTmp, (int)0);
                param = new Param("subslotid", "");
                pgPortRowparam.addParam(param);
                int subBoardType = 0;
                if (255 != subslotid) {
                    pgPortRowparam.getParam("subslotid").setValue(subslotid + "");
                    subBoardType = pgportMgr.getSubboardType(this.neid, slotid, subslotid);
                    String subBoardName = pgportMgr.getBoardTypeName(this.neid, subBoardType);
                    param = new Param("subBoardName", subBoardName);
                    pgPortRowparam.addParam(param);
                }
                bTmp = new byte[4];
                System.arraycopy(bPgPortValue, startIndex + 6, bTmp, 0, 4);
                int port = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                param = new Param("port", port + "");
                pgPortRowparam.addParam(param);
                String portName = "";
                portName = 0 == subBoardType ? pgportMgr.getPortNameForPTN(this.neid, slotid, boardType, port, 16) : pgportMgr.getPortNameForPTN(this.neid, slotid, subBoardType, port, 16);
                param = new Param("portName", portName);
                pgPortRowparam.addParam(param);
                param = new Param("portProtocolEnable", "");
                pgPortRowparam.addParam(param);
                pgportoper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_GET_MSTPPORTSTATE");
                input = pgportoper.getInput();
                input.setPartValue("portGroupID", portGroupID);
                input.setPartValue("slotid", slotid + "");
                input.setPartValue("subslotid", subslotid + "");
                input.setPartValue("port", port + "");
                this.operationList.add(pgportoper);
                this.outputData.getBussinessParams().addRowParams(pgPortRowparam);
                startIndex += stepLength;
            }
        }
        return 0;
    }

    private int queryPortProtocol(String portGroupID) {
        RowParams rowparam = null;
        Param param = null;
        OperationResult pgPortresult = TENECommMgr.getInstance().sendCommand(this.neid, (List)this.operationList, this.TIME_OUT);
        if (pgPortresult.retCode != 0) {
            return pgPortresult.retCode;
        }
        int len = this.operationList.size();
        block0: for (int i = 0; i < len; ++i) {
            Output outputArr;
            Operation tmpPgPortOper = (Operation)this.operationList.get(i);
            Output output = outputArr = tmpPgPortOper.getOutput()[0];
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code == 0) continue;
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("portGroupID", portGroupID);
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                this.rowErrorList.add(rowError);
                return code;
            }
            String slotid = output.getPartValue("slotid");
            String subslotid = output.getPartValue("subslotid");
            if (255 == Integer.parseInt(subslotid)) {
                subslotid = "";
            }
            String port = output.getPartValue("port");
            String portProtocolEnable = output.getPartValue("portProtocolEnable");
            BussinessParams businessparams = this.outputData.getBussinessParams();
            int size = businessparams.getRowParamsCount();
            for (int index = 0; index < size; ++index) {
                rowparam = businessparams.getRowParams(index);
                param = rowparam.getParam("portProtocolEnable");
                if (!param.getValue().equals("") || !rowparam.getParam("slotid").getValue().equals(slotid) || !rowparam.getParam("subslotid").getValue().equals(subslotid) || !rowparam.getParam("port").getValue().equals(port)) continue;
                param.setValue(portProtocolEnable);
                continue block0;
            }
        }
        this.operationList.clear();
        return 0;
    }
}

