/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethprotocolconfig.mstp;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class TEQueryMappingListBean
extends TENEExplorerBean {
    private static int MSTI_COUNT = 17;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.initMSTICount(neid);
        StringBuffer[] mappingList = new StringBuffer[MSTI_COUNT];
        for (int i = 0; i < MSTI_COUNT; ++i) {
            mappingList[i] = new StringBuffer();
        }
        RowParams rowparam = null;
        Param param = null;
        int vlanID = 0;
        int mstiID = 0;
        int vlanNumber = 0;
        this.outputData.setBussinessParams(new BussinessParams());
        Operation tmpOper = (Operation)operationList.get(0);
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code == 0) continue;
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("errorBbj", neid + "Query Mapping List");
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)code));
                RowParams rParam = new RowParams();
                rParam.addRowErrors(rowError);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                this.outputData.getBussinessParams().addRowParams(rParam);
                return;
            }
            String vlanList = output.getPartValue("vlanList");
            int startIndex = 0;
            int lenList = vlanList.length();
            while (startIndex < lenList) {
                mstiID = Integer.parseInt(vlanList.substring(startIndex, startIndex + 2), 16);
                vlanNumber = Integer.parseInt(vlanList.substring(startIndex += 2, startIndex + 4), 16);
                startIndex += 4;
                for (int j = 0; j < vlanNumber; ++j) {
                    vlanID = Integer.parseInt(vlanList.substring(startIndex, startIndex + 4), 16);
                    startIndex += 4;
                    mappingList[mstiID].append(vlanID).append(",");
                }
            }
        }
        for (int i = 0; i < MSTI_COUNT; ++i) {
            rowparam = new RowParams();
            param = new Param("mstiID", i + "");
            rowparam.addParam(param);
            String vlanIDStr = mappingList[i].toString();
            int len = vlanIDStr.length();
            if (0 != len) {
                vlanIDStr = vlanIDStr.substring(0, len - 1);
                vlanIDStr = this.parseEncapsValueList(vlanIDStr);
            }
            param = new Param("vlanID", vlanIDStr);
            rowparam.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowparam);
        }
        tmpOper = (Operation)operationList.get(1);
        operationList.clear();
        rowparam = new RowParams();
        String mappingmodel = tmpOper.getOutput()[0].getPartValue("mappingModel");
        if (mappingmodel == null) {
            mappingmodel = "";
        }
        param = new Param("mappingModel", mappingmodel);
        rowparam.addParam(param);
        this.outputData.getBussinessParams().addRowParams(rowparam);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private String parseEncapsValueList(String str) {
        String[] stringArrays = str.split(",");
        int[] intArray = new int[stringArrays.length];
        int len = stringArrays.length;
        for (int j = 0; j < len; ++j) {
            intArray[j] = Integer.parseInt(stringArrays[j]);
        }
        Arrays.sort(intArray);
        ArrayList<String> encapsValue = new ArrayList<String>();
        int len2 = stringArrays.length;
        for (int j = 0; j < len2; ++j) {
            encapsValue.add(intArray[j] + "");
        }
        String result = "";
        if (encapsValue.size() >= 2) {
            Iterator it = encapsValue.iterator();
            int curNum = Integer.parseInt((String)it.next());
            int offset = 0;
            StringBuffer buffer = new StringBuffer();
            buffer.append(curNum);
            int tmpNum = -1;
            while (it.hasNext()) {
                int nextNum = Integer.parseInt((String)it.next());
                if (nextNum != curNum + offset + 1) {
                    if (offset != 0) {
                        tmpNum = curNum + offset;
                        buffer.append("-").append(tmpNum);
                        buffer.append(",").append(nextNum);
                    } else {
                        buffer.append(",").append(nextNum);
                    }
                    offset = 0;
                    curNum = nextNum;
                    continue;
                }
                ++offset;
            }
            if (offset > 0) {
                tmpNum = curNum + offset;
                buffer.append("-").append(tmpNum);
            }
            result = buffer.toString();
        } else if (encapsValue.size() == 1) {
            result = encapsValue.get(0).toString();
        }
        return result;
    }

    private void initMSTICount(int neid) {
        int maxInt;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String neVersion = ne.getHostVersion();
        String[] versionArray = neVersion.split("\\.");
        if (68 == neType || (29 == neType || 41 == neType || 82 == neType) && (versionArray[2] + versionArray[3]).compareTo("3210") >= 0) {
            MSTI_COUNT = 16;
        }
        if ((maxInt = TESpecialAttrMgr.getInstance().getNEAttrIntValue(neid, "TE_FUNC_PORT_GROUP", "MSTP_ATTR_MAX_MSTIID")) != -1) {
            MSTI_COUNT = maxInt + 1;
        }
    }
}

