/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.ethinterface;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.TEAlarm;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Vector;

public class TEEthInterfaceQueryBean
extends TEGenCfgQueryBean {
    private static final String INVALID_ATTRI = "/";
    private static final String REGMENT = " ";
    private static final String MAC_LOOPBACK_TYPE = "1";
    private static final String PHY_LOOPBACK_TYPE = "2";
    private static final String PORT_ENABLED = "1";
    private static final String PORT_STATUS_DOWN = "0";
    private static final String PORT_STATUS_UP = "1";
    private static final String PORT_STATUS_INVALID = "255";
    private static final int ETH_LOS = 235;

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        Operation tmpOper = null;
        int len = operationList.size();
        block0: for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            if (tmpOper.getName().equals("NSCMD_PTNETY_GET_CURRENT_RATE") && tmpOper.getOutputCount() > 0) {
                Output tempOutput = tmpOper.getOutput()[0];
                tmpOper.clearOutput();
                tmpOper.addOutput(tempOutput);
                continue;
            }
            if (!tmpOper.getName().equals("NSCMD_PTNETY_GET_LOOPMODE") || tmpOper.getOutputCount() <= 0) continue;
            int m = tmpOper.getOutputCount();
            for (int j = 0; j < m; ++j) {
                Output tmpOut = tmpOper.getOutput(j);
                if (tmpOut.getPart("loopBackType") != null && tmpOut.getPart("loopBackType").getValue() != null && tmpOut.getPart("loopBackType").getValue().equals("1") && tmpOut.getPart("ATTR_ETHOVERPTN_MAC_PHY_LOOPBACK") != null) {
                    tmpOper.removeOutput(j);
                    continue block0;
                }
                if (tmpOut.getPart("loopBackType") == null || tmpOut.getPart("loopBackType").getValue() == null || !tmpOut.getPart("loopBackType").getValue().equals(PHY_LOOPBACK_TYPE) || tmpOut.getPart("ATTR_ETHOVERPTN_MAC_MAC_LOOPBACK") == null) continue;
                tmpOper.removeOutput(j);
                continue block0;
            }
        }
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        this.adjustAttributes();
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return true;
    }

    private void adjustAttributes() {
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        RowParams[] rowParamses = bussinessParams.getRowParams();
        RowParams rowParams = null;
        String temp = "";
        int slotId = -1;
        int portId = -1;
        String portName = "";
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        for (int i = bussinessParams.getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = rowParamses[i];
            if (null != rowParams.getParam("port")) {
                portId = Integer.valueOf(rowParams.getParam("port").getValue());
                if (null != rowParams.getParam("slotid")) {
                    slotId = Integer.valueOf(rowParams.getParam("slotid").getValue());
                    portName = cfgMgr.getPortNameForPTN(this.neid, slotId, cfgMgr.getBoardType(this.neid, slotId), portId);
                    rowParams.getParam("portname").setValue(portName);
                }
            }
            if (null != rowParams.getParam("PTNIF_PORT_ATTR_PORTNAME") && !"".equals(portName = rowParams.getParam("PTNIF_PORT_ATTR_PORTNAME").getValue())) {
                rowParams.getParam("portname").setValue(portId + "(" + portName + ")");
            }
            if (null != rowParams.getParam("ATTR_ETHOVERPTN_MAC_QINQ_TYPE") && !INVALID_ATTRI.equals(temp = rowParams.getParam("ATTR_ETHOVERPTN_MAC_QINQ_TYPE").getValue())) {
                rowParams.getParam("ATTR_ETHOVERPTN_MAC_QINQ_TYPE").setValue(this.insertToValue(temp, REGMENT, 2));
            }
            if (null != rowParams.getParam("ATTR_ETHOVERPTN_MAC_STATUS")) {
                temp = rowParams.getParam("ATTR_ETHOVERPTN_MAC_STATUS").getValue();
                String portStatus = PORT_STATUS_INVALID;
                if ("1".equals(temp)) {
                    Param param_status = rowParams.getParam("ATTR_ETHOVERPTN_MAC_UPDOWNSTATUS");
                    portStatus = null != param_status ? param_status.getValue() : this.getPortUpDownStatus(this.neid, slotId, portId);
                }
                rowParams.getParam("ATTR_ETHOVERPTN_MAC_STATUS").setValue(portStatus);
            }
            this.resetRowErrorPortName(rowParams);
        }
    }

    private String getPortUpDownStatus(int neid, int slotid, int portid) {
        String portstatus = "1";
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        TEBoard board = ne.getBoard(slotid);
        TEBoard phyboard = ne.getPhyBoard(slotid);
        if (phyboard == null || phyboard.getBoardType() != board.getBoardType()) {
            return PORT_STATUS_INVALID;
        }
        Vector alarmList = (Vector)ne.getAlarmList().clone();
        TEAlarm tempAlarm = null;
        int len = alarmList.size();
        for (int i = 0; i < len; ++i) {
            tempAlarm = (TEAlarm)alarmList.get(i);
            if (tempAlarm.getAlarmID() != 235 || tempAlarm.getSlotID() != slotid || tempAlarm.getPort() != portid) continue;
            portstatus = PORT_STATUS_DOWN;
            break;
        }
        return portstatus;
    }

    private String insertToValue(String value, String regment, int intervalcount) {
        StringBuffer temp = new StringBuffer(0);
        for (int i = 0; i < value.length(); i += intervalcount) {
            temp.append(value.substring(i, i + intervalcount)).append(regment);
        }
        if (temp.length() > 1) {
            return temp.toString().substring(0, temp.length() - 1);
        }
        return INVALID_ATTRI;
    }

    private void resetRowErrorPortName(RowParams rowParams) {
        int slotId = -1;
        int portId = -1;
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        int m = rowParams.getRowErrorsCount();
        for (int i = 0; i < m; ++i) {
            RowErrors rowErrors = rowParams.getRowErrors(i);
            if (null == rowErrors.getParam("port")) continue;
            portId = Integer.valueOf(rowErrors.getParam("port").getValue());
            if (null == rowErrors.getParam("slotid")) continue;
            slotId = Integer.valueOf(rowErrors.getParam("slotid").getValue());
            rowErrors.getParam("portname").setValue(cfgMgr.getPortNameForPTN(this.neid, slotId, cfgMgr.getBoardType(this.neid, slotId), portId));
        }
    }

    public ArrayList<Integer> getFilterErrorCodeList() {
        ArrayList<Integer> filterList = new ArrayList<Integer>();
        filterList.add(38737);
        filterList.add(39185);
        return filterList;
    }
}

