/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.erps_u2kv1r8c00;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TEVlanSwitchQueryBean
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private int INVALID_VALUE = 65535;
    private ArrayList<Integer> vlanIDList;
    private ArrayList<Integer> masterVlanIDList;
    private String erpsId;
    private String masterErpsId;

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(44092);
        return list;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
        int size = this.outputData.getBussinessParams().getRowParamsCount();
        this.vlanIDList = new ArrayList();
        this.masterVlanIDList = new ArrayList();
        for (int i = size - 1; i >= 0; --i) {
            RowParams rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowParams.getRowErrorsCount() != 0) continue;
            Param para = rowParams.getParam("erpsid");
            if (null == para || null == para.getValue() || this.INVALID_VALUE == Integer.parseInt(para.getValue())) {
                this.outputData.getBussinessParams().removeRowParams(rowParams);
                continue;
            }
            this.erpsId = para.getValue();
            para = rowParams.getParam("mastererpsid");
            if (null == para || null == para.getValue() || this.INVALID_VALUE == Integer.parseInt(para.getValue())) {
                this.outputData.getBussinessParams().removeRowParams(rowParams);
                continue;
            }
            this.masterErpsId = para.getValue();
            para = rowParams.getParam("vlancount");
            if (null == para || null == para.getValue() || this.INVALID_VALUE == Integer.parseInt(para.getValue())) {
                this.outputData.getBussinessParams().removeRowParams(rowParams);
                continue;
            }
            int vlanidCount = Integer.parseInt(para.getValue());
            if (vlanidCount <= 0) {
                this.outputData.getBussinessParams().removeRowParams(rowParams);
                continue;
            }
            Param vlanpara = rowParams.getParam("vlanidlist");
            if (null == vlanpara || null == vlanpara.getValue() || vlanpara.getValue().equals("")) {
                this.outputData.getBussinessParams().removeRowParams(rowParams);
                continue;
            }
            this.processVlanInfo(vlanpara.getValue(), vlanidCount);
            this.outputData.getBussinessParams().removeRowParams(rowParams);
        }
        if (this.masterVlanIDList.size() != 0) {
            this.processResult();
        }
    }

    private void processVlanInfo(String vlanStr, int vlanidCount) {
        int interval = 8;
        for (int i = 0; i < vlanidCount; ++i) {
            int vlan = Integer.parseInt(vlanStr.substring(i * interval, i * interval + 4), 16);
            this.vlanIDList.add(vlan);
            vlan = Integer.parseInt(vlanStr.substring(i * interval + 4, i * interval + 8), 16);
            this.masterVlanIDList.add(vlan);
        }
    }

    private void processResult() {
        RowParams rowParams = null;
        int size = this.masterVlanIDList.size();
        for (int i = 0; i < size; ++i) {
            rowParams = new RowParams();
            rowParams.addParam("erpsid", this.erpsId);
            rowParams.addParam("mastererpsid", this.masterErpsId);
            rowParams.addParam("virtualVlanID", String.valueOf(this.vlanIDList.get(i)));
            rowParams.addParam("mastervirtualVlanID", String.valueOf(this.masterVlanIDList.get(i)));
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("ptn").append(File.separator).append("res").append(File.separator).append("erps").append(File.separator).append("erps_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        Param[] params = rowparams.getParam();
        String erpsID = Datainterface.getParam((Param[])params, (String)"erpsid").getValue();
        StringBuffer strBuf = new StringBuffer();
        if ("0".equals(erpsID)) {
            strBuf.append(this.subfunc.getSubFuncDes(this.neid));
        } else {
            strBuf.append(this.res.getString("erpsid")).append(": ");
            strBuf.append(erpsID);
        }
        return strBuf.toString();
    }
}

