/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.erps_u2kv1r8c00;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.Param;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TEERPSQueryBean
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private int INVALID_VALUE = 65535;
    private boolean isSupportEth = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.isSupportEth = TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_ETHDOMAIN");
        if (this.isSupportEth) {
            QxMapping qxMapping = new QxMapping();
            qxMapping.setContent("NSCMD_CFG_PTN_ERPS_GET_ETHTYPE");
            int cnt = subFunc.getQxMappingCount();
            qxMapping.setSerialno(cnt + 1);
            subFunc.addQxMapping(qxMapping);
            Param param = new Param();
            param.setType("int");
            param.setName("ethdomain");
            subFunc.getOutput().addParam(param);
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(44102);
        list.add(44092);
        list.add(37898);
        return list;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
        int size = this.outputData.getBussinessParams().getRowParamsCount();
        String rplName = "/";
        for (int i = 0; i < size; ++i) {
            RowParams rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowParams.getRowErrorsCount() != 0) continue;
            int eSlotid = Integer.parseInt(rowParams.getParam("eastslotid").getValue());
            if (eSlotid == this.INVALID_VALUE) {
                rowParams.getParam("eastslotid").setValue("");
                rowParams.getParam("eastPortId").setValue("");
                rowParams.addParam("eastBoardName", "-");
            } else {
                rowParams.addParam("eastBoardName", TEConfigurationDataMgr.getInstance().getBoardName(neid, eSlotid));
                rowParams.addParam("eastsubrack", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)eSlotid));
            }
            int wSlotid = Integer.parseInt(rowParams.getParam("westslotid").getValue());
            if (wSlotid == this.INVALID_VALUE) {
                rowParams.getParam("westslotid").setValue("");
                rowParams.getParam("westPortId").setValue("");
                rowParams.addParam("westBoardName", "-");
            } else {
                rowParams.addParam("westBoardName", TEConfigurationDataMgr.getInstance().getBoardName(neid, wSlotid));
                rowParams.addParam("westsubrack", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)wSlotid));
            }
            int rSlotid = Integer.parseInt(rowParams.getParam("rplslotid").getValue());
            if (rSlotid == this.INVALID_VALUE) {
                rowParams.getParam("rplslotid").setValue("");
                rowParams.getParam("rplPortId").setValue("-");
                rowParams.addParam("rplBoardName", "");
            } else {
                rplName = TEConfigurationDataMgr.getInstance().getBoardName(neid, rSlotid);
                rowParams.addParam("rplsubrack", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)rSlotid));
                rowParams.addParam("rplBoardName", rplName);
            }
            com.huawei.nglct.common.datainterface.Param mastererpsidParam = rowParams.getParam("mastererpsid");
            if (mastererpsidParam != null && mastererpsidParam.getValue() != null && !mastererpsidParam.getValue().equals("")) {
                int mastererpsid = Integer.parseInt(mastererpsidParam.getValue());
                if (mastererpsid == this.INVALID_VALUE) {
                    rowParams.getParam("mastererpsid").setValue("/");
                }
            } else {
                rowParams.addParam(new com.huawei.nglct.common.datainterface.Param("mastererpsid", "-"));
            }
            com.huawei.nglct.common.datainterface.Param vlanidCountParam = rowParams.getParam("vlanidcount");
            if (vlanidCountParam != null && vlanidCountParam.getValue() != null && !vlanidCountParam.getValue().equals("")) {
                int vlanidCount = Integer.parseInt(vlanidCountParam.getValue());
                if (vlanidCount <= 0) {
                    rowParams.addParam(new com.huawei.nglct.common.datainterface.Param("virtualVlanID", ""));
                } else {
                    int length = 4;
                    String vlanIdListStr = this.parseVlanList(rowParams.getParam("vlanidlist").getValue(), vlanidCount, length);
                    rowParams.addParam(new com.huawei.nglct.common.datainterface.Param("virtualVlanID", vlanIdListStr));
                }
            } else {
                rowParams.addParam(new com.huawei.nglct.common.datainterface.Param("virtualVlanID", ""));
            }
            com.huawei.nglct.common.datainterface.Param chnStatusParam = rowParams.getParam("chnstatus");
            if (chnStatusParam != null && chnStatusParam.getValue() != null) continue;
            rowParams.addParam(new com.huawei.nglct.common.datainterface.Param("chnstatus", "-"));
        }
    }

    private String parseVlanList(String valueStr, int tagnum, int interval) {
        if (valueStr == null || valueStr.length() == 0) {
            return "";
        }
        ArrayList<Integer> strList = new ArrayList<Integer>();
        int index = 0;
        for (int i = 0; i < tagnum; ++i) {
            int tmp = Integer.parseInt(valueStr.substring(index, index + interval), 16);
            if (tmp != 0) {
                strList.add(tmp);
            }
            index += interval;
        }
        ArrayList allList = new ArrayList();
        ArrayList<Integer> dstlist = new ArrayList<Integer>();
        int size = strList.size();
        for (int i = 0; i < size; ++i) {
            int pathNumCounter = (Integer)strList.get(i);
            if (dstlist.isEmpty() || (Integer)dstlist.get(dstlist.size() - 1) + 1 == pathNumCounter) {
                dstlist.add(pathNumCounter);
            } else {
                allList.add(dstlist);
                dstlist = new ArrayList<Integer>();
                dstlist.add(pathNumCounter);
            }
            if (i != size - 1) continue;
            allList.add(dstlist);
        }
        StringBuilder strBuilder = new StringBuilder();
        int size2 = allList.size();
        for (int i = 0; i < size2; ++i) {
            dstlist = (ArrayList<Integer>)allList.get(i);
            if (dstlist.size() == 1) {
                strBuilder.append(",");
                strBuilder.append(dstlist.get(0));
                continue;
            }
            strBuilder.append(",");
            strBuilder.append(dstlist.get(0));
            strBuilder.append("-");
            strBuilder.append(dstlist.get(dstlist.size() - 1));
        }
        return strBuilder.toString().substring(1, strBuilder.toString().length());
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("ptn").append(File.separator).append("res").append(File.separator).append("erps").append(File.separator).append("erps_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        com.huawei.nglct.common.datainterface.Param[] params = rowparams.getParam();
        String erpsID = Datainterface.getParam((com.huawei.nglct.common.datainterface.Param[])params, (String)"erpsid").getValue();
        StringBuffer strBuf = new StringBuffer();
        if ("0".equals(erpsID)) {
            strBuf.append(this.subfunc.getSubFuncDes(this.neid));
        } else {
            strBuf.append(this.res.getString("erpsid")).append(": ");
            strBuf.append(erpsID);
        }
        return strBuf.toString();
    }
}

