/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.erps_u2kv1r8c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.io.File;
import java.util.ArrayList;

public class TEERPSModifyBean
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private static final int MAC_ADDRESS_LEN = 12;
    private static final int MAX_VLANS = 255;
    private int vlanid_num = 0;
    private boolean isSupportEth = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.isSupportEth = TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_ETHDOMAIN");
            if (this.isSupportEth) {
                QxMapping qxMapping = new QxMapping();
                qxMapping.setContent("NSCMD_CFG_PTN_ERPS_SET_ETHTYPE");
                int cnt = subFunc.getQxMappingCount();
                qxMapping.setSerialno(cnt + 1);
                subFunc.addQxMapping(qxMapping);
            }
            this.modifyInputParams();
            if (this.vlanid_num >= 255) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090615219));
                return this.outputData;
            }
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1107427165));
                return this.outputData;
            }
            if (this.operationList.isEmpty()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            this.modifyOutputParams();
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    protected void modifyInputParams() {
        RowParams[] rows = this.inputData.getBussinessParams().getRowParams();
        RowParams row = null;
        String tempIDStr = "";
        for (int i = 0; i < rows.length; ++i) {
            Param flagParam;
            row = rows[i];
            Param ethParam = row.getParam("ethdomain");
            String ethdomainStr = "/";
            int[] setValue = new int[]{34825, 35074};
            this.isSupportEth = TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_ETHDOMAIN");
            if (ethParam != null && this.isSupportEth) {
                ethdomainStr = ethParam.getValue();
                if (ethdomainStr.compareTo("0x8809") == 0) {
                    ethParam.setValue(String.valueOf(setValue[0]));
                } else if (ethdomainStr.compareTo("0x8902") == 0) {
                    ethParam.setValue(String.valueOf(setValue[1]));
                }
            }
            if ((flagParam = row.getParam("cmdFlag")) == null || row.getParam("cmdFlag").getValue() == null || row.getParam("cmdFlag").getValue().isEmpty()) continue;
            ArrayList vlans = new ArrayList(0);
            TEStringUtils.strToNumList((String)row.getParam("vlanidlist").getValue(), vlans);
            Integer[] vlanIDArray = new Integer[vlans.size()];
            vlans.toArray(vlanIDArray);
            this.vlanid_num = vlanIDArray.length;
            if (this.vlanid_num >= 1) {
                StringBuffer vlanIdbuffer = new StringBuffer();
                if (this.vlanid_num > 255) continue;
                for (int j = 0; j < vlanIDArray.length; ++j) {
                    tempIDStr = Integer.toHexString(vlanIDArray[j]);
                    vlanIdbuffer.append(TEStringUtils.convertStringToProtolType((String)tempIDStr, (int)4));
                }
                row.getParam("vlanidcount").setValue(String.valueOf(this.vlanid_num));
                row.getParam("vlanidlist").setValue(vlanIdbuffer.toString());
                continue;
            }
            row.getParam("vlanidcount").setValue("0");
            row.getParam("vlanidlist").setValue("");
        }
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer(30);
        filePath.append("ip").append(File.separator).append("ptn").append(File.separator).append("res").append(File.separator).append("erps").append(File.separator).append("erps_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        Param[] params = rowparams.getParam();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(this.res.getString("erpsid")).append(": ");
        String erpsID = Datainterface.getParam((Param[])params, (String)"erpsid").getValue();
        strBuf.append(erpsID);
        Param param = Datainterface.getParam((Param[])params, (String)"ctrlVlan");
        if (param != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("ctrlVlan")).append(": ");
            strBuf.append(param.getValue());
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"desMacAddr")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("desMacAddr")).append(": ");
            strBuf.append(this.convertMacToIpAddr(param.getValue()));
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"chnstatus")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("chnstatus")).append(": ");
            strBuf.append(this.res.getString("chnstatus_" + param.getValue()));
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"vlanidlist")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("vlanidlist")).append(": ");
            String vlanIdListStr = this.parseVlanList(rowparams.getParam("vlanidlist").getValue(), Integer.parseInt(rowparams.getParam("vlanidcount").getValue()), 4);
            strBuf.append(vlanIdListStr);
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"mastererpsid")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("mastererpsid")).append(": ");
            strBuf.append(param.getValue());
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"holdoffTime")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("holdoffTime")).append(": ");
            strBuf.append(param.getValue());
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"wtrTime")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("wtrTime")).append(": ");
            strBuf.append(param.getValue());
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"guardTime")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("guardTime")).append(": ");
            strBuf.append(param.getValue());
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"entityLevel")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("entityLevel")).append(": ");
            strBuf.append(param.getValue());
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"sendInterval")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("sendInterval")).append(": ");
            strBuf.append(param.getValue());
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"resumeMode")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("resumeMode")).append(": ");
            strBuf.append(this.res.getString("resumeMode_" + param.getValue()));
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"compatibleVersion")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("compatibleVersion")).append(": ");
            strBuf.append(this.res.getString("ver_" + param.getValue()));
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"W32NE_ATTR_ERPS_LOOPDETECT")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("W32NE_ATTR_ERPS_LOOPDETECT")).append(": ");
            strBuf.append(this.res.getString("loopdetect_" + param.getValue()));
        }
        if ((param = Datainterface.getParam((Param[])params, (String)"ethdomain")) != null && param.getValue() != null) {
            strBuf.append(' ');
            strBuf.append(this.res.getString("ethdomain")).append(": ");
            strBuf.append(this.res.getString("ethdomain_" + param.getValue()));
        }
        return strBuf.toString();
    }

    private String parseVlanList(String valueStr, int tagnum, int interval) {
        if (valueStr == null || valueStr.length() == 0) {
            return "";
        }
        ArrayList<Integer> strList = new ArrayList<Integer>();
        int index = 0;
        for (int i = 0; i < tagnum; ++i) {
            int tmp = Integer.parseInt(valueStr.substring(index, index + interval), 16);
            if (tmp != 0) {
                strList.add(tmp);
            }
            index += interval;
        }
        ArrayList allList = new ArrayList();
        ArrayList<Integer> dstlist = new ArrayList<Integer>();
        int size = strList.size();
        for (int i = 0; i < size; ++i) {
            int pathNum = (Integer)strList.get(i);
            if (dstlist.isEmpty() || (Integer)dstlist.get(dstlist.size() - 1) + 1 == pathNum) {
                dstlist.add(pathNum);
            } else {
                allList.add(dstlist);
                dstlist = new ArrayList<Integer>();
                dstlist.add(pathNum);
            }
            if (i != size - 1) continue;
            allList.add(dstlist);
        }
        StringBuilder strBuilder = new StringBuilder();
        int size2 = allList.size();
        for (int i = 0; i < size2; ++i) {
            dstlist = (ArrayList<Integer>)allList.get(i);
            if (dstlist.size() == 1) {
                strBuilder.append(",");
                strBuilder.append(dstlist.get(0));
                continue;
            }
            strBuilder.append(",");
            strBuilder.append(dstlist.get(0));
            strBuilder.append("-");
            strBuilder.append(dstlist.get(dstlist.size() - 1));
        }
        return strBuilder.toString().substring(1, strBuilder.toString().length());
    }

    public String convertMacToIpAddr(String macAddrStr) {
        StringBuilder sb = new StringBuilder();
        int len = 12;
        for (int i = 0; i < len; ++i) {
            sb.append(macAddrStr.charAt(i));
            if ((i + 1) % 2 != 0 || i == len - 1) continue;
            sb.append("-");
        }
        return sb.toString();
    }
}

