/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.erps.beanplugin.otn;

import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.event.Event;
import com.huawei.nglct.core.reliableevent.TEReliableEventMgr;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsUtil;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnAddERPSInsRpt;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnChgERPSInsRpt;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnDelERPSInsRpt;
import com.huawei.nglct.po.embeddednemgrmo.TEETHERPSMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEETHERPSBeanPluginUtil {
    public static final int NSCMD_ETHN_ERPS_CRT_ENTITY_EX = 37896;
    public static final int NSCMD_ETHN_ERPS_DEL_ENTITY_EX = 37897;
    public static final int NSCMD_ETHN_ERPS_SET_CTRLVLAN_EX = 37898;
    public static final int NSCMD_ETHN_ERPS_SET_HOLDOFFTIME_EX = 37900;
    public static final int NSCMD_ETHN_ERPS_SET_WTRTIME_EX = 37902;
    public static final int NSCMD_ETHN_ERPS_SET_GUARDTIME_EX = 37904;
    public static final int NSCMD_ETHN_ERPS_SET_RAPSINFO_EX = 37906;
    public static final int NSCMD_ETHN_ERPS_GET_HOLDOFFTIME_EX = 37901;
    public static final int NSCMD_ETHN_ERPS_GET_WTRTIME_EX = 37903;
    public static final int NSCMD_ETHN_ERPS_GET_GUARDTIME_EX = 37905;
    public static final int NSCMD_ETHN_ERPS_GET_RAPSINFO_EX = 37907;
    public static final int NSCMD_ETHN_ERPS_GET_ENTITYSTATE_EX = 37908;
    public static final int NSCMD_ETHN_ERPS_GET_PORTSTATE_WBID = 38051;
    public static final int CREATE_ERPS_CMD = 0xB00B03;
    public static final int DELETE_ERPS_CMD = 0xB00B04;
    public static final int CHANGE_ERPS_CMD = 0xB00B05;
    public static final int CREATEFLAG = 0;
    public static final int DELETEFLAG = 1;
    public static final int CHANGEFLAG = 2;
    private static final Logger normalLogger = TELogFactory.getNormalLogger();
    public static final int FIRSTELEMENT_INDEX = 0;
    public static final int GET_DATA_FROM_NE = 1;

    public static int getIntValue(String strValue) {
        if (strValue == null || strValue.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(strValue);
    }

    public static String getStrValue(String strValue) {
        if (strValue == null) {
            return "";
        }
        return strValue;
    }

    public static void createNEERpsToDB(int neID, TEETHERPSMOPO erpsMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TENEERPSBeanPluginUtil.createNEERpsToDB";
        normalLogger.info("TENEERPSBeanPluginUtil.createNEERpsToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID, erpsMO.getSlotID()}, (Object)erpsMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID, erpsMO.getSlotID()}, (Object)erpsMO);
        }
        catch (Exception e) {
            TEETHERPSBeanPluginUtil.logExceptionErrorOnCreate(neID, e);
            TEETHERPSBeanPluginUtil.addOperFail(neID, errRet, 1092743443);
            TEETHERPSBeanPluginUtil.logFuncEnd("TENEERPSBeanPluginUtil.createNEERpsToDB");
            return;
        }
        if (null == dbResult) {
            TEETHERPSBeanPluginUtil.logNullError(neID);
            TEETHERPSBeanPluginUtil.addOperFail(neID, errRet, 1092743443);
            TEETHERPSBeanPluginUtil.logFuncEnd("TENEERPSBeanPluginUtil.createNEERpsToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEETHERPSBeanPluginUtil.logRetCodeError(neID, retCode);
            TEETHERPSBeanPluginUtil.addOperFail(neID, errRet, retCode);
        }
        TEETHERPSBeanPluginUtil.logFuncEnd("TENEERPSBeanPluginUtil.createNEERpsToDB");
    }

    public static void updateNEERpsToDB(int neID, List<TEETHERPSMOPO> erpsMOList, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TENEERPSBeanPluginUtil.createNEERpsToDB";
        normalLogger.info("TENEERPSBeanPluginUtil.createNEERpsToDB: begin.");
        int size = erpsMOList.size();
        for (int i = 0; i < size; ++i) {
            TEETHERPSMOPO erpsMO = erpsMOList.get(i);
            TEDaoOperationResult dbResult = null;
            try {
                TENE ne = TENEListMgr.getInstance().getNE(neID);
                dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID, erpsMO.getSlotID()}, (Object)erpsMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID, erpsMO.getSlotID()}, (Object)erpsMO);
            }
            catch (Exception e) {
                TEETHERPSBeanPluginUtil.logExceptionErrorOnCreate(neID, e);
                TEETHERPSBeanPluginUtil.addOperFail(neID, errRet, 1092743443);
                TEETHERPSBeanPluginUtil.logFuncEnd("TENEERPSBeanPluginUtil.createNEERpsToDB");
                continue;
            }
            if (null == dbResult) {
                TEETHERPSBeanPluginUtil.logNullError(neID);
                TEETHERPSBeanPluginUtil.addOperFail(neID, errRet, 1092743443);
                TEETHERPSBeanPluginUtil.logFuncEnd("TENEERPSBeanPluginUtil.createNEERpsToDB");
                continue;
            }
            int retCode = dbResult.getResult();
            if (0 != retCode) {
                TEETHERPSBeanPluginUtil.logRetCodeError(neID, retCode);
                TEETHERPSBeanPluginUtil.addOperFail(neID, errRet, retCode);
            }
            TEETHERPSBeanPluginUtil.logFuncEnd("TENEERPSBeanPluginUtil.createNEERpsToDB");
        }
    }

    public static TEDaoOperationResult findNEERpsFromDB(int neID, int slotID) {
        String FUNC_NAME = "TENEERPSBeanPluginUtil.findNEERpsFromDB";
        normalLogger.info("TENEERPSBeanPluginUtil.findNEERpsFromDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID, slotID}, TEETHERPSMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID, slotID}, TEETHERPSMOPO.class);
        }
        catch (Exception e) {
            TEETHERPSBeanPluginUtil.logExceptionErrorOnCreate(neID, e);
        }
        TEETHERPSBeanPluginUtil.logFuncEnd("TENEERPSBeanPluginUtil.findNEERpsFromDB");
        return dbResult;
    }

    public static int getSlotIDFromOper(List<Operation> operationList) {
        for (Operation oper : operationList) {
            if (oper.getInput().getPart("slotid") == null) continue;
            return Integer.parseInt(oper.getInput().getPartValue("slotid"));
        }
        return -1;
    }

    public static TEDaoOperationResult deleteNEERpsFromDB(int neID, TEETHERPSMOPO mopo) {
        String FUNC_NAME = "TENEERPSBeanPluginUtil.findNEERpsFromDB";
        normalLogger.info("TENEERPSBeanPluginUtil.findNEERpsFromDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID, mopo.getSlotID()}, (Object)mopo) : TECommonDaoService.delete_NonLock((int[])new int[]{neID, mopo.getSlotID()}, (Object)mopo);
        }
        catch (Exception e) {
            TEETHERPSBeanPluginUtil.logExceptionErrorOnCreate(neID, e);
        }
        TEETHERPSBeanPluginUtil.logFuncEnd("TENEERPSBeanPluginUtil.findNEERpsFromDB");
        return dbResult;
    }

    public static void addOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(new int[]{neID});
        errInfo.setObjName(neName);
        errInfo.setErrorCode(retCode);
        rspErrRet.addErrInfo(errInfo);
    }

    private static void logNullError(int neID) {
        normalLogger.error("delete clock to db device fail! neID->" + neID);
    }

    private static void logFuncEnd(String funcName) {
        normalLogger.info(funcName + ": end.");
    }

    private static void logRetCodeError(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        normalLogger.error("create  fail! neID->" + neID, (Throwable)e);
    }

    public static SubFunc getSubFunc(int neid, int sfid) {
        SubFunc subFunc;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
            if (null == subFunc && null == (subFunc = TECreateObjectFactory.getSubFunc((int)sfid))) {
                normalLogger.info("Don't found subfunction(sfid = " + sfid + ") description in Functions description file\u00a3\u00a1");
            }
        }
        catch (Exception e) {
            normalLogger.error("getSubFunc fail", (Throwable)e);
            return null;
        }
        return subFunc;
    }

    public static int getErrorCode(Operation opertaioin) {
        int errCode = -1;
        try {
            errCode = Integer.parseInt(opertaioin.getOutput(0).getFault(0).getCode());
        }
        catch (Exception e) {
            errCode = -1;
        }
        return errCode;
    }

    public static int getParamIntValue(Param param) {
        if (param == null || param.getValue() == null || param.getValue().isEmpty()) {
            return -1;
        }
        return Integer.parseInt(param.getValue());
    }

    public static HashMap<Integer, List<Operation>> findERPSOperation(List<Operation> operationList) {
        HashMap<Integer, List<Operation>> erpsOprMap = new HashMap<Integer, List<Operation>>();
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation opertaioin = operationList.get(i);
            Input input = opertaioin.getInput();
            int errCode = TEETHERPSBeanPluginUtil.getErrorCode(opertaioin);
            if (errCode != 0) continue;
            int erpsID = TEETHERPSBeanPluginUtil.getIntValue(input.getPartValue("erpsid"));
            if (erpsOprMap.get(erpsID) == null) {
                ArrayList<Operation> oprList = new ArrayList<Operation>();
                erpsOprMap.put(erpsID, oprList);
                oprList.add(opertaioin);
                continue;
            }
            erpsOprMap.get(erpsID).add(opertaioin);
        }
        return erpsOprMap;
    }

    public static boolean isBoardSupportERPS(int boardType) {
        ArrayList<Integer> ethBoardTypeList = new ArrayList<Integer>();
        ethBoardTypeList.add(2217);
        ethBoardTypeList.add(2439);
        ethBoardTypeList.add(1210);
        ethBoardTypeList.add(2423);
        ethBoardTypeList.add(2109);
        ethBoardTypeList.add(2110);
        ethBoardTypeList.add(1557);
        ethBoardTypeList.add(1067);
        ethBoardTypeList.add(2272);
        ethBoardTypeList.add(3005);
        ethBoardTypeList.add(2292);
        return ethBoardTypeList.contains(boardType);
    }

    public static int uploadERPSData(int neID, boolean uploadFlag) {
        String firstFlag = "Upload";
        if (!uploadFlag) {
            firstFlag = "Sync";
        }
        normalLogger.info(firstFlag + " ETH ERPS begin.");
        if (!TEE2EErpsUtil.isSupportETHERPS(neID)) {
            return 0;
        }
        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != retCode) {
            String tipStr = firstFlag + " ETH ERPS fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            normalLogger.error(tipStr);
            normalLogger.info(firstFlag + " ETH ERPS end.");
            return retCode;
        }
        List boardList = TEConfigurationDataMgr.getInstance().getBoardList(neID);
        int boardType = -1;
        boolean isAllFail = true;
        boolean isAllSuccess = true;
        TEErrInfoReturn errInfoReturn = new TEErrInfoReturn();
        for (TEBoard board : boardList) {
            boardType = board.getBoardType();
            if (!TEETHERPSBeanPluginUtil.isBoardSupportERPS(boardType)) continue;
            int slotid = board.getSlotID();
            Datainterface inputData = TEETHERPSBeanPluginUtil.createInputData(neID, slotid);
            Datainterface outputData = TEETHERPSBeanPluginUtil.queryALLNEErpsData(neID, inputData, 2172665);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (0 != errorCode) {
                String tipStr = "Query ETH ERPS from ne fail! ";
                tipStr = tipStr + String.format("[neID:%d, errCode:%d]", neID, errorCode);
                normalLogger.error(tipStr);
                TEErrInfo errInfo = new TEErrInfo();
                errInfo.setObjID(new int[]{neID, board.getSlotID()});
                errInfo.setErrorCode(errorCode);
                errInfoReturn.addErrInfo(errInfo);
                isAllSuccess = false;
                continue;
            }
            isAllFail = false;
        }
        if (isAllSuccess) {
            errInfoReturn.setResult(0);
        } else if (isAllFail) {
            errInfoReturn.setResult(1090650122);
        } else {
            errInfoReturn.setResult(1090650126);
        }
        normalLogger.info(firstFlag + " Query ETH ERPS from ne end.");
        return 0;
    }

    private static Datainterface createInputData(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams row = new RowParams();
        row.addParam("neid", String.valueOf(neID));
        row.addParam("erpsid", "0");
        row.addParam("isLogFlag", "0");
        bussiness.addRowParams(row);
        return inputData;
    }

    private static Datainterface createInputData(int neID, int slotID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams row = new RowParams();
        row.addParam("neid", String.valueOf(neID));
        row.addParam("slotid", String.valueOf(slotID));
        row.addParam("erpsid", "0");
        row.addParam("isLogFlag", "0");
        bussiness.addRowParams(row);
        return inputData;
    }

    private static Datainterface queryALLNEErpsData(int neID, Datainterface inputData, int sfid) {
        Datainterface allData = null;
        try {
            SubFunc subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
            if (null == subFunc && null == (subFunc = TECreateObjectFactory.getSubFunc((int)sfid))) {
                normalLogger.info("Don't found subfunction(sfid = " + sfid + ") description in Functions description file\u00a3\u00a1");
                return null;
            }
            Datainterface memeryData = new Datainterface();
            allData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess((int)neID, (SubFunc)subFunc, (Datainterface)inputData, (Datainterface)memeryData, null, null, (int)1);
        }
        catch (Exception e) {
            normalLogger.error("The ETH ERPS from weblct exception " + neID, (Throwable)e);
            allData = new Datainterface();
            allData.setBussinessParams(new BussinessParams());
            allData.setErrorMessage(new ErrorMessage());
            allData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)1090646019));
        }
        return allData;
    }

    public static void sendRpt(List erpsList4Rpt, byte[] poTaskFlag, int rptCmd) {
        if (null == erpsList4Rpt || erpsList4Rpt.isEmpty()) {
            return;
        }
        QAsnAddERPSInsRpt rptObj = null;
        if (0xB00B03 == rptCmd) {
            QAsnAddERPSInsRpt addRpt = new QAsnAddERPSInsRpt();
            addRpt.erpsInfoList.addAll((Collection)erpsList4Rpt);
            addRpt.poTaskFlag = poTaskFlag;
            rptObj = addRpt;
        } else if (0xB00B04 == rptCmd) {
            QAsnDelERPSInsRpt delRpt = new QAsnDelERPSInsRpt();
            delRpt.erpsIndexList.addAll((Collection)erpsList4Rpt);
            delRpt.poTaskFlag = poTaskFlag;
            rptObj = delRpt;
        } else {
            QAsnChgERPSInsRpt chgRpt = new QAsnChgERPSInsRpt();
            chgRpt.erpsInfoList.addAll((Collection)erpsList4Rpt);
            chgRpt.poTaskFlag = poTaskFlag;
            rptObj = chgRpt;
        }
        Event event = new Event(rptCmd, (Object)rptObj);
        FStruct rpt = (FStruct)event.getEventContext();
        TEReliableEventMgr.getInstance().send(event.getEventID(), rpt);
        TELogFactory.getE2ELogger().info("Reliable event Handled!");
        TELogFactory.getE2ELogger().info(TEAsn1Util.getAsn1String((Object)rpt));
    }
}

