/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.erps.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPlugin;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsUtil;
import com.huawei.nglct.nemgr.ip.ptn.erps.beanplugin.TENEERPSBeanPluginUtil;
import com.huawei.nglct.nemgr.ip.ptn.erps.beanplugin.otn.TEETHERPSBeanPluginUtil;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnERPSIndex;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnERPSIndexList;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnERPSInfo;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnERPSInfoList;
import com.huawei.nglct.po.embeddednemgrmo.ptn.TEPTNERPSMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEERPSQueryBeanPlugin
extends TEBeanPlugin {
    public static final int OPER_TYPE_UPLOAD = 3;
    private HashMap<Integer, TEPTNERPSMOPO> erpsMOMap = new HashMap();

    public TEErrInfoReturn doAfterSendMessage(int neid, SubFunc subFunc, List<Operation> operationList) {
        TENE tENE;
        TEPTNERPSMOPO tmpMO;
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        if (operationList.isEmpty()) {
            errRet.setResult(0);
            return errRet;
        }
        this.initERPSMap(operationList);
        this.queryErpsDetail(neid);
        QAsnERPSInfoList erpsCreateList = new QAsnERPSInfoList();
        QAsnERPSInfoList erpsChgList = new QAsnERPSInfoList();
        QAsnERPSIndexList erpsDelList = new QAsnERPSIndexList();
        HashMap<Integer, TEPTNERPSMOPO> dataMOMap = new HashMap<Integer, TEPTNERPSMOPO>();
        TEDaoOperationResult dbResult = TENEERPSBeanPluginUtil.findNEERpsFromDB(neid);
        if (dbResult != null && dbResult.getResult() == 0) {
            List dbDataList = dbResult.getData();
            int n = dbDataList.size();
            for (int i = 0; i < n; ++i) {
                TEPTNERPSMOPO dataMO = (TEPTNERPSMOPO)dbDataList.get(i);
                dataMOMap.put(dataMO.getErpsID(), dataMO);
            }
        }
        ArrayList<TEPTNERPSMOPO> needUpdateData = new ArrayList<TEPTNERPSMOPO>();
        for (Map.Entry<Integer, TEPTNERPSMOPO> entry : this.erpsMOMap.entrySet()) {
            QAsnERPSInfo erpsInfo;
            int erpsID = entry.getKey();
            if (erpsID <= 0) continue;
            TEPTNERPSMOPO erpsMo = entry.getValue();
            tmpMO = (TEPTNERPSMOPO)dataMOMap.get(erpsID);
            if (tmpMO != null) {
                needUpdateData.add(erpsMo);
                if (erpsMo == null || !this.isNeedToNotice(erpsMo, tmpMO)) continue;
                erpsInfo = TEE2EErpsUtil.convertPTNERPSMopotoQAsnErpsInfo(erpsMo, neid);
                erpsChgList.add((Object)erpsInfo);
                continue;
            }
            TENEERPSBeanPluginUtil.createNEERpsToDB(neid, erpsMo, errRet);
            erpsInfo = TEE2EErpsUtil.convertPTNERPSMopotoQAsnErpsInfo(erpsMo, neid);
            if (erpsMo.getErpsID() == -1) continue;
            erpsCreateList.add((Object)erpsInfo);
        }
        for (Map.Entry<Integer, Object> entry : dataMOMap.entrySet()) {
            int erpsID = entry.getKey();
            if (erpsID <= 0) continue;
            TEPTNERPSMOPO erps_Mo = (TEPTNERPSMOPO)entry.getValue();
            tmpMO = this.erpsMOMap.get(erpsID);
            if (tmpMO != null) continue;
            TENEERPSBeanPluginUtil.deleteNEERpsFromDB(neid, erps_Mo);
            QAsnERPSIndex erpsIndex = new QAsnERPSIndex();
            erpsIndex.neID = neid;
            erpsIndex.erpsID = erps_Mo.getErpsID();
            erpsIndex.slotID = 0;
            erpsIndex.erpsKey = TEE2EErpsUtil.constructERPSUniResID(neid, 0, erpsIndex.erpsID);
            erpsDelList.add((Object)erpsIndex);
        }
        if (!needUpdateData.isEmpty()) {
            TENEERPSBeanPluginUtil.updateNEERpsToDB(neid, needUpdateData, errRet);
        }
        if ((tENE = TENEListMgr.getInstance().getNE(neid)) != null && tENE.getNeImplInterface() != null && 3 == tENE.getNeImplInterface().getNeDatacfgStatus()) {
            return errRet;
        }
        if (erpsCreateList.size() > 0) {
            TELogFactory.getE2ELogger().info("query send to E2E: create ERPS---");
            TEETHERPSBeanPluginUtil.sendRpt((List)erpsCreateList, "create".getBytes(), 0xB00B03);
        }
        if (erpsChgList.size() > 0) {
            TELogFactory.getE2ELogger().info("query send to E2E: chg ERPS---");
            TEETHERPSBeanPluginUtil.sendRpt((List)erpsChgList, "chg".getBytes(), 0xB00B05);
        }
        if (erpsDelList.size() > 0) {
            TELogFactory.getE2ELogger().info("query send to E2E: del ERPS---");
            TEETHERPSBeanPluginUtil.sendRpt((List)erpsDelList, "del".getBytes(), 0xB00B04);
        }
        return errRet;
    }

    private void initERPSMap(List<Operation> operationList) {
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation operation = operationList.get(i);
            int len = operation.getOutputCount();
            for (int j = 0; j < len; ++j) {
                Output output = operation.getOutput(j);
                int erpsID = TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("erpsid"));
                TEPTNERPSMOPO erpsMo = this.erpsMOMap.get(erpsID);
                if (erpsMo == null) {
                    erpsMo = new TEPTNERPSMOPO();
                    erpsMo.setErpsID(erpsID);
                    erpsMo.setCompatibleVersion(1);
                    erpsMo.setRvtmode(-1);
                    erpsMo.setLoopDetect(-1);
                    this.erpsMOMap.put(erpsID, erpsMo);
                }
                if (operation.getCmdid() == 36141) {
                    erpsMo.setEastBid(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("eastslotid")));
                    erpsMo.setEastSubBd(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("eastsubslotid")));
                    erpsMo.setEastPortID(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("eastPortId")));
                    erpsMo.setWestBid(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("westslotid")));
                    erpsMo.setWestSubBd(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("westsubslotid")));
                    erpsMo.setWestPortID(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("westPortId")));
                    erpsMo.setRplBid(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("rplslotid")));
                    erpsMo.setRplSubBd(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("rplsubslotid")));
                    erpsMo.setRplPortID(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("rplPortId")));
                    erpsMo.setIsRplOwner(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("isRPLOwnerFlag")));
                    erpsMo.setCtrlVlan(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("ctrlVlan")));
                    erpsMo.setDesNodeMacAddr(TENEERPSBeanPluginUtil.getStrValue(output.getPartValue("desMacAddr")));
                    erpsMo.setCurNodeMacAddr(TENEERPSBeanPluginUtil.getStrValue(output.getPartValue("curNodeMacAddr")));
                    continue;
                }
                if (operation.getCmdid() == 39591) {
                    erpsMo.setCompatibleVersion(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("compatibleVersion")));
                    if (erpsMo.getCompatibleVersion() != 1) continue;
                    erpsMo.setVirChannelSatus(-1);
                    continue;
                }
                if (operation.getCmdid() == 39589) {
                    erpsMo.setRvtmode(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("resumeMode")));
                    continue;
                }
                if (operation.getCmdid() == 39772) {
                    erpsMo.setMajorRingID(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("mastererpsid")));
                    continue;
                }
                if (operation.getCmdid() == 39768) {
                    erpsMo.setVirChannelSatus(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("chnstatus")));
                    continue;
                }
                if (operation.getCmdid() == 39770) {
                    erpsMo.setVirChannelVlans(TENEERPSBeanPluginUtil.parseVlanList(output.getPartValue("vlanidlist"), TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("vlanidcount")), 4));
                    continue;
                }
                if (operation.getCmdid() == 38127) {
                    erpsMo.setEthType(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("ethdomain")));
                    continue;
                }
                if (operation.getCmdid() != 39832) continue;
                erpsMo.setLoopDetect(TENEERPSBeanPluginUtil.getIntValue(output.getPartValue("W32NE_ATTR_ERPS_LOOPDETECT")));
            }
        }
    }

    private void queryErpsDetail(int neid) {
        for (Map.Entry<Integer, TEPTNERPSMOPO> entry : this.erpsMOMap.entrySet()) {
            int erpsID = entry.getKey();
            TEPTNERPSMOPO erpsMo = entry.getValue();
            Datainterface inputData = this.createInputData(neid, erpsID);
            SubFunc subFunc = TENEERPSBeanPluginUtil.getSubFunc(neid, 2179957);
            if (subFunc == null) continue;
            try {
                Datainterface outputData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess((int)neid, (SubFunc)subFunc, (Datainterface)inputData, null, null, null, (int)1);
                this.addErpsDetailToMo(outputData, erpsMo);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("query ERPS Detail fail! erpsID = " + erpsID, (Throwable)e);
            }
        }
    }

    private Datainterface createInputData(int neid, int erpsID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams row = new RowParams();
        row.addParam("neid", String.valueOf(neid));
        row.addParam("erpsid", String.valueOf(erpsID));
        row.addParam("isLogFlag", "0");
        bussiness.addRowParams(row);
        return inputData;
    }

    private void addErpsDetailToMo(Datainterface outputData, TEPTNERPSMOPO erpsMo) {
        int recordCount = outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < recordCount; ++i) {
            RowParams rowParams = outputData.getBussinessParams().getRowParams(i);
            int erpsID = TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("erpsid"));
            if (erpsID != erpsMo.getErpsID()) continue;
            erpsMo.setHoldOffTime(TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("holdoffTime")));
            erpsMo.setWtrTime(TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("wtrTime")));
            erpsMo.setGuardTime(TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("guardTime")));
            erpsMo.setEntityLevel(TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("entityLevel")));
            erpsMo.setRapsInterval(TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("sendInterval")));
            erpsMo.setDNFStatus(TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("erpsDNF")));
            erpsMo.setStateMachineStatus(TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("erpsFSMstate")));
            erpsMo.setWastPortStatus(TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("wportstate")));
            erpsMo.setEastPortStatus(TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("eportstate")));
            erpsMo.setLastSwitchReq(TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("lastReqERPS")));
            erpsMo.setRBStatus(TENEERPSBeanPluginUtil.getParamIntValue(rowParams.getParam("erpsRB")));
            if (rowParams.getParam("reqNodeAddr") == null) continue;
            erpsMo.setNECarriedWithCurPckt(TENEERPSBeanPluginUtil.getStrValue(rowParams.getParam("reqNodeAddr").getValue()));
        }
    }

    private boolean isNeedToNotice(TEPTNERPSMOPO erpsMo, TEPTNERPSMOPO tmpMO) {
        if (erpsMo.getCtrlVlan() != tmpMO.getCtrlVlan()) {
            return true;
        }
        if (erpsMo.getCompatibleVersion() != tmpMO.getCompatibleVersion()) {
            return true;
        }
        if (erpsMo.getRvtmode() != tmpMO.getRvtmode()) {
            return true;
        }
        if (erpsMo.getMajorRingID() != tmpMO.getMajorRingID()) {
            return true;
        }
        if (erpsMo.getVirChannelSatus() != tmpMO.getVirChannelSatus()) {
            return true;
        }
        if (erpsMo.getVirChannelVlans() != null && tmpMO.getVirChannelVlans() != null && erpsMo.getVirChannelVlans().equals(tmpMO.getVirChannelVlans())) {
            return true;
        }
        if (erpsMo.getLoopDetect() != tmpMO.getLoopDetect()) {
            return true;
        }
        if (erpsMo.getEthType() != tmpMO.getEthType()) {
            return true;
        }
        if (erpsMo.getEastBid() != tmpMO.getEastBid() || erpsMo.getEastSubBd() != tmpMO.getEastSubBd() || erpsMo.getEastPortID() != tmpMO.getEastPortID()) {
            return true;
        }
        if (erpsMo.getWestBid() != tmpMO.getWestBid() || erpsMo.getWestSubBd() != tmpMO.getWestSubBd() || erpsMo.getWestPortID() != tmpMO.getWestPortID()) {
            return true;
        }
        if (erpsMo.getRplBid() != tmpMO.getRplBid()) {
            return true;
        }
        if (erpsMo.getRplSubBd() != tmpMO.getRplSubBd()) {
            return true;
        }
        if (erpsMo.getRplPortID() != tmpMO.getRplPortID()) {
            return true;
        }
        if (erpsMo.getIsRplOwner() != tmpMO.getIsRplOwner()) {
            return true;
        }
        if (erpsMo.getHoldOffTime() != tmpMO.getHoldOffTime()) {
            return true;
        }
        if (erpsMo.getWtrTime() != tmpMO.getWtrTime()) {
            return true;
        }
        return erpsMo.getGuardTime() != tmpMO.getGuardTime();
    }
}

