/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.erps;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.Param;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TEERPSQueryBean
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private boolean isSupportEth = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.isSupportEth = TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_ETHDOMAIN");
        if (this.isSupportEth) {
            QxMapping qxMapping = new QxMapping();
            qxMapping.setContent("NSCMD_CFG_PTN_ERPS_GET_ETHTYPE");
            int cnt = subFunc.getQxMappingCount();
            qxMapping.setSerialno(cnt + 1);
            subFunc.addQxMapping(qxMapping);
            Param param = new Param();
            param.setType("int");
            param.setName("ethdomain");
            subFunc.getOutput().addParam(param);
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(44102);
        list.add(44092);
        list.add(37898);
        return list;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
        int size = this.outputData.getBussinessParams().getRowParamsCount();
        String rplName = "/";
        for (int i = 0; i < size; ++i) {
            RowParams rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowParams.getRowErrorsCount() != 0) continue;
            int eSlotid = Integer.parseInt(rowParams.getParam("eastslotid").getValue());
            int wSlotid = Integer.parseInt(rowParams.getParam("westslotid").getValue());
            int rSlotid = Integer.parseInt(rowParams.getParam("rplslotid").getValue());
            rowParams.addParam("eastBoardName", TEConfigurationDataMgr.getInstance().getBoard(neid, eSlotid).getBoardName());
            rowParams.addParam("westBoardName", TEConfigurationDataMgr.getInstance().getBoard(neid, wSlotid).getBoardName());
            int eBoardType = TENEListMgr.getInstance().getNE(neid).getBoard(eSlotid).getBoardType();
            int ePortID = Integer.parseInt(rowParams.getParam("eastPortId").getValue());
            String ePortName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, eSlotid, eBoardType, ePortID, 16);
            rowParams.addParam("eastPortName", ePortName);
            int wBoardType = TENEListMgr.getInstance().getNE(neid).getBoard(wSlotid).getBoardType();
            int wPortID = Integer.parseInt(rowParams.getParam("westPortId").getValue());
            String wPortName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, wSlotid, wBoardType, wPortID, 16);
            rowParams.addParam("westPortName", wPortName);
            if (rSlotid == 65535) {
                rowParams.getParam("rplslotid").setValue("");
                rowParams.getParam("rplPortId").setValue("-");
                rowParams.addParam("rplBoardName", "");
                rowParams.addParam("rplPortName", "-");
                continue;
            }
            rplName = TEConfigurationDataMgr.getInstance().getBoard(neid, rSlotid).getBoardName();
            rowParams.addParam("rplBoardName", rplName);
            int rplBoardType = TENEListMgr.getInstance().getNE(neid).getBoard(rSlotid).getBoardType();
            int rplPortID = Integer.parseInt(rowParams.getParam("rplPortId").getValue());
            String rplPortName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, rSlotid, rplBoardType, rplPortID, 16);
            rowParams.addParam("rplPortName", rplPortName);
        }
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("ptn").append(File.separator).append("res").append(File.separator).append("erps").append(File.separator).append("erps_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        com.huawei.nglct.common.datainterface.Param[] params = rowparams.getParam();
        String erpsID = Datainterface.getParam((com.huawei.nglct.common.datainterface.Param[])params, (String)"erpsid").getValue();
        StringBuffer strBuf = new StringBuffer();
        if ("0".equals(erpsID)) {
            strBuf.append(this.subfunc.getSubFuncDes(this.neid));
        } else {
            strBuf.append(this.res.getString("erpsid")).append(": ");
            strBuf.append(erpsID);
        }
        return strBuf.toString();
    }
}

