/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.elps;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ptn.elps.TEOAMUtils;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eline.TELogInfQinq;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.eline.TELogicInfPort;
import com.huawei.nglct.nemgr.ip.ptn.ethservice.ethcommon.ethoam.TEEthOAMUtils;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TEELPSQueryOAMResBean
extends TENEExplorerBean {
    private static final String MP_DIRECTION_EGRESS = "2";
    public static final String VUNI_TYPE = "1";
    public static final String VNNI_TYPE = "2";
    public static final String INVALID_VLAN = "65535";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (!String.valueOf(0).equals(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        this.appendOutputPortParams(this.outputData);
    }

    public void appendOutputPortParams(Datainterface outputData) {
        this.operationList.clear();
        this.operationList.addAll(this.getQueryPortIdOperation(this.neid, outputData));
        this.operationList.addAll(this.getQueryMDMANameOperation(this.neid, outputData));
        if (this.operationList.isEmpty()) {
            return;
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, (List)this.operationList, this.TIME_OUT);
        if (result.retCode == 0) {
            Map<String, TELogicInfPort> portMap = this.parseOperationList(this.neid, this.operationList);
            Map<String, String> mdmaNameMap = TEOAMUtils.parseOperationList(this.operationList);
            RowParams inputRow = this.inputData.getBussinessParams().getRowParams(0);
            String wslotid = inputRow.getParam("wslotid").getValue();
            String pslotid = inputRow.getParam("pslotid").getValue();
            String wportid = inputRow.getParam("wportid").getValue();
            String pportid = inputRow.getParam("pportid").getValue();
            for (int i = outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
                RowParams row = outputData.getBussinessParams().getRowParams(i);
                String mdid = row.getParam("mdid").getValue();
                row.addParam("mdname", TEOAMUtils.getMdNameFromMap(mdmaNameMap, mdid));
                String maid = row.getParam("maid").getValue();
                row.addParam("maname", TEOAMUtils.getMaNameFromMap(mdmaNameMap, maid));
                TELogicInfPort port = portMap.get(row.getParam("serviceid").getValue() + "-" + row.getParam("niid").getValue());
                if ("2".equals(row.getParam("direction").getValue()) && port != null && (port.getSlotid() == Integer.parseInt(wslotid) && port.getPortid() == Integer.parseInt(wportid) || port.getSlotid() == Integer.parseInt(pslotid) && port.getPortid() == Integer.parseInt(pportid))) {
                    row.addParam("slotid", String.valueOf(port.getSlotid()));
                    row.addParam("port", String.valueOf(port.getPortid()));
                    continue;
                }
                outputData.getBussinessParams().removeRowParams(i);
            }
        }
    }

    private Map<String, TELogicInfPort> parseOperationList(int neid, List<Operation> operation) {
        Map<String, TELogInfQinq> qinqmap = TEEthOAMUtils.getQinqLink(neid);
        HashMap<String, TELogicInfPort> portMap = new HashMap<String, TELogicInfPort>();
        for (int i = 0; i < operation.size(); ++i) {
            String linkid;
            TELogInfQinq qinq;
            TELogicInfPort logicinf;
            String serviceIndex;
            String logicinfid;
            int role;
            int portid;
            int subslotid;
            int slotid;
            Output output;
            Operation opersec = operation.get(i);
            if (!opersec.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
            if (opersec.getName().equals("NSCMD_SERVICE_GET_ETHVUNI_EX")) {
                output = opersec.getOutput(0);
                slotid = Integer.parseInt(output.getPartValue("slotid"));
                subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                portid = Integer.parseInt(output.getPartValue("portid"));
                role = Integer.parseInt(output.getPartValue("role"));
                logicinfid = output.getPartValue("vuniID");
                serviceIndex = output.getPartValue("serviceIndex");
                logicinf = new TELogicInfPort(neid, slotid, subslotid, portid, role, logicinfid, VUNI_TYPE);
                portMap.put(serviceIndex + "-" + logicinfid, logicinf);
            }
            if (opersec.getName().equals("NSCMD_CFG_SERVICE_GET_ETHPBVUNI_EX")) {
                output = opersec.getOutput(0);
                slotid = Integer.parseInt(output.getPartValue("slotid"));
                subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                portid = Integer.parseInt(output.getPartValue("portid"));
                role = Integer.parseInt(output.getPartValue("role"));
                logicinfid = output.getPartValue("vuniID");
                serviceIndex = output.getPartValue("serviceIndex");
                logicinf = new TELogicInfPort(neid, slotid, subslotid, portid, role, logicinfid, VUNI_TYPE);
                portMap.put(serviceIndex + "-" + logicinfid, logicinf);
            }
            if (!opersec.getName().equals("NSCMD_SERVICE_GET_EVNNI_EX")) continue;
            output = opersec.getOutput(0);
            slotid = -1;
            subslotid = -1;
            portid = -1;
            String carrierType = output.getPartValue("carrierType");
            logicinfid = output.getPartValue("vnniID");
            serviceIndex = output.getPartValue("serviceIndex");
            int role2 = Integer.parseInt(output.getPartValue("role"));
            if ("3".equals(carrierType)) {
                slotid = Integer.parseInt(output.getPartValue("carrierID1"));
                subslotid = Integer.parseInt(output.getPartValue("carrierID2"));
                portid = Integer.parseInt(output.getPartValue("carrierID3"));
            } else if ("4".equals(carrierType) && (qinq = qinqmap.get(linkid = output.getPartValue("carrierID3"))) != null) {
                slotid = qinq.getSlotid();
                subslotid = qinq.getSubslotid();
                portid = qinq.getPortid();
            }
            if (slotid == -1 || portid == -1) continue;
            TELogicInfPort logicinf2 = new TELogicInfPort(neid, slotid, subslotid, portid, role2, logicinfid, "2");
            portMap.put(serviceIndex + "-" + logicinfid, logicinf2);
        }
        return portMap;
    }

    private List<Operation> getQueryPortIdOperation(int neid, Datainterface outputData) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation1 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_ETHVUNI_EX");
        Operation operation2 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SERVICE_GET_EVNNI_EX");
        Operation operation3 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SERVICE_GET_ETHPBVUNI_EX");
        RowParams inputRow = this.inputData.getBussinessParams().getRowParams(0);
        String wvlanid = inputRow.getParam("wvlanid").getValue();
        String pvlanid = inputRow.getParam("pvlanid").getValue();
        RowParams[] rowParams = outputData.getBussinessParams().getRowParams();
        int size = rowParams.length;
        for (int i = 0; i < size; ++i) {
            if (!"2".equals(rowParams[i].getParam("direction").getValue()) || !wvlanid.equals(rowParams[i].getParam("vid").getValue()) && !pvlanid.equals(rowParams[i].getParam("vid").getValue())) continue;
            String logicinftype = rowParams[i].getParam("porttype").getValue();
            String logicinfid = rowParams[i].getParam("niid").getValue();
            String serviceindex = rowParams[i].getParam("serviceid").getValue();
            if (logicinftype.equals(VUNI_TYPE)) {
                operation1.getInput().setPartValue("ethType", "0");
                operation1.getInput().setPartValue("serviceIndex", serviceindex);
                operation1.getInput().setPartValue("vuniID", logicinfid);
                operationList.add((Operation)operation1.clone());
                operation3.getInput().setPartValue("ethType", "2");
                operation3.getInput().setPartValue("serviceIndex", serviceindex);
                operation3.getInput().setPartValue("vuniID", logicinfid);
                operationList.add((Operation)operation3.clone());
                continue;
            }
            if (!logicinftype.equals("2")) continue;
            operation2.getInput().setPartValue("ethType", "0");
            operation2.getInput().setPartValue("serviceIndex", serviceindex);
            operation2.getInput().setPartValue("vnniID", logicinfid);
            operationList.add((Operation)operation2.clone());
        }
        return operationList;
    }

    private List<Operation> getQueryMDMANameOperation(int neid, Datainterface outputData) {
        HashSet<Integer> mdIdList = new HashSet<Integer>();
        HashSet<String> mdmaIdList = new HashSet<String>();
        RowParams inputRow = this.inputData.getBussinessParams().getRowParams(0);
        String wvlanid = inputRow.getParam("wvlanid").getValue();
        String pvlanid = inputRow.getParam("pvlanid").getValue();
        BussinessParams bussiness = outputData.getBussinessParams();
        RowParams row = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0 || !"2".equals(row.getParam("direction").getValue()) || !wvlanid.equals(row.getParam("vid").getValue()) && !pvlanid.equals(row.getParam("vid").getValue())) continue;
            if (!"".equals(row.getParam("mdid").getValue())) {
                mdIdList.add(Integer.parseInt(row.getParam("mdid").getValue()));
            }
            if ("".equals(row.getParam("maid").getValue())) continue;
            mdmaIdList.add(row.getParam("mdid").getValue() + "," + row.getParam("maid").getValue());
        }
        List<Operation> queryMdMaList = TEOAMUtils.getQuryMDNameOperation(neid, mdIdList);
        queryMdMaList.addAll(TEOAMUtils.getQuryMANameOperation(neid, mdmaIdList));
        return queryMdMaList;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38662);
        return errorList;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

