/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.elag_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.elag.TEPTNLAGPort;
import com.huawei.nglct.nemgr.ip.ptn.elag.TEPTNLinkAggrGroup;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;

public class TEPTNQueryLinkAggrGroup
extends TECommonWriteLogBean {
    public static final int NONWORK = 0;
    public static final int WORK = 1;
    public ArrayList operList = new ArrayList();
    public TIntObjectHashMap<TEPTNLinkAggrGroup> lagMap = new TIntObjectHashMap();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        this.outputData.setBussinessParams(bussiness);
        RowParams rowParams = null;
        int errCode = this.handleLinkAggrGroup(neid, operationList);
        if (0 != errCode) {
            if (filterErrorCodeList.contains(errCode)) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else {
                RowErrors rowErrors = new RowErrors();
                rowErrors.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errCode));
                Param param = new Param("neid", String.valueOf(neid));
                rowErrors.addParam(param);
                param = new Param("nename", TENEListMgr.getInstance().getNE(neid).getNEName());
                rowErrors.addParam(param);
                rowParams = new RowParams();
                rowParams.addRowErrors(rowErrors);
                bussiness.addRowParams(rowParams);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            }
        } else {
            this.handleWtrtime(operationList);
            this.handleLAGperiods(operationList);
            this.handleLagsdcondition(operationList);
            this.handleMinActLinkTH(operationList);
            this.handleOtherOpetaion(operationList);
            this.queryLagRealStatus();
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            TIntObjectIterator iter = this.lagMap.iterator();
            while (iter.hasNext()) {
                iter.advance();
                this.outputData.getBussinessParams().addRowParams(((TEPTNLinkAggrGroup)iter.value()).toRowParams());
            }
        }
    }

    protected void handleOtherOpetaion(ArrayList operationList) {
    }

    public int handleMinActLinkTH(ArrayList operationList) {
        if (operationList.size() >= 5) {
            Operation oper = (Operation)operationList.get(4);
            Output output = null;
            int errCode = 0;
            int m = oper.getOutputCount();
            for (int i = 0; i < m; ++i) {
                if (!oper.getName().equals("NSCMD_ETHN_GET_LAGMINACTLINKTH_EX")) continue;
                output = oper.getOutput(i);
                errCode = Integer.valueOf(output.getFault(0).getCode());
                if (0 != errCode) {
                    return errCode;
                }
                String lagno = oper.getOutput(i).getPartValue("lagno");
                TEPTNLinkAggrGroup linkGroup = (TEPTNLinkAggrGroup)this.lagMap.get(Integer.valueOf(lagno).intValue());
                if (oper.getOutput(i).getPart("minUpLinkTH") == null) continue;
                linkGroup.setMinUpLinkTH(Integer.valueOf(oper.getOutput(i).getPartValue("minUpLinkTH")));
            }
            return errCode;
        }
        return 0;
    }

    public int handleWtrtime(ArrayList operationList) {
        Operation oper = (Operation)operationList.get(2);
        Output output = null;
        int errCode = 0;
        int m = oper.getOutputCount();
        for (int i = 0; i < m; ++i) {
            output = oper.getOutput(i);
            errCode = Integer.valueOf(output.getFault(0).getCode());
            if (0 != errCode) {
                return errCode;
            }
            String lagno = oper.getOutput(i).getPartValue("lagno");
            TEPTNLinkAggrGroup linkGroup = (TEPTNLinkAggrGroup)this.lagMap.get(Integer.valueOf(lagno).intValue());
            linkGroup.setWtrtime(Integer.valueOf(oper.getOutput(i).getPartValue("wtrtime")));
        }
        return errCode;
    }

    public int handleLAGperiods(ArrayList operationList) {
        return 0;
    }

    public int handleLagsdcondition(ArrayList operationList) {
        Operation oper = (Operation)operationList.get(3);
        Output output = null;
        int errCode = 0;
        int m = oper.getOutputCount();
        for (int i = 0; i < m; ++i) {
            output = oper.getOutput(i);
            errCode = Integer.valueOf(output.getFault(0).getCode());
            if (0 != errCode) {
                return errCode;
            }
            String lagno = oper.getOutput(i).getPartValue("lagno");
            TEPTNLinkAggrGroup linkGroup = (TEPTNLinkAggrGroup)this.lagMap.get(Integer.valueOf(lagno).intValue());
            if (!linkGroup.getMainPort().isIFPort()) continue;
            linkGroup.setLagsdcondition(Integer.valueOf(oper.getOutput(i).getPartValue("lagsdcondition")));
        }
        return errCode;
    }

    public int handleLinkAggrGroup(int neid, ArrayList operationList) {
        int errCode = 0;
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_LAGREAL_EX2");
        Input input = operation.getInput();
        Output output = null;
        TEPTNLAGPort lagPort = null;
        TEPTNLinkAggrGroup lag = null;
        ArrayList<TEPTNLAGPort> lagPortList = null;
        Operation oper = (Operation)operationList.get(0);
        Operation oper1 = (Operation)operationList.get(1);
        String sharinghash = oper1.getOutput(0).getPartValue("sharinghash");
        int m = oper.getOutputCount();
        for (int i = 0; i < m; ++i) {
            output = oper.getOutput(i);
            errCode = Integer.valueOf(output.getFault(0).getCode());
            if (0 != errCode) {
                return errCode;
            }
            lag = new TEPTNLinkAggrGroup();
            int lagno = Integer.valueOf(output.getPartValue("lagno"));
            lag.setLagNo(lagno);
            input.setPartValue("lagno", lagno + "");
            this.operList.add(operation.clone());
            lag.setLagName(output.getPartValue("lagname"));
            lag.setLagType(Integer.valueOf(output.getPartValue("lagtype")));
            lag.setRvtMode(Integer.valueOf(output.getPartValue("revmode")));
            lag.setLagSysPri(Integer.valueOf(output.getPartValue("syspriority")));
            lag.setLoadType(Integer.valueOf(output.getPartValue("loadsharing")));
            lag.setLoadALG(Integer.valueOf(sharinghash));
            lagPort = new TEPTNLAGPort();
            int slotId = Integer.valueOf(output.getPartValue("slotid"));
            lagPort.setSlotId(slotId);
            int cpType = mgr.getBoardType(neid, slotId);
            String cpName = mgr.getBoardTypeName(neid, cpType);
            lagPort.setCpName(cpName);
            boolean isIFCP = mgr.isIFboard(cpType);
            lagPort.setIFPort(isIFCP);
            int portId = Integer.valueOf(output.getPartValue("port"));
            lagPort.setPortId(portId);
            String portName = mgr.getPortNameForPTN(neid, slotId, cpType, portId);
            lagPort.setPortName(portName);
            lag.setMainPort(lagPort);
            int slavePortNum = Integer.parseInt(output.getPartValue("slaveportnum"));
            if (slavePortNum > 0) {
                lagPortList = new ArrayList<TEPTNLAGPort>();
                StringBuffer sb = new StringBuffer();
                byte[] bValue = output.getPartValue("slaveport").getBytes();
                int nCount = 14;
                int nPos = 0;
                int nParaSize = bValue.length;
                while (nPos + nCount <= nParaSize) {
                    lagPort = new TEPTNLAGPort();
                    slotId = IOStreamConvertor.readPositiveInt((byte[])bValue, (int)nPos);
                    lagPort.setSlotId(slotId);
                    cpType = mgr.getBoardType(neid, slotId);
                    cpName = mgr.getBoardTypeName(neid, cpType);
                    lagPort.setCpName(cpName);
                    sb.append(slotId).append("-").append(cpName);
                    portId = IOStreamConvertor.readPositiveInt((byte[])bValue, (int)(nPos + 6));
                    lagPort.setPortId(portId);
                    portName = mgr.getPortNameForPTN(neid, slotId, cpType, portId);
                    lagPort.setPortName(portName);
                    sb.append("-").append(portName).append(",");
                    lagPortList.add(lagPort);
                    nPos += nCount;
                }
                lag.setSlavePortList(lagPortList);
                output.setPartValue("slaveport", sb.substring(0, sb.length() - 1));
            } else {
                output.setPartValue("slaveport", "");
            }
            this.lagMap.put(lagno, (Object)lag);
        }
        return 0;
    }

    public void queryLagRealStatus() {
        if (this.operList.size() > 0) {
            Operation oper = null;
            Output output = null;
            int errCode = this.sendMessage(this.neid, this.operList);
            if (0 == errCode) {
                int m = this.operList.size();
                for (int i = 0; i < m; ++i) {
                    oper = (Operation)this.operList.get(i);
                    output = oper.getOutput(0);
                    errCode = Integer.valueOf(output.getFault(0).getCode());
                    if (0 != errCode) continue;
                    this.setPortRealStatus(output);
                }
            }
        }
    }

    public void setPortRealStatus(Output output) {
        TEPTNLinkAggrGroup lag = null;
        TEPTNLAGPort tmpLagPort = null;
        TEPTNLAGPort lagPort = null;
        int lagNo = Integer.valueOf(output.getPartValue("lagno"));
        int portNum = Integer.valueOf(output.getPartValue("portnum"));
        if (portNum <= 0) {
            return;
        }
        if (this.lagMap.containsKey(lagNo)) {
            lag = (TEPTNLinkAggrGroup)this.lagMap.get(lagNo);
            lag.getMainPort().setStatus(0);
            if (lag.getSlavePortList() == null) {
                lag.setSlavePortList(new ArrayList<TEPTNLAGPort>());
            }
            int n = lag.getSlavePortList().size();
            for (int j = 0; j < n; ++j) {
                lag.getSlavePortList().get(j).setStatus(0);
            }
            byte[] bValue = output.getPartValue("ports").getBytes();
            int nCount = 10;
            int nPos = 0;
            int nParaSize = bValue.length;
            while (nPos + nCount <= nParaSize) {
                lagPort = new TEPTNLAGPort();
                int slotId = IOStreamConvertor.readPositiveInt((byte[])bValue, (int)nPos);
                lagPort.setSlotId(slotId);
                int portId = IOStreamConvertor.readPositiveInt((byte[])bValue, (int)(nPos + 6));
                lagPort.setPortId(portId);
                lag = (TEPTNLinkAggrGroup)this.lagMap.get(lagNo);
                tmpLagPort = lag.getMainPort();
                if (tmpLagPort.equals(lagPort)) {
                    tmpLagPort.setStatus(1);
                }
                int n2 = lag.getSlavePortList().size();
                for (int j = 0; j < n2; ++j) {
                    tmpLagPort = lag.getSlavePortList().get(j);
                    if (!tmpLagPort.equals(lagPort)) continue;
                    tmpLagPort.setStatus(1);
                }
                nPos += nCount;
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList list = super.getFilterErrorCodeList();
        list.add(38662);
        list.add(37898);
        return list;
    }
}

