/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.elag;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.elag.TEPTNLAGPort;
import com.huawei.nglct.nemgr.ip.ptn.elag.TEPTNLinkAggrGroup;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;

public class TEPTNQueryLinkAggrGroup
extends TECommonWriteLogBean {
    private static final int NONWORK = 0;
    private static final int WORK = 1;
    private ArrayList operList = new ArrayList();
    private TIntObjectHashMap<TEPTNLinkAggrGroup> lagMap = new TIntObjectHashMap();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        this.outputData.setBussinessParams(bussiness);
        RowParams rowParams = null;
        int erroCode = this.handleLinkAggrGroup(neid, operationList);
        if (0 != erroCode) {
            if (filterErrorCodeList.contains(erroCode)) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else {
                RowErrors rowErrs = new RowErrors();
                rowErrs.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)erroCode));
                Param param = new Param("neid", String.valueOf(neid));
                rowErrs.addParam(param);
                param = new Param("nename", TENEListMgr.getInstance().getNE(neid).getNEName());
                rowErrs.addParam(param);
                rowParams = new RowParams();
                rowParams.addRowErrors(rowErrs);
                bussiness.addRowParams(rowParams);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            }
        } else {
            this.queryLagRealStatus();
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            TIntObjectIterator iterator = this.lagMap.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                this.outputData.getBussinessParams().addRowParams(((TEPTNLinkAggrGroup)iterator.value()).toRowParams());
            }
        }
    }

    private int handleLinkAggrGroup(int neid, ArrayList operationList) {
        int errCode = 0;
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_LAGREAL_EX2");
        Input input = oper.getInput();
        Output output = null;
        TEPTNLAGPort lagPort = null;
        TEPTNLinkAggrGroup lagGrp = null;
        ArrayList<TEPTNLAGPort> lagPortList = null;
        Operation operation = (Operation)operationList.get(0);
        int m = operation.getOutputCount();
        for (int i = 0; i < m; ++i) {
            output = operation.getOutput(i);
            errCode = Integer.valueOf(output.getFault(0).getCode());
            if (0 != errCode) {
                return errCode;
            }
            lagGrp = new TEPTNLinkAggrGroup();
            int lagno = Integer.valueOf(output.getPartValue("lagno"));
            lagGrp.setLagNo(lagno);
            input.setPartValue("lagno", lagno + "");
            this.operList.add(oper.clone());
            lagGrp.setLagName(output.getPartValue("lagname"));
            lagGrp.setLagType(Integer.valueOf(output.getPartValue("lagtype")));
            lagGrp.setRvtMode(Integer.valueOf(output.getPartValue("revmode")));
            lagGrp.setLagSysPri(Integer.valueOf(output.getPartValue("syspriority")));
            lagGrp.setLoadType(Integer.valueOf(output.getPartValue("loadsharing")));
            lagGrp.setLoadALG(Integer.valueOf(output.getPartValue("sharinghash")));
            lagPort = new TEPTNLAGPort();
            int slotId = Integer.valueOf(output.getPartValue("slotid"));
            lagPort.setSlotId(slotId);
            int cpType = mgr.getBoardType(neid, slotId);
            String cpNameStr = mgr.getBoardTypeName(neid, cpType);
            lagPort.setCpName(cpNameStr);
            int portId = Integer.valueOf(output.getPartValue("port"));
            lagPort.setPortId(portId);
            String portNameStr = mgr.getPortNameForPTN(neid, slotId, cpType, portId);
            lagPort.setPortName(portNameStr);
            lagGrp.setMainPort(lagPort);
            int slavePortNum = Integer.parseInt(output.getPartValue("slaveportnum"));
            if (slavePortNum > 0) {
                lagPortList = new ArrayList<TEPTNLAGPort>();
                StringBuffer buffer = new StringBuffer();
                byte[] bValue = output.getPartValue("slaveport").getBytes();
                int nCount = 14;
                int nPos = 0;
                int nParaSize = bValue.length;
                while (nPos + nCount <= nParaSize) {
                    lagPort = new TEPTNLAGPort();
                    slotId = IOStreamConvertor.readPositiveInt((byte[])bValue, (int)nPos);
                    lagPort.setSlotId(slotId);
                    cpType = mgr.getBoardType(neid, slotId);
                    cpNameStr = mgr.getBoardTypeName(neid, cpType);
                    lagPort.setCpName(cpNameStr);
                    buffer.append(slotId).append("-").append(cpNameStr);
                    portId = IOStreamConvertor.readPositiveInt((byte[])bValue, (int)(nPos + 6));
                    lagPort.setPortId(portId);
                    portNameStr = mgr.getPortNameForPTN(neid, slotId, cpType, portId);
                    lagPort.setPortName(portNameStr);
                    buffer.append("-").append(portNameStr).append(",");
                    lagPortList.add(lagPort);
                    nPos += nCount;
                }
                lagGrp.setSlavePortList(lagPortList);
                output.setPartValue("slaveport", buffer.substring(0, buffer.length() - 1));
            } else {
                output.setPartValue("slaveport", "");
            }
            this.lagMap.put(lagno, (Object)lagGrp);
        }
        return 0;
    }

    private void queryLagRealStatus() {
        if (this.operList.size() > 0) {
            Operation operation = null;
            Output output = null;
            int errCode = this.sendMessage(this.neid, this.operList);
            if (0 == errCode) {
                int m = this.operList.size();
                for (int i = 0; i < m; ++i) {
                    operation = (Operation)this.operList.get(i);
                    output = operation.getOutput(0);
                    errCode = Integer.valueOf(output.getFault(0).getCode());
                    if (0 != errCode) continue;
                    this.setPortRealStatus(output);
                }
            }
        }
    }

    private void setPortRealStatus(Output output) {
        TEPTNLinkAggrGroup lagNoVal = null;
        TEPTNLAGPort tempLagPort = null;
        TEPTNLAGPort lagPort = null;
        int lagno = Integer.valueOf(output.getPartValue("lagno"));
        int portNum = Integer.valueOf(output.getPartValue("portnum"));
        if (portNum <= 0) {
            return;
        }
        if (this.lagMap.containsKey(lagno)) {
            lagNoVal = (TEPTNLinkAggrGroup)this.lagMap.get(lagno);
            lagNoVal.getMainPort().setStatus(0);
            if (lagNoVal.getSlavePortList() == null) {
                lagNoVal.setSlavePortList(new ArrayList<TEPTNLAGPort>());
            }
            int n = lagNoVal.getSlavePortList().size();
            for (int j = 0; j < n; ++j) {
                lagNoVal.getSlavePortList().get(j).setStatus(0);
            }
            byte[] portBytesVal = output.getPartValue("ports").getBytes();
            int nCount = 10;
            int nPos = 0;
            int nParaSize = portBytesVal.length;
            while (nPos + nCount <= nParaSize) {
                lagPort = new TEPTNLAGPort();
                int slotId = IOStreamConvertor.readPositiveInt((byte[])portBytesVal, (int)nPos);
                lagPort.setSlotId(slotId);
                int portId = IOStreamConvertor.readPositiveInt((byte[])portBytesVal, (int)(nPos + 6));
                lagPort.setPortId(portId);
                lagNoVal = (TEPTNLinkAggrGroup)this.lagMap.get(lagno);
                tempLagPort = lagNoVal.getMainPort();
                if (tempLagPort.equals(lagPort)) {
                    tempLagPort.setStatus(1);
                }
                int n2 = lagNoVal.getSlavePortList().size();
                for (int j = 0; j < n2; ++j) {
                    tempLagPort = lagNoVal.getSlavePortList().get(j);
                    if (!tempLagPort.equals(lagPort)) continue;
                    tempLagPort.setStatus(1);
                }
                nPos += nCount;
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList list = super.getFilterErrorCodeList();
        list.add(38662);
        list.add(37898);
        return list;
    }
}

