/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.elag;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TEGenCfgCommon;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nemgr.ip.ptn.elag.TEPTNLAGPort;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class TEPTNGetValidPortList
extends TENEExplorerBean {
    private static final String SERVICE_TYPE_ELINE = "1";
    private static final String SERVICE_TYPE_ELAN = "2";
    private static final String SERVICE_TYPE_ETREE = "3";
    private static final String SERVICE_TYPE_EAGGR = "4";
    private static final int TIME_OUT_SECOND = 10;
    private static final int INVALID_SLOTID = 65535;
    private static final String NSCMD_SERVICE_GET_ETHVUNI_EX = "NSCMD_SERVICE_GET_ETHVUNI_EX";
    private Set<TEPTNLAGPort> usedPortList = new TreeSet<TEPTNLAGPort>();
    private Set<TEPTNLAGPort> servicedPortList = new TreeSet<TEPTNLAGPort>();
    private Set<TEPTNLAGPort> usedAndServicedPortList = new TreeSet<TEPTNLAGPort>();
    private Set<TEPTNLAGPort> unUsedPortList = new TreeSet<TEPTNLAGPort>();
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private static final String INVALID_SHAREHASH = "-1";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.getPortsUsedByLag((Operation)operationList.get(0));
        int errcode = this.getPortsUsedByService();
        if (0 != errcode) {
            TELogFactory.getNormalLogger().info("get serviced ports fail!", (Object)errcode);
        }
        this.getPortsUsedByMSTP((Operation)operationList.get(1));
        String sharinghash = this.getSharinghash(operationList);
        this.getAllValidPorts();
        this.outputData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        RowParams rowParams = new RowParams();
        Param param = new Param("availableportnum", String.valueOf(this.unUsedPortList.size() + this.servicedPortList.size()));
        rowParams.addParam(param);
        param = new Param("sharinghash", sharinghash);
        rowParams.addParam(param);
        bussinessParams.addRowParams(rowParams);
        this.toRowParams(bussinessParams, this.unUsedPortList, "unusedport");
        this.toRowParams(bussinessParams, this.usedPortList, "usedport");
        this.toRowParams(bussinessParams, this.servicedPortList, "servicedport");
        this.toRowParams(bussinessParams, this.usedAndServicedPortList, "usedandservicedport");
    }

    private void toRowParams(BussinessParams bussinessParams, Set<TEPTNLAGPort> portList, String portFlag) {
        int slotId = 0;
        int tmpSlotId = 0;
        int boardType = 0;
        Param portParamName = null;
        Param portParamType = null;
        RowParams rowParams = null;
        TEPTNLAGPort lagPort2 = null;
        for (TEPTNLAGPort lagPort2 : portList) {
            tmpSlotId = lagPort2.getSlotId();
            boardType = this.mgr.getBoardType(this.neid, tmpSlotId);
            boolean isCpNotSupportLag = TEGenCfgCommon.isSupportAttr((int)boardType, (String)"ATTR_NOTSUPPROT_PTN_LAG");
            if (isCpNotSupportLag) continue;
            if (slotId != tmpSlotId) {
                slotId = tmpSlotId;
                rowParams = new RowParams();
                rowParams.addParam(new Param("slotid", String.valueOf(slotId)));
                rowParams.addParam(new Param("boardname", lagPort2.getCpName()));
                portParamName = new Param(portFlag, "");
                rowParams.addParam(portParamName);
                portParamType = new Param("portType", "");
                rowParams.addParam(portParamType);
                bussinessParams.addRowParams(rowParams);
            }
            portParamName.addOption(new Option(lagPort2.getPortNameForPTN()));
            portParamType.addOption(new Option(String.valueOf(lagPort2.isIFPort())));
        }
    }

    private void getAllValidPorts() {
        TEBoard board = null;
        TEPortProperty portProperty = null;
        ArrayList portPropertyList = null;
        TEPTNLAGPort lagPort = null;
        int portId = 0;
        boolean isIFPort = false;
        Vector bdVec = this.mgr.getNE(this.neid).getClonedBoardList();
        int m = bdVec.size();
        for (int i = 0; i < m; ++i) {
            board = (TEBoard)bdVec.get(i);
            portPropertyList = this.mgr.getBoardPortPropertyList(this.neid, board.getBoardType());
            ArrayList existPortList = new ArrayList();
            boolean isDynBoard = false;
            if (this.mgr.isDynPortBoardType(this.neid, board.getBoardType())) {
                existPortList = this.mgr.getLogicPortList(this.neid, board.getSlotID());
                isDynBoard = true;
            }
            int n = portPropertyList.size();
            for (int j = 0; j < n; ++j) {
                lagPort = new TEPTNLAGPort();
                lagPort.setSlotId(board.getSlotID());
                lagPort.setCpName(board.getBoardTypeName());
                portProperty = (TEPortProperty)portPropertyList.get(j);
                if (portProperty.getPortType() != 1799 && portProperty.getPortType() != 1802) continue;
                portId = portProperty.getPortNo();
                if (isDynBoard && !existPortList.contains(portId)) continue;
                lagPort.setPortId(portId);
                lagPort.setPortName(this.mgr.getPortNameForPTN(this.neid, board.getSlotID(), board.getBoardType(), portId));
                isIFPort = this.mgr.isIFPort(this.neid, board.getBoardType(), portId);
                lagPort.setIFPort(isIFPort);
                if (this.unUsedPortList.contains(lagPort) || this.usedPortList.contains(lagPort) || this.servicedPortList.contains(lagPort) || this.usedAndServicedPortList.contains(lagPort)) continue;
                this.unUsedPortList.add(lagPort);
            }
        }
    }

    private void getPortsUsedByLag(Operation oper) {
        int errCode = 0;
        int slotId = 0;
        int cpType = 0;
        String cpName = "";
        int portId = 0;
        String portName = "";
        int slavePortNum = 0;
        boolean isIFPort = false;
        Output output = null;
        TEPTNLAGPort lagPort = null;
        int m = oper.getOutputCount();
        for (int i = 0; i < m; ++i) {
            output = oper.getOutput(i);
            errCode = Integer.parseInt(output.getFault(0).getCode());
            if (0 != errCode) continue;
            lagPort = new TEPTNLAGPort();
            slotId = Integer.parseInt(output.getPartValue("slotid"));
            lagPort.setSlotId(slotId);
            cpType = this.mgr.getBoardType(this.neid, slotId);
            cpName = this.mgr.getBoardTypeName(this.neid, cpType);
            lagPort.setCpName(cpName);
            portId = Integer.parseInt(output.getPartValue("port"));
            lagPort.setPortId(portId);
            portName = this.mgr.getPortNameForPTN(this.neid, slotId, cpType, portId);
            lagPort.setPortName(portName);
            isIFPort = this.mgr.isIFPort(this.neid, cpType, portId);
            lagPort.setIFPort(isIFPort);
            this.usedPortList.add(lagPort);
            slavePortNum = Integer.parseInt(output.getPartValue("slaveportnum"));
            if (slavePortNum <= 0) continue;
            byte[] bValue = output.getPartValue("slaveport").getBytes();
            int nCount = 14;
            int nPos = 0;
            int nParaSize = bValue.length;
            while (nPos + nCount <= nParaSize) {
                lagPort = new TEPTNLAGPort();
                slotId = IOStreamConvertor.readPositiveInt((byte[])bValue, (int)nPos);
                lagPort.setSlotId(slotId);
                cpType = this.mgr.getBoardType(this.neid, slotId);
                cpName = this.mgr.getBoardTypeName(this.neid, cpType);
                lagPort.setCpName(cpName);
                isIFPort = this.mgr.isIFPort(this.neid, cpType, portId);
                lagPort.setIFPort(isIFPort);
                portId = IOStreamConvertor.readPositiveInt((byte[])bValue, (int)(nPos + 6));
                lagPort.setPortId(portId);
                portName = this.mgr.getPortNameForPTN(this.neid, slotId, cpType, portId);
                lagPort.setPortName(portName);
                this.usedPortList.add(lagPort);
                nPos += nCount;
            }
        }
    }

    private int getPortsUsedByService() {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation_1 = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_SERVICE_GET_ETHVUNI_EX);
        Input input_1 = operation_1.getInput();
        input_1.getPart("ethType").setValue(SERVICE_TYPE_ELINE);
        input_1.getPart("serviceIndex").setValue("0");
        input_1.getPart("vuniID").setValue("0");
        operationList.add(operation_1);
        Operation operation_2 = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_SERVICE_GET_ETHVUNI_EX);
        Input input_2 = operation_2.getInput();
        input_2.getPart("ethType").setValue(SERVICE_TYPE_ELAN);
        input_2.getPart("serviceIndex").setValue("0");
        input_2.getPart("vuniID").setValue("0");
        operationList.add(operation_2);
        Operation operation_3 = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_SERVICE_GET_ETHVUNI_EX);
        Input input_3 = operation_3.getInput();
        input_3.getPart("ethType").setValue(SERVICE_TYPE_ETREE);
        input_3.getPart("serviceIndex").setValue("0");
        input_3.getPart("vuniID").setValue("0");
        operationList.add(operation_3);
        Operation operation_4 = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_SERVICE_GET_ETHVUNI_EX);
        Input input_4 = operation_4.getInput();
        input_4.getPart("ethType").setValue(SERVICE_TYPE_EAGGR);
        input_4.getPart("serviceIndex").setValue("0");
        input_4.getPart("vuniID").setValue("0");
        operationList.add(operation_4);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, 10);
        if (result.retCode != 0) {
            return result.retCode;
        }
        int errCode = 0;
        int slotId = 0;
        int cpType = 0;
        String cpName = "";
        boolean isIFPort = false;
        int portId = 0;
        String portName = "";
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation operation = (Operation)operationList.get(i);
            Output output = null;
            TEPTNLAGPort lagPort = null;
            int m = operation.getOutputCount();
            for (int j = 0; j < m; ++j) {
                output = operation.getOutput(j);
                errCode = Integer.parseInt(output.getFault(0).getCode());
                if (0 != errCode) continue;
                lagPort = new TEPTNLAGPort();
                slotId = Integer.parseInt(output.getPartValue("slotid"));
                if (slotId == 65535) continue;
                lagPort.setSlotId(slotId);
                cpType = this.mgr.getBoardType(this.neid, slotId);
                cpName = this.mgr.getBoardTypeName(this.neid, cpType);
                lagPort.setCpName(cpName);
                portId = Integer.parseInt(output.getPartValue("portid"));
                lagPort.setPortId(portId);
                portName = this.mgr.getPortNameForPTN(this.neid, slotId, cpType, portId);
                lagPort.setPortName(portName);
                isIFPort = this.mgr.isIFPort(this.neid, cpType, portId);
                lagPort.setIFPort(isIFPort);
                if (!this.usedPortList.contains(lagPort)) {
                    this.servicedPortList.add(lagPort);
                    continue;
                }
                this.usedPortList.remove(lagPort);
                this.usedAndServicedPortList.add(lagPort);
            }
        }
        return 0;
    }

    private String getSharinghash(ArrayList opers) {
        Output output;
        int errCode;
        String hash = INVALID_SHAREHASH;
        Operation operHash = (Operation)opers.get(opers.size() - 1);
        if ("NSCMD_CFG_ETHN_GET_TTLLAGLOADALG".equals(operHash.getName()) && (errCode = Integer.parseInt((output = operHash.getOutput(0)).getFault(0).getCode())) == 0) {
            hash = output.getPartValue("sharinghash");
        }
        return hash;
    }

    private void getPortsUsedByMSTP(Operation oper) {
        int errCode = 0;
        int portNum = 0;
        int slotId = 0;
        int cpType = 0;
        String cpName = "";
        boolean isIFPort = false;
        int portId = 0;
        String portName = "";
        Output output = null;
        TEPTNLAGPort lagPort = null;
        int m = oper.getOutputCount();
        for (int i = 0; i < m; ++i) {
            output = oper.getOutput(i);
            errCode = Integer.parseInt(output.getFault(0).getCode());
            if (0 != errCode || (portNum = Integer.parseInt(output.getPartValue("portNumber"))) <= 0) continue;
            byte[] bValue = output.getPartValue("portInfo").getBytes();
            int stepLength = 8;
            int startIndex = 0;
            while (startIndex + stepLength <= bValue.length) {
                lagPort = new TEPTNLAGPort();
                byte[] bTmp = new byte[4];
                System.arraycopy(bValue, startIndex + 0, bTmp, 0, 4);
                slotId = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                lagPort.setSlotId(slotId);
                cpType = this.mgr.getBoardType(this.neid, slotId);
                cpName = this.mgr.getBoardTypeName(this.neid, cpType);
                lagPort.setCpName(cpName);
                isIFPort = this.mgr.isIFPort(this.neid, cpType, portNum);
                lagPort.setIFPort(isIFPort);
                bTmp = new byte[4];
                System.arraycopy(bValue, startIndex + 6, bTmp, 0, 4);
                portId = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                lagPort.setPortId(portId);
                portName = this.mgr.getPortNameForPTN(this.neid, slotId, cpType, portId);
                lagPort.setPortName(portName);
                if (!this.usedPortList.contains(lagPort)) {
                    this.servicedPortList.add(lagPort);
                } else {
                    this.usedPortList.remove(lagPort);
                    this.usedAndServicedPortList.add(lagPort);
                }
                startIndex += stepLength;
            }
        }
    }
}

