/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.lldp.util;

import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.OperationResult;
import java.util.ArrayList;

public class TELldpConfig {
    private static final int TIME_OUT = 60;
    private static final int RTN900_R8C00_VERSION_START = 1300;
    private static final int RTN900_R8C00_VERSION_START3 = 5;
    private static final int RTN900_R8C00_VERSION_START4 = 20;

    private TELldpConfig() {
    }

    private static boolean isRTN900SupportLldpVersion(String version) {
        String[] vers = version.split("\\.");
        return vers.length >= 4 && Integer.parseInt(vers[vers.length - 1]) >= 5 && Integer.parseInt(vers[vers.length - 1]) >= 20;
    }

    public static boolean isSupportLldp(TENE ne) {
        String version = ne.getHostVersion();
        return (114 == ne.getNEType() || 76 == ne.getNEType() || 77 == ne.getNEType() || 83 == ne.getNEType() || 95 == ne.getNEType()) && TELldpConfig.isRTN900SupportLldpVersion(version);
    }

    public static boolean isSupportLldp(int neId) {
        TENE ne = TENEListMgr.getInstance().getNE(neId);
        return TELldpConfig.isSupportLldp(ne);
    }

    public static int sendMessage(int neid, SubFunc subFunc, ArrayList operationList) {
        int retCode = 0;
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, operationList, 60, subFunc);
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public static SubFunc getSubFunc(int neID, int sfid) {
        SubFunc subFunc = null;
        return subFunc;
    }

    private static long convertIntVersion(String version) {
        String[] vers = version.split("\\.");
        if (vers.length < 4) {
            return 0L;
        }
        byte[] a = new byte[4];
        int len = vers.length;
        for (int i = 0; i < len; ++i) {
            a[i] = (byte)(Integer.parseInt(vers[i]) & 0xFF);
        }
        return IOStreamConvertor.readInt((byte[])a, (int)0);
    }
}

