/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.lldp.util;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.lldp.util.TELldpConfig;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import gnu.trove.TIntArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;

public final class TEE2ELldpUtil {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static String filePath = new StringBuffer().append(TEPathManager.RESOURCE_PROFILE_PATH).append("errcode_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini").toString();
    private static TEResourceUtil res = TEResourceUtil.getInstance((String)filePath);

    private TEE2ELldpUtil() {
    }

    public static Set<Integer> getSupportLldpNEIdSet() {
        HashSet<Integer> idSet = new HashSet<Integer>();
        TENE ne = null;
        TIntArrayList neIdList = TENEListMgr.getInstance().getNEIDList();
        int size = neIdList.size();
        for (int i = 0; i < size; ++i) {
            ne = TENEListMgr.getInstance().getNE(neIdList.get(i));
            if (!TELldpConfig.isSupportLldp(ne)) continue;
            idSet.add(neIdList.get(i));
        }
        if (0 == neIdList.size()) {
            e2eLogger.info("neIdList is empty.");
        }
        e2eLogger.debug("getSupportLldpNEIdList->" + ((Object)idSet).toString());
        return idSet;
    }

    public static Set<Integer> connectSBIForNEImpl(QAsnErrInfoReturn erreturn, Set<Integer> neIDSet) {
        HashSet<Integer> normalNEIDSet = new HashSet<Integer>();
        int neID2 = -1;
        int result = -1;
        for (int neID2 : neIDSet) {
            result = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID2);
            if (0 != result) {
                erreturn.errList.add((Object)TEE2ELldpUtil.createQAsnErrInfo(result, neID2));
                e2eLogger.error("connectSBIForNEImpl: Connect to ne failed! neID->" + neID2);
                continue;
            }
            normalNEIDSet.add(neID2);
        }
        return normalNEIDSet;
    }

    public static QAsnErrInfo createQAsnErrInfo(int errorCode, int objID) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        TENE ne = TENEListMgr.getInstance().getNE(objID);
        String neName = "UNKNOWN";
        if (null != ne) {
            neName = ne.getNEName();
        }
        errInfo.objName = neName.getBytes();
        errInfo.errCode = errorCode;
        errInfo.objID = new QAsnTinyIntList();
        errInfo.objID.add((Object)ne.getNEID());
        errInfo.strOperDesc = res.getString(String.valueOf(errorCode)).getBytes();
        return errInfo;
    }

    public static void logFuncBegin(String funcName) {
        e2eLogger.info(funcName + ": begin.");
    }

    public static void logFuncEnd(String funcName) {
        e2eLogger.info(funcName + ": end.");
    }

    public static void setGlobalErrCode(QAsnErrInfoReturn erreturn) {
        erreturn.result = erreturn.errList.isEmpty() ? 0 : 1090605056;
    }
}

