/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.lldp.bean;

import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nemgr.ip.ptn.e2e.lldp.util.TEE2ELldpUtil;
import com.huawei.nglct.nemgr.ip.ptn.e2e.lldp.util.TELldpConfig;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TESetLldpEnableBean {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static final String NSCMD_ETHN_SET_LLDP_WORKMODE = "NSCMD_ETHN_SET_LLDP_WORKMODE";
    private static final int WORK_MODE_DISABLE = 0;
    private static final int WORK_MODE_TX = 1;
    private static final int WORK_MODE_RX = 2;
    private static final int WORK_MODE_TXRX = 3;

    public void setLldpEnable(int neID, QAsnErrInfoReturn erreturn) {
        if (!TELldpConfig.isSupportLldp(neID)) {
            e2eLogger.info("not support LLDP, neID->" + neID);
            return;
        }
        ArrayList operationList = this.getOperationList(neID);
        int retCode = TELldpConfig.sendMessage(neID, null, operationList);
        if (retCode != 0) {
            erreturn.errList.add((Object)TEE2ELldpUtil.createQAsnErrInfo(retCode, neID));
            e2eLogger.info("e2e:ne communication fail, neID->" + neID);
        } else {
            this.consturctErrInfo(neID, operationList, erreturn);
        }
    }

    public ArrayList getOperationList(int neID) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        List portList = this.getSupportLLDPPortList(neID);
        TEPort port = new TEPort();
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            port = (TEPort)portList.get(i);
            Operation operation = TECreateObjectFactory.getOperation((int)neID, (String)NSCMD_ETHN_SET_LLDP_WORKMODE);
            Input input = operation.getInput();
            input.getPart("slotid").setValue(String.valueOf(port.getSlotID()));
            input.getPart("subslotid").setValue(String.valueOf(255));
            input.getPart("portid").setValue(String.valueOf(port.getPortNo()));
            input.getPart("workmode").setValue(String.valueOf(this.getWorkMode()));
            operationList.add(operation);
        }
        return operationList;
    }

    public List getSupportLLDPPortList(int neid) {
        TEConfigurationDataMgr cfgInstance = TEConfigurationDataMgr.getInstance();
        Vector boardList = cfgInstance.getNE(neid).getClonedBoardList();
        TEBoard board = null;
        ArrayList portList = new ArrayList();
        int m = boardList.size();
        for (int i = 0; i < m; ++i) {
            board = (TEBoard)boardList.get(i);
            portList.addAll(cfgInstance.getPortList(neid, board.getSlotID(), 1799));
        }
        return portList;
    }

    private int getWorkMode() {
        return 3;
    }

    private void consturctErrInfo(int neID, List operationList, QAsnErrInfoReturn erreturn) {
        Operation oper = null;
        int errCode = 0;
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            oper = (Operation)operationList.get(i);
            errCode = Integer.valueOf(oper.getOutput()[0].getFault()[0].getCode());
            if (0 == errCode || this.getFilterErrorCodeList().contains(errCode)) continue;
            erreturn.errList.add((Object)TEE2ELldpUtil.createQAsnErrInfo(errCode, neID));
            e2eLogger.error("e2e:operation fail, neID-->" + neID + ",errCode-->" + errCode);
        }
    }

    public ArrayList<Integer> getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38737);
        errorList.add(37898);
        return errorList;
    }

    public void writeLog(int neid, String user, ArrayList operationList) {
    }
}

