/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.model.TEE2EErpsAttr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2ErpsLog;
import com.huawei.nglct.nemgr.q_interface.e2e.QAsnUniResID;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnERPSInfo;
import com.huawei.nglct.po.embeddednemgrmo.TEETHERPSMOPO;
import com.huawei.nglct.po.embeddednemgrmo.ptn.TEPTNERPSMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.fdn.FDNBuilder;
import com.huawei.nglct.util.fdn.FDNParser;
import com.huawei.nglct.util.fdn.FDNTypeEnum;
import com.huawei.nglct.util.fdn.FDNUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public final class TEE2EErpsUtil {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EErpsUtil() {
    }

    public static Set<Integer> connectSBIForNE(List<TEE2EErpsAttr> erpsAttrList) {
        String FUNC_NAME = "TEEthXCUtil.connectSBIForNE";
        TEE2ErpsLog.logFuncBegin("TEEthXCUtil.connectSBIForNE");
        HashSet<Integer> neIDSet = new HashSet<Integer>();
        if (null == erpsAttrList || erpsAttrList.isEmpty()) {
            return new HashSet<Integer>();
        }
        TEE2EErpsAttr erpsAttr = null;
        int len = erpsAttrList.size();
        for (int i = 0; i < len; ++i) {
            erpsAttr = erpsAttrList.get(i);
            neIDSet.add(erpsAttr.getNeID());
        }
        Map<Integer, Integer> neIDErrorCodeMap = TEE2EErpsUtil.connectSBIForNEImpl(neIDSet);
        TEE2EErpsAttr asnErps = null;
        int errorCode = -1;
        int len2 = erpsAttrList.size();
        for (int i = 0; i < len2; ++i) {
            asnErps = erpsAttrList.get(i);
            errorCode = neIDErrorCodeMap.get(asnErps.getNeID());
            asnErps.getPoOperResult().retCode = errorCode;
            asnErps.getPoOperResult().isSuccess = 0 == errorCode;
        }
        HashSet<Integer> normalNEIDSet = new HashSet<Integer>();
        Map.Entry<Integer, Integer> entry2 = null;
        for (Map.Entry<Integer, Integer> entry2 : neIDErrorCodeMap.entrySet()) {
            if (0 != entry2.getValue()) continue;
            normalNEIDSet.add(entry2.getKey());
        }
        return normalNEIDSet;
    }

    public static Map<Integer, Integer> connectSBIForNEImpl(Set<Integer> neIDSet) {
        HashMap<Integer, Integer> neIDErrorCodeMap = new HashMap<Integer, Integer>();
        int neID2 = -1;
        int result = -1;
        for (int neID2 : neIDSet) {
            result = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID2);
            if (0 != result) {
                TELogFactory.getE2ELogger().error("connectSBIForNEImpl: Connect to ne failed! neID->" + neID2);
            }
            neIDErrorCodeMap.put(neID2, result);
        }
        return neIDErrorCodeMap;
    }

    public static QAsnErrInfo createQAsnErrInfo(TEE2EErpsAttr dataErps) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.errCode = dataErps.getPoOperResult().retCode;
        errInfo.objName = TEE2EErpsUtil.getStrOperDesc(dataErps).getBytes();
        errInfo.objID.add((Object)dataErps.getNeID());
        errInfo.objID.add((Object)dataErps.getiERPSID());
        return errInfo;
    }

    private static String getStrOperDesc(TEE2EErpsAttr dataErps) {
        int neID = dataErps.getNeID();
        int erpsID = dataErps.getiERPSID();
        String neName = "UNKNOWN";
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne) {
            neName = ne.getNEName();
        }
        return neName + ", " + "ERPS ID:" + erpsID;
    }

    public static void setGlobalErrCode(QAsnErrInfoReturn rspErrInfoRet, boolean isAllSuccess, boolean isAllFail) {
        rspErrInfoRet.result = isAllSuccess ? 0 : (isAllFail ? 1090650122 : 1090650121);
    }

    public static SubFunc createSubFunc(int neID, int sfid) {
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e) {
            TELogFactory.getE2ELogger().error("createSubFunc: Get SubFunc fail!", (Throwable)e);
        }
        return subFunc;
    }

    public static int getErpsCodeVersion(int neID, int cmdID) {
        int version = 0;
        SubFunc subFunc = TEE2EErpsUtil.createSubFunc(neID, cmdID);
        if (null == subFunc) {
            e2eLogger.error(String.format("getErpsCodeVersion: subFunc is null! [neID:%d, slotID:%d]", neID, cmdID));
            return version;
        }
        String classMapping = subFunc.getClassMapping();
        if (null == classMapping) {
            e2eLogger.error(String.format("getErpsCodeVersion: classMapping is null! [neID:%d, slotID:%d]", neID, cmdID));
            return version;
        }
        version = -1 != classMapping.indexOf(".erps_u2kv1r8c00.") ? 2 : (-1 != classMapping.indexOf(".erps_u2kv1r6c00.") ? 1 : 0);
        e2eLogger.info("erps code version->" + version);
        return version;
    }

    public static byte[] convertToBytes(String strObj) {
        if (null == strObj) {
            return null;
        }
        return strObj.getBytes();
    }

    public static QAsnERPSInfo convertETHERPSMopotoQAsnErpsInfo(TEETHERPSMOPO dataMO, int neid) {
        QAsnERPSInfo erpsInfo = new QAsnERPSInfo();
        erpsInfo.erpsKey = TEE2EErpsUtil.constructERPSUniResID(neid, dataMO.getSlotID(), dataMO.getErpsID());
        erpsInfo.neID = neid;
        erpsInfo.slotID = dataMO.getSlotID();
        erpsInfo.erpsID = dataMO.getErpsID();
        erpsInfo.eastPortIndex = dataMO.getEastPortID() != 65535 ? TEE2EErpsUtil.constructPortUniResID(neid, erpsInfo.slotID, dataMO.getEastPortID()) : TEE2EErpsUtil.constructDefaultUniResID(neid);
        erpsInfo.westPortIndex = dataMO.getWestPortID() != 65535 ? TEE2EErpsUtil.constructPortUniResID(neid, erpsInfo.slotID, dataMO.getWestPortID()) : TEE2EErpsUtil.constructDefaultUniResID(neid);
        erpsInfo.rplNodeFlag = dataMO.getIsRplOwner();
        if (erpsInfo.rplNodeFlag == 1) {
            erpsInfo.rplPort = TEE2EErpsUtil.constructPortUniResID(neid, erpsInfo.slotID, dataMO.getRplPortID());
            erpsInfo.revertiveMode = 1;
        } else {
            erpsInfo.rplPort = TEE2EErpsUtil.constructDefaultUniResID(neid);
            erpsInfo.revertiveMode = -1;
        }
        erpsInfo.controlVlan = dataMO.getCtrlVlan();
        erpsInfo.destinationNode = TEE2EErpsUtil.convertToBytes(dataMO.getDesMacAddr());
        erpsInfo.currentNode = TEE2EErpsUtil.convertToBytes("");
        erpsInfo.virChannelSatus = -1;
        erpsInfo.virChannelVlans = "".getBytes();
        erpsInfo.majorERPSRingID = 0;
        erpsInfo.compatibleVersion = 1;
        return erpsInfo;
    }

    public static QAsnERPSInfo convertPTNERPSMopotoQAsnErpsInfo(TEPTNERPSMOPO dataMO, int neid) {
        QAsnERPSInfo erpsInfo = new QAsnERPSInfo();
        erpsInfo.erpsKey = TEE2EErpsUtil.constructERPSUniResID(neid, 0, dataMO.getErpsID());
        erpsInfo.neID = neid;
        erpsInfo.slotID = 0;
        erpsInfo.erpsID = dataMO.getErpsID();
        erpsInfo.eastPortIndex = dataMO.getEastBid() != 65535 && dataMO.getEastPortID() != 65535 ? TEE2EErpsUtil.constructPortUniResID(neid, dataMO.getEastBid(), dataMO.getEastPortID()) : TEE2EErpsUtil.constructDefaultUniResID(neid);
        erpsInfo.westPortIndex = dataMO.getWestBid() != 65535 && dataMO.getWestPortID() != 65535 ? TEE2EErpsUtil.constructPortUniResID(neid, dataMO.getWestBid(), dataMO.getWestPortID()) : TEE2EErpsUtil.constructDefaultUniResID(neid);
        erpsInfo.rplNodeFlag = dataMO.getIsRplOwner();
        erpsInfo.revertiveMode = dataMO.getRvtmode();
        erpsInfo.poEthType = dataMO.getEthType();
        erpsInfo.poLoopDetect = dataMO.getLoopDetect();
        if (erpsInfo.rplNodeFlag == 1) {
            erpsInfo.rplPort = TEE2EErpsUtil.constructPortUniResID(neid, dataMO.getRplBid(), dataMO.getRplPortID());
            if (dataMO.getCompatibleVersion() == 1) {
                erpsInfo.revertiveMode = 1;
            }
        } else {
            erpsInfo.rplPort = TEE2EErpsUtil.constructDefaultUniResID(neid);
            erpsInfo.revertiveMode = -1;
            erpsInfo.poLoopDetect = -1;
        }
        if (!TEE2EErpsUtil.isSupportLOOPDETECT(neid)) {
            erpsInfo.poLoopDetect = -1;
        }
        erpsInfo.controlVlan = dataMO.getCtrlVlan();
        erpsInfo.destinationNode = TEE2EErpsUtil.convertToBytes(dataMO.getDesNodeMacAddr());
        erpsInfo.currentNode = TEE2EErpsUtil.convertToBytes(dataMO.getCurNodeMacAddr());
        erpsInfo.virChannelSatus = dataMO.getVirChannelSatus();
        erpsInfo.virChannelVlans = null != dataMO.getVirChannelVlans() ? dataMO.getVirChannelVlans().getBytes() : "".getBytes();
        erpsInfo.majorERPSRingID = dataMO.getMajorRingID();
        if (0 != erpsInfo.majorERPSRingID) {
            erpsInfo.majorERPSKey = TEE2EErpsUtil.constructERPSUniResID(neid, 0, erpsInfo.majorERPSRingID);
        }
        erpsInfo.compatibleVersion = dataMO.getCompatibleVersion();
        if (erpsInfo.compatibleVersion == -1) {
            erpsInfo.compatibleVersion = 1;
            erpsInfo.revertiveMode = 1;
            erpsInfo.virChannelSatus = -1;
        } else if (erpsInfo.compatibleVersion == 1) {
            erpsInfo.virChannelVlans = "".getBytes();
        }
        return erpsInfo;
    }

    public static QAsnUniResID constructERPSUniResID(int neID, int slotID, int erpsID) {
        FDNBuilder builder = new FDNBuilder();
        String fdn = FDNUtil.buildFDNValue((String[])new String[]{String.valueOf(slotID), String.valueOf(erpsID)});
        builder.append(FDNTypeEnum.ERPS, fdn);
        builder.append(FDNTypeEnum.NE, neID);
        QAsnUniResID inPortID = new QAsnUniResID();
        inPortID.strFDN = TEE2EErpsUtil.convertToBytes(builder.getValue());
        inPortID.strMOC = TEE2EErpsUtil.convertToBytes("ERPS");
        inPortID.neID = neID;
        inPortID.poSerialNum = TEE2EErpsUtil.convertToBytes("");
        return inPortID;
    }

    public static QAsnUniResID constructDefaultUniResID(int neID) {
        QAsnUniResID inPortID = new QAsnUniResID();
        inPortID.strFDN = TEE2EErpsUtil.convertToBytes("");
        inPortID.strMOC = TEE2EErpsUtil.convertToBytes("");
        inPortID.neID = neID;
        inPortID.poSerialNum = TEE2EErpsUtil.convertToBytes("");
        return inPortID;
    }

    public static QAsnUniResID constructPortUniResID(int neID, int slotID, int portID) {
        FDNBuilder builder = new FDNBuilder();
        builder.append(FDNTypeEnum.NE, neID);
        if (-1 != neID) {
            int shelfID = TEBoardUtil.getSubrackIDFromSlot((int)neID, (int)slotID);
            TENE neObj = TEConfigurationDataMgr.getInstance().getNE(neID);
            if (neObj.getNEType() == 67 && neObj.getShelfType() == 153) {
                shelfID = 0;
            }
            if (-1 != shelfID) {
                builder.append(FDNTypeEnum.FRAME, shelfID);
            }
        }
        int relativeSlotID = TEBoardUtil.bigSlotToSmall((int)slotID);
        builder.append(FDNTypeEnum.SLOT, relativeSlotID);
        builder.append(FDNTypeEnum.CARD, -1);
        int portDomain = 16;
        TEBoard boardref = TEBoardConfigurationDataMgr.getInstance().getBoardRef(neID, slotID);
        if (boardref != null) {
            int portType = TEPortModelConfigurationDataMgr.getInstance().getPortType(neID, boardref.getBoardType(), portID);
            if (portType != 1799 && portType != 1802 && portType != 63213 && portType != 1025 && portType != 61005) {
                portDomain = 16;
            } else if (portType == 61005 || portType == 1025) {
                portDomain = 4;
            } else {
                portDomain = TEPortDescription.getInstance().getPortDomain(portType);
                if (portDomain == 255) {
                    portDomain = TEQueryPortForDataMgr.getCNEMgrDomainType((int)neID);
                }
            }
        }
        String fdn = FDNUtil.buildFDNValue((String[])new String[]{String.valueOf(portDomain), "", String.valueOf(portID), ""});
        builder.append(FDNTypeEnum.PORT, fdn);
        QAsnUniResID inPortID = new QAsnUniResID();
        inPortID.strFDN = TEE2EErpsUtil.convertToBytes(builder.getValue());
        inPortID.strMOC = TEE2EErpsUtil.convertToBytes("PP");
        inPortID.neID = neID;
        inPortID.poSerialNum = TEE2EErpsUtil.convertToBytes("");
        return inPortID;
    }

    public static int getSlotID(String fdn) {
        FDNParser parser = new FDNParser(fdn);
        String erps = parser.getValue(FDNTypeEnum.ERPS);
        String[] erpsinfo = FDNUtil.parseFDNValue((String)erps);
        if (erpsinfo[0].equals("")) {
            return -1;
        }
        return Integer.parseInt(erpsinfo[0]);
    }

    public static int getErpsID(String fdn) {
        FDNParser parser = new FDNParser(fdn);
        String erps = parser.getValue(FDNTypeEnum.ERPS);
        String[] erpsinfo = FDNUtil.parseFDNValue((String)erps);
        return Integer.parseInt(erpsinfo[1]);
    }

    public static boolean isSupportNEERPSV1(int neid) {
        return TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_V1");
    }

    public static boolean isSupportNEERPSV2(int neid) {
        return TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_V2");
    }

    public static boolean isSupportNEERPSV1_5(int neid) {
        return TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_V1.5");
    }

    public static boolean isSupportLOOPDETECT(int neid) {
        return TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_LOOPDETECT");
    }

    public static boolean isSupportBoardLOOPDETECT(int neid, int slotId) {
        return TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_LOOPDETECT");
    }

    public static boolean isSupportETHERPS(int neid) {
        return TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_ETH_ERPS", "TE_ATTR_ERPS_SUPPORT_V1");
    }

    public static boolean isSupportBoardERPS(int neid, int slotId) {
        return TESpecialAttrMgr.getInstance().isCPSupport(neid, slotId, "TE_FUNC_ERPS", "TE_ATTR_ERPS_SUPPORT_BAORD");
    }

    public static ArrayList parseValidValue(String s) {
        ArrayList<Integer> valueList = new ArrayList<Integer>();
        if (s == null || s.equals("")) {
            return valueList;
        }
        int cur = -1;
        int last = -1;
        char[] ch = s.toCharArray();
        if (ch.length == 0) {
            return valueList;
        }
        int strLength = ch.length;
        for (int i = 0; i <= strLength; ++i) {
            if (i == strLength || ch[i] == ',') {
                if (TEE2EErpsUtil.isAvailableValue(last, cur)) {
                    int min = last;
                    int max = cur;
                    if (last > cur) {
                        min = cur;
                        max = last;
                    }
                    for (int j = min; j <= max; ++j) {
                        valueList.add(j);
                    }
                } else if (cur != -1) {
                    valueList.add(cur);
                } else if (last != -1) {
                    valueList.add(last);
                } else {
                    return valueList;
                }
                last = -1;
                cur = -1;
                continue;
            }
            if (ch[i] == '-') {
                if (!TEE2EErpsUtil.isAppointedValue(last, cur)) {
                    return valueList;
                }
                last = cur;
                cur = -1;
                continue;
            }
            if (ch[i] >= '0' && ch[i] <= '9') {
                if (cur == -1) {
                    cur = 0;
                }
                cur = cur * 10 + (ch[i] - 48);
                continue;
            }
            return valueList;
        }
        return valueList;
    }

    public static String getStringFromSequenceOfInt(List<Integer> src) {
        if (src != null) {
            Collections.sort(src);
            StringBuffer result = new StringBuffer();
            boolean bneedAddDelim = false;
            int start = 0;
            int end = 0;
            int startTemp = 0;
            int endTemp = 0;
            int endTempX = 0;
            int size = src.size();
            while (start != end || start != size) {
                endTempX = src.get(++end - 1);
                startTemp = src.get(start);
                if (end < src.size() && (endTemp = src.get(end).intValue()) - endTempX == 1) continue;
                if (bneedAddDelim) {
                    result.append(',');
                }
                if (start == end - 1) {
                    result.append(startTemp);
                } else {
                    result.append(startTemp).append('-').append(endTempX);
                }
                bneedAddDelim = true;
                start = end;
            }
            return result.toString();
        }
        return "";
    }

    private static boolean isAvailableValue(int last, int cur) {
        return last != -1 && cur != -1;
    }

    private static boolean isAppointedValue(int last, int cur) {
        return last == -1 && cur != -1;
    }
}

