/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_nativeethsrv_model.QAsnERPSAttr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.model.TEE2EErpsAttr;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.fdn.TEE2EUniResID;
import java.util.ArrayList;
import java.util.List;

public final class TEE2EErpsConverter {
    private TEE2EErpsConverter() {
    }

    public static TEE2EErpsAttr convertErpsAttr(QAsnERPSAttr asnErps) {
        TEE2EErpsAttr dataErps = new TEE2EErpsAttr();
        dataErps.setNeID(asnErps.neID);
        dataErps.setiERPSID(asnErps.iERPSID);
        dataErps.setEastPortIndex(TEE2EErpsConverter.asn2Data(asnErps.eastPortIndex));
        dataErps.setWestPortIndex(TEE2EErpsConverter.asn2Data(asnErps.westPortIndex));
        dataErps.setiIsRPLOwner(asnErps.iIsRPLOwner);
        dataErps.setiCtrlVlan(asnErps.iCtrlVlan);
        dataErps.setiHoldOffTime(asnErps.iHoldOffTime);
        dataErps.setiGuardTime(asnErps.iGuardTime);
        dataErps.setiPktTrsInterval(asnErps.iPktTrsInterval);
        dataErps.setiEntityLevel(asnErps.iEntityLevel);
        dataErps.setPoWtrTime(TEE2EErpsConverter.convertInteger(asnErps.poWtrTime));
        if (1 == asnErps.iIsRPLOwner) {
            dataErps.setPoRPLPortIndex(TEE2EErpsConverter.asn2Data(asnErps.poRPLPortIndex));
        }
        if (null != asnErps.poOperResult) {
            dataErps.setPoOperResult(asnErps.poOperResult);
        }
        dataErps.setPoLastSwitchReq(TEE2EErpsConverter.convertInteger(asnErps.poLastSwitchReq));
        dataErps.setPoRBStatus(TEE2EErpsConverter.convertInteger(asnErps.poRBStatus));
        dataErps.setPoDNFStatus(TEE2EErpsConverter.convertInteger(asnErps.poDNFStatus));
        dataErps.setPoStateMachineStatus(TEE2EErpsConverter.convertInteger(asnErps.poStateMachineStatus));
        dataErps.setPoEstPortStatus(TEE2EErpsConverter.convertInteger(asnErps.poEstPortStatus));
        dataErps.setPoWstPortStatus(TEE2EErpsConverter.convertInteger(asnErps.poWstPortStatus));
        dataErps.setPoNECarriedWithCurPckt(TEE2EErpsConverter.getStr(asnErps.poNECarriedWithCurPckt));
        String poDesNodeMacAddr = TEE2EErpsConverter.getStr(asnErps.poDesNodeMacAddr);
        if (!poDesNodeMacAddr.isEmpty()) {
            dataErps.setPoDesNodeMacAddr(poDesNodeMacAddr);
        }
        dataErps.setPoCurNodeMacAddr(TEE2EErpsConverter.getStr(asnErps.poCurNodeMacAddr));
        return dataErps;
    }

    private static int convertInteger(Integer value) {
        return value == null ? -1 : value;
    }

    public static QAsnERPSAttr convertErpsAttr(TEE2EErpsAttr dataErps) {
        QAsnERPSAttr asnErps = new QAsnERPSAttr();
        asnErps.neID = dataErps.getNeID();
        asnErps.iERPSID = dataErps.getiERPSID();
        asnErps.eastPortIndex = TEE2EErpsConverter.data2Asn(dataErps.getEastPortIndex());
        asnErps.westPortIndex = TEE2EErpsConverter.data2Asn(dataErps.getWestPortIndex());
        asnErps.iIsRPLOwner = dataErps.getiIsRPLOwner();
        asnErps.iCtrlVlan = dataErps.getiCtrlVlan();
        asnErps.iHoldOffTime = dataErps.getiHoldOffTime();
        asnErps.iGuardTime = dataErps.getiGuardTime();
        asnErps.iPktTrsInterval = dataErps.getiPktTrsInterval();
        asnErps.iEntityLevel = dataErps.getiEntityLevel();
        asnErps.poWtrTime = dataErps.getPoWtrTime();
        asnErps.poRPLPortIndex = TEE2EErpsConverter.data2Asn(dataErps.getPoRPLPortIndex());
        asnErps.poOperResult = dataErps.getPoOperResult();
        asnErps.poLastSwitchReq = dataErps.getPoLastSwitchReq();
        asnErps.poRBStatus = dataErps.getPoRBStatus();
        asnErps.poDNFStatus = dataErps.getPoDNFStatus();
        asnErps.poStateMachineStatus = dataErps.getPoStateMachineStatus();
        asnErps.poEstPortStatus = dataErps.getPoEstPortStatus();
        asnErps.poWstPortStatus = dataErps.getPoWstPortStatus();
        asnErps.poNECarriedWithCurPckt = TEE2EErpsConverter.convertToBytes(dataErps.getPoNECarriedWithCurPckt());
        asnErps.poDesNodeMacAddr = TEE2EErpsConverter.convertToBytes(dataErps.getPoDesNodeMacAddr());
        asnErps.poCurNodeMacAddr = TEE2EErpsConverter.convertToBytes(dataErps.getPoCurNodeMacAddr());
        return asnErps;
    }

    private static byte[] convertToBytes(String strObj) {
        if (null == strObj) {
            return null;
        }
        return strObj.getBytes();
    }

    private static TEE2EUniResID asn2Data(QAsnUniResID asnResID) {
        TEE2EUniResID resID = new TEE2EUniResID();
        resID.setNeID(asnResID.neID);
        resID.setStrFDN(TEE2EErpsConverter.getStr(asnResID.strFDN));
        resID.setStrMOC(TEE2EErpsConverter.getStr(asnResID.strMOC));
        resID.setPoSerialNum(TEE2EErpsConverter.getStr(asnResID.poSerialNum));
        return resID;
    }

    private static String getStr(byte[] byteArr) {
        if (null == byteArr || 0 == byteArr.length) {
            return "";
        }
        return new String(byteArr);
    }

    public static List<QAsnErrInfo> data2AsnErrInfo(List<TEErrInfo> errList) {
        ArrayList<QAsnErrInfo> asnErrList = new ArrayList<QAsnErrInfo>();
        if (null == errList) {
            return asnErrList;
        }
        for (TEErrInfo errInfo : errList) {
            asnErrList.add(TEE2EErpsConverter.data2Asn(errInfo));
        }
        return asnErrList;
    }

    private static QAsnUniResID data2Asn(TEE2EUniResID asnResID) {
        if (null == asnResID || -1 == asnResID.getNeID()) {
            return null;
        }
        QAsnUniResID uniResID = new QAsnUniResID();
        uniResID.strFDN = asnResID.getStrFDN().getBytes();
        uniResID.strMOC = asnResID.getStrMOC().getBytes();
        uniResID.neID = asnResID.getNeID();
        uniResID.poSerialNum = asnResID.getPoSerialNum().getBytes();
        return uniResID;
    }

    public static QAsnErrInfo data2Asn(TEErrInfo errInfo) {
        QAsnErrInfo asnErr = new QAsnErrInfo();
        asnErr.objID.add((Object)errInfo.getObjID());
        asnErr.errCode = errInfo.getErrorCode();
        asnErr.objName = null != errInfo.getObjName() ? errInfo.getObjName().getBytes() : "".getBytes();
        asnErr.strOperDesc = null != errInfo.getStrOperDesc() ? errInfo.getStrOperDesc().getBytes() : "".getBytes();
        return asnErr;
    }
}

