/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.erps;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsUtil;
import com.huawei.nglct.nemgr.q_interface.common.QAsnErrInfo;
import com.huawei.nglct.nemgr.q_interface.common.QAsnErrInfoList;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnERPSIndex;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnERPSSwitch;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnSetERPSInsSwitchReq;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnSetERPSInsSwitchRsp;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EErpsSetInsSwitchHandler
extends TEWNEMgrHandler {
    private static final Logger LOG = TELogFactory.getE2ELogger();
    private String userID;
    QAsnErrInfoList errList = new QAsnErrInfoList();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        TELogFactory.getE2ELogger().info("handleRequestImpl: handle QAsnSetERPSInsSwitchReq begin.");
        QAsnSetERPSInsSwitchReq req = (QAsnSetERPSInsSwitchReq)qReq;
        QAsnSetERPSInsSwitchRsp rsp = (QAsnSetERPSInsSwitchRsp)qRsp;
        rsp.result.errList = new QAsnErrInfoList();
        this.userID = String.valueOf(req.userID);
        boolean succ = false;
        rsp.erpsSwitchList.clear();
        rsp.result.result = 0;
        if (req.erpsSwitchList.isEmpty()) {
            TELogFactory.getE2ELogger().info("handleRequestImpl: QAsnSetERPSInsSwitchReq.erpsSwitchList is empty!");
            return 0;
        }
        int len = req.erpsSwitchList.size();
        for (int i = 0; i < len; ++i) {
            int erpsID;
            QAsnERPSSwitch erpsswitch = (QAsnERPSSwitch)req.erpsSwitchList.get(i);
            QAsnERPSIndex erpsindex = erpsswitch.erpsIndex;
            int erpsSwitchType = erpsswitch.erpsSwitchType;
            int neID = erpsindex.erpsKey.neID;
            int slotID = TEE2EErpsUtil.getSlotID(new String(erpsindex.erpsKey.strFDN));
            int result = this.switchErps(neID, slotID, erpsID = TEE2EErpsUtil.getErpsID(new String(erpsindex.erpsKey.strFDN)), erpsSwitchType);
            if (result != 0) continue;
            succ = true;
            rsp.erpsSwitchList.add((Object)erpsswitch);
        }
        if (this.errList.size() > 0) {
            rsp.result.errList = this.errList;
            rsp.result.result = !succ ? 1090650122 : 1090650121;
        }
        TELogFactory.getE2ELogger().info("handleRequestImpl: handle QAsnSetERPSInsSwitchReq end.");
        return 0;
    }

    private int switchErps(int neID, int slotid, int erpsID, int switchtype) {
        int err = 0;
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rowParam3 = new RowParams();
        bus.addRowParams(rowParam3);
        Param p = null;
        p = new Param("neid", String.valueOf(neID));
        rowParam3.addParam(p);
        p = new Param("slotid", String.valueOf(slotid));
        rowParam3.addParam(p);
        p = new Param("erpsid", String.valueOf(erpsID));
        rowParam3.addParam(p);
        p = new Param("switchtype", String.valueOf(switchtype));
        rowParam3.addParam(p);
        int sfid = 2179961;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            LOG.info("handleRequestImpl:get subFunc fail.");
        }
        if (null == subFunc) {
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.objID.add(neID);
            errInfo.errCode = 40921;
            this.errList.add((Object)errInfo);
            return 2;
        }
        String classMapping = subFunc.getClassMapping();
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = classMapping == null ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(classMapping).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("neMgrBean", (Throwable)e);
        }
        Datainterface allData = null;
        if (null != neMgrBean && 0 != (err = Integer.parseInt((allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, this.userID, null)).getErrorMessage().getErrorcode())) && null != allData.getBussinessParams() && allData.getBussinessParams().getRowParamsCount() > 0) {
            int len = allData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                RowParams vRowParams = allData.getBussinessParams().getRowParams(i);
                int jLen = vRowParams.getRowErrorsCount();
                for (int j = 0; j < jLen; ++j) {
                    RowErrors vRowError = vRowParams.getRowErrors(j);
                    ErrorMessage errorMessage = vRowError.getErrorMessage();
                    if (null == errorMessage.getErrorcode() || "".equals(errorMessage.getErrorcode())) continue;
                    QAsnErrInfo errInfo = new QAsnErrInfo();
                    errInfo.objID.add(neID);
                    errInfo.errCode = Integer.parseInt(errorMessage.getErrorcode());
                    errInfo.strOperDesc = errorMessage.getErrorinfo().getBytes();
                    this.errList.add((Object)errInfo);
                }
            }
        }
        return err;
    }
}

