/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.erps;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSIndex;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSVlanSwitchTable;
import com.huawei.network.qasn.m_q_nml_erps.QAsnGetERPSVlanSwitchTableReq;
import com.huawei.network.qasn.m_q_nml_erps.QAsnGetERPSVlanSwitchTableRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginIF;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsUtil;
import com.huawei.nglct.nemgr.q_interface.e2e.QAsnUniResID;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EErpsGetVlanSwitchTableHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private QAsnErrInfoList errList = new QAsnErrInfoList();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        e2eLogger.info("handleRequestImpl: handle QAsnGetERPSVlanSwitchTableReq begin.");
        QAsnGetERPSVlanSwitchTableReq req = (QAsnGetERPSVlanSwitchTableReq)qReq;
        QAsnGetERPSVlanSwitchTableRsp rsp = (QAsnGetERPSVlanSwitchTableRsp)qRsp;
        rsp.vlanSwitchTable.clear();
        rsp.result.result = 0;
        if (req == null || req.erpsKeyList.isEmpty()) {
            e2eLogger.info("handleRequestImpl: QAsnGetERPSVlanSwitchTableReq.erpsKeyList is empty!");
            return 0;
        }
        int size = req.erpsKeyList.size();
        for (int i = 0; i < size; ++i) {
            QAsnERPSIndex erpsIndex = (QAsnERPSIndex)req.erpsKeyList.get(i);
            int neid = erpsIndex.erpsKey.neID;
            int erpsid = TEE2EErpsUtil.getErpsID(new String(erpsIndex.erpsKey.strFDN));
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            if (null == ne) {
                QAsnErrInfo errInfo = new QAsnErrInfo();
                errInfo.objID.add((Object)neid);
                errInfo.errCode = 1090596385;
                this.errList.add((Object)errInfo);
                e2eLogger.info("The neid " + neid + "is not exist!");
                continue;
            }
            int colresult = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neid);
            if (colresult != 0) {
                QAsnErrInfo errInfo = new QAsnErrInfo();
                errInfo.objID.add((Object)neid);
                errInfo.errCode = colresult;
                this.errList.add((Object)errInfo);
                e2eLogger.info("The neid " + neid + " connect failed!");
                continue;
            }
            List<QAsnERPSVlanSwitchTable> switchTableList = this.getErpsVlanSwitch(neid, erpsid, erpsIndex);
            rsp.vlanSwitchTable.addAll(switchTableList);
        }
        if (this.errList.size() > 0) {
            rsp.result.errList = this.errList;
            rsp.result.result = 1090650122;
        }
        e2eLogger.info("handleRequestImpl: handle QAsnGetERPSVlanSwitchTableReq end.");
        return 0;
    }

    private List<QAsnERPSVlanSwitchTable> getErpsVlanSwitch(int neID, int erpsID, QAsnERPSIndex erpsIndex) {
        ArrayList<QAsnERPSVlanSwitchTable> result = new ArrayList<QAsnERPSVlanSwitchTable>();
        int err = 0;
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rowParam = new RowParams();
        bus.addRowParams(rowParam);
        Param p = null;
        p = new Param("neid", String.valueOf(neID));
        rowParam.addParam(p);
        p = new Param("erpsid", String.valueOf(erpsID));
        rowParam.addParam(p);
        int sfid = 2180213;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            TELogFactory.getE2ELogger().info(e1.getMessage());
        }
        if (null == subFunc) {
            return result;
        }
        subFunc.setBeanPlugin(null);
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = null == subFunc.getClassMapping() ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(subFunc.getClassMapping()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        Datainterface allData = null;
        if (null != neMgrBean) {
            TEE2EErpsGetVlanSwitchTableHandler.setBeanPlugin(neMgrBean, subFunc);
            allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, null, null);
            err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 == err && null != allData.getBussinessParams() && allData.getBussinessParams().getRowParamsCount() > 0) {
                int len = allData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    Param mastervirtualVlanIDParam;
                    Param virtualVlanIDParam;
                    QAsnERPSVlanSwitchTable switchTable = new QAsnERPSVlanSwitchTable();
                    int mastererpsid = 0;
                    RowParams vRowParams = allData.getBussinessParams().getRowParams(i);
                    switchTable.subErpsKey = erpsIndex;
                    Param masterErpsIdParam = vRowParams.getParam("mastererpsid");
                    if (null != masterErpsIdParam && null != masterErpsIdParam.getValue() && !"".equals(masterErpsIdParam.getValue())) {
                        mastererpsid = Integer.parseInt(masterErpsIdParam.getValue());
                        QAsnUniResID uniResID = TEE2EErpsUtil.constructERPSUniResID(neID, 0, mastererpsid);
                        switchTable.mainErpsKey.erpsKey.strFDN = new String(uniResID.strFDN).getBytes();
                        switchTable.mainErpsKey.erpsKey.strMOC = new String(uniResID.strMOC).getBytes();
                        switchTable.mainErpsKey.erpsKey.neID = neID;
                        switchTable.mainErpsKey.neID = neID;
                        switchTable.mainErpsKey.slotID = 0;
                        switchTable.mainErpsKey.erpsID = BigInteger.valueOf(mastererpsid);
                        switchTable.mainErpsKey.erpsKey.poSerialNum = new String(uniResID.poSerialNum).getBytes();
                    }
                    if (null != (virtualVlanIDParam = vRowParams.getParam("virtualVlanID")) && null != virtualVlanIDParam.getValue() && !"".equals(virtualVlanIDParam.getValue())) {
                        switchTable.subVlan = BigInteger.valueOf(Integer.parseInt(virtualVlanIDParam.getValue()));
                    }
                    if (null != (mastervirtualVlanIDParam = vRowParams.getParam("mastervirtualVlanID")) && null != mastervirtualVlanIDParam.getValue() && !"".equals(mastervirtualVlanIDParam.getValue())) {
                        switchTable.mainVlan = BigInteger.valueOf(Integer.parseInt(mastervirtualVlanIDParam.getValue()));
                    }
                    result.add(switchTable);
                }
            }
        }
        return result;
    }

    private static void setBeanPlugin(TENEMgrInterface neMgrBean, SubFunc subFunc) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        String beanPluginStr = subFunc.getBeanPlugin();
        if (null == beanPluginStr || beanPluginStr.isEmpty()) {
            return;
        }
        try {
            if (neMgrBean instanceof TENEExplorerBean) {
                TENEExplorerBean bean = (TENEExplorerBean)neMgrBean;
                TEBeanPluginIF beanPlugin = TEE2EErpsGetVlanSwitchTableHandler.praseBeanPlugin(beanPluginStr);
                bean.setBeanPluginIF(beanPlugin);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Bean Plugin init fail: " + beanPluginStr, (Throwable)e);
        }
    }

    private static TEBeanPluginIF praseBeanPlugin(String beanPluginStr) {
        TEBeanPluginIF beanPlugin = null;
        try {
            beanPlugin = (TEBeanPluginIF)Class.forName(beanPluginStr.trim()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Bean Plugin init fail: " + beanPluginStr, (Throwable)e);
        }
        return beanPlugin;
    }
}

