/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.erps;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnNameAndValueString;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSGetPortResReq;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSGetPortResRsp;
import com.huawei.network.qasn.m_q_nml_erps.QAsnErpsPortInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsUtil;
import com.huawei.nglct.nemgr.q_interface.e2e.QAsnUniResID;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EErpsGetPortResHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static final int ERPS_NELEVEL = 1;
    private static final int ERPS_BOARDLEVEL = 2;
    private static final int ERPS_VERSION_1 = 1;
    private static final int ERPS_VERSION_2 = 2;
    private static final int ERPS_SUPPORT_NOT_RPL = 0;
    private static final int ERPS_SUPPORT_RPL = 1;
    private static final int ERPS_SUPPORT_NEIGHBORLY = 2;
    private static final int ERPS_SUPPORT_NEXT_NEIGHBORLY = 3;
    private static final int ERPS_SUPPORT_LOOPDETECT = 1;
    private static final int ERPS_NOT_SUPPORT_LOOPDETECT = 0;
    private static final int ERPS_WTR_TIME_MIN_1 = 5;
    private static final int ERPS_WTR_TIME_MIN_2 = 1;
    private static final int ERPS_WTR_TIME_MAX = 12;
    private static final int ERPS_GUARD_TIME_MIN = 10;
    private static final int ERPS_GUARD_TIME_MAX_1 = 2000;
    private static final int ERPS_GUARD_TIME_MAX_2 = 10000;
    private static final int ERPS_GUARD_TIME_STEP_LEN = 10;
    private static final int ERPS_HOLDOFF_TIME_MIN = 0;
    private static final int ERPS_HOLDOFF_TIME_MAX = 10000;
    private static final int ERPS_HOLDOFF_TIME_STEP_LEN = 100;
    private static final int ERPS_SEND_INTERVAL_MIN = 1;
    private static final int ERPS_SEND_INTERVAL_MAX = 10;

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        e2eLogger.info("handleRequestImpl: handle QAsnERPSGetPortResReq begin.");
        QAsnErrInfoList errList = new QAsnErrInfoList();
        QAsnERPSGetPortResReq req = (QAsnERPSGetPortResReq)qReq;
        QAsnERPSGetPortResRsp rsp = (QAsnERPSGetPortResRsp)qRsp;
        rsp.portIndexList.clear();
        rsp.result.result = 0;
        if (req == null || req.neIDList.isEmpty()) {
            e2eLogger.info("handleRequestImpl: QAsnERPSGetPortResReq.neIDList is empty!");
            return 0;
        }
        int size = req.neIDList.size();
        for (int i = 0; i < size; ++i) {
            int neid = Integer.parseInt(String.valueOf(req.neIDList.get(i)));
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            if (null == ne) {
                QAsnErrInfo errInfo = new QAsnErrInfo();
                errInfo.objID.add((Object)neid);
                errInfo.errCode = 1090596385;
                errList.add((Object)errInfo);
                e2eLogger.info("The neid " + neid + "is not exist!");
                continue;
            }
            int colresult = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neid);
            if (colresult != 0) {
                QAsnErrInfo errInfo = new QAsnErrInfo();
                errInfo.objID.add((Object)neid);
                errInfo.errCode = colresult;
                errList.add((Object)errInfo);
                e2eLogger.info("The neid " + neid + "can not connect!");
                continue;
            }
            Vector boardList = TENEListMgr.getInstance().getNE(neid).getBoardList();
            Collections.sort(boardList);
            int sizeTemp = boardList.size();
            for (int j = 0; j < sizeTemp; ++j) {
                TEBoard board = (TEBoard)boardList.get(j);
                if (!this.isETHERPS(neid, board.getSlotID())) continue;
                rsp.portIndexList.addAll(this.getETHPortRes(neid, board.getSlotID()));
            }
            rsp.portIndexList.addAll(this.getPortRes(neid));
        }
        if (errList.size() > 0) {
            rsp.result.errList = errList;
            rsp.result.result = 1090650122;
        }
        e2eLogger.info("handleRequestImpl: handle QAsnERPSGetPortResReq end.");
        return 0;
    }

    private List<QAsnErpsPortInfo> getPortRes(int neID) {
        ArrayList<QAsnErpsPortInfo> result = new ArrayList<QAsnErpsPortInfo>();
        int err = 0;
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rowParam = new RowParams();
        bus.addRowParams(rowParam);
        Param p = null;
        p = new Param("neid", String.valueOf(neID));
        rowParam.addParam(p);
        int sfid = 2179960;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            TELogFactory.getE2ELogger().info(e1.getMessage());
        }
        if (null == subFunc) {
            return result;
        }
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = null == subFunc.getClassMapping() ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(subFunc.getClassMapping()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        Datainterface allData = null;
        if (null != neMgrBean && 0 == (err = Integer.valueOf((allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, null, null)).getErrorMessage().getErrorcode()).intValue()) && null != allData.getBussinessParams() && allData.getBussinessParams().getRowParamsCount() > 0) {
            int len = allData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                QAsnErpsPortInfo portInfo = new QAsnErpsPortInfo();
                portInfo.poExAttrList = new QAsnNVSList();
                RowParams vRowParams = allData.getBussinessParams().getRowParams(i);
                Param slotIDParam = vRowParams.getParam("slotid");
                if (null != slotIDParam && null != slotIDParam.getValue() && !"".equals(slotIDParam.getValue())) {
                    portInfo.slotID = Integer.parseInt(slotIDParam.getValue());
                }
                QAsnNameAndValueString nameValue = new QAsnNameAndValueString();
                nameValue.name = "loopdetect".getBytes();
                nameValue.value = this.isSupportLoopDetect(neID, portInfo.slotID) ? String.valueOf(1).getBytes() : String.valueOf(0).getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "wtrtime".getBytes();
                String value = "1-12";
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "guardtime".getBytes();
                value = "10-10000";
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "guardtimestep".getBytes();
                value = String.valueOf(10);
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "holdofftime".getBytes();
                value = "0-10000";
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "holdofftimestep".getBytes();
                value = String.valueOf(100);
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "sendinterval".getBytes();
                value = "1-10";
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "erpsnodeflag".getBytes();
                value = "0,1";
                if (this.isSupportV2(neID) && !this.isSupportV1_5(neID)) {
                    value = value + "," + 2 + "," + 3;
                }
                nameValue.value = String.valueOf(value).getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                portInfo.erpsLevel = BigInteger.valueOf(1L);
                portInfo.version = this.isSupportV2(neID) ? BigInteger.valueOf(2L) : BigInteger.valueOf(1L);
                int portId = 0;
                Param portIDParam = vRowParams.getParam("portid");
                if (null != portIDParam && null != portIDParam.getValue() && !"".equals(portIDParam.getValue())) {
                    portId = Integer.parseInt(portIDParam.getValue());
                }
                QAsnUniResID uniResID = TEE2EErpsUtil.constructPortUniResID(neID, portInfo.slotID, portId);
                portInfo.portKey.strFDN = uniResID.strFDN;
                portInfo.portKey.strMOC = uniResID.strMOC;
                portInfo.portKey.neID = neID;
                portInfo.portKey.poSerialNum = uniResID.poSerialNum;
                result.add(portInfo);
            }
        }
        return result;
    }

    private List<QAsnErpsPortInfo> getETHPortRes(int neID, int slotId) {
        ArrayList<QAsnErpsPortInfo> result = new ArrayList<QAsnErpsPortInfo>();
        int err = 0;
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rowParam = new RowParams();
        bus.addRowParams(rowParam);
        Param p = null;
        p = new Param("neid", String.valueOf(neID));
        rowParam.addParam(p);
        p = new Param("slotid", String.valueOf(slotId));
        rowParam.addParam(p);
        int sfid = 2172669;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            TELogFactory.getE2ELogger().info(e1.getMessage());
        }
        if (null == subFunc) {
            return result;
        }
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = null == subFunc.getClassMapping() ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(subFunc.getClassMapping()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        Datainterface allData = null;
        if (null != neMgrBean && 0 == (err = Integer.valueOf((allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, null, null)).getErrorMessage().getErrorcode()).intValue()) && null != allData.getBussinessParams() && allData.getBussinessParams().getRowParamsCount() > 0) {
            int len = allData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                QAsnErpsPortInfo portInfo = new QAsnErpsPortInfo();
                portInfo.poExAttrList = new QAsnNVSList();
                portInfo.slotID = slotId;
                RowParams vRowParams = allData.getBussinessParams().getRowParams(i);
                portInfo.erpsLevel = BigInteger.valueOf(2L);
                portInfo.version = BigInteger.valueOf(1L);
                QAsnNameAndValueString nameValue = new QAsnNameAndValueString();
                nameValue.name = "loopdetect".getBytes();
                nameValue.value = String.valueOf(0).getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "wtrtime".getBytes();
                String value = "5-12";
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "guardtime".getBytes();
                value = "10-2000";
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "guardtimestep".getBytes();
                value = String.valueOf(10);
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "holdofftime".getBytes();
                value = "0-10000";
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "holdofftimestep".getBytes();
                value = String.valueOf(100);
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "sendinterval".getBytes();
                value = "1-10";
                nameValue.value = value.getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                nameValue = new QAsnNameAndValueString();
                nameValue.name = "erpsnodeflag".getBytes();
                value = "0,1";
                nameValue.value = String.valueOf(value).getBytes();
                portInfo.poExAttrList.add((Object)nameValue);
                int portId = 0;
                Param portIDParam = vRowParams.getParam("portid");
                if (null != portIDParam && null != portIDParam.getValue() && !"".equals(portIDParam.getValue())) {
                    portId = Integer.parseInt(portIDParam.getValue());
                }
                QAsnUniResID uniResID = TEE2EErpsUtil.constructPortUniResID(neID, portInfo.slotID, portId);
                portInfo.portKey.strFDN = uniResID.strFDN;
                portInfo.portKey.strMOC = uniResID.strMOC;
                portInfo.portKey.neID = neID;
                portInfo.portKey.poSerialNum = uniResID.poSerialNum;
                result.add(portInfo);
            }
        }
        return result;
    }

    private boolean isETHERPS(int neId, int slotId) {
        return TEE2EErpsUtil.isSupportBoardERPS(neId, slotId);
    }

    private boolean isSupportV2(int neId) {
        return TEE2EErpsUtil.isSupportNEERPSV2(neId);
    }

    private boolean isSupportV1_5(int neId) {
        return TEE2EErpsUtil.isSupportNEERPSV1_5(neId);
    }

    private boolean isSupportLoopDetect(int neId, int slotId) {
        if (TEE2EErpsUtil.isSupportBoardERPS(neId, slotId)) {
            return TEE2EErpsUtil.isSupportBoardLOOPDETECT(neId, slotId);
        }
        return TEE2EErpsUtil.isSupportLOOPDETECT(neId);
    }
}

