/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.erps;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnNameAndValueString;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginIF;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsUtil;
import com.huawei.nglct.nemgr.ip.ptn.erps.beanplugin.TENEERPSBeanPluginUtil;
import com.huawei.nglct.nemgr.ip.ptn.erps.beanplugin.otn.TEETHERPSBeanPluginUtil;
import com.huawei.nglct.nemgr.q_interface.common.QAsnNVSList;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnERPSDetail;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnERPSIndex;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnGetERPSInsDetailsReq;
import com.huawei.nglct.nemgr.q_interface.erps.QAsnGetERPSInsDetailsRsp;
import com.huawei.nglct.po.embeddednemgrmo.TEETHERPSMOPO;
import com.huawei.nglct.po.embeddednemgrmo.ptn.TEPTNERPSMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EErpsGetInsDetailsHandler
extends TEWNEMgrHandler {
    private static final Logger LOG = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        LOG.info("handleRequestImpl: handle QAsnGetERPSInsDetailsReq begin.");
        QAsnGetERPSInsDetailsReq req = (QAsnGetERPSInsDetailsReq)qReq;
        QAsnGetERPSInsDetailsRsp rsp = (QAsnGetERPSInsDetailsRsp)qRsp;
        rsp.result.result = 0;
        if (req == null || req.erpsIndexList.isEmpty()) {
            LOG.info("handleRequestImpl:req.erpsIndexList is empty.");
            return 0;
        }
        int size = req.erpsIndexList.size();
        for (int i = 0; i < size; ++i) {
            QAsnERPSDetail erpsInfo;
            TEPTNERPSMOPO dataMO;
            int j;
            List dbDataList;
            QAsnERPSIndex index = (QAsnERPSIndex)req.erpsIndexList.get(i);
            int neid = index.neID;
            QAsnERPSDetail erpsDetailInfo = new QAsnERPSDetail();
            erpsDetailInfo.erpsKey = index.erpsKey;
            erpsDetailInfo.poExAttrList = new QAsnNVSList();
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            if (null == ne) {
                QAsnNameAndValueString nameValue = new QAsnNameAndValueString();
                nameValue.name = "errorcode".getBytes();
                nameValue.value = String.valueOf(1090596385).getBytes();
                rsp.erpsDetailList.add((Object)erpsDetailInfo);
                continue;
            }
            int colresult = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neid);
            if (colresult != 0) {
                QAsnNameAndValueString nameValue = new QAsnNameAndValueString();
                nameValue.name = "errorcode".getBytes();
                nameValue.value = String.valueOf(1090596385).getBytes();
                rsp.erpsDetailList.add((Object)erpsDetailInfo);
                continue;
            }
            int slotid = TEE2EErpsUtil.getSlotID(new String(index.erpsKey.strFDN));
            int erpsid = TEE2EErpsUtil.getErpsID(new String(index.erpsKey.strFDN));
            TEDaoOperationResult dbResult = null;
            if (slotid != 0) {
                this.sendGetCPERPSDetailsReq(neid, slotid, erpsid);
                dbResult = TEETHERPSBeanPluginUtil.findNEERpsFromDB(neid, slotid);
                if (dbResult == null || dbResult.getResult() != 0) continue;
                dbDataList = dbResult.getData();
                int size1 = dbDataList.size();
                for (j = 0; j < size1; ++j) {
                    dataMO = (TEETHERPSMOPO)dbDataList.get(j);
                    if (erpsid != dataMO.getErpsID()) continue;
                    erpsInfo = this.convertMopotoInfo((TEETHERPSMOPO)dataMO, neid);
                    rsp.erpsDetailList.add((Object)erpsInfo);
                }
                continue;
            }
            this.sendGetNEERPSDetailsReq(neid, erpsid);
            dbResult = TENEERPSBeanPluginUtil.findNEERpsFromDB(neid);
            if (dbResult == null || dbResult.getResult() != 0) continue;
            dbDataList = dbResult.getData();
            int count = dbDataList.size();
            for (j = 0; j < count; ++j) {
                dataMO = (TEPTNERPSMOPO)dbDataList.get(j);
                if (erpsid != dataMO.getErpsID()) continue;
                erpsInfo = this.convertPTNERPSMopotoInfo(dataMO, neid);
                rsp.erpsDetailList.add((Object)erpsInfo);
            }
        }
        LOG.info("handleRequestImpl: handle QAsnGetERPSInsDetailsReq end.");
        return 0;
    }

    private QAsnERPSDetail convertMopotoInfo(TEETHERPSMOPO dataMO, int neid) {
        QAsnERPSDetail erpsInfo = new QAsnERPSDetail();
        erpsInfo.erpsKey = TEE2EErpsUtil.constructERPSUniResID(neid, dataMO.getSlotID(), dataMO.getErpsID());
        erpsInfo.neID = neid;
        erpsInfo.slotID = dataMO.getSlotID();
        erpsInfo.erpsID = dataMO.getErpsID();
        erpsInfo.holdOffTime = dataMO.getHoldOffTime();
        erpsInfo.wrtTime = dataMO.getWtrTime();
        erpsInfo.guardTime = dataMO.getGuardTime();
        erpsInfo.packetTranInterval = dataMO.getPktTrsInterval();
        erpsInfo.entityLevel = dataMO.getEntityLevel();
        erpsInfo.lastSwitchRequest = dataMO.getLastSwitchReq();
        erpsInfo.rbStatus = dataMO.getRBStatus();
        erpsInfo.dnfStatus = dataMO.getDNFStatus();
        erpsInfo.stateMachineStatus = dataMO.getStateMachineStatus();
        erpsInfo.nodeCarryPackCurr = dataMO.getNECarriedWithCurPckt().getBytes();
        erpsInfo.eastPortStatus = dataMO.getEastPortStatus();
        erpsInfo.westPortStatus = dataMO.getWestPortStatus();
        if (dataMO.getIsRplOwner() != 1) {
            erpsInfo.wrtTime = -1;
        }
        return erpsInfo;
    }

    private QAsnERPSDetail convertPTNERPSMopotoInfo(TEPTNERPSMOPO dataMO, int neid) {
        QAsnERPSDetail erpsInfo = new QAsnERPSDetail();
        erpsInfo.erpsKey = TEE2EErpsUtil.constructERPSUniResID(neid, 0, dataMO.getErpsID());
        erpsInfo.neID = neid;
        erpsInfo.slotID = 0;
        erpsInfo.erpsID = dataMO.getErpsID();
        erpsInfo.holdOffTime = dataMO.getHoldOffTime();
        erpsInfo.wrtTime = dataMO.getWtrTime();
        erpsInfo.guardTime = dataMO.getGuardTime();
        erpsInfo.packetTranInterval = dataMO.getRapsInterval();
        erpsInfo.entityLevel = dataMO.getEntityLevel();
        erpsInfo.lastSwitchRequest = dataMO.getLastSwitchReq();
        erpsInfo.rbStatus = dataMO.getRBStatus();
        erpsInfo.dnfStatus = dataMO.getDNFStatus();
        erpsInfo.stateMachineStatus = dataMO.getStateMachineStatus();
        erpsInfo.nodeCarryPackCurr = dataMO.getNECarriedWithCurPckt().getBytes();
        erpsInfo.eastPortStatus = dataMO.getEastPortStatus();
        erpsInfo.westPortStatus = dataMO.getWastPortStatus();
        if (dataMO.getIsRplOwner() != 1) {
            erpsInfo.wrtTime = -1;
        }
        return erpsInfo;
    }

    private boolean sendGetNEERPSDetailsReq(int neID, int erpsID) {
        boolean result = false;
        int err = 0;
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rowParam = new RowParams();
        bus.addRowParams(rowParam);
        Param p = null;
        p = new Param("neid", String.valueOf(neID));
        rowParam.addParam(p);
        p = new Param("erpsid", String.valueOf(erpsID));
        rowParam.addParam(p);
        int sfid = 2179957;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            TELogFactory.getE2ELogger().info(e1.getMessage());
        }
        if (null == subFunc) {
            return result;
        }
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = null == subFunc.getClassMapping() ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(subFunc.getClassMapping()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        Datainterface allData = null;
        if (null != neMgrBean) {
            TEE2EErpsGetInsDetailsHandler.setBeanPlugin(neMgrBean, subFunc);
            allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, null, null);
            err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 == err) {
                return true;
            }
        }
        return result;
    }

    private boolean sendGetCPERPSDetailsReq(int neID, int slotID, int erpsID) {
        boolean result = false;
        int err = 0;
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rowParam = new RowParams();
        bus.addRowParams(rowParam);
        Param p = null;
        p = new Param("neid", String.valueOf(neID));
        rowParam.addParam(p);
        p = new Param("slotid", String.valueOf(slotID));
        rowParam.addParam(p);
        p = new Param("erpsid", String.valueOf(erpsID));
        rowParam.addParam(p);
        int sfid = 2172666;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            TELogFactory.getE2ELogger().info(e1.getMessage());
        }
        if (null == subFunc) {
            return result;
        }
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = null == subFunc.getClassMapping() ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(subFunc.getClassMapping()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        Datainterface allData = null;
        if (null != neMgrBean) {
            TEE2EErpsGetInsDetailsHandler.setBeanPlugin(neMgrBean, subFunc);
            allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, null, null);
            err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 == err) {
                return true;
            }
        }
        return result;
    }

    private static void setBeanPlugin(TENEMgrInterface neMgrBean, SubFunc subFunc) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        String beanPluginStr = subFunc.getBeanPlugin();
        if (null == beanPluginStr || beanPluginStr.isEmpty()) {
            return;
        }
        try {
            if (neMgrBean instanceof TENEExplorerBean) {
                TENEExplorerBean bean = (TENEExplorerBean)neMgrBean;
                TEBeanPluginIF beanPlugin = TEE2EErpsGetInsDetailsHandler.praseBeanPlugin(beanPluginStr);
                bean.setBeanPluginIF(beanPlugin);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Bean Plugin init fail: " + beanPluginStr, (Throwable)e);
        }
    }

    private static TEBeanPluginIF praseBeanPlugin(String beanPluginStr) {
        TEBeanPluginIF beanPlugin = null;
        try {
            beanPlugin = (TEBeanPluginIF)Class.forName(beanPluginStr.trim()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Bean Plugin init fail: " + beanPluginStr, (Throwable)e);
        }
        return beanPlugin;
    }
}

