/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.erps;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ip_nativeethsrv_model.QAsnERPSAttr;
import com.huawei.network.qasn.m_q_ip_nativeethsrv_op.QAsnCreatERPSReq;
import com.huawei.network.qasn.m_q_ip_nativeethsrv_op.QAsnCreatERPSRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.bean.TEE2EERPSCreateBean;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.bean.TEE2EERPSModifyBean;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.model.TEE2EErpsAttr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsCheckEmpty;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsConverter;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsUtil;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2ErpsLog;
import com.huawei.nglct.util.fdn.FDNParser;
import com.huawei.nglct.util.fdn.FDNTypeEnum;
import com.huawei.nglct.util.fdn.PortFDNValue;
import com.huawei.nglct.util.fdn.TEE2EUniResID;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EErpsCreateHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        String FUNC_NAME = "handleRequestImpl";
        TEE2ErpsLog.logFuncBegin("handleRequestImpl");
        QAsnCreatERPSReq req = (QAsnCreatERPSReq)qReq;
        QAsnCreatERPSRsp rsp = (QAsnCreatERPSRsp)qRsp;
        rsp.result.errList = new QAsnErrInfoList();
        if (TEE2EErpsCheckEmpty.isListEmpty((List<Object>)req.erpsAttrLst, "handleRequestImpl", "req.xcInfoList")) {
            TEE2ErpsLog.logFuncEnd("handleRequestImpl");
            return 0;
        }
        List<TEE2EErpsAttr> dataErpsList = this.convertERPS(req);
        rsp.result.errList = new QAsnErrInfoList();
        Set<Integer> normalNESet = TEE2EErpsUtil.connectSBIForNE(dataErpsList);
        if (normalNESet.isEmpty()) {
            this.setAllNECommError(rsp, dataErpsList);
            TEE2ErpsLog.logFuncEnd("handleRequestImpl");
            return 0;
        }
        if (!dataErpsList.isEmpty()) {
            this.createERPS(dataErpsList);
        }
        this.setGlobalErrorCode(rsp, dataErpsList);
        TEE2ErpsLog.logFuncEnd("handleRequestImpl");
        return 0;
    }

    private List<TEE2EErpsAttr> convertERPS(QAsnCreatERPSReq req) {
        ArrayList<TEE2EErpsAttr> dataErpsList = new ArrayList<TEE2EErpsAttr>();
        int len = req.erpsAttrLst.size();
        for (int i = 0; i < len; ++i) {
            QAsnERPSAttr asnErps = (QAsnERPSAttr)req.erpsAttrLst.get(i);
            TEE2EErpsAttr dataErps = TEE2EErpsConverter.convertErpsAttr(asnErps);
            dataErps.getPoOperResult().isSuccess = true;
            dataErps.getPoOperResult().retCode = 0;
            dataErpsList.add(dataErps);
        }
        return dataErpsList;
    }

    private void createERPS(List<TEE2EErpsAttr> dataErpsList) {
        HashMap<Integer, ArrayList<TEE2EErpsAttr>> neIDErpsMap = new HashMap<Integer, ArrayList<TEE2EErpsAttr>>();
        ArrayList<TEE2EErpsAttr> tempErpsList = null;
        int neID = -1;
        for (TEE2EErpsAttr dataErps : dataErpsList) {
            neID = dataErps.getNeID();
            tempErpsList = (ArrayList<TEE2EErpsAttr>)neIDErpsMap.get(neID);
            if (null == tempErpsList) {
                tempErpsList = new ArrayList<TEE2EErpsAttr>();
                neIDErpsMap.put(neID, tempErpsList);
            }
            tempErpsList.add(dataErps);
        }
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : neIDErpsMap.entrySet()) {
            neID = (Integer)entry2.getKey();
            tempErpsList = (List)entry2.getValue();
            this.createERPSImpl(neID, tempErpsList);
            this.setERPSAtribute(neID, tempErpsList);
        }
    }

    private void createERPSImpl(int neID, List<TEE2EErpsAttr> tempErpsList) {
        Datainterface inputData;
        ArrayList operationList;
        SubFunc subFunc;
        String FUNC_NAME = "createERPSImpl";
        TEE2ErpsLog.logFuncBegin("createERPSImpl");
        if (tempErpsList.isEmpty()) {
            return;
        }
        HashMap<Integer, TEE2EErpsAttr> erpsMap = new HashMap<Integer, TEE2EErpsAttr>();
        for (TEE2EErpsAttr attr : tempErpsList) {
            erpsMap.put(attr.getiERPSID(), attr);
        }
        int sfid = this.getCreateERPSSfid();
        TEE2EERPSCreateBean bean = this.getCreateErpsBean(neID, sfid);
        int retCode = bean.sendMessage(neID, subFunc = TEE2EErpsUtil.createSubFunc(neID, sfid), operationList = bean.getOperation(neID, subFunc, inputData = this.createCreateERPSInputData(neID, tempErpsList), null));
        if (0 != retCode || null == operationList || operationList.isEmpty()) {
            for (TEE2EErpsAttr dataErps : tempErpsList) {
                dataErps.getPoOperResult().isSuccess = false;
                dataErps.getPoOperResult().retCode = 1090646019;
                dataErps.setCreateSuccess(false);
            }
            return;
        }
        if (operationList.size() != tempErpsList.size()) {
            e2eLogger.error("The size of operationList is not equal that of tempErpsList!");
        }
        int erpsid = -1;
        int errCode = 1;
        TEE2EErpsAttr dataErps = null;
        for (Operation oper : operationList) {
            erpsid = this.getInputParamValueInt(oper, "erpsid");
            dataErps = (TEE2EErpsAttr)erpsMap.get(erpsid);
            errCode = Integer.parseInt(oper.getOutput(0).getFault(0).getCode());
            if (0 != errCode) {
                dataErps.getPoOperResult().isSuccess = false;
                dataErps.getPoOperResult().retCode = errCode;
                dataErps.setCreateSuccess(false);
                continue;
            }
            dataErps.setCreateSuccess(true);
        }
        TEE2ErpsLog.logFuncEnd("createERPSImpl");
    }

    private int getInputParamValueInt(Operation oper, String partName) {
        return Integer.parseInt(oper.getInput().getPartValue(partName));
    }

    private int getCreateERPSSfid() {
        return 2179955;
    }

    private TEE2EERPSCreateBean getCreateErpsBean(int neID, int sfid) {
        TEE2EERPSCreateBean bean = null;
        bean = new TEE2EERPSCreateBean(){

            public boolean isNeedOperationlog() {
                return false;
            }
        };
        return bean;
    }

    private Datainterface createCreateERPSInputData(int neID, List<TEE2EErpsAttr> tempErpsList) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        for (TEE2EErpsAttr dataErps : tempErpsList) {
            rowparams = new RowParams();
            bussiness.addRowParams(rowparams);
            TEE2EErpsCreateHandler.appendParam(rowparams, "neid", dataErps.getNeID());
            TEE2EErpsCreateHandler.appendParam(rowparams, "erpsid", dataErps.getiERPSID());
            TEE2EErpsCreateHandler.appendParam(rowparams, "eastslotid", this.getFdnSlotID(dataErps.getEastPortIndex()));
            TEE2EErpsCreateHandler.appendParam(rowparams, "eastPortId", this.getFdnPortID(dataErps.getEastPortIndex()));
            TEE2EErpsCreateHandler.appendParam(rowparams, "westslotid", this.getFdnSlotID(dataErps.getWestPortIndex()));
            TEE2EErpsCreateHandler.appendParam(rowparams, "westPortId", this.getFdnPortID(dataErps.getWestPortIndex()));
            int isRPLOwnerFlag = dataErps.getiIsRPLOwner();
            if (0 == isRPLOwnerFlag) {
                TEE2EErpsCreateHandler.appendParam(rowparams, "rplslotid", 65535);
                TEE2EErpsCreateHandler.appendParam(rowparams, "rplPortId", 65535);
            } else {
                TEE2EErpsCreateHandler.appendParam(rowparams, "rplslotid", this.getFdnSlotID(dataErps.getPoRPLPortIndex()));
                TEE2EErpsCreateHandler.appendParam(rowparams, "rplPortId", this.getFdnPortID(dataErps.getPoRPLPortIndex()));
            }
            TEE2EErpsCreateHandler.appendParam(rowparams, "isRPLOwnerFlag", isRPLOwnerFlag);
            TEE2EErpsCreateHandler.appendParam(rowparams, "ctrlVlan", dataErps.getiCtrlVlan());
            TEE2EErpsCreateHandler.appendParam(rowparams, "desMacAddr", this.neMacAddr(dataErps.getPoDesNodeMacAddr()));
        }
        return inputData;
    }

    String neMacAddr(String macAddrStr) {
        StringBuffer macStrBuffer = new StringBuffer();
        int len = macAddrStr.length();
        for (int i = 0; i < len; i += 3) {
            macStrBuffer.append(macAddrStr.substring(i, i + 2));
        }
        return macStrBuffer.toString();
    }

    private String getFdnSlotID(TEE2EUniResID poRPLPortIndex) {
        return String.valueOf(TEE2EErpsCreateHandler.getSlotID(poRPLPortIndex.getStrFDN()));
    }

    public static int getSlotID(String fdn) {
        int INVALID_SLOTID = -1;
        FDNParser parser = null;
        try {
            parser = new FDNParser(fdn);
        }
        catch (Exception e) {
            return -1;
        }
        int shelfID = 0;
        String shelfIDStr = parser.getValue(FDNTypeEnum.FRAME);
        if (null != shelfIDStr && TEStringUtils.isNumber((String)shelfIDStr)) {
            shelfID = Integer.parseInt(shelfIDStr);
        }
        int relativeSlotID = -1;
        String relativeSlotIDStr = parser.getValue(FDNTypeEnum.SLOT);
        if (null == relativeSlotIDStr || !TEStringUtils.isNumber((String)relativeSlotIDStr)) {
            return -1;
        }
        relativeSlotID = Integer.parseInt(relativeSlotIDStr);
        return 65536 * shelfID + relativeSlotID;
    }

    private String getFdnPortID(TEE2EUniResID poRPLPortIndex) {
        int portID = -1;
        FDNParser parser = new FDNParser(poRPLPortIndex.getStrFDN());
        String port = parser.getValue(FDNTypeEnum.PORT);
        if (port != null) {
            portID = new PortFDNValue(port).getPortID();
        }
        return String.valueOf(portID);
    }

    private static void appendParam(RowParams rowParams, String paramName, String paramValue) {
        Param param = null;
        param = new Param();
        param.setName(paramName);
        param.setValue(paramValue);
        rowParams.addParam(param);
    }

    private static void appendParam(RowParams rowParams, String paramName, int paramValue) {
        TEE2EErpsCreateHandler.appendParam(rowParams, paramName, String.valueOf(paramValue));
    }

    private void setERPSAtribute(int neID, List<TEE2EErpsAttr> tempErpsList) {
        Datainterface inputData;
        ArrayList operationList;
        SubFunc subFunc;
        HashMap<Integer, TEE2EErpsAttr> erpsMap = new HashMap<Integer, TEE2EErpsAttr>();
        for (TEE2EErpsAttr dataErps : tempErpsList) {
            if (0 != dataErps.getPoOperResult().retCode) continue;
            erpsMap.put(dataErps.getiERPSID(), dataErps);
        }
        if (erpsMap.isEmpty()) {
            return;
        }
        Collection<TEE2EErpsAttr> erpsList = erpsMap.values();
        int sfid = this.getModifyERPSSfid();
        TEE2EERPSModifyBean bean = this.getModifyERPSBean(neID, sfid);
        int retCode = bean.sendMessage(neID, subFunc = TEE2EErpsUtil.createSubFunc(neID, sfid), operationList = bean.getOperation(neID, subFunc, inputData = this.createModifyERPSInputData(neID, erpsList), null));
        if (0 != retCode || null == operationList || operationList.isEmpty()) {
            for (TEE2EErpsAttr dataErps : erpsList) {
                dataErps.getPoOperResult().isSuccess = false;
                dataErps.getPoOperResult().retCode = 1090646019;
                dataErps.setCreateSuccess(false);
            }
            return;
        }
        if (operationList.size() != erpsList.size()) {
            e2eLogger.error("The size of operationList is not equal that of tempErpsList!");
        }
        int erpsid = -1;
        int errCode = 1;
        TEE2EErpsAttr dataErps = null;
        for (Operation oper : operationList) {
            erpsid = this.getInputParamValueInt(oper, "erpsid");
            dataErps = (TEE2EErpsAttr)erpsMap.get(erpsid);
            errCode = Integer.parseInt(oper.getOutput(0).getFault(0).getCode());
            if (0 == errCode) continue;
            dataErps.getPoOperResult().isSuccess = false;
            dataErps.getPoOperResult().retCode = 1090615169;
            e2eLogger.error(String.format("modify erps error! [neID:%d, erpsID:%d]", neID, errCode));
        }
    }

    private int getModifyERPSSfid() {
        return 2179959;
    }

    private TEE2EERPSModifyBean getModifyERPSBean(int neID, int sfid) {
        TEE2EERPSModifyBean bean = new TEE2EERPSModifyBean(){

            public boolean isNeedOperationlog() {
                return false;
            }
        };
        return bean;
    }

    private Datainterface createModifyERPSInputData(int neID, Collection<TEE2EErpsAttr> tempErpsList) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        for (TEE2EErpsAttr dataErps : tempErpsList) {
            if (0 != dataErps.getPoOperResult().retCode) continue;
            rowparams = new RowParams();
            bussiness.addRowParams(rowparams);
            TEE2EErpsCreateHandler.appendParam(rowparams, "neid", dataErps.getNeID());
            TEE2EErpsCreateHandler.appendParam(rowparams, "erpsid", dataErps.getiERPSID());
            TEE2EErpsCreateHandler.appendParam(rowparams, "holdoffTime", dataErps.getiHoldOffTime());
            TEE2EErpsCreateHandler.appendParam(rowparams, "guardTime", dataErps.getiGuardTime());
            TEE2EErpsCreateHandler.appendParam(rowparams, "entityLevel", dataErps.getiEntityLevel());
            TEE2EErpsCreateHandler.appendParam(rowparams, "sendInterval", dataErps.getiPktTrsInterval());
            if (1 != dataErps.getiIsRPLOwner()) continue;
            TEE2EErpsCreateHandler.appendParam(rowparams, "wtrTime", dataErps.getPoWtrTime());
        }
        return inputData;
    }

    private void setAllNECommError(QAsnCreatERPSRsp rsp, List<TEE2EErpsAttr> dataErpsList) {
        rsp.result.result = 1090650122;
        int len = dataErpsList.size();
        for (int i = 0; i < len; ++i) {
            TEE2EErpsAttr dataErps = dataErpsList.get(i);
            rsp.result.errList.add((Object)TEE2EErpsUtil.createQAsnErrInfo(dataErps));
            QAsnERPSAttr asnErps = TEE2EErpsConverter.convertErpsAttr(dataErps);
            rsp.erpsAttrLst.add((Object)asnErps);
        }
    }

    private void setGlobalErrorCode(QAsnCreatERPSRsp rsp, List<TEE2EErpsAttr> dataErpsList) {
        boolean isAllSuccess = true;
        boolean isPartSuccess = false;
        int errorCode = -1;
        int len = dataErpsList.size();
        for (int i = 0; i < len; ++i) {
            TEE2EErpsAttr dataErps = dataErpsList.get(i);
            errorCode = dataErps.getPoOperResult().retCode;
            if (0 != errorCode) {
                isAllSuccess = false;
                if (dataErps.isCreateSuccess()) {
                    isPartSuccess = true;
                }
                rsp.result.errList.add((Object)TEE2EErpsUtil.createQAsnErrInfo(dataErps));
            }
            QAsnERPSAttr asnErps = TEE2EErpsConverter.convertErpsAttr(dataErps);
            rsp.erpsAttrLst.add((Object)asnErps);
        }
        rsp.result.result = isAllSuccess ? 0 : (isPartSuccess ? 1090646033 : 1090588678);
    }
}

