/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ptn.e2e.erps;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSCreateReq;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSCreateRsp;
import com.huawei.network.qasn.m_q_nml_erps.QAsnERPSInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginIF;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ptn.e2e.erps.util.TEE2EErpsUtil;
import com.huawei.nglct.nemgr.ip.ptn.erps.beanplugin.TENEERPSBeanPluginUtil;
import com.huawei.nglct.nemgr.ip.ptn.erps.beanplugin.otn.TEETHERPSBeanPluginUtil;
import com.huawei.nglct.nemgr.q_interface.e2e.QAsnUniResID;
import com.huawei.nglct.po.embeddednemgrmo.TEETHERPSMOPO;
import com.huawei.nglct.po.embeddednemgrmo.ptn.TEPTNERPSMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.fdn.FDNParser;
import com.huawei.nglct.util.fdn.FDNTypeEnum;
import com.huawei.nglct.util.fdn.PortFDNValue;
import com.huawei.nglct.util.string.TEStringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EErpsCreateEntityHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private QAsnErrInfoList errList = new QAsnErrInfoList();
    private QAsnErrInfoList errInfo = new QAsnErrInfoList();
    private static final int ZERO = 0;
    private static final int ERPSID_MIN = 1;
    private static final int ERPSID_MAX = 8;
    private static final int ERPSID_BIG_MAX = 32;
    private static final int OSN1800V = 121;
    private static final int OSN1832X16 = 121;
    private static final int OSN580 = 125;
    private static final String EMPTY_SLOT_PORT = "65535";
    private static final String MAC = "01-19-A7-00-00-01";

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        e2eLogger.info("handleRequestImpl: handle QAsnERPSCreateReq begin.");
        QAsnERPSCreateReq req = (QAsnERPSCreateReq)qReq;
        QAsnERPSCreateRsp rsp = (QAsnERPSCreateRsp)qRsp;
        rsp.erpsList.clear();
        rsp.result.result = 0;
        if (req == null || req.erpsList.isEmpty()) {
            e2eLogger.info("handleRequestImpl: QAsnERPSCreateRsp.erpsList is empty!");
            return 0;
        }
        int size = req.erpsList.size();
        for (int i = 0; i < size; ++i) {
            QAsnErrInfo errResult;
            int result;
            QAsnUniResID uniResID;
            QAsnERPSInfo erpsInfo = (QAsnERPSInfo)req.erpsList.get(i);
            erpsInfo.poResult = new QAsnErrInfoReturn();
            erpsInfo.poResult.errList = new QAsnErrInfoList();
            int neID = erpsInfo.neID;
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                erpsInfo.poResult.result = 1090596385;
                QAsnErrInfo errResult2 = new QAsnErrInfo();
                errResult2.objID.add((Object)neID);
                errResult2.errCode = 1090596385;
                this.errList.add((Object)errResult2);
                erpsInfo.poResult.errList.add((Object)errResult2);
                rsp.erpsList.add((Object)erpsInfo);
                continue;
            }
            int colresult = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
            if (colresult != 0) {
                erpsInfo.poResult.result = colresult;
                QAsnErrInfo errResult3 = new QAsnErrInfo();
                errResult3.objID.add((Object)neID);
                errResult3.errCode = colresult;
                this.errList.add((Object)errResult3);
                erpsInfo.poResult.errList.add((Object)errResult3);
                rsp.erpsList.add((Object)erpsInfo);
                continue;
            }
            int slotId = erpsInfo.slotID;
            int erpsId = 0;
            if (slotId == 0) {
                erpsId = this.getERPSID(neID);
                if (erpsId > 0) {
                    uniResID = TEE2EErpsUtil.constructERPSUniResID(neID, 0, erpsId);
                    erpsInfo.erpsKey.strFDN = new String(uniResID.strFDN).getBytes();
                    erpsInfo.erpsKey.strMOC = new String(uniResID.strMOC).getBytes();
                    erpsInfo.erpsKey.neID = neID;
                    erpsInfo.erpsKey.poSerialNum = new String(uniResID.poSerialNum).getBytes();
                    erpsInfo.neID = neID;
                    erpsInfo.erpsID = BigInteger.valueOf(erpsId);
                    if (erpsInfo.destinationNode == null) {
                        erpsInfo.destinationNode = MAC.getBytes();
                    }
                    erpsInfo.virChannelSatus = BigInteger.valueOf(1L);
                    result = this.createNeERPS(null, neID, erpsId, erpsInfo);
                    if (result != 0) {
                        erpsInfo.poResult.result = 1090650122;
                        erpsInfo.poResult.errList.addAll((Collection)this.errInfo);
                        rsp.erpsList.add((Object)erpsInfo);
                        continue;
                    }
                    erpsInfo.poResult.result = 0;
                    rsp.erpsList.add((Object)erpsInfo);
                    continue;
                }
                erpsInfo.poResult.result = 1090615319;
                errResult = new QAsnErrInfo();
                errResult.objID.add((Object)neID);
                errResult.errCode = 1090615319;
                this.errList.add((Object)errResult);
                erpsInfo.poResult.errList.add((Object)errResult);
                rsp.erpsList.add((Object)erpsInfo);
                continue;
            }
            erpsId = this.getERPSID(neID, slotId);
            if (erpsId > 0) {
                uniResID = TEE2EErpsUtil.constructERPSUniResID(neID, slotId, erpsId);
                erpsInfo.erpsKey.strFDN = new String(uniResID.strFDN).getBytes();
                erpsInfo.erpsKey.strMOC = new String(uniResID.strMOC).getBytes();
                erpsInfo.erpsKey.neID = neID;
                erpsInfo.erpsKey.poSerialNum = new String(uniResID.poSerialNum).getBytes();
                erpsInfo.neID = neID;
                erpsInfo.erpsID = BigInteger.valueOf(erpsId);
                if (erpsInfo.destinationNode == null) {
                    erpsInfo.destinationNode = MAC.getBytes();
                }
                erpsInfo.virChannelSatus = BigInteger.valueOf(-1L);
                result = this.createBoardERPS(null, neID, erpsId, slotId, erpsInfo);
                if (result != 0) {
                    erpsInfo.poResult.result = 1090650122;
                    erpsInfo.poResult.errList.addAll((Collection)this.errInfo);
                    rsp.erpsList.add((Object)erpsInfo);
                    continue;
                }
                erpsInfo.poResult.result = 0;
                rsp.erpsList.add((Object)erpsInfo);
                continue;
            }
            erpsInfo.poResult.result = 1090615319;
            errResult = new QAsnErrInfo();
            errResult.objID.add((Object)neID);
            errResult.errCode = 1090615319;
            this.errList.add((Object)errResult);
            erpsInfo.poResult.errList.add((Object)errResult);
            rsp.erpsList.add((Object)erpsInfo);
        }
        if (this.errList.size() > 0) {
            rsp.result.errList = this.errList;
            rsp.result.result = 1090650122;
        }
        e2eLogger.info("handleRequestImpl: handle QAsnERPSCreateReq end.");
        return 0;
    }

    private int createNeERPS(String userID, int neID, int erpsId, QAsnERPSInfo erpsInfo) {
        int err = 0;
        boolean isSupportV2 = TEE2EErpsUtil.isSupportNEERPSV2(neID);
        boolean isSupportV1 = TEE2EErpsUtil.isSupportNEERPSV1(neID);
        boolean isSupportLoop = TEE2EErpsUtil.isSupportLOOPDETECT(neID);
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rowParam = new RowParams();
        bus.addRowParams(rowParam);
        Param p = null;
        p = new Param("neid", String.valueOf(neID));
        rowParam.addParam(p);
        p = new Param("erpsid", String.valueOf(erpsId));
        rowParam.addParam(p);
        String eastPortIndexFdn = new String(erpsInfo.eastPortIndex.strFDN);
        if (eastPortIndexFdn.isEmpty()) {
            p = new Param("eastslotid", EMPTY_SLOT_PORT);
            rowParam.addParam(p);
            p = new Param("eastPortId", EMPTY_SLOT_PORT);
            rowParam.addParam(p);
        } else {
            p = new Param("eastslotid", this.getFdnSlotID(erpsInfo.eastPortIndex.strFDN));
            rowParam.addParam(p);
            p = new Param("eastPortId", this.getFdnPortID(erpsInfo.eastPortIndex.strFDN));
            rowParam.addParam(p);
        }
        String westPortIndexFdn = new String(erpsInfo.westPortIndex.strFDN);
        if (westPortIndexFdn.isEmpty()) {
            p = new Param("westslotid", EMPTY_SLOT_PORT);
            rowParam.addParam(p);
            p = new Param("westPortId", EMPTY_SLOT_PORT);
            rowParam.addParam(p);
        } else {
            p = new Param("westslotid", this.getFdnSlotID(erpsInfo.westPortIndex.strFDN));
            rowParam.addParam(p);
            p = new Param("westPortId", this.getFdnPortID(erpsInfo.westPortIndex.strFDN));
            rowParam.addParam(p);
        }
        String rplPortFdn = new String(erpsInfo.rplPort.strFDN);
        if (rplPortFdn.isEmpty()) {
            p = new Param("rplslotid", EMPTY_SLOT_PORT);
            rowParam.addParam(p);
            p = new Param("rplPortId", EMPTY_SLOT_PORT);
            rowParam.addParam(p);
        } else {
            p = new Param("rplslotid", this.getFdnSlotID(erpsInfo.rplPort.strFDN));
            rowParam.addParam(p);
            p = new Param("rplPortId", this.getFdnPortID(erpsInfo.rplPort.strFDN));
            rowParam.addParam(p);
        }
        p = new Param("isRPLOwnerFlag", String.valueOf(erpsInfo.rplNodeFlag));
        rowParam.addParam(p);
        p = new Param("ctrlVlan", String.valueOf(erpsInfo.controlVlan));
        rowParam.addParam(p);
        if (erpsInfo.destinationNode != null) {
            p = new Param("desMacAddr", this.neMacAddr(new String(erpsInfo.destinationNode)));
            rowParam.addParam(p);
        }
        if (erpsInfo.erpsdetailInfo != null) {
            p = new Param("holdoffTime", String.valueOf(erpsInfo.erpsdetailInfo.holdOffTime));
            rowParam.addParam(p);
            if (erpsInfo.rplNodeFlag.intValue() == 1) {
                if (erpsInfo.erpsdetailInfo.wrtTime.intValue() != -1) {
                    p = new Param("wtrTime", String.valueOf(erpsInfo.erpsdetailInfo.wrtTime));
                    rowParam.addParam(p);
                }
                if (erpsInfo.revertiveMode.intValue() != -1) {
                    if (isSupportV2) {
                        p = new Param("resumeMode", String.valueOf(erpsInfo.revertiveMode));
                        rowParam.addParam(p);
                    } else if (isSupportV1) {
                        erpsInfo.revertiveMode = BigInteger.valueOf(1L);
                    }
                }
            } else {
                erpsInfo.erpsdetailInfo.wrtTime = BigInteger.valueOf(-1L);
                erpsInfo.revertiveMode = BigInteger.valueOf(-1L);
            }
            p = new Param("guardTime", String.valueOf(erpsInfo.erpsdetailInfo.guardTime));
            rowParam.addParam(p);
            if (isSupportV2) {
                p = new Param("compatibleVersion", String.valueOf(erpsInfo.compatibleVersion));
                rowParam.addParam(p);
            } else {
                erpsInfo.compatibleVersion = BigInteger.valueOf(1L);
            }
            p = new Param("entityLevel", String.valueOf(erpsInfo.erpsdetailInfo.entityLevel));
            rowParam.addParam(p);
            p = new Param("sendInterval", String.valueOf(erpsInfo.erpsdetailInfo.packetTranInterval));
            rowParam.addParam(p);
        }
        if (erpsInfo.rplNodeFlag.intValue() == 1 && erpsInfo.poLoopDetect != null && isSupportLoop) {
            p = new Param("W32NE_ATTR_ERPS_LOOPDETECT", String.valueOf(erpsInfo.poLoopDetect));
            rowParam.addParam(p);
        } else {
            erpsInfo.poLoopDetect = -1;
        }
        int sfid = 2180625;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            TELogFactory.getE2ELogger().info(e1.getMessage());
        }
        if (null == subFunc) {
            QAsnErrInfo errResult = new QAsnErrInfo();
            errResult.objID.add((Object)neID);
            errResult.errCode = 1090650122;
            this.errInfo.add((Object)errResult);
            this.errList.add((Object)errResult);
            return 1090650122;
        }
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = null == subFunc.getClassMapping() ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(subFunc.getClassMapping()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        Datainterface allData = null;
        if (null != neMgrBean) {
            TEE2EErpsCreateEntityHandler.setBeanPlugin(neMgrBean, subFunc);
            allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, userID, null);
            this.errInfo.clear();
            err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 != err) {
                if (null != allData.getBussinessParams() && allData.getBussinessParams().getRowParamsCount() > 0) {
                    int len = allData.getBussinessParams().getRowParamsCount();
                    for (int i = 0; i < len; ++i) {
                        RowParams vRowParams = allData.getBussinessParams().getRowParams(i);
                        int jLen = vRowParams.getRowErrorsCount();
                        for (int j = 0; j < jLen; ++j) {
                            QAsnErrInfo errResult;
                            RowErrors vRowError = vRowParams.getRowErrors(j);
                            ErrorMessage errorMessage = vRowError.getErrorMessage();
                            if (null != errorMessage.getErrorcode() && !"".equals(errorMessage.getErrorcode())) {
                                TELogFactory.getNormalLogger().error("Create NeERPS fail!");
                                errResult = new QAsnErrInfo();
                                errResult.objID.add((Object)neID);
                                errResult.errCode = Integer.parseInt(errorMessage.getErrorcode());
                                errResult.strOperDesc = errorMessage.getErrorinfo().getBytes();
                                this.errInfo.add((Object)errResult);
                                this.errList.add((Object)errResult);
                                continue;
                            }
                            TELogFactory.getNormalLogger().error("Create NeERPS fail with no errorCode!");
                            errResult = new QAsnErrInfo();
                            errResult.objID.add((Object)neID);
                            errResult.errCode = 1090650122;
                            this.errInfo.add((Object)errResult);
                            this.errList.add((Object)errResult);
                        }
                    }
                } else {
                    TELogFactory.getNormalLogger().error("Create NeERPS fail with no allData!");
                    QAsnErrInfo errResult = new QAsnErrInfo();
                    errResult.objID.add((Object)neID);
                    errResult.errCode = 1090650122;
                    this.errInfo.add((Object)errResult);
                    this.errList.add((Object)errResult);
                }
            }
        }
        return err;
    }

    private int createBoardERPS(String userID, int neID, int erpsId, int slotId, QAsnERPSInfo erpsInfo) {
        int err = 0;
        String eastPortIndexFdn = new String(erpsInfo.eastPortIndex.strFDN);
        String westPortIndexFdn = new String(erpsInfo.westPortIndex.strFDN);
        if (eastPortIndexFdn.isEmpty() || westPortIndexFdn.isEmpty()) {
            err = 38751;
            QAsnErrInfo errEmpty = new QAsnErrInfo();
            errEmpty.objID.add((Object)neID);
            errEmpty.errCode = 38751;
            this.errInfo.add((Object)errEmpty);
            this.errList.add((Object)errEmpty);
            return err;
        }
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rowParam = new RowParams();
        bus.addRowParams(rowParam);
        Param p = null;
        p = new Param("slotid", String.valueOf(slotId));
        rowParam.addParam(p);
        p = new Param("erpsid", String.valueOf(erpsId));
        rowParam.addParam(p);
        p = new Param("subslotid", String.valueOf(slotId));
        rowParam.addParam(p);
        p = new Param("eastPortId", this.getFdnPortID(erpsInfo.eastPortIndex.strFDN));
        rowParam.addParam(p);
        p = new Param("eastSubSlotId", String.valueOf(slotId));
        rowParam.addParam(p);
        p = new Param("westPortId", this.getFdnPortID(erpsInfo.westPortIndex.strFDN));
        rowParam.addParam(p);
        p = new Param("westSubSlotId", String.valueOf(slotId));
        rowParam.addParam(p);
        String rplPortFdn = new String(erpsInfo.rplPort.strFDN);
        if (rplPortFdn.isEmpty()) {
            p = new Param("rplPortId", EMPTY_SLOT_PORT);
            rowParam.addParam(p);
        } else {
            p = new Param("rplPortId", this.getFdnPortID(erpsInfo.rplPort.strFDN));
            rowParam.addParam(p);
        }
        p = new Param("isRPLOwnerFlag", String.valueOf(erpsInfo.rplNodeFlag));
        rowParam.addParam(p);
        p = new Param("ctrlVlan", String.valueOf(erpsInfo.controlVlan));
        rowParam.addParam(p);
        if (erpsInfo.destinationNode != null) {
            p = new Param("desMacAddr", this.neMacAddr(new String(erpsInfo.destinationNode)));
            rowParam.addParam(p);
        }
        if (erpsInfo.erpsdetailInfo != null) {
            p = new Param("holdoffTime", String.valueOf(erpsInfo.erpsdetailInfo.holdOffTime));
            rowParam.addParam(p);
            if (erpsInfo.rplNodeFlag.intValue() == 1 && erpsInfo.erpsdetailInfo.wrtTime.intValue() != -1) {
                p = new Param("wtrTime", String.valueOf(erpsInfo.erpsdetailInfo.wrtTime));
                rowParam.addParam(p);
            }
            p = new Param("guardTime", String.valueOf(erpsInfo.erpsdetailInfo.guardTime));
            rowParam.addParam(p);
            p = new Param("entityLevel", String.valueOf(erpsInfo.erpsdetailInfo.entityLevel));
            rowParam.addParam(p);
            p = new Param("sendInterval", String.valueOf(erpsInfo.erpsdetailInfo.packetTranInterval));
            rowParam.addParam(p);
        }
        int sfid = 2180626;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            TELogFactory.getE2ELogger().info(e1.getMessage());
        }
        if (null == subFunc) {
            QAsnErrInfo errResult = new QAsnErrInfo();
            errResult.objID.add((Object)neID);
            errResult.errCode = 1090650122;
            this.errInfo.add((Object)errResult);
            this.errList.add((Object)errResult);
            return 1090650122;
        }
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = null == subFunc.getClassMapping() ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(subFunc.getClassMapping()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        Datainterface allData = null;
        if (null != neMgrBean) {
            TEE2EErpsCreateEntityHandler.setBeanPlugin(neMgrBean, subFunc);
            allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, userID, null);
            this.errInfo.clear();
            err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 != err) {
                if (null != allData.getBussinessParams() && allData.getBussinessParams().getRowParamsCount() > 0) {
                    int len = allData.getBussinessParams().getRowParamsCount();
                    for (int i = 0; i < len; ++i) {
                        RowParams vRowParams = allData.getBussinessParams().getRowParams(i);
                        int jLen = vRowParams.getRowErrorsCount();
                        for (int j = 0; j < jLen; ++j) {
                            QAsnErrInfo errResult;
                            RowErrors vRowError = vRowParams.getRowErrors(j);
                            ErrorMessage errorMessage = vRowError.getErrorMessage();
                            if (null != errorMessage.getErrorcode() && !"".equals(errorMessage.getErrorcode())) {
                                errResult = new QAsnErrInfo();
                                errResult.objID.add((Object)neID);
                                errResult.errCode = Integer.parseInt(errorMessage.getErrorcode());
                                errResult.strOperDesc = errorMessage.getErrorinfo().getBytes();
                                this.errInfo.add((Object)errResult);
                                this.errList.add((Object)errResult);
                                continue;
                            }
                            TELogFactory.getNormalLogger().error("Create BoardERPS fail with no errorCode!");
                            errResult = new QAsnErrInfo();
                            errResult.objID.add((Object)neID);
                            errResult.errCode = 1090650122;
                            this.errInfo.add((Object)errResult);
                            this.errList.add((Object)errResult);
                        }
                    }
                } else {
                    TELogFactory.getNormalLogger().error("Create BoardERPS fail with no allData!");
                    QAsnErrInfo errResult = new QAsnErrInfo();
                    errResult.objID.add((Object)neID);
                    errResult.errCode = 1090650122;
                    this.errInfo.add((Object)errResult);
                    this.errList.add((Object)errResult);
                }
            }
        }
        return err;
    }

    private int getERPSID(int neID) {
        ArrayList<Integer> erpsIdList = new ArrayList<Integer>();
        TEDaoOperationResult dbResult = null;
        dbResult = TENEERPSBeanPluginUtil.findNEERpsFromDB(neID);
        if (dbResult != null && dbResult.getResult() == 0) {
            List dbDataList = dbResult.getData();
            int count = dbDataList.size();
            for (int j = 0; j < count; ++j) {
                TEPTNERPSMOPO dataMO = (TEPTNERPSMOPO)dbDataList.get(j);
                erpsIdList.add(dataMO.getErpsID());
            }
        }
        int bigValue = this.getErpsMax(neID);
        for (int k = 1; k <= bigValue; ++k) {
            if (erpsIdList.contains(k)) continue;
            return k;
        }
        return 0;
    }

    private int getErpsMax(int neID) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (ne.getNEType() == 121 || ne.getNEType() == 125 || ne.getNEType() == 121) {
            return 32;
        }
        return 8;
    }

    private int getERPSID(int neID, int slotID) {
        ArrayList<Integer> erpsIdList = new ArrayList<Integer>();
        TEDaoOperationResult dbResult = null;
        dbResult = TEETHERPSBeanPluginUtil.findNEERpsFromDB(neID, slotID);
        if (dbResult != null && dbResult.getResult() == 0) {
            List dbDataList = dbResult.getData();
            int count = dbDataList.size();
            for (int j = 0; j < count; ++j) {
                TEETHERPSMOPO dataMO = (TEETHERPSMOPO)dbDataList.get(j);
                erpsIdList.add(dataMO.getErpsID());
            }
        }
        for (int k = 1; k <= 8; ++k) {
            if (erpsIdList.contains(k)) continue;
            return k;
        }
        return 0;
    }

    private String neMacAddr(String macAddrStr) {
        StringBuffer macStrBuffer = new StringBuffer();
        int len = macAddrStr.length();
        for (int i = 0; i < len; i += 3) {
            macStrBuffer.append(macAddrStr.substring(i, i + 2));
        }
        return macStrBuffer.toString();
    }

    private String getFdnSlotID(byte[] strFDN) {
        return String.valueOf(TEE2EErpsCreateEntityHandler.getSlotID(new String(strFDN)));
    }

    public static int getSlotID(String fdn) {
        int INVALID_SLOTID = -1;
        FDNParser parser = null;
        try {
            parser = new FDNParser(fdn);
        }
        catch (Exception e) {
            return -1;
        }
        int shelfID = 0;
        String shelfIDStr = parser.getValue(FDNTypeEnum.FRAME);
        if (null != shelfIDStr && TEStringUtils.isNumber((String)shelfIDStr)) {
            shelfID = Integer.parseInt(shelfIDStr);
        }
        int relativeSlotID = -1;
        String relativeSlotIDStr = parser.getValue(FDNTypeEnum.SLOT);
        if (null == relativeSlotIDStr || !TEStringUtils.isNumber((String)relativeSlotIDStr)) {
            return -1;
        }
        relativeSlotID = Integer.parseInt(relativeSlotIDStr);
        return 65536 * shelfID + relativeSlotID;
    }

    private String getFdnPortID(byte[] strFDN) {
        int portID = -1;
        FDNParser parser = new FDNParser(new String(strFDN));
        String port = parser.getValue(FDNTypeEnum.PORT);
        if (port != null) {
            portID = new PortFDNValue(port).getPortID();
        }
        return String.valueOf(portID);
    }

    private static void setBeanPlugin(TENEMgrInterface neMgrBean, SubFunc subFunc) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        String beanPluginStr = subFunc.getBeanPlugin();
        if (null == beanPluginStr || beanPluginStr.isEmpty()) {
            return;
        }
        try {
            if (neMgrBean instanceof TENEExplorerBean) {
                TENEExplorerBean bean = (TENEExplorerBean)neMgrBean;
                TEBeanPluginIF beanPlugin = TEE2EErpsCreateEntityHandler.praseBeanPlugin(beanPluginStr);
                bean.setBeanPluginIF(beanPlugin);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Bean Plugin init fail: " + beanPluginStr, (Throwable)e);
        }
    }

    private static TEBeanPluginIF praseBeanPlugin(String beanPluginStr) {
        TEBeanPluginIF beanPlugin = null;
        try {
            beanPlugin = (TEBeanPluginIF)Class.forName(beanPluginStr.trim()).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Bean Plugin init fail: " + beanPluginStr, (Throwable)e);
        }
        return beanPlugin;
    }
}

